/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.debug;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.doc.JSONExporter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.ecm.webengine.jaxrs.views.TemplateView;
import org.nuxeo.runtime.api.Framework;

public class DebugResource {
    private static final Log log = LogFactory.getLog(DebugResource.class);
    static final XMap xmap = new XMap();

    public AutomationService getOperationService() throws Exception {
        return (AutomationService)Framework.getLocalService(AutomationService.class);
    }

    public String getOperationsListAsJson() throws Exception {
        return JSONExporter.toJSON();
    }

    @GET
    @Produces(value={"text/html"})
    public Object doGet() throws Exception {
        return new TemplateView((Object)this, "index.ftl.html");
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="doc")
    public Object doGetText() throws Exception {
        return JSONExporter.toJSON();
    }

    @GET
    @Produces(value={"application/json"})
    public Object doGetJSON() throws Exception {
        return JSONExporter.toJSON();
    }

    @POST
    public Response doPost(@FormParam(value="input") String input, @FormParam(value="chain") String chainXml) throws Exception {
        CoreSession session = SessionFactory.getSession();
        if (!((NuxeoPrincipal)session.getPrincipal()).isAdministrator()) {
            return Response.status((int)403).build();
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(chainXml.getBytes());
            OperationChainContribution contrib = (OperationChainContribution)xmap.load((InputStream)in);
            OperationChain chain = contrib.toOperationChain(Framework.getRuntime().getContext().getBundle());
            OperationContext ctx = new OperationContext(session);
            ctx.setInput((Object)this.getDocumentRef(input));
            this.getOperationService().run(ctx, chain);
            return Response.ok((Object)"Operation Done.").build();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="{chainId}")
    public Response doChainIdPost(@FormParam(value="input") String input, @FormParam(value="chainId") String chainId) throws Exception {
        try {
            OperationContext ctx = new OperationContext(SessionFactory.getSession());
            ctx.setInput((Object)this.getDocumentRef(input));
            this.getOperationService().run(ctx, chainId);
            return Response.ok((Object)"Operation Done.").build();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    protected DocumentRef getDocumentRef(String ref) {
        if (ref == null || ref.length() == 0) {
            return null;
        }
        if (ref.startsWith("/")) {
            return new PathRef(ref);
        }
        return new IdRef(ref);
    }

    static {
        xmap.register(OperationChainContribution.class);
    }
}

