/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.setup;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;

@Scope(value=ScopeType.SESSION)
@Name(value="setupWizardAction")
public class SetupWizardActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(SetupWizardActionBean.class);
    private static final String[] managedKeyParameters = new String[]{"nuxeo.bind.address", "nuxeo.url", "nuxeo.data.dir", "nuxeo.log.dir", "org.nuxeo.ecm.product.name", "org.nuxeo.ecm.product.version", "nuxeo.conf", "nuxeo.dbtemplate", "nuxeo.db.name", "nuxeo.db.user", "nuxeo.db.password", "nuxeo.db.host", "nuxeo.db.port", "nuxeo.db.min-pool-size", "nuxeo.db.min-pool-size", "nuxeo.db.max-pool-size", "nuxeo.vcs.min-pool-size", "nuxeo.vcs.max-pool-size", "nuxeo.notification.eMailSubjectPrefix", "mailservice.user", "mailservice.password", "mail.store.protocol", "mail.transport.protocol", "mail.pop3.host", "mail.debug", "mail.smtp.host", "mail.smtp.port", "mail.smtp.auth", "mail.smtp.username", "mail.smtp.password", "mail.from"};
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    protected Map<String, String> parameters = null;
    protected Map<String, String> advancedParameters = null;
    protected static boolean needsRestart = false;
    protected boolean configurable = false;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    private ConfigurationGenerator configGenerator;
    protected Properties userConfig;

    @Factory(value="advancedParams", scope=ScopeType.STATELESS)
    public Map<String, String> getAdvancedParameters() {
        if (this.advancedParameters == null) {
            this.readParameters();
        }
        return this.advancedParameters;
    }

    @Factory(value="configurable", scope=ScopeType.SESSION)
    public boolean isConfigurable() {
        if (this.configGenerator == null) {
            this.readParameters();
        }
        return this.configurable;
    }

    @Factory(value="setupRequiresRestart", scope=ScopeType.EVENT)
    public boolean isNeedsRestart() {
        return needsRestart;
    }

    @Factory(value="setupParams", scope=ScopeType.STATELESS)
    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.readParameters();
        }
        return this.parameters;
    }

    protected void readParameters() {
        this.configGenerator = new ConfigurationGenerator();
        this.configGenerator.init();
        this.configurable = this.configGenerator.isConfigurable();
        if (this.configurable) {
            this.setParameters();
        } else {
            log.debug((Object)"Server not configurable !");
        }
    }

    private void setParameters() {
        this.userConfig = this.configGenerator.getUserConfig();
        this.parameters = new HashMap<String, String>();
        this.advancedParameters = new TreeMap<String, String>();
        for (String key : this.userConfig.stringPropertyNames()) {
            this.advancedParameters.put(key, this.userConfig.getProperty(key).trim());
        }
        for (String keyParam : managedKeyParameters) {
            this.setParameter(keyParam);
        }
    }

    private void setParameter(String key) {
        String parameter = this.userConfig.getProperty(key);
        if (parameter != null) {
            this.parameters.put(key, parameter.trim());
            this.advancedParameters.remove(key);
        }
    }

    public void save() {
        this.saveParameters();
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.parameters.saved"), new Object[0]);
        needsRestart = true;
        this.resetParameters();
    }

    protected void saveParameters() {
        String currentDB = this.parameters.get("nuxeo.dbtemplate");
        this.advancedParameters.put("nuxeo.templates", this.configGenerator.rebuildTemplatesStr(currentDB));
        HashMap<String, String> customParameters = new HashMap<String, String>();
        customParameters.putAll(this.parameters);
        customParameters.putAll(this.advancedParameters);
        try {
            this.configGenerator.saveFilteredConfiguration(customParameters);
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
        }
    }

    public void resetParameters() {
        this.readParameters();
        Contexts.getPageContext().remove("setupParams");
        Contexts.getPageContext().remove("advancedParams");
        Contexts.getEventContext().remove("setupRequiresRestart");
    }

    public void templateChange(ActionEvent event) {
        UIComponent select = event.getComponent().getParent();
        if (!(select instanceof ValueHolder)) {
            log.error((Object)("Bad component returned " + select));
            throw new AbortProcessingException("Bad component returned " + select);
        }
        String dbTemplate = (String)((ValueHolder)select).getValue();
        this.configGenerator.changeDBTemplate(dbTemplate);
        this.setParameters();
        Contexts.getPageContext().remove("setupParams");
        Contexts.getPageContext().remove("advancedParams");
        FacesContext context = FacesContext.getCurrentInstance();
        context.renderResponse();
    }
}

