/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.mvel2.ast.EndOfStatement;
import org.mvel2.ast.Function;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.util.ExecutionStack;
import org.mvel2.util.ParseTools;

public class FunctionParser {
    private String name;
    private int cursor;
    private int endOffset;
    private char[] expr;
    private ParserContext pCtx;
    private ExecutionStack splitAccumulator;

    public FunctionParser(String functionName, int cursor, int endOffset, char[] expr, ParserContext pCtx, ExecutionStack splitAccumulator) {
        this.name = functionName;
        this.cursor = cursor;
        this.endOffset = endOffset;
        this.expr = expr;
        this.pCtx = pCtx;
        this.splitAccumulator = splitAccumulator;
    }

    public Function parse() {
        int blockEnd;
        int blockStart;
        int start = this.cursor;
        int startCond = 0;
        int endCond = 0;
        this.cursor = ParseTools.captureToNextTokenJunction(this.expr, this.cursor, this.pCtx);
        this.cursor = ParseTools.nextNonBlank(this.expr, this.cursor);
        if (this.expr[this.cursor] == '(') {
            startCond = this.cursor;
            this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, startCond, '(', this.pCtx);
            endCond = this.cursor++;
            ++startCond;
            this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor, this.pCtx);
            if (this.cursor >= this.endOffset) {
                throw new CompileException("incomplete statement", this.expr, this.cursor);
            }
            if (this.expr[this.cursor] == '{') {
                blockStart = this.cursor;
                blockEnd = this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, blockStart, '{', this.pCtx);
            } else {
                blockStart = this.cursor - 1;
                blockEnd = this.cursor = ParseTools.captureToEOS(this.expr, this.cursor, this.pCtx);
            }
        } else if (this.expr[this.cursor] == '{') {
            blockStart = this.cursor;
            blockEnd = this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, blockStart, '{', this.pCtx);
        } else {
            blockStart = this.cursor - 1;
            blockEnd = this.cursor = ParseTools.captureToEOS(this.expr, this.cursor, this.pCtx);
        }
        blockStart = ParseTools.trimRight(this.expr, start, blockStart + 1);
        blockEnd = ParseTools.trimLeft(this.expr, start, blockEnd);
        ++this.cursor;
        if (this.splitAccumulator != null && ParseTools.isStatementNotManuallyTerminated(this.expr, this.cursor)) {
            this.splitAccumulator.add(new EndOfStatement());
        }
        return new Function(this.name, ParseTools.subArray(this.expr, startCond, endCond), ParseTools.subArray(this.expr, blockStart, blockEnd), this.pCtx == null ? (this.pCtx = AbstractParser.getCurrentThreadParserContext()) : this.pCtx);
    }

    public String getName() {
        return this.name;
    }

    public int getCursor() {
        return this.cursor;
    }
}

