/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.webengine.gadgets;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;

@Path(value="/gadgets")
@WebObject(type="gadgets")
@Produces(value={"text/html; charset=UTF-8"})
public class Gadgets
extends ModuleRoot {
    private final GadgetService gm = (GadgetService)Framework.getService(GadgetService.class);

    @GET
    public Object getGallery(@QueryParam(value="cat") String category, @QueryParam(value="mode") String mode) {
        List gadgetList;
        String ftlName = null;
        if (mode == null) {
            mode = "gallery";
        }
        if (mode.equalsIgnoreCase("gallery")) {
            ftlName = "gallery";
        } else if (mode.equalsIgnoreCase("popup")) {
            ftlName = "chooser-body";
        } else {
            return Response.serverError().build();
        }
        if (category == null) {
            gadgetList = this.gm.getGadgetList();
            category = "all";
        } else {
            gadgetList = this.gm.getGadgetList(category);
        }
        List categories = this.gm.getGadgetCategory();
        categories.add(0, "all");
        return this.getView(ftlName).arg("gadgets", (Object)gadgetList).arg("categories", (Object)categories).arg("category", (Object)category).arg("mode", (Object)mode);
    }

    @GET
    @Path(value="listGadgets")
    public Object getGadgetList(@QueryParam(value="cat") String category) {
        List gadgetList;
        if (category == null) {
            gadgetList = this.gm.getGadgetList();
            category = "all";
        } else {
            gadgetList = this.gm.getGadgetList(category);
        }
        return this.getView("list").arg("gadgets", (Object)gadgetList);
    }

    @GET
    @Path(value="sample")
    public Object getSample() {
        return this.getView("sample-popup");
    }

    @Path(value="{name}")
    public Object getGadget(@PathParam(value="name") String gadgetName) throws Exception {
        if (this.gm == null) {
            return Response.ok((Object)500).build();
        }
        GadgetDeclaration gadget = this.gm.getGadget(gadgetName);
        if (gadget != null) {
            return this.ctx.newObject("gadget", new Object[]{gadget});
        }
        return Response.ok((Object)404).build();
    }

    public String getCategoryLabel(String categoryKey) {
        String label;
        if (categoryKey == null) {
            return "";
        }
        if (!categoryKey.startsWith("gadget.category")) {
            categoryKey = "gadget.category." + categoryKey;
        }
        if ((label = this.getContext().getMessage(categoryKey)).startsWith("!")) {
            label = categoryKey.replace("gadget.category.", "");
            label = label.substring(0, 1).toUpperCase() + label.substring(1);
        }
        return label;
    }
}

