/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.steadystate.css.parser.CSSOMParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.theme.formats.styles.Style;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

public final class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static final String EMPTY_CSS_SELECTOR = "EMPTY";
    private static final Pattern emptyCssSelectorPattern = Pattern.compile("(.*?)\\{(.*?)\\}", 32);

    private Utils() {
    }

    public static String listToCsv(List<String> list) {
        StringWriter sw = new StringWriter();
        CSVWriter writer = new CSVWriter((Writer)sw, ',');
        writer.writeNext(list.toArray(new String[0]));
        return sw.toString();
    }

    public static List<String> csvToList(String str) throws IOException {
        if ("".equals(str) || str == null) {
            return new ArrayList<String>();
        }
        StringReader sr = new StringReader(str);
        CSVReader reader = new CSVReader((Reader)sr, ',');
        return Arrays.asList(reader.readNext());
    }

    public static boolean contains(String[] array, String value) {
        for (String s : array) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static String cleanUp(String text) {
        return text.replaceAll("\n", " ").replaceAll("\\t+", " ").replaceAll("\\s+", " ").trim();
    }

    public static byte[] readResourceAsBytes(String path) throws IOException {
        return Utils.readResource(path).toByteArray();
    }

    public static String readResourceAsString(String path) throws IOException {
        return Utils.readResource(path).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteArrayOutputStream readResource(String path) throws IOException {
        ByteArrayOutputStream os;
        block15: {
            InputStream is = null;
            os = null;
            try {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                if (is == null) {
                    log.warn((Object)("Resource not found: " + path));
                    break block15;
                }
                try {
                    int i;
                    os = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((i = is.read(buffer)) != -1) {
                        os.write(buffer, 0, i);
                    }
                    os.flush();
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    finally {
                        is = null;
                    }
                }
            }
        }
        return os;
    }

    public static byte[] fetchUrl(URL url) {
        byte[] data = null;
        try {
            int i;
            InputStream in = url.openStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((i = in.read(buffer)) != -1) {
                os.write(buffer, 0, i);
            }
            data = os.toByteArray();
            in.close();
            os.close();
        }
        catch (IOException e) {
            log.error((Object)("Could not retrieve URL: " + url.toString()));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFile(URL url, String text) throws IOException {
        if (url.getProtocol().equals("file")) {
            String filepath = url.getFile();
            File file = new File(filepath);
            FileUtils.writeFile((File)file, (String)text);
            return;
        }
        OutputStream os = null;
        try {
            URLConnection urlc = url.openConnection();
            os = urlc.getOutputStream();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        if (os == null) return;
        try {
            os.write(text.getBytes());
            os.flush();
            return;
        }
        catch (IOException e) {
            log.error((Object)e);
            return;
        }
        finally {
            try {
                try {
                    os.close();
                    os = null;
                }
                catch (IOException e) {
                    log.error((Object)e);
                    os = null;
                }
            }
            catch (Throwable throwable) {
                os = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(Properties properties, String resourceName) {
        if (properties.isEmpty()) {
            InputStream in = null;
            try {
                in = Utils.class.getResourceAsStream(resourceName);
                if (in != null) {
                    properties.load(in);
                }
            }
            catch (IOException e) {
                log.error((Object)"Could not load properties", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to close stream", (Throwable)e);
                    }
                }
            }
        }
    }

    public static void loadCss(Style style, String cssSource, String viewName) {
        Matcher matcher = emptyCssSelectorPattern.matcher(cssSource);
        StringBuilder buf = new StringBuilder();
        while (matcher.find()) {
            if (matcher.group(1).trim().equals("")) {
                buf.append(EMPTY_CSS_SELECTOR);
            }
            buf.append(matcher.group(0));
        }
        cssSource = buf.toString();
        CSSOMParser parser = new CSSOMParser();
        InputSource is = new InputSource((Reader)new StringReader(cssSource));
        CSSStyleSheet css = null;
        try {
            css = parser.parseStyleSheet(is, null, null);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error while converting CSS value: \n" + cssSource));
        }
        catch (CSSException e) {
            log.error((Object)("Invalid CSS: \n" + cssSource));
        }
        catch (IOException e) {
            log.error((Object)("Could not parse CSS: \n" + cssSource));
        }
        if (css == null) {
            return;
        }
        style.clearPropertiesFor(viewName);
        CSSRuleList rules = css.getCssRules();
        for (int i = 0; i < rules.getLength(); ++i) {
            String selector;
            CSSRule rule = rules.item(i);
            if (rule.getType() != 1) continue;
            CSSStyleRule sr = (CSSStyleRule)rule;
            CSSStyleDeclaration s = sr.getStyle();
            Properties properties = new Properties();
            for (int j = 0; j < s.getLength(); ++j) {
                String propertyName = s.item(j);
                CSSValue value = s.getPropertyCSSValue(propertyName);
                properties.setProperty(propertyName, value.toString());
            }
            if (s.getLength() == 0) {
                properties.setProperty("", "");
            }
            if ((selector = sr.getSelectorText()).equals(EMPTY_CSS_SELECTOR)) {
                selector = "";
            }
            style.setPropertiesFor(viewName, selector, properties);
        }
    }
}

