/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jbpm.graph.exe.ProcessInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.JbpmTaskListService;
import org.nuxeo.ecm.platform.jbpm.TaskList;
import org.nuxeo.ecm.platform.jbpm.VirtualTaskInstance;
import org.nuxeo.ecm.platform.jbpm.web.JbpmActions;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="jbpmTaskListActions")
@Scope(value=ScopeType.CONVERSATION)
public class JbpmTaskListActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient JbpmActions jbpmActions;
    @In(create=true)
    protected transient JbpmService jbpmService;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected String selectedListId;
    protected String listName;

    public String getSelectedListId() {
        return this.selectedListId;
    }

    public void setSelectedListId(String selectedListId) {
        this.selectedListId = selectedListId;
    }

    public String getListName() {
        return this.listName;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }

    @Factory(value="availableLists", scope=ScopeType.EVENT)
    public List<TaskList> availableListsFactory() throws Exception {
        JbpmTaskListService service = (JbpmTaskListService)Framework.getService(JbpmTaskListService.class);
        List lists = service.getTaskLists(this.documentManager);
        return lists;
    }

    public void createTaskList() throws Exception {
        if (this.listName == null || this.listName.equals("")) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("label.review.list.chooseaname"), new Object[0]);
            return;
        }
        JbpmTaskListService service = (JbpmTaskListService)Framework.getService(JbpmTaskListService.class);
        TaskList list = service.createTaskList(this.documentManager, this.listName);
        ArrayList<Object> virtualTasks = this.jbpmActions.getCurrentVirtualTasks();
        if (virtualTasks == null) {
            virtualTasks = new ArrayList();
        }
        for (VirtualTaskInstance virtualTaskInstance : virtualTasks) {
            list.addTask(virtualTaskInstance);
        }
        service.saveTaskList(this.documentManager, list);
        this.listName = null;
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.review.list.created"), new Object[0]);
    }

    public void deleteTaskList() throws Exception {
        if (this.selectedListId == null) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("label.review.list.notselected"), new Object[0]);
            return;
        }
        JbpmTaskListService service = (JbpmTaskListService)Framework.getService(JbpmTaskListService.class);
        service.deleteTaskList(this.documentManager, this.selectedListId);
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.review.list.deleted"), new Object[0]);
    }

    public void loadTaskList() throws Exception {
        if (this.selectedListId == null) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("label.review.list.notselected"), new Object[0]);
            return;
        }
        ProcessInstance pi = this.jbpmActions.getCurrentProcess();
        if (pi != null && this.jbpmActions.getCanManageParticipants()) {
            JbpmTaskListService service;
            TaskList list;
            ArrayList<Object> virtualTasks = this.jbpmActions.getCurrentVirtualTasks();
            if (virtualTasks == null) {
                virtualTasks = new ArrayList();
            }
            if ((list = (service = (JbpmTaskListService)Framework.getService(JbpmTaskListService.class)).getTaskList(this.documentManager, this.selectedListId)) == null) {
                return;
            }
            for (VirtualTaskInstance task : list.getTasks()) {
                virtualTasks.add(task);
            }
            pi.getContextInstance().setVariable(JbpmService.VariableName.participants.name(), virtualTasks);
            this.jbpmService.persistProcessInstance(pi);
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.review.list.added"), new Object[0]);
        }
    }
}

