/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.jai.JAIUtils;
import it.tidalwave.image.op.AssignColorProfileOp;
import it.tidalwave.image.op.OperationImplementation;
import java.awt.color.ICC_Profile;
import java.awt.image.RenderedImage;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignColorProfileJAIOp
extends OperationImplementation<AssignColorProfileOp, PlanarImage> {
    private static final String CLASS = AssignColorProfileJAIOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected PlanarImage execute(AssignColorProfileOp operation, PlanarImage planarImage) {
        ICC_Profile iccProfile = operation.getICCProfile();
        TiledImage tiledImage = new TiledImage((RenderedImage)planarImage, true);
        int[] bandSelect = new int[planarImage.getSampleModel().getNumBands()];
        for (int i = 0; i < bandSelect.length; ++i) {
            bandSelect[i] = i;
        }
        return tiledImage.getSubImage(bandSelect, JAIUtils.getColorModel(planarImage, iccProfile));
    }
}

