/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;

public class TaggedDocumentRemovedListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(TaggedDocumentRemovedListener.class);

    public void handleEvent(EventBundle events) throws ClientException {
        if (events.containsEventName("documentRemoved")) {
            for (Event event : events) {
                this.handleEvent(event);
            }
        }
    }

    public void handleEvent(Event event) {
        if (!"documentRemoved".equals(event.getName())) {
            return;
        }
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            if (doc == null) {
                return;
            }
            String docId = doc.getId();
            CoreSession coreSession = docCtx.getCoreSession();
            try {
                List tags;
                TagService tagService = (TagService)Framework.getService(TagService.class);
                if (tagService != null && (tags = tagService.getDocumentTags(coreSession, docId, null)) != null) {
                    for (Tag tag : tags) {
                        tagService.untag(coreSession, doc.getId(), tag.getLabel(), null);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            return;
        }
    }
}

