/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.editor.SessionManager;
import org.nuxeo.theme.editor.UndoBuffer;
import org.nuxeo.theme.elements.CellElement;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFactory;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.PageElement;
import org.nuxeo.theme.elements.SectionElement;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatFactory;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.formats.layouts.Layout;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.formats.widgets.Widget;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.fragments.FragmentFactory;
import org.nuxeo.theme.fragments.FragmentType;
import org.nuxeo.theme.html.CSSUtils;
import org.nuxeo.theme.nodes.Node;
import org.nuxeo.theme.nodes.NodeException;
import org.nuxeo.theme.perspectives.PerspectiveManager;
import org.nuxeo.theme.presets.PresetManager;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.properties.FieldIO;
import org.nuxeo.theme.resources.ImageInfo;
import org.nuxeo.theme.resources.ResourceBank;
import org.nuxeo.theme.resources.SkinInfo;
import org.nuxeo.theme.resources.StyleInfo;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeIOException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.themes.ThemeSerializer;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.uids.Identifiable;
import org.nuxeo.theme.views.ViewType;

public class Editor {
    private static final Log log = LogFactory.getLog(Editor.class);

    public static void updateElementWidget(Element element, String viewName) throws ThemeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "change widget view");
        FormatType widgetType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "widget");
        Format widget = ElementFormatter.getFormatByType((Object)element, (FormatType)widgetType);
        ThemeManager themeManager = Manager.getThemeManager();
        if (widget == null) {
            widget = themeManager.createWidget();
        }
        widget.setName(viewName);
        ElementFormatter.setFormat((Object)element, (Format)widget);
        Editor.saveTheme(themeName);
    }

    public static void updateElementLayout(Element element, Map<String, String> propertyMap) throws ThemeException {
        if (element != null) {
            String themeName = ThemeManager.getThemeOf((Element)element).getName();
            Editor.saveToUndoBuffer(themeName, "change layout");
            Layout layout = (Layout)ElementFormatter.getFormatFor((Element)element, (String)"layout");
            if (layout == null) {
                layout = Manager.getThemeManager().createLayout();
                ElementFormatter.setFormat((Object)element, (Format)layout);
            }
            for (String key : propertyMap.keySet()) {
                layout.setProperty(key, propertyMap.get(key));
            }
            Editor.saveTheme(themeName);
        }
    }

    public static void updateElementVisibility(Element element, List<String> perspectives, boolean alwaysVisible) throws ThemeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "change element visibility");
        PerspectiveManager perspectiveManager = Manager.getPerspectiveManager();
        if (alwaysVisible) {
            perspectiveManager.setAlwaysVisible(element);
        } else if (perspectives == null || perspectives.isEmpty()) {
            perspectiveManager.setVisibleInAllPerspectives(element);
        } else {
            perspectiveManager.setVisibleInPerspectives(element, perspectives);
        }
        Editor.saveTheme(themeName);
    }

    public static void updateElementStyle(Element element, Style style, String path, String viewName, Map<String, String> propertyMap) throws ThemeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "update element style");
        Properties properties = new Properties();
        for (String key : propertyMap.keySet()) {
            properties.put(key, propertyMap.get(key));
        }
        if (style == null) {
            FormatType styleType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "style");
            style = (Style)ElementFormatter.getFormatByType((Object)element, (FormatType)styleType);
        }
        if (style.getName() != null || "".equals(viewName)) {
            viewName = "*";
        }
        style.setPropertiesFor(viewName, path, properties);
        Editor.saveTheme(themeName);
    }

    public static void setPageStyles(String themeName, Map<String, String> propertyMap) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "set page styles");
        ThemeManager themeManager = Manager.getThemeManager();
        for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
            String pagePath;
            PageElement page;
            String pageName = entry.getKey();
            String styleName = entry.getValue();
            if ("".equals(styleName)) {
                styleName = null;
            }
            if ((page = themeManager.getPageByPath(pagePath = String.format("%s/%s", themeName, pageName))) == null) continue;
            Style pageStyle = (Style)ElementFormatter.getFormatFor((Element)page, (String)"style");
            if (pageStyle == null) {
                pageStyle = (Style)FormatFactory.create((String)"style");
                ElementFormatter.setFormat((Object)page, (Format)pageStyle);
            }
            Editor.makeElementUseNamedStyle((Element)page, styleName, themeName);
        }
        Editor.saveTheme(themeName);
    }

    public static void splitElement(Element element) throws NodeException, ThemeException {
        String halfWidth;
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "split cell");
        if (!element.getElementType().getTypeName().equals("cell")) {
            return;
        }
        ThemeManager themeManager = Manager.getThemeManager();
        Element newCell = ElementFactory.create((String)"cell");
        Widget cellWidget = themeManager.createWidget();
        cellWidget.setName("cell frame");
        Layout cellLayout = themeManager.createLayout();
        FormatType layoutType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "layout");
        Format layout = ElementFormatter.getFormatByType((Object)element, (FormatType)layoutType);
        String width = layout.getProperty("width");
        if (width != null && (halfWidth = org.nuxeo.theme.html.Utils.divideWebLength((String)width, (int)2)) != null) {
            cellLayout.setProperty("width", halfWidth);
            layout.setProperty("width", org.nuxeo.theme.html.Utils.substractWebLengths((String)width, (String)halfWidth));
        }
        Style cellStyle = themeManager.createStyle();
        ElementFormatter.setFormat((Object)newCell, (Format)cellWidget);
        ElementFormatter.setFormat((Object)newCell, (Format)cellLayout);
        ElementFormatter.setFormat((Object)newCell, (Format)cellStyle);
        newCell.insertAfter((Node)element);
        Editor.saveTheme(themeName);
    }

    public static void updateElementStyleCss(Element element, Style style, String viewName, String cssSource) throws ThemeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "update style properties");
        if (style == null) {
            FormatType styleType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "style");
            style = (Style)ElementFormatter.getFormatByType((Object)element, (FormatType)styleType);
        }
        if (style.isNamed() || "".equals(viewName)) {
            viewName = "*";
        }
        Utils.loadCss((Style)style, (String)cssSource, (String)viewName);
        Editor.saveTheme(themeName);
    }

    public static void updateNamedStyleCss(Style style, String cssSource, String themeName) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "update style properties");
        if (style == null || style.getName() == null) {
            throw new ThemeException("A named style is required.");
        }
        String viewName = "*";
        Utils.loadCss((Style)style, (String)cssSource, (String)"*");
        if (style.isRemote()) {
            style.setCustomized(true);
        }
        Editor.saveTheme(themeName);
    }

    public static void restoreNamedStyle(Style style, String themeName) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "restore style");
        if (style == null || style.getName() == null) {
            throw new ThemeException("A named style is required.");
        }
        if (!style.isRemote()) {
            throw new ThemeException("A style from a remote resource bank is required.");
        }
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)themeName);
        if (themeDescriptor == null) {
            throw new ThemeException("Theme not found: " + themeName);
        }
        String resourceBankName = themeDescriptor.getResourceBankName();
        if (resourceBankName != null) {
            ThemeManager.loadRemoteStyle((String)resourceBankName, (Style)style);
        }
        style.setCustomized(false);
        Editor.saveTheme(themeName);
    }

    public static void updateElementWidth(Format layout, String width) throws ThemeException {
        String themeName = ThemeManager.getThemeOfFormat((Format)layout).getName();
        Editor.saveToUndoBuffer(themeName, "change element width");
        layout.setProperty("width", width);
        Editor.saveTheme(themeName);
    }

    public static void updateElementProperties(Element element, Map<String, String> propertyMap) throws ThemeIOException, ThemeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "change element properties");
        Properties properties = new Properties();
        for (String key : propertyMap.keySet()) {
            properties.put(key, propertyMap.get(key));
        }
        FieldIO.updateFieldsFromProperties((Object)element, (Properties)properties);
        Editor.saveTheme(themeName);
    }

    public static void updateElementDescription(Element element, String description) throws ThemeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "change element description");
        element.setDescription(description);
        Editor.saveTheme(themeName);
    }

    public static void repairTheme(String src) throws ThemeIOException, ThemeException {
        ThemeElement theme = Manager.getThemeManager().getThemeBySrc(src);
        if (theme == null) {
            throw new ThemeIOException("Unknown theme: " + src);
        }
        String themeName = theme.getName();
        Editor.saveToUndoBuffer(themeName, "repair theme");
        ThemeManager.repairTheme((ThemeElement)theme);
        Editor.saveTheme(themeName);
    }

    public static void deleteTheme(String src) throws ThemeIOException, ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        themeManager.deleteTheme(src);
    }

    public static void deletePage(String pagePath) throws ThemeIOException, ThemeException {
        String themeName = pagePath.split("/")[0];
        Editor.saveToUndoBuffer(themeName, "delete page");
        ThemeManager themeManager = Manager.getThemeManager();
        themeManager.deletePage(pagePath);
        Editor.saveTheme(themeName);
    }

    public static void saveTheme(String themeName) throws ThemeException {
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)themeName);
        if (themeDescriptor == null) {
            throw new ThemeException("Theme not found: " + themeName);
        }
        String themeSrc = themeDescriptor.getSrc();
        if (!themeDescriptor.isSaveable()) {
            if (themeDescriptor.isCustomizable()) {
                themeDescriptor = ThemeManager.customizeTheme((ThemeDescriptor)themeDescriptor);
                themeSrc = themeDescriptor.getSrc();
            } else {
                throw new ThemeException("Theme cannot be customized: " + themeName);
            }
        }
        try {
            ThemeManager.saveTheme((String)themeSrc);
        }
        catch (ThemeIOException e) {
            throw new ThemeException("Theme cannot be saved: " + themeName, (Throwable)e);
        }
        ThemeManager themeManager = Manager.getThemeManager();
        themeManager.themeModified(themeName);
        themeManager.stylesModified(themeName);
    }

    public static String renderCssPreview(Element element, Style style, String viewName, String basePath) {
        FormatType styleType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "style");
        if (style == null) {
            style = (Style)ElementFormatter.getFormatByType((Object)element, (FormatType)styleType);
        }
        if (style == null) {
            return "";
        }
        ThemeElement theme = ThemeManager.getThemeOf((Element)element);
        String themeName = theme.getName();
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)themeName);
        StringBuilder css = new StringBuilder();
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Format ancestor : ThemeManager.listAncestorFormatsOf((Format)style)) {
            styles.add(0, (Style)ancestor);
        }
        styles.add(style);
        for (Style s : styles) {
            String name = viewName;
            if (s.getName() != null) {
                name = "*";
            }
            for (String path : s.getPathsForView(name)) {
                css.append("#stylePreviewArea");
                css.append(' ').append(path).append(" {");
                Properties styleProperties = s.getPropertiesFor(name, path);
                Enumeration<?> propertyNames = CSSUtils.getCssProperties().propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    String value = styleProperties.getProperty(propertyName);
                    if (value == null) continue;
                    css.append(propertyName);
                    css.append(':');
                    css.append(value);
                    css.append(';');
                }
                css.append('}');
            }
        }
        return CSSUtils.expandVariables((String)css.toString(), (String)basePath, (ThemeDescriptor)themeDescriptor);
    }

    public static void pasteElement(Element element, String destId) throws ThemeException, NodeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "paste element");
        Element destElement = ThemeManager.getElementById((String)destId);
        if (destElement.isLeaf()) {
            destElement = (Element)destElement.getParent();
        }
        if (element != null) {
            destElement.addChild((Node)Manager.getThemeManager().duplicateElement(element, true));
        }
        Editor.saveTheme(themeName);
    }

    public static void moveElement(Element srcElement, Element destElement, int order) throws ThemeException, NodeException {
        ThemeElement srcTheme = ThemeManager.getThemeOf((Element)srcElement);
        if (srcTheme == null) {
            throw new ThemeException("Could not determing the theme of the element :" + srcElement.computeXPath());
        }
        String themeName = srcTheme.getName();
        Editor.saveToUndoBuffer(themeName, "move element");
        srcElement.moveTo((Node)destElement, Integer.valueOf(order));
        Editor.saveTheme(themeName);
    }

    public static void makeElementUseNamedStyle(Element element, String styleName, String themeName) throws ThemeException {
        Style currentStyle = (Style)ElementFormatter.getFormatFor((Element)element, (String)"style");
        if (currentStyle == null) {
            throw new ThemeException(String.format("Element %s has no style format.", element.computeXPath()));
        }
        Editor.saveToUndoBuffer(themeName, "change element style");
        ThemeManager themeManager = Manager.getThemeManager();
        if (styleName == null) {
            ThemeManager.removeInheritanceTowards((Format)currentStyle);
        } else {
            Style namedStyle = (Style)themeManager.getNamedObject(themeName, "style", styleName);
            if (namedStyle != null) {
                themeManager.makeFormatInherit((Format)currentStyle, (Format)namedStyle);
            }
        }
        Editor.saveTheme(themeName);
    }

    public static void removeStyleInheritance(String styleName, String themeName) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "remove style inheritance");
        ThemeManager themeManager = Manager.getThemeManager();
        Style style = (Style)themeManager.getNamedObject(themeName, "style", styleName);
        if (style == null) {
            throw new ThemeException("Could not find named style: " + styleName);
        }
        ThemeManager.removeInheritanceTowards((Format)style);
        Editor.saveTheme(themeName);
    }

    public static void setStyleInheritance(String styleName, String ancestorStyleName, String themeName) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "set style inheritance");
        boolean allowMany = true;
        ThemeManager.setStyleInheritance((String)styleName, (String)ancestorStyleName, (String)themeName, (boolean)true);
        Editor.saveTheme(themeName);
    }

    public static String addPage(String path) throws ThemeException, NodeException, ThemeIOException {
        ThemeManager themeManager = Manager.getThemeManager();
        if (!path.contains("/")) {
            throw new ThemeException("Incorrect theme path: " + path);
        }
        String themeName = path.split("/")[0];
        String pageName = path.split("/")[1];
        if (themeManager.getPageByPath(path) != null) {
            throw new ThemeException("Theme page name is already taken: " + pageName);
        }
        Editor.saveToUndoBuffer(themeName, "add page");
        ThemeElement theme = themeManager.getThemeByName(themeName);
        PageElement page = (PageElement)ElementFactory.create((String)"page");
        page.setName(pageName);
        Widget pageWidget = themeManager.createWidget();
        pageWidget.setName("page frame");
        Layout pageLayout = themeManager.createLayout();
        Style pageStyle = themeManager.createStyle();
        ElementFormatter.setFormat((Object)page, (Format)pageWidget);
        ElementFormatter.setFormat((Object)page, (Format)pageStyle);
        ElementFormatter.setFormat((Object)page, (Format)pageLayout);
        themeManager.registerPage(theme, page);
        Editor.saveTheme(themeName);
        return path;
    }

    public static String addTheme(String name) throws ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        if (themeManager.getThemeByName(name) != null) {
            throw new ThemeException("The theme name is already taken: " + name);
        }
        ThemeDescriptor themeDef = ThemeManager.createCustomTheme((String)name);
        String themeName = themeDef.getName();
        return String.format("%s/default", themeName);
    }

    public static String uncustomizeTheme(String src) throws ThemeException {
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptor((String)src);
        if (themeDescriptor == null) {
            throw new ThemeException("Theme not found: " + src);
        }
        String themeName = themeDescriptor.getName();
        ThemeManager.uncustomizeTheme((ThemeDescriptor)themeDescriptor);
        return String.format("%s/default", themeName);
    }

    public static void assignStyleProperty(Element element, String propertyName, String value) throws ThemeException {
        Widget widget;
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "change style");
        Style style = (Style)ElementFormatter.getFormatFor((Element)element, (String)"style");
        if (style == null) {
            style = Manager.getThemeManager().createStyle();
            ElementFormatter.setFormat((Object)element, (Format)style);
        }
        if ((widget = (Widget)ElementFormatter.getFormatFor((Element)element, (String)"widget")) == null) {
            return;
        }
        String viewName = widget.getName();
        Properties properties = style.getPropertiesFor(viewName, "");
        if (properties == null) {
            properties = new Properties();
        }
        if ("".equals(value)) {
            properties.remove(propertyName);
        } else {
            properties.setProperty(propertyName, value);
        }
        style.setPropertiesFor(viewName, "", properties);
        Editor.saveTheme(themeName);
    }

    public static void alignElement(Element element, String position) throws ThemeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "change element alignment");
        ThemeManager themeManager = Manager.getThemeManager();
        Layout layout = (Layout)ElementFormatter.getFormatFor((Element)element, (String)"layout");
        if (layout == null) {
            layout = themeManager.createLayout();
            ElementFormatter.setFormat((Object)element, (Format)layout);
        }
        if (element instanceof SectionElement) {
            if (position.equals("left")) {
                layout.setProperty("margin-left", "0");
                layout.setProperty("margin-right", "auto");
            } else if (position.equals("center")) {
                layout.setProperty("margin-left", "auto");
                layout.setProperty("margin-right", "auto");
            } else if (position.equals("right")) {
                layout.setProperty("margin-left", "auto");
                layout.setProperty("margin-right", "0");
            }
        } else if (position.equals("left")) {
            layout.setProperty("text-align", "left");
        } else if (position.equals("center")) {
            layout.setProperty("text-align", "center");
        } else if (position.equals("right")) {
            layout.setProperty("text-align", "right");
        }
        Editor.saveTheme(themeName);
    }

    public static void deleteElement(Element element) throws ThemeException, NodeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "delete element");
        Element parent = (Element)element.getParent();
        ThemeManager themeManager = Manager.getThemeManager();
        if (element instanceof ThemeElement || element instanceof PageElement) {
            themeManager.destroyElement(element);
        } else if (element instanceof CellElement) {
            if (element.hasSiblings()) {
                String width2;
                String newWidth;
                Format layout2;
                String width1;
                FormatType layoutType;
                Format layout1;
                Element sibling = (Element)element.getNextNode();
                if (sibling == null) {
                    sibling = (Element)element.getPreviousNode();
                }
                if ((layout1 = ElementFormatter.getFormatByType((Object)element, (FormatType)(layoutType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "layout")))) != null && (width1 = layout1.getProperty("width")) != null && (layout2 = ElementFormatter.getFormatByType((Object)sibling, (FormatType)layoutType)) != null && (newWidth = org.nuxeo.theme.html.Utils.addWebLengths((String)width1, (String)(width2 = layout2.getProperty("width")))) != null) {
                    layout2.setProperty("width", newWidth);
                }
                themeManager.destroyElement(element);
            } else {
                themeManager.destroyElement(parent);
            }
        } else if (element instanceof Fragment) {
            themeManager.destroyElement(element);
        }
        Editor.saveTheme(themeName);
    }

    public static int duplicateElement(Element element) throws ThemeException, NodeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "duplicate element");
        Element duplicate = Manager.getThemeManager().duplicateElement(element, true);
        element.getParent().addChild((Node)duplicate);
        duplicate.moveTo(element.getParent(), Integer.valueOf(element.getOrder() + 1));
        Editor.saveTheme(themeName);
        return duplicate.getUid();
    }

    public static void createStyle(Element element) throws ThemeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "create style");
        ThemeManager themeManager = Manager.getThemeManager();
        Style style = themeManager.createStyle();
        ElementFormatter.setFormat((Object)element, (Format)style);
        Editor.saveTheme(themeName);
    }

    public static void createNamedStyle(Element element, String styleName, String themeName) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "create style");
        ThemeManager themeManager = Manager.getThemeManager();
        Style style = (Style)themeManager.getNamedObject(themeName, "style", styleName);
        if (style != null) {
            throw new ThemeException("Style name is already taken: " + styleName);
        }
        style = themeManager.createStyle();
        style.setName(styleName);
        themeManager.setNamedObject(themeName, "style", (Identifiable)style);
        if (element != null) {
            themeManager.makeElementUseNamedStyle(element, styleName, themeName);
        }
        Editor.saveTheme(themeName);
    }

    public static Style getNamedStyleOf(Element element) throws ThemeException {
        Style style = (Style)ElementFormatter.getFormatFor((Element)element, (String)"style");
        if (style == null) {
            return null;
        }
        Style ancestorStyle = (Style)ThemeManager.getAncestorFormatOf((Format)style);
        if (ancestorStyle == null || !ancestorStyle.isNamed()) {
            return null;
        }
        return ancestorStyle;
    }

    public static void deleteNamedStyle(Element element, String styleName, String themeName) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "delete style");
        ThemeManager themeManager = Manager.getThemeManager();
        Style style = (Style)themeManager.getNamedObject(themeName, "style", styleName);
        themeManager.deleteFormat((Format)style);
        if (element != null) {
            themeManager.makeElementUseNamedStyle(element, null, themeName);
        }
        themeManager.removeNamedObject(themeName, "style", styleName);
        Editor.saveTheme(themeName);
    }

    public static void deleteStyleView(Style style, String viewName) throws ThemeException {
        String themeName = ThemeManager.getThemeOfFormat((Format)style).getName();
        Editor.saveToUndoBuffer(themeName, "delete style view");
        style.clearPropertiesFor(viewName);
        Editor.saveTheme(themeName);
    }

    public static List<String> getHardcodedColors(String themeName) {
        HashSet colors = new HashSet();
        for (Style style : Manager.getThemeManager().getStyles(themeName)) {
            for (Map.Entry<Object, Object> entry : style.getAllProperties().entrySet()) {
                String value = (String)entry.getValue();
                colors.addAll(CSSUtils.extractCssColors((String)value));
            }
        }
        HashSet<String> colorPresetValues = new HashSet<String>();
        for (PresetType preset : PresetManager.getCustomPresets((String)themeName, (String)"color")) {
            colorPresetValues.add(preset.getValue());
        }
        colors.removeAll(colorPresetValues);
        return new ArrayList<String>(colors);
    }

    public static List<String> getHardcodedImages(String themeName) {
        HashSet images = new HashSet();
        for (Style style : Manager.getThemeManager().getStyles(themeName)) {
            for (Map.Entry<Object, Object> entry : style.getAllProperties().entrySet()) {
                String value = (String)entry.getValue();
                images.addAll(CSSUtils.extractCssImages((String)value));
            }
        }
        HashSet<String> imagePresetValues = new HashSet<String>();
        for (PresetType preset : PresetManager.getCustomPresets((String)themeName)) {
            String category = preset.getCategory();
            if (!"image".equals(category) && !"background".equals(category)) continue;
            imagePresetValues.add(preset.getValue());
        }
        images.removeAll(imagePresetValues);
        return new ArrayList<String>(images);
    }

    public static String addPreset(String themeName, String presetName, String category, String value) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "create preset");
        if (presetName.equals("")) {
            throw new ThemeException("Preset name cannot be empty");
        }
        if (PresetManager.getCustomPreset((String)themeName, (String)presetName) != null) {
            throw new ThemeException("Preset name already taken: " + presetName);
        }
        PresetManager.createCustomPreset((String)themeName, (String)presetName, (String)category, (String)value, (String)"", (String)"");
        Editor.saveTheme(themeName);
        return presetName;
    }

    public static void editPreset(String themeName, String presetName, String value) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "modify preset");
        PresetManager.editPreset((String)themeName, (String)presetName, (String)value);
        Editor.saveTheme(themeName);
    }

    public static void setPresetCategory(String themeName, String presetName, String category) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "change preset category");
        PresetManager.setPresetCategory((String)themeName, (String)presetName, (String)category);
        Editor.saveTheme(themeName);
    }

    public static void renamePreset(String themeName, String oldName, String newName) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "rename preset");
        PresetManager.renamePreset((String)themeName, (String)oldName, (String)newName);
        String oldPresetStr = String.format("\"%s\"", oldName);
        String newPresetStr = String.format("\"%s\"", newName);
        ThemeManager themeManager = Manager.getThemeManager();
        for (Style style : themeManager.getStyles(themeName)) {
            for (String viewName : style.getSelectorViewNames()) {
                for (String path : style.getPathsForView(viewName)) {
                    Properties styleProperties = style.getPropertiesFor(viewName, path);
                    for (Map.Entry<Object, Object> entry : styleProperties.entrySet()) {
                        String text = (String)entry.getValue();
                        String key = (String)entry.getKey();
                        String newText = text.replace(oldPresetStr, newPresetStr);
                        if (newText.equals(text)) continue;
                        styleProperties.setProperty(key, newText);
                    }
                }
            }
        }
        Editor.saveTheme(themeName);
    }

    public static void deletePreset(String themeName, String presetName) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "delete preset");
        PresetManager.deletePreset((String)themeName, (String)presetName);
        Editor.saveTheme(themeName);
    }

    public static void convertCssValueToPreset(String themeName, String category, String presetName, String value) throws ThemeException {
        Editor.saveToUndoBuffer(themeName, "create preset from CSS property");
        if (!"color".equals(category) && !"image".equals(category)) {
            throw new ThemeException("Preset category not supported while converting css value to preset: " + category);
        }
        Editor.addPreset(themeName, presetName, category, value);
        String presetStr = String.format("\"%s\"", presetName);
        ThemeManager themeManager = Manager.getThemeManager();
        for (Style style : themeManager.getStyles(themeName)) {
            for (String viewName : style.getSelectorViewNames()) {
                for (String path : style.getPathsForView(viewName)) {
                    Properties styleProperties = style.getPropertiesFor(viewName, path);
                    for (Map.Entry<Object, Object> entry : styleProperties.entrySet()) {
                        String text = (String)entry.getValue();
                        String key = (String)entry.getKey();
                        String newText = text;
                        if (category.equals("color")) {
                            newText = CSSUtils.replaceColor((String)text, (String)value, (String)presetStr);
                        } else if (category.equals("image")) {
                            newText = CSSUtils.replaceImage((String)text, (String)value, (String)presetStr);
                        }
                        if (newText.equals(text)) continue;
                        styleProperties.setProperty(key, newText);
                    }
                }
            }
        }
        Editor.saveTheme(themeName);
    }

    public static void loadTheme(String src) throws ThemeIOException, ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        themeManager.loadTheme(src);
        ThemeDescriptor themeDef = ThemeManager.getThemeDescriptor((String)src);
        String themeName = themeDef.getName();
        UndoBuffer undoBuffer = SessionManager.getUndoBuffer(themeName);
        if (undoBuffer != null) {
            undoBuffer.clearBuffer();
        }
    }

    public static void insertFragment(Element destElement, String typeName, String styleName) throws NodeException, ThemeException {
        Style ancestor;
        String themeName = ThemeManager.getThemeOf((Element)destElement).getName();
        Editor.saveToUndoBuffer(themeName, "add fragment");
        int order = 0;
        Element destContainer = destElement;
        if (destElement instanceof Fragment) {
            order = destElement.getOrder() + 1;
            destContainer = (Element)destElement.getParent();
        } else if (destElement instanceof CellElement) {
            order = destElement.getChildren().size();
        }
        ThemeManager themeManager = Manager.getThemeManager();
        String fragmentTypeName = typeName.split("/")[0];
        Fragment fragment = FragmentFactory.create((String)fragmentTypeName);
        Widget widget = themeManager.createWidget();
        String viewTypeName = typeName.split("/")[1];
        widget.setName(viewTypeName);
        ElementFormatter.setFormat((Object)fragment, (Format)widget);
        if (!"".equals(styleName) && (ancestor = (Style)themeManager.getNamedObject(themeName, "style", styleName)) != null) {
            Style style = themeManager.createStyle();
            themeManager.makeFormatInherit((Format)style, (Format)ancestor);
            ElementFormatter.setFormat((Object)fragment, (Format)style);
        }
        destContainer.addChild((Node)fragment);
        fragment.moveTo((Node)destContainer, Integer.valueOf(order));
        Editor.saveTheme(themeName);
    }

    public static void insertSectionAfter(Element element) throws NodeException, ThemeException {
        String themeName = ThemeManager.getThemeOf((Element)element).getName();
        Editor.saveToUndoBuffer(themeName, "insert section");
        ThemeManager themeManager = Manager.getThemeManager();
        Element newSection = ElementFactory.create((String)"section");
        Element newCell = ElementFactory.create((String)"cell");
        Widget sectionWidget = themeManager.createWidget();
        sectionWidget.setName("section frame");
        Layout sectionLayout = themeManager.createLayout();
        sectionLayout.setProperty("width", "100%");
        Style sectionStyle = themeManager.createStyle();
        ElementFormatter.setFormat((Object)newSection, (Format)sectionWidget);
        ElementFormatter.setFormat((Object)newSection, (Format)sectionLayout);
        ElementFormatter.setFormat((Object)newSection, (Format)sectionStyle);
        Widget cellWidget = themeManager.createWidget();
        cellWidget.setName("cell frame");
        Layout cellLayout = themeManager.createLayout();
        cellLayout.setProperty("width", "100%");
        Style cellStyle = themeManager.createStyle();
        ElementFormatter.setFormat((Object)newCell, (Format)cellWidget);
        ElementFormatter.setFormat((Object)newCell, (Format)cellLayout);
        ElementFormatter.setFormat((Object)newCell, (Format)cellStyle);
        newSection.addChild((Node)newCell);
        String elementTypeName = element.getElementType().getTypeName();
        if (elementTypeName.equals("section")) {
            newSection.insertAfter((Node)element);
        } else if (elementTypeName.equals("page")) {
            element.addChild((Node)newSection);
        }
        Editor.saveTheme(themeName);
    }

    public static void saveToUndoBuffer(String themeName, String message) throws ThemeException {
        String xmlSource;
        if (themeName == null) {
            throw new ThemeException("Theme not set.");
        }
        ThemeDescriptor themeDef = ThemeManager.getThemeDescriptorByThemeName((String)themeName);
        if (themeDef == null) {
            throw new ThemeException("Theme not found: " + themeName);
        }
        ThemeSerializer serializer = new ThemeSerializer();
        try {
            xmlSource = serializer.serializeToXml(themeDef.getSrc(), 0);
        }
        catch (ThemeIOException e) {
            throw new ThemeException("Could not save theme into the under buffer", (Throwable)e);
        }
        UndoBuffer undoBuffer = SessionManager.getUndoBuffer(themeName);
        if (undoBuffer == null) {
            undoBuffer = new UndoBuffer();
            SessionManager.setUndoBuffer(themeName, undoBuffer);
        }
        undoBuffer.save(xmlSource, message);
    }

    public static String undo(String themeName) throws ThemeException {
        ThemeDescriptor themeDef = ThemeManager.getThemeDescriptorByThemeName(null, (String)themeName);
        if (themeDef == null) {
            throw new ThemeException("Theme unknown." + themeName);
        }
        UndoBuffer undoBuffer = SessionManager.getUndoBuffer(themeName);
        if (undoBuffer == null) {
            throw new ThemeException("No history buffer found.");
        }
        String savedVersion = undoBuffer.getSavedVersion();
        if (savedVersion == null) {
            throw new ThemeException("No saved version found.");
        }
        try {
            Manager.getThemeManager().loadTheme(themeDef.getSrc(), savedVersion);
        }
        catch (ThemeIOException e) {
            throw new ThemeException(e.getMessage(), (Throwable)e);
        }
        undoBuffer.clearBuffer();
        Editor.saveTheme(themeName);
        return undoBuffer.getMessage();
    }

    public static void createFragmentPreview(String currentThemeName) {
        ThemeManager themeManager = Manager.getThemeManager();
        String fragmentType = SessionManager.getFragmentType();
        String viewName = SessionManager.getFragmentView();
        String styleName = SessionManager.getFragmentStyle();
        Fragment fragment = FragmentFactory.create((String)fragmentType);
        try {
            Widget widget = (Widget)FormatFactory.create((String)"widget");
            widget.setName(viewName);
            ElementFormatter.setFormat((Object)fragment, (Format)widget);
            Style style = (Style)FormatFactory.create((String)"style");
            ElementFormatter.setFormat((Object)fragment, (Format)style);
            String themeName = currentThemeName.split("/")[0];
            themeManager.makeElementUseNamedStyle((Element)fragment, styleName, themeName);
            themeManager.fillScratchPage(themeName, (Element)fragment);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        themeManager.themeModified(currentThemeName);
    }

    public static void activateSkin(String themeName, String bankName, String collectionName, String resourceName, boolean isBaseSkin) throws ThemeException {
        String currentTopSkinName = Editor.getCurrentTopSkinName(themeName);
        String currentBaseSkinName = Editor.getCurrentBaseSkinName(themeName);
        for (SkinInfo skin : Editor.getBankSkins(bankName)) {
            if (skin.getName().equals(currentTopSkinName) && skin.isBase()) {
                currentTopSkinName = null;
            }
            if (!skin.getName().equals(currentBaseSkinName) || skin.isBase()) continue;
            currentBaseSkinName = null;
        }
        ThemeManager themeManager = Manager.getThemeManager();
        String skinName = String.format("%s (%s)", resourceName, collectionName);
        if (!isBaseSkin && currentBaseSkinName == null) {
            throw new ThemeException("Cannot set skin: " + skinName + " (base skin is missing)");
        }
        if (isBaseSkin && skinName.equals(currentBaseSkinName)) {
            return;
        }
        Editor.saveToUndoBuffer(themeName, "activate skin");
        if (!isBaseSkin && currentBaseSkinName != null) {
            if (skinName.equals(currentTopSkinName)) {
                return;
            }
            boolean allowMany = false;
            ThemeManager.setStyleInheritance((String)skinName, (String)currentBaseSkinName, (String)themeName, (boolean)false);
        }
        for (PageElement page : themeManager.getPagesOf(themeName)) {
            Style newStyle = themeManager.createStyle();
            ElementFormatter.setFormat((Object)page, (Format)newStyle);
            themeManager.makeElementUseNamedStyle((Element)page, skinName, themeName);
        }
        themeManager.removeOrphanedFormats();
        Editor.saveTheme(themeName);
    }

    public static void deactivateSkin(String themeName) throws ThemeException {
        ThemeManager themeManager = Manager.getThemeManager();
        Editor.saveToUndoBuffer(themeName, "deactivate skin");
        for (PageElement page : themeManager.getPagesOf(themeName)) {
            Style newStyle = themeManager.createStyle();
            ElementFormatter.setFormat((Object)page, (Format)newStyle);
            themeManager.makeElementUseNamedStyle((Element)page, null, themeName);
        }
        themeManager.removeOrphanedFormats();
        Editor.saveTheme(themeName);
    }

    public static String getCurrentTopSkinName(String themeName) {
        Style skinStyle = Editor.getCurrentPageSkin(themeName);
        if (skinStyle == null) {
            return null;
        }
        return skinStyle.getName();
    }

    public static String getCurrentBaseSkinName(String themeName) {
        Style skinStyle = Editor.getCurrentPageSkin(themeName);
        if (skinStyle == null) {
            return null;
        }
        Style ancestorStyle = (Style)ThemeManager.getAncestorFormatOf((Format)skinStyle);
        if (ancestorStyle != null && ancestorStyle.isNamed()) {
            return ancestorStyle.getName();
        }
        return skinStyle.getName();
    }

    public static Style getCurrentPageSkin(String themeName) {
        if (themeName == null) {
            return null;
        }
        ThemeManager themeManager = Manager.getThemeManager();
        FormatType styleType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "style");
        Style skinStyle = null;
        String skinName = null;
        String previousSkinName = null;
        List themePages = themeManager.getPagesOf(themeName);
        if (themePages == null) {
            return null;
        }
        for (PageElement page : themePages) {
            Style style = (Style)ElementFormatter.getFormatByType((Object)page, (FormatType)styleType);
            if (style == null) {
                return null;
            }
            Style ancestorStyle = (Style)ThemeManager.getAncestorFormatOf((Format)style);
            if (ancestorStyle == null || !ancestorStyle.isNamed()) {
                return null;
            }
            skinName = ancestorStyle.getName();
            if (previousSkinName != null && !skinName.equals(previousSkinName)) {
                return null;
            }
            skinStyle = ancestorStyle;
            previousSkinName = skinName;
        }
        return skinStyle;
    }

    public static void useResourceBank(String themeSrc, String bankName) throws ThemeException {
        ResourceBank resourceBank = ThemeManager.getResourceBank((String)bankName);
        if (!resourceBank.checkStatus()) {
            throw new ThemeException("Could not connect to bank: " + bankName);
        }
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptor((String)themeSrc);
        String themeName = themeDescriptor.getName();
        Editor.saveToUndoBuffer(themeName, "connect to theme bank: " + bankName);
        themeDescriptor.setResourceBankName(bankName);
        resourceBank.connect(themeName);
        Editor.saveTheme(themeName);
    }

    public static void useNoResourceBank(String themeSrc) throws ThemeException {
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptor((String)themeSrc);
        String bankName = themeDescriptor.getResourceBankName();
        ResourceBank resourceBank = ThemeManager.getResourceBank((String)bankName);
        if (!resourceBank.checkStatus()) {
            throw new ThemeException("Could not disconnect from bank: " + bankName);
        }
        String themeName = themeDescriptor.getName();
        Editor.saveToUndoBuffer(themeName, "disconnect from theme bank: " + bankName);
        resourceBank.disconnect(themeName);
        themeDescriptor.setResourceBankName(null);
        Editor.saveTheme(themeName);
    }

    public static List<SkinInfo> getBankSkins(String bankName) {
        List<Object> info = new ArrayList<SkinInfo>();
        if (bankName != null) {
            try {
                ResourceBank resourceBank = ThemeManager.getResourceBank((String)bankName);
                info = resourceBank.getSkins();
            }
            catch (ThemeException e) {
                e.printStackTrace();
            }
        }
        return info;
    }

    public static List<StyleInfo> getBankStyles(String bankName) {
        List<Object> info = new ArrayList<StyleInfo>();
        if (bankName != null) {
            try {
                ResourceBank resourceBank = ThemeManager.getResourceBank((String)bankName);
                info = resourceBank.getStyles();
            }
            catch (ThemeException e) {
                e.printStackTrace();
            }
        }
        return info;
    }

    public static SkinInfo getSkinInfo(String bankName, String skinName) {
        ResourceBank resourceBank;
        try {
            resourceBank = ThemeManager.getResourceBank((String)bankName);
        }
        catch (ThemeException e) {
            return null;
        }
        for (SkinInfo skin : resourceBank.getSkins()) {
            if (!skinName.equals(skin.getName())) continue;
            return skin;
        }
        return null;
    }

    public static List<String> getBankCollections(String bankName) {
        ArrayList<String> collections = new ArrayList<String>();
        if (bankName != null) {
            try {
                ResourceBank resourceBank = ThemeManager.getResourceBank((String)bankName);
                collections.addAll(resourceBank.getCollections());
            }
            catch (ThemeException e) {
                e.printStackTrace();
            }
        }
        return collections;
    }

    public static List<ImageInfo> getBankImages(String bankName) {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        if (bankName != null) {
            try {
                ResourceBank resourceBank = ThemeManager.getResourceBank((String)bankName);
                images.addAll(resourceBank.getImages());
            }
            catch (ThemeException e) {
                e.printStackTrace();
            }
        }
        return images;
    }

    public static List<Style> getNamedStyles(String themeName, ResourceBank resourceBank) {
        ArrayList<Style> styles = new ArrayList<Style>();
        ThemeManager themeManager = Manager.getThemeManager();
        for (Identifiable s : themeManager.getNamedObjects(themeName, "style")) {
            styles.add((Style)s);
        }
        return styles;
    }

    public static List<Style> listNamedStylesDirectlyInheritingFrom(Style style) {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Format format : ThemeManager.listFormatsDirectlyInheritingFrom((Format)style)) {
            if (!format.isNamed()) continue;
            styles.add((Style)format);
        }
        return styles;
    }

    public static Map<String, String> getPageStyles(String themeName) {
        LinkedHashMap<String, String> pageStyles = new LinkedHashMap<String, String>();
        List pages = Manager.getThemeManager().getPagesOf(themeName);
        if (!pages.isEmpty()) {
            for (PageElement page : pages) {
                Style namedStyle = null;
                try {
                    namedStyle = Editor.getNamedStyleOf((Element)page);
                }
                catch (ThemeException e) {
                    e.printStackTrace();
                }
                String styleName = namedStyle == null ? "" : namedStyle.getName();
                pageStyles.put(page.getName(), styleName);
            }
        }
        return pageStyles;
    }

    public static Style getThemeSkin(String themeName) {
        List pages = Manager.getThemeManager().getPagesOf(themeName);
        if (pages == null || pages.isEmpty()) {
            return null;
        }
        for (PageElement page : pages) {
            Style namedStyle = null;
            try {
                namedStyle = Editor.getNamedStyleOf((Element)page);
            }
            catch (ThemeException e) {
                e.printStackTrace();
            }
            if (namedStyle == null) continue;
            return namedStyle;
        }
        return null;
    }

    public static List<FragmentType> getFragments(String templateEngine) {
        ArrayList<FragmentType> fragments = new ArrayList<FragmentType>();
        for (Type f : Manager.getTypeRegistry().getTypes(TypeFamily.FRAGMENT)) {
            FragmentType fragmentType = (FragmentType)f;
            if (fragments.contains(fragmentType)) continue;
            ArrayList<ViewType> views = new ArrayList<ViewType>();
            for (ViewType viewType : ThemeManager.getViewTypesForFragmentType((FragmentType)fragmentType)) {
                if (!templateEngine.equals(viewType.getTemplateEngine())) continue;
                views.add(viewType);
            }
            if (views.isEmpty()) continue;
            fragments.add(fragmentType);
        }
        return fragments;
    }

    public static List<ViewType> getViews(String fragmentTypeName, String templateEngine) {
        ArrayList<ViewType> views = new ArrayList<ViewType>();
        if (fragmentTypeName == null) {
            return views;
        }
        FragmentType fragmentType = (FragmentType)Manager.getTypeRegistry().lookup(TypeFamily.FRAGMENT, fragmentTypeName);
        if (fragmentType == null) {
            return views;
        }
        for (ViewType viewType : ThemeManager.getViewTypesForFragmentType((FragmentType)fragmentType)) {
            if (!templateEngine.equals(viewType.getTemplateEngine())) continue;
            views.add(viewType);
        }
        return views;
    }
}

