/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.theme.editor.UndoBuffer;

public class SessionManager {
    private static final long serialVersionUID = 1L;
    private static final String SELECTED_ELEMENT_ID = "org.nuxeo.theme.editor.selected_element";
    private static final String STYLE_EDIT_MODE = "org.nuxeo.theme.editor.style_edit_mode";
    private static final String STYLE_LAYER_ID = "org.nuxeo.theme.editor.style_layer";
    private static final String NAMED_STYLE_ID = "org.nuxeo.theme.editor.named_style";
    private static final String STYLE_SELECTOR = "org.nuxeo.theme.editor.style_selector";
    private static final String STYLE_CATEGORY = "org.nuxeo.theme.editor.style_category";
    private static final String STYLE_MANAGER_MODE = "org.nuxeo.theme.editor.style_manager_mode";
    private static final String PRESET_MANAGER_MODE = "org.nuxeo.theme.editor.preset_manager_mode";
    private static final String PRESET_GROUP = "org.nuxeo.theme.editor.preset_group";
    private static final String PRESET_CATEGORY = "org.nuxeo.theme.editor.preset_category";
    private static final String CLIPBOARD_ELEMENT_ID = "org.nuxeo.theme.editor.clipboard_element";
    private static final String CLIPBOARD_PRESET_ID = "org.nuxeo.theme.editor.clipboard_preset";
    private static final String SELECTED_FRAGMENT_TYPE = "org.nuxeo.theme.editor.fragment_type";
    private static final String SELECTED_FRAGMENT_VIEW = "org.nuxeo.theme.editor.fragment_view";
    private static final String SELECTED_FRAGMENT_STYLE = "org.nuxeo.theme.editor.fragment_style";
    private static final String SELECTED_CSS_CATEGORIES = "org.nuxeo.theme.editor.css_categories";
    private static final String SELECTED_RESOURCE_BANK = "org.nuxeo.theme.editor.resource_bank";
    private static final String WORKSPACE_THEME_NAMES = "org.nuxeo.theme.editor.workspace_theme_names";
    private static final String UNDO_BUFFER = "org.nuxeo.theme.editor.undo_buffer";
    private static final String SELECTED_EDIT_FIELD = "org.nuxeo.theme.editor.edit_field";
    private static final String SELECTED_BANK_COLLECTION = "org.nuxeo.theme.editor.selected_bank_collection";

    private static HttpSession getHttpSession() {
        return WebEngine.getActiveContext().getRequest().getSession();
    }

    public static synchronized void setElementId(String id) {
        SessionManager.getHttpSession().setAttribute(SELECTED_ELEMENT_ID, (Object)id);
    }

    public static synchronized String getElementId() {
        return (String)SessionManager.getHttpSession().getAttribute(SELECTED_ELEMENT_ID);
    }

    public static synchronized String getStyleEditMode() {
        return (String)SessionManager.getHttpSession().getAttribute(STYLE_EDIT_MODE);
    }

    public static synchronized void setStyleEditMode(String mode) {
        SessionManager.getHttpSession().setAttribute(STYLE_EDIT_MODE, (Object)mode);
    }

    public static synchronized String getStyleLayerId() {
        return (String)SessionManager.getHttpSession().getAttribute(STYLE_LAYER_ID);
    }

    public static synchronized void setStyleLayerId(String id) {
        SessionManager.getHttpSession().setAttribute(STYLE_LAYER_ID, (Object)id);
    }

    public static synchronized String getNamedStyleId() {
        return (String)SessionManager.getHttpSession().getAttribute(NAMED_STYLE_ID);
    }

    public static synchronized void setNamedStyleId(String id) {
        SessionManager.getHttpSession().setAttribute(NAMED_STYLE_ID, (Object)id);
    }

    public static synchronized String getStyleSelector() {
        return (String)SessionManager.getHttpSession().getAttribute(STYLE_SELECTOR);
    }

    public static synchronized void setStyleSelector(String selector) {
        SessionManager.getHttpSession().setAttribute(STYLE_SELECTOR, (Object)selector);
    }

    public static synchronized String getStyleCategory() {
        return (String)SessionManager.getHttpSession().getAttribute(STYLE_CATEGORY);
    }

    public static synchronized void setStyleCategory(String category) {
        SessionManager.getHttpSession().setAttribute(STYLE_CATEGORY, (Object)category);
    }

    public static synchronized String getStyleManagerMode() {
        return (String)SessionManager.getHttpSession().getAttribute(STYLE_MANAGER_MODE);
    }

    public static synchronized void setStyleManagerMode(String mode) {
        SessionManager.getHttpSession().setAttribute(STYLE_MANAGER_MODE, (Object)mode);
    }

    public static synchronized String getPresetManagerMode() {
        return (String)SessionManager.getHttpSession().getAttribute(PRESET_MANAGER_MODE);
    }

    public static synchronized void setPresetManagerMode(String mode) {
        SessionManager.getHttpSession().setAttribute(PRESET_MANAGER_MODE, (Object)mode);
    }

    public static synchronized String getPresetGroup() {
        return (String)SessionManager.getHttpSession().getAttribute(PRESET_GROUP);
    }

    public static synchronized void setPresetGroup(String group) {
        SessionManager.getHttpSession().setAttribute(PRESET_GROUP, (Object)group);
    }

    public static synchronized String getPresetCategory() {
        return (String)SessionManager.getHttpSession().getAttribute(PRESET_CATEGORY);
    }

    public static synchronized void setPresetCategory(String category) {
        SessionManager.getHttpSession().setAttribute(PRESET_CATEGORY, (Object)category);
    }

    public static synchronized String getClipboardElementId() {
        return (String)SessionManager.getHttpSession().getAttribute(CLIPBOARD_ELEMENT_ID);
    }

    public static synchronized void setClipboardElementId(String id) {
        SessionManager.getHttpSession().setAttribute(CLIPBOARD_ELEMENT_ID, (Object)id);
    }

    public static synchronized void setClipboardPresetId(String id) {
        SessionManager.getHttpSession().setAttribute(CLIPBOARD_PRESET_ID, (Object)id);
    }

    public static synchronized String getClipboardPresetId() {
        return (String)SessionManager.getHttpSession().getAttribute(CLIPBOARD_PRESET_ID);
    }

    public static synchronized void setFragmentType(String type) {
        SessionManager.getHttpSession().setAttribute(SELECTED_FRAGMENT_TYPE, (Object)type);
    }

    public static synchronized String getFragmentType() {
        return (String)SessionManager.getHttpSession().getAttribute(SELECTED_FRAGMENT_TYPE);
    }

    public static synchronized void setFragmentView(String view) {
        SessionManager.getHttpSession().setAttribute(SELECTED_FRAGMENT_VIEW, (Object)view);
    }

    public static synchronized String getFragmentView() {
        return (String)SessionManager.getHttpSession().getAttribute(SELECTED_FRAGMENT_VIEW);
    }

    public static synchronized void setFragmentStyle(String style) {
        SessionManager.getHttpSession().setAttribute(SELECTED_FRAGMENT_STYLE, (Object)style);
    }

    public static synchronized String getFragmentStyle() {
        return (String)SessionManager.getHttpSession().getAttribute(SELECTED_FRAGMENT_STYLE);
    }

    public static synchronized Set<String> getWorkspaceThemeNames() {
        LinkedHashSet themes = (LinkedHashSet)SessionManager.getHttpSession().getAttribute(WORKSPACE_THEME_NAMES);
        if (themes == null) {
            themes = new LinkedHashSet();
        }
        return themes;
    }

    public static synchronized void setWorkspaceThemeNames(Set<String> themes) {
        SessionManager.getHttpSession().setAttribute(WORKSPACE_THEME_NAMES, themes);
    }

    public static synchronized UndoBuffer getUndoBuffer(String themeName) {
        return (UndoBuffer)SessionManager.getHttpSession().getAttribute(String.format("%s.%s", UNDO_BUFFER, themeName));
    }

    public static synchronized void setUndoBuffer(String themeName, UndoBuffer undoBuffer) {
        SessionManager.getHttpSession().setAttribute(String.format("%s.%s", UNDO_BUFFER, themeName), (Object)undoBuffer);
    }

    public static synchronized List<String> getSelectedCssCategories() {
        ArrayList categories = (ArrayList)SessionManager.getHttpSession().getAttribute(SELECTED_CSS_CATEGORIES);
        if (categories == null) {
            categories = new ArrayList();
        }
        return categories;
    }

    public static synchronized void toggleCssCategory(String name) {
        List<String> categories = SessionManager.getSelectedCssCategories();
        if (categories.contains(name)) {
            categories.remove(name);
        } else {
            categories.add(name);
        }
        SessionManager.setSelectedCssCategories(categories);
    }

    public static synchronized void setSelectedCssCategories(List<String> categories) {
        SessionManager.getHttpSession().setAttribute(SELECTED_CSS_CATEGORIES, categories);
    }

    public static synchronized String getSelectedEditField() {
        return (String)SessionManager.getHttpSession().getAttribute(SELECTED_EDIT_FIELD);
    }

    public static synchronized void setSelectedEditField(String fieldName) {
        SessionManager.getHttpSession().setAttribute(SELECTED_EDIT_FIELD, (Object)fieldName);
    }

    public static void setSelectedBankCollection(String collection) {
        SessionManager.getHttpSession().setAttribute(SELECTED_BANK_COLLECTION, (Object)collection);
    }

    public static String getSelectedBankCollection() {
        return (String)SessionManager.getHttpSession().getAttribute(SELECTED_BANK_COLLECTION);
    }

    public static void setSelectedResourceBank(String bankName) {
        SessionManager.getHttpSession().setAttribute(SELECTED_RESOURCE_BANK, (Object)bankName);
    }

    public static String getSelectedResourceBank() {
        return (String)SessionManager.getHttpSession().getAttribute(SELECTED_RESOURCE_BANK);
    }
}

