/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.runtime.api.login.Authenticator;

public interface UserManager
extends Authenticator,
Serializable {
    public boolean checkUsernamePassword(String var1, String var2) throws ClientException;

    public boolean validatePassword(String var1) throws ClientException;

    public NuxeoPrincipal getPrincipal(String var1) throws ClientException;

    public NuxeoGroup getGroup(String var1) throws ClientException;

    @Deprecated
    public List<NuxeoPrincipal> searchPrincipals(String var1) throws ClientException;

    @Deprecated
    public List<NuxeoGroup> searchGroups(String var1) throws ClientException;

    public List<String> getUserIds() throws ClientException;

    public DocumentModel createUser(DocumentModel var1) throws ClientException, UserAlreadyExistsException;

    public void updateUser(DocumentModel var1) throws ClientException;

    public void deleteUser(DocumentModel var1) throws ClientException;

    public void deleteUser(String var1) throws ClientException;

    public DocumentModel getBareUserModel() throws ClientException;

    public DocumentModel getUserModel(String var1) throws ClientException;

    public DocumentModelList searchUsers(String var1) throws ClientException;

    public DocumentModelList searchUsers(Map<String, Serializable> var1, Set<String> var2) throws ClientException;

    public String getUserListingMode() throws ClientException;

    public String getUserSortField() throws ClientException;

    public Pattern getUserPasswordPattern() throws ClientException;

    public List<String> getGroupIds() throws ClientException;

    public DocumentModelList searchGroups(Map<String, Serializable> var1, HashSet<String> var2) throws ClientException;

    public DocumentModel createGroup(DocumentModel var1) throws ClientException, GroupAlreadyExistsException;

    public void updateGroup(DocumentModel var1) throws ClientException;

    public void deleteGroup(DocumentModel var1) throws ClientException;

    public void deleteGroup(String var1) throws ClientException;

    public DocumentModel getBareGroupModel() throws ClientException;

    public DocumentModel getGroupModel(String var1) throws ClientException;

    public String getDefaultGroup();

    public String getGroupListingMode() throws ClientException;

    public List<String> getGroupsInGroup(String var1) throws ClientException;

    public List<String> getTopLevelGroups() throws ClientException;

    public List<String> getUsersInGroup(String var1) throws ClientException;

    public List<String> getUsersInGroupAndSubGroups(String var1) throws ClientException;

    public Boolean areGroupsReadOnly() throws ClientException;

    public Boolean areUsersReadOnly() throws ClientException;

    public String getUserDirectoryName() throws ClientException;

    public String getUserSchemaName() throws ClientException;

    public String getUserIdField() throws ClientException;

    public String getUserEmailField() throws ClientException;

    public Set<String> getUserSearchFields() throws ClientException;

    public String getGroupDirectoryName() throws ClientException;

    public String getGroupSchemaName() throws ClientException;

    public String getGroupIdField() throws ClientException;

    public String getGroupMembersField() throws ClientException;

    public String getGroupSubGroupsField() throws ClientException;

    public String getGroupParentGroupsField() throws ClientException;

    public String getAnonymousUserId() throws ClientException;

    public void setConfiguration(UserManagerDescriptor var1) throws ClientException;

    public List<String> getAdministratorsGroups();

    @Deprecated
    public DocumentModel getModelForUser(String var1) throws ClientException;

    @Deprecated
    public List<NuxeoPrincipal> getAvailablePrincipals() throws ClientException;

    @Deprecated
    public void createPrincipal(NuxeoPrincipal var1) throws ClientException;

    @Deprecated
    public void updatePrincipal(NuxeoPrincipal var1) throws ClientException;

    @Deprecated
    public void deletePrincipal(NuxeoPrincipal var1) throws ClientException;

    @Deprecated
    public List<NuxeoPrincipal> searchByMap(Map<String, Serializable> var1, Set<String> var2) throws ClientException;

    @Deprecated
    public List<NuxeoGroup> getAvailableGroups() throws ClientException;

    @Deprecated
    public void createGroup(NuxeoGroup var1) throws ClientException;

    @Deprecated
    public void deleteGroup(NuxeoGroup var1) throws ClientException;

    @Deprecated
    public void updateGroup(NuxeoGroup var1) throws ClientException;

    public String[] getUsersForPermission(String var1, ACP var2);

    public static enum MatchType {
        EXACT,
        SUBSTRING;

    }
}

