/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.ServerConfigurator;

public class TomcatConfigurator
extends ServerConfigurator {
    @Deprecated
    public static final String TOMCAT_CONFIG = "conf/Catalina/localhost/nuxeo.xml";
    public static final String DEFAULT_DATA_DIR = "nxserver" + File.separator + "data";
    public static final String DEFAULT_TMP_DIR = "tmp";
    public static final String STARTUP_CLASS = "org.apache.catalina.startup.Bootstrap";
    private static final String DEFAULT_CONTEXT_NAME = "/nuxeo";
    private String contextName = null;

    public TomcatConfigurator(ConfigurationGenerator configurationGenerator) {
        super(configurationGenerator);
    }

    @Override
    protected boolean isConfigured() {
        log.info((Object)"Detected Tomcat server.");
        return new File(this.generator.getNuxeoHome(), this.getTomcatConfig()).exists();
    }

    @Override
    protected File getOutputDirectory() {
        return this.generator.getNuxeoHome();
    }

    @Override
    protected String getDefaultDataDir() {
        return DEFAULT_DATA_DIR;
    }

    @Override
    public void checkPaths() throws ConfigurationException {
        super.checkPaths();
        File oldPath = new File(this.generator.getNuxeoHome(), "nxserver" + File.separator + "data" + File.separator + "vcsh2repo");
        String message = "Please rename 'vcsh2repo' directory from " + oldPath + "to " + new File(this.generator.getDataDir(), "h2" + File.separator + "nuxeo");
        this.checkPath(oldPath, message);
        oldPath = new File(this.generator.getNuxeoHome(), "nxserver" + File.separator + "data" + File.separator + "derby" + File.separator + "nxsqldirectory");
        message = "It is not possible to migrate Derby data." + System.getProperty("line.separator") + "Please remove 'nx*' directories from " + oldPath.getParent() + System.getProperty("line.separator") + "or edit templates/default/" + this.getTomcatConfig() + System.getProperty("line.separator") + "following http://hg.nuxeo.org/nuxeo/nuxeo-distribution/raw-file/release-5.3.2/nuxeo-distribution-resources/src/main/resources/templates-tomcat/default/conf/Catalina/localhost/nuxeo.xml";
        this.checkPath(oldPath, message);
    }

    @Override
    public String getDefaultTmpDir() {
        return DEFAULT_TMP_DIR;
    }

    @Override
    public File getLogConfFile() {
        return new File(this.generator.getNuxeoHome(), "lib" + File.separator + "log4j.xml");
    }

    @Override
    public File getConfigDir() {
        return new File(this.generator.getNuxeoHome(), "nxserver" + File.separator + "config");
    }

    public String getTomcatConfig() {
        return "conf" + File.separator + "Catalina" + File.separator + "localhost" + File.separator + this.getContextName() + ".xml";
    }

    private String getContextName() {
        if (this.contextName == null) {
            Properties userConfig = this.generator.getUserConfig();
            this.contextName = userConfig != null ? this.generator.getUserConfig().getProperty("org.nuxeo.ecm.contextPath", DEFAULT_CONTEXT_NAME).substring(1) : DEFAULT_CONTEXT_NAME.substring(1);
        }
        return this.contextName;
    }

    @Override
    public void prepareWizardStart() {
        try {
            File serverXMLBase = new File(this.generator.getNuxeoHome(), "conf");
            File nuxeoServerXML = new File(serverXMLBase, "server.xml");
            File nuxeoServerXMLOrg = new File(serverXMLBase, "server.xml.nx");
            nuxeoServerXML.delete();
            FileUtils.moveFile((File)nuxeoServerXMLOrg, (File)nuxeoServerXML);
            File contextXML = new File(this.generator.getNuxeoHome(), this.getTomcatConfig());
            contextXML.delete();
            File wizardWAR = new File(this.generator.getNuxeoHome(), "templates" + File.separator + "nuxeo-wizard.war");
            File nuxeoWAR = new File(this.generator.getNuxeoHome(), "webapps" + File.separator + this.getContextName() + ".war");
            nuxeoWAR.delete();
            FileUtils.copyFile((File)wizardWAR, (File)nuxeoWAR);
        }
        catch (IOException e) {
            log.error((Object)"Could not change Tomcat configuration to run wizard instead of Nuxeo.", (Throwable)e);
        }
    }

    @Override
    public void cleanupPostWizard() {
        File nuxeoWAR = new File(this.generator.getNuxeoHome(), "webapps" + File.separator + this.getContextName() + ".war");
        nuxeoWAR.delete();
    }

    @Override
    public boolean isWizardAvailable() {
        File wizardWAR = new File(this.generator.getNuxeoHome(), "templates" + File.separator + "nuxeo-wizard.war");
        return wizardWAR.exists();
    }
}

