/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemLifeCycleListener;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.ItemValidator;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ItemImpl
implements Item,
ItemStateListener {
    private static Logger log = LoggerFactory.getLogger((Class)ItemImpl.class);
    protected static final int STATUS_NORMAL = 0;
    protected static final int STATUS_MODIFIED = 1;
    protected static final int STATUS_DESTROYED = 2;
    protected static final int STATUS_INVALIDATED = 3;
    protected int status;
    protected final ItemId id;
    protected final SessionImpl session;
    protected final RepositoryImpl rep;
    protected ItemState state;
    protected final ItemManager itemMgr;
    protected final SessionItemStateManager stateMgr;
    protected final Map listeners = Collections.synchronizedMap(new ReferenceMap(2, 2));

    ItemImpl(ItemManager itemMgr, SessionImpl session, ItemId id, ItemState state, ItemLifeCycleListener[] listeners) {
        this.session = session;
        this.rep = (RepositoryImpl)session.getRepository();
        this.stateMgr = session.getItemStateManager();
        this.id = id;
        this.itemMgr = itemMgr;
        this.state = state;
        this.status = 0;
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                this.addLifeCycleListener(listeners[i]);
            }
        }
        this.notifyCreated();
    }

    protected void sanityCheck() throws RepositoryException {
        this.session.sanityCheck();
        if (this.status == 2 || this.status == 3) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
    }

    protected boolean isTransient() {
        return this.state.isTransient();
    }

    protected abstract ItemState getOrCreateTransientItemState() throws RepositoryException;

    protected abstract void makePersistent() throws InvalidItemStateException;

    protected void setRemoved() throws RepositoryException {
        if (this.status == 3 || this.status == 2) {
            return;
        }
        ItemState transientState = this.getOrCreateTransientItemState();
        if (transientState.getStatus() == 4) {
            this.stateMgr.disposeTransientItemState(transientState);
        } else {
            transientState.setStatus(3);
            this.stateMgr.moveTransientItemStateToAttic(transientState);
            this.status = 3;
            this.notifyInvalidated();
        }
    }

    ItemState getItemState() {
        return this.state;
    }

    private void notifyCreated() {
        ItemLifeCycleListener[] la = this.listeners.values().toArray(new ItemLifeCycleListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].itemCreated(this);
        }
    }

    protected void notifyInvalidated() {
        ItemLifeCycleListener[] la = this.listeners.values().toArray(new ItemLifeCycleListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].itemInvalidated(this.id, this);
        }
    }

    protected void notifyDestroyed() {
        ItemLifeCycleListener[] la = this.listeners.values().toArray(new ItemLifeCycleListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].itemDestroyed(this.id, this);
        }
    }

    void addLifeCycleListener(ItemLifeCycleListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    void removeLifeCycleListener(ItemLifeCycleListener listener) {
        this.listeners.remove(listener);
    }

    public ItemId getId() {
        return this.id;
    }

    public Path getPrimaryPath() throws RepositoryException {
        return this.session.getHierarchyManager().getPath(this.id);
    }

    private Collection getTransientStates() throws InvalidItemStateException, RepositoryException {
        ArrayList<ItemState> dirty = new ArrayList<ItemState>();
        if (this.isNode()) {
            Iterator iter = this.stateMgr.getDescendantTransientItemStates((NodeId)this.id);
            block13: while (iter.hasNext()) {
                ItemState transientState = (ItemState)iter.next();
                switch (transientState.getStatus()) {
                    case 2: 
                    case 4: {
                        dirty.add(transientState);
                        continue block13;
                    }
                    case 5: {
                        String msg = transientState.getId() + ": the item cannot be saved because it has been modified externally.";
                        log.debug(msg);
                        throw new InvalidItemStateException(msg);
                    }
                    case 6: {
                        String msg = transientState.getId() + ": the item cannot be saved because it has been deleted externally.";
                        log.debug(msg);
                        throw new InvalidItemStateException(msg);
                    }
                    case 0: {
                        String msg = this.safeGetJCRPath() + ": the item cannot be saved; it seems to have been removed externally.";
                        log.debug(msg);
                        throw new InvalidItemStateException(msg);
                    }
                }
                log.debug("unexpected state status (" + transientState.getStatus() + ")");
            }
        }
        if (this.isTransient()) {
            switch (this.state.getStatus()) {
                case 2: {
                    dirty.add(this.state);
                    break;
                }
                case 4: {
                    String msg = this.safeGetJCRPath() + ": cannot save a new item.";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                case 5: {
                    String msg = this.safeGetJCRPath() + ": the item cannot be saved because it has been modified externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                case 6: {
                    String msg = this.safeGetJCRPath() + ": the item cannot be saved because it has been deleted externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                case 0: {
                    String msg = this.safeGetJCRPath() + ": the item cannot be saved; it seems to have been removed externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                default: {
                    log.debug("unexpected state status (" + this.state.getStatus() + ")");
                }
            }
        }
        return dirty;
    }

    private Collection getRemovedStates() throws InvalidItemStateException, RepositoryException {
        ArrayList<ItemState> removed = new ArrayList<ItemState>();
        if (this.isNode()) {
            Iterator iter = this.stateMgr.getDescendantTransientItemStatesInAttic((NodeId)this.id);
            while (iter.hasNext()) {
                ItemState transientState = (ItemState)iter.next();
                if (transientState.getStatus() == 5) {
                    String msg = transientState.getId() + ": the item cannot be removed because it has been modified externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                if (transientState.getStatus() == 6) {
                    String msg = transientState.getId() + ": the item cannot be removed because it has already been deleted externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                removed.add(transientState);
            }
        }
        return removed;
    }

    private void validateTransientItems(Iterator dirtyIter, Iterator removedIter) throws AccessDeniedException, ConstraintViolationException, RepositoryException {
        String msg;
        ItemId id;
        ItemState itemState;
        AccessManager accessMgr = this.session.getAccessManager();
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        ItemValidator validator = new ItemValidator(ntMgr.getNodeTypeRegistry(), this.session.getHierarchyManager(), (PathResolver)this.session);
        while (dirtyIter.hasNext()) {
            String[] constraints;
            String msg2;
            ItemDefinitionImpl def;
            itemState = (ItemState)dirtyIter.next();
            if (itemState.getStatus() != 4 && !accessMgr.isGranted(id = itemState.getId(), 2)) {
                msg = this.itemMgr.safeGetJCRPath(id) + ": not allowed to modify item";
                log.debug(msg);
                throw new AccessDeniedException(msg);
            }
            if (itemState.isNode()) {
                String msg3;
                int i;
                NodeState nodeState = (NodeState)itemState;
                NodeId id2 = nodeState.getNodeId();
                def = ntMgr.getNodeDefinition(nodeState.getDefinitionId());
                NodeTypeImpl pnt = ntMgr.getNodeType(nodeState.getNodeTypeName());
                EffectiveNodeType ent = validator.getEffectiveNodeType(nodeState);
                if (nodeState.getStatus() == 4 || !nodeState.getNodeTypeName().equals(((NodeState)nodeState.getOverlayedState()).getNodeTypeName())) {
                    NodeType[] nta = def.getRequiredPrimaryTypes();
                    for (i = 0; i < nta.length; ++i) {
                        NodeTypeImpl ntReq = (NodeTypeImpl)nta[i];
                        if (pnt.getQName().equals(ntReq.getQName()) || pnt.isDerivedFrom(ntReq.getQName())) continue;
                        msg3 = this.itemMgr.safeGetJCRPath(id2) + " must be of node type " + ntReq.getName();
                        log.debug(msg3);
                        throw new ConstraintViolationException(msg3);
                    }
                }
                PropDef[] pda = ent.getMandatoryPropDefs();
                for (i = 0; i < pda.length; ++i) {
                    PropDef pd = pda[i];
                    if (pd.getDeclaringNodeType().equals(NameConstants.MIX_VERSIONABLE) || nodeState.hasPropertyName(pd.getName())) continue;
                    msg3 = this.itemMgr.safeGetJCRPath(id2) + ": mandatory property " + pd.getName() + " does not exist";
                    log.debug(msg3);
                    throw new ConstraintViolationException(msg3);
                }
                NodeDef[] cnda = ent.getMandatoryNodeDefs();
                for (int i2 = 0; i2 < cnda.length; ++i2) {
                    NodeDef cnd = cnda[i2];
                    if (nodeState.hasChildNodeEntry(cnd.getName())) continue;
                    msg2 = this.itemMgr.safeGetJCRPath(id2) + ": mandatory child node " + cnd.getName() + " does not exist";
                    log.debug(msg2);
                    throw new ConstraintViolationException(msg2);
                }
                continue;
            }
            PropertyState propState = (PropertyState)itemState;
            PropertyId propId = propState.getPropertyId();
            def = ntMgr.getPropertyDefinition(propState.getDefinitionId());
            if (def.isProtected() || (constraints = ((PropertyDefinitionImpl)def).getValueConstraints()) == null) continue;
            InternalValue[] values = propState.getValues();
            try {
                EffectiveNodeType.checkSetPropertyValueConstraints(((PropertyDefinitionImpl)def).unwrap(), values);
            }
            catch (RepositoryException e) {
                String msg4 = this.itemMgr.safeGetJCRPath(propId) + ": " + e.getMessage();
                log.debug(msg4);
                throw new ConstraintViolationException(msg4);
            }
            if (constraints.length <= 0 || ((PropertyDefinitionImpl)def).getRequiredType() != 9) continue;
            for (int i = 0; i < values.length; ++i) {
                boolean satisfied = false;
                String constraintViolationMsg = null;
                try {
                    UUID targetUUID = values[i].getUUID();
                    Node targetNode = this.session.getNodeByUUID(targetUUID);
                    for (int j = 0; j < constraints.length; ++j) {
                        String ntName = constraints[j];
                        if (!targetNode.isNodeType(ntName)) continue;
                        satisfied = true;
                        break;
                    }
                    if (!satisfied) {
                        NodeType[] mixinNodeTypes = targetNode.getMixinNodeTypes();
                        String[] targetMixins = new String[mixinNodeTypes.length];
                        for (int j = 0; j < mixinNodeTypes.length; ++j) {
                            targetMixins[j] = mixinNodeTypes[j].getName();
                        }
                        String targetMixinsString = Text.implode((String[])targetMixins, (String)", ");
                        String constraintsString = Text.implode((String[])constraints, (String)", ");
                        constraintViolationMsg = this.itemMgr.safeGetJCRPath(propId) + ": is constraint to [" + constraintsString + "] but references [primaryType=" + targetNode.getPrimaryNodeType().getName() + ", mixins=" + targetMixinsString + "]";
                    }
                }
                catch (RepositoryException re) {
                    msg2 = this.itemMgr.safeGetJCRPath(propId) + ": failed to check REFERENCE value constraint";
                    log.debug(msg2);
                    throw new ConstraintViolationException(msg2, (Throwable)re);
                }
                if (satisfied) continue;
                log.debug(constraintViolationMsg);
                throw new ConstraintViolationException(constraintViolationMsg);
            }
        }
        while (removedIter.hasNext()) {
            itemState = (ItemState)removedIter.next();
            id = itemState.getId();
            if (accessMgr.isGranted(id, 4)) continue;
            msg = this.itemMgr.safeGetJCRPath(id) + ": not allowed to remove item";
            log.debug(msg);
            throw new AccessDeniedException(msg);
        }
    }

    private void removeTransientItems(Iterator iter) {
        while (iter.hasNext()) {
            ItemState transientState = (ItemState)iter.next();
            ItemState persistentState = transientState.getOverlayedState();
            this.stateMgr.destroy(persistentState);
        }
    }

    private void persistTransientItems(Iterator iter) throws RepositoryException {
        while (iter.hasNext()) {
            ItemState itemState = (ItemState)iter.next();
            ItemImpl item = this.itemMgr.getItem(itemState);
            item.makePersistent();
        }
    }

    private void restoreTransientItems(Iterator iter) {
        while (iter.hasNext()) {
            ItemState itemState = (ItemState)iter.next();
            ItemId id = itemState.getId();
            try {
                ItemImpl item;
                if (this.stateMgr.isItemStateInAttic(id)) {
                    item = itemState.isNode() ? this.itemMgr.createNodeInstance((NodeState)itemState) : this.itemMgr.createPropertyInstance((PropertyState)itemState);
                    itemState.setStatus(4);
                } else {
                    try {
                        item = this.itemMgr.getItem(id);
                    }
                    catch (ItemNotFoundException infe) {
                        item = itemState.isNode() ? this.itemMgr.createNodeInstance((NodeState)itemState) : this.itemMgr.createPropertyInstance((PropertyState)itemState);
                        itemState.setStatus(4);
                    }
                }
                if (item.isTransient()) continue;
                if (item.isNode()) {
                    NodeImpl node = (NodeImpl)item;
                    node.restoreTransient((NodeState)itemState);
                    continue;
                }
                PropertyImpl prop = (PropertyImpl)item;
                prop.restoreTransient((PropertyState)itemState);
            }
            catch (RepositoryException re) {
                String msg = this.itemMgr.safeGetJCRPath(id) + ": failed to restore transient state";
                log.warn(msg, (Throwable)re);
            }
        }
    }

    private boolean initVersionHistories(Iterator iter) throws RepositoryException {
        boolean createdTransientState = false;
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        ItemValidator validator = new ItemValidator(ntMgr.getNodeTypeRegistry(), this.session.getHierarchyManager(), (PathResolver)this.session);
        while (iter.hasNext()) {
            NodeState nodeState;
            EffectiveNodeType nt;
            ItemState itemState = (ItemState)iter.next();
            if (!itemState.isNode() || !(nt = validator.getEffectiveNodeType(nodeState = (NodeState)itemState)).includesNodeType(NameConstants.MIX_VERSIONABLE) || nodeState.hasPropertyName(NameConstants.JCR_VERSIONHISTORY)) continue;
            NodeImpl node = (NodeImpl)this.itemMgr.getItem(itemState.getId());
            VersionManager vMgr = this.session.getVersionManager();
            VersionHistory vh = vMgr.getVersionHistory((Session)this.session, nodeState);
            if (vh == null) {
                vh = vMgr.createVersionHistory((Session)this.session, nodeState);
            }
            node.internalSetProperty(NameConstants.JCR_VERSIONHISTORY, InternalValue.create(new UUID(vh.getUUID())));
            node.internalSetProperty(NameConstants.JCR_BASEVERSION, InternalValue.create(new UUID(vh.getRootVersion().getUUID())));
            node.internalSetProperty(NameConstants.JCR_ISCHECKEDOUT, InternalValue.create(true));
            node.internalSetProperty(NameConstants.JCR_PREDECESSORS, new InternalValue[]{InternalValue.create(new UUID(vh.getRootVersion().getUUID()))});
            createdTransientState = true;
        }
        return createdTransientState;
    }

    public String safeGetJCRPath() {
        return this.itemMgr.safeGetJCRPath(this.id);
    }

    protected void internalRemove(boolean noChecks) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        String msg;
        PropertyDefinition def;
        this.sanityCheck();
        Path.Element thisName = this.getPrimaryPath().getNameElement();
        if (this.isNode()) {
            NodeImpl node = (NodeImpl)this;
            if (node.getDepth() == 0) {
                String msg2 = this.safeGetJCRPath() + ": cannot remove root node";
                log.debug(msg2);
                throw new RepositoryException(msg2);
            }
            def = node.getDefinition();
            if (!noChecks && def.isProtected()) {
                String msg3 = this.safeGetJCRPath() + ": cannot remove a protected node";
                log.debug(msg3);
                throw new ConstraintViolationException(msg3);
            }
        } else {
            PropertyImpl prop = (PropertyImpl)this;
            def = prop.getDefinition();
            if (!noChecks && def.isProtected()) {
                String msg4 = this.safeGetJCRPath() + ": cannot remove a protected property";
                log.debug(msg4);
                throw new ConstraintViolationException(msg4);
            }
        }
        NodeImpl parentNode = (NodeImpl)this.getParent();
        if (!noChecks && !parentNode.internalIsCheckedOut()) {
            msg = parentNode.safeGetJCRPath() + ": cannot remove a child of a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        if (!noChecks && parentNode.getDefinition().isProtected()) {
            msg = parentNode.safeGetJCRPath() + ": cannot remove a child of a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        if (!noChecks) {
            parentNode.checkLock();
        }
        if (this.isNode()) {
            parentNode.removeChildNode(thisName.getName(), thisName.getIndex());
        } else {
            parentNode.removeChildProperty(thisName.getName());
        }
    }

    public abstract Name getQName() throws RepositoryException;

    public void stateCreated(ItemState created) {
        this.status = 0;
    }

    public void stateDestroyed(ItemState destroyed) {
        if (this.state == destroyed) {
            this.status = 2;
            if (this.state == destroyed) {
                this.state = null;
            }
            this.notifyDestroyed();
        }
    }

    public void stateModified(ItemState modified) {
        if (this.state == modified) {
            this.status = 1;
        }
    }

    public void stateDiscarded(ItemState discarded) {
        if (this.state == discarded) {
            if (this.isTransient()) {
                switch (this.state.getStatus()) {
                    case 2: 
                    case 3: 
                    case 5: {
                        ItemState persistentState = this.state.getOverlayedState();
                        this.stateMgr.disconnectTransientItemState(this.state);
                        this.state = persistentState;
                        return;
                    }
                    case 6: {
                        this.notifyDestroyed();
                        this.status = 2;
                        this.state = null;
                        return;
                    }
                    case 4: {
                        this.notifyDestroyed();
                        this.status = 2;
                        this.state = null;
                        return;
                    }
                }
            }
            this.notifyInvalidated();
            this.status = 3;
        }
    }

    public abstract void accept(ItemVisitor var1) throws RepositoryException;

    public abstract boolean isNode();

    public abstract String getName() throws RepositoryException;

    public abstract Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException;

    public boolean isNew() {
        return this.state.isTransient() && this.state.getOverlayedState() == null;
    }

    protected boolean isTransactionalNew() {
        return this.state.getStatus() == 4;
    }

    public boolean isModified() {
        return this.state.isTransient() && this.state.getOverlayedState() != null;
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.internalRemove(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.sanityCheck();
        SessionImpl sessionImpl = this.session;
        synchronized (sessionImpl) {
            ItemState transientState;
            Iterator it;
            Collection dirty = this.getTransientStates();
            if (dirty.size() == 0) {
                return;
            }
            Collection removed = this.getRemovedStates();
            HashSet<ItemId> affectedIds = new HashSet<ItemId>(dirty.size() + removed.size());
            IteratorChain it2 = new IteratorChain(dirty.iterator(), removed.iterator());
            while (it2.hasNext()) {
                affectedIds.add(((ItemState)it2.next()).getId());
            }
            it2 = new IteratorChain(dirty.iterator(), removed.iterator());
            while (it2.hasNext()) {
                NodeState.ChildNodeEntry cne;
                ItemState transientState2 = (ItemState)it2.next();
                if (!transientState2.isNode()) continue;
                NodeState nodeState = (NodeState)transientState2;
                HashSet<NodeId> dependentIDs = new HashSet<NodeId>();
                if (nodeState.hasOverlayedState()) {
                    NodeState overlayedState = (NodeState)nodeState.getOverlayedState();
                    NodeId oldParentId = overlayedState.getParentId();
                    NodeId newParentId = nodeState.getParentId();
                    if (oldParentId != null) {
                        if (newParentId == null) {
                            dependentIDs.add(oldParentId);
                        } else if (!oldParentId.equals(newParentId)) {
                            dependentIDs.add(oldParentId);
                            dependentIDs.add(newParentId);
                        } else if (!affectedIds.contains(newParentId) && this.stateMgr.hasTransientItemState(newParentId)) {
                            try {
                                NodeState parent = (NodeState)this.stateMgr.getTransientItemState(newParentId);
                                Iterator cneIt = parent.getRenamedChildNodeEntries().iterator();
                                while (cneIt.hasNext()) {
                                    NodeState.ChildNodeEntry cne2 = (NodeState.ChildNodeEntry)cneIt.next();
                                    if (!cne2.getId().equals(nodeState.getId())) continue;
                                    dependentIDs.add(newParentId);
                                }
                            }
                            catch (ItemStateException ise) {
                                log.warn("failed to retrieve transient state: " + newParentId, (Throwable)((Object)ise));
                            }
                        }
                    }
                }
                Iterator cneIt = nodeState.getRemovedChildNodeEntries().iterator();
                while (cneIt.hasNext()) {
                    cne = (NodeState.ChildNodeEntry)cneIt.next();
                    dependentIDs.add(cne.getId());
                }
                cneIt = nodeState.getAddedChildNodeEntries().iterator();
                while (cneIt.hasNext()) {
                    cne = (NodeState.ChildNodeEntry)cneIt.next();
                    dependentIDs.add(cne.getId());
                }
                Iterator depIt = dependentIDs.iterator();
                while (depIt.hasNext()) {
                    NodeId id = (NodeId)depIt.next();
                    if (affectedIds.contains(id) || !this.stateMgr.hasTransientItemState(id) && !this.stateMgr.hasTransientItemStateInAttic(id)) continue;
                    String msg = this.itemMgr.safeGetJCRPath(id) + " needs to be saved as well.";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
            }
            this.validateTransientItems(dirty.iterator(), removed.iterator());
            try {
                this.stateMgr.edit();
            }
            catch (IllegalStateException e) {
                String msg = "Unable to start edit operation";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
            boolean succeeded = false;
            try {
                this.removeTransientItems(removed.iterator());
                if (this.initVersionHistories(dirty.iterator())) {
                    dirty = this.getTransientStates();
                }
                this.persistTransientItems(dirty.iterator());
                it = dirty.iterator();
                while (it.hasNext()) {
                    transientState = (ItemState)it.next();
                    this.stateMgr.disposeTransientItemState(transientState);
                }
                this.stateMgr.update();
                succeeded = true;
            }
            catch (StaleItemStateException e) {
                throw new InvalidItemStateException(e.getMessage());
            }
            catch (ItemStateException e) {
                String msg = this.safeGetJCRPath() + ": unable to update item.";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)((Object)e));
            }
            finally {
                if (!succeeded) {
                    this.stateMgr.cancel();
                    this.restoreTransientItems(dirty.iterator());
                }
            }
            it = removed.iterator();
            while (it.hasNext()) {
                transientState = (ItemState)it.next();
                this.stateMgr.disposeTransientItemStateInAttic(transientState);
            }
        }
    }

    public synchronized void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        Iterator iter;
        ItemState transientState;
        this.sanityCheck();
        if (keepChanges) {
            return;
        }
        if (this.isNode() && this.getDepth() == 0) {
            this.stateMgr.disposeAllTransientItemStates();
            return;
        }
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        if (this.isTransient()) {
            transientState = this.state;
            switch (transientState.getStatus()) {
                case 2: 
                case 5: 
                case 6: {
                    list.add(transientState);
                    break;
                }
                case 4: {
                    String msg = this.safeGetJCRPath() + ": cannot refresh a new item.";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                default: {
                    log.debug("unexpected state status (" + transientState.getStatus() + ")");
                }
            }
        }
        if (this.isNode()) {
            iter = this.stateMgr.getDescendantTransientItemStates((NodeId)this.id);
            block7: while (iter.hasNext()) {
                transientState = (ItemState)iter.next();
                switch (transientState.getStatus()) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        list.add(transientState);
                        continue block7;
                    }
                }
                log.debug("unexpected state status (" + transientState.getStatus() + ")");
            }
        }
        iter = list.iterator();
        while (iter.hasNext()) {
            transientState = (ItemState)iter.next();
            this.stateMgr.disposeTransientItemState(transientState);
        }
        if (this.isNode()) {
            iter = this.stateMgr.getDescendantTransientItemStatesInAttic((NodeId)this.id);
            while (iter.hasNext()) {
                transientState = (ItemState)iter.next();
                this.stateMgr.disposeTransientItemStateInAttic(transientState);
            }
        }
    }

    public Item getAncestor(int degree) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        if (degree == 0) {
            return this.itemMgr.getRootNode();
        }
        try {
            Path path = this.getPrimaryPath();
            int relDegree = path.getAncestorCount() - degree;
            if (relDegree < 0) {
                throw new ItemNotFoundException();
            }
            if (relDegree == 0) {
                return this;
            }
            Path ancestorPath = path.getAncestor(relDegree);
            return this.itemMgr.getNode(ancestorPath);
        }
        catch (PathNotFoundException pnfe) {
            throw new ItemNotFoundException();
        }
    }

    public String getPath() throws RepositoryException {
        this.sanityCheck();
        return this.session.getJCRPath(this.getPrimaryPath());
    }

    public int getDepth() throws RepositoryException {
        this.sanityCheck();
        if (this.state.getParentId() == null) {
            return 0;
        }
        return this.session.getHierarchyManager().getDepth(this.id);
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        this.sanityCheck();
        if (this == otherItem) {
            return true;
        }
        if (otherItem instanceof ItemImpl) {
            ItemImpl other = (ItemImpl)otherItem;
            return this.id.equals(other.id) && this.session.getWorkspace().getName().equals(other.getSession().getWorkspace().getName());
        }
        return false;
    }
}

