/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.persistence.bundle.util.StringIndex;

public class HashMapIndex
implements StringIndex {
    static final String CVS_ID = "$URL: http://svn.eu.apache.org/repos/asf/jackrabbit/tags/jackrabbit-core-1.4.5/src/main/java/org/apache/jackrabbit/core/persistence/bundle/util/HashMapIndex.java $ $Rev: 517150 $ $Date: 2007-03-12 11:42:12 +0200 (Mon, 12 Mar 2007) $";
    private final HashMap stringToIndex = new HashMap();
    private final HashMap indexToString = new HashMap();
    private final Properties stringToIndexProps = new Properties();
    private FileSystemResource file;
    private long lastModified = -1L;

    public HashMapIndex(FileSystemResource file) throws FileSystemException, IOException {
        this.file = file;
        if (!file.exists()) {
            file.makeParentDirs();
            file.getOutputStream().close();
        }
        this.load();
    }

    private void load() throws IOException, FileSystemException {
        long modTime = this.file.lastModified();
        if (modTime > this.lastModified) {
            InputStream in = this.file.getInputStream();
            this.stringToIndexProps.clear();
            this.stringToIndexProps.load(in);
            Iterator<Object> iter = this.stringToIndexProps.keySet().iterator();
            while (iter.hasNext()) {
                String uri = (String)iter.next();
                String prop = this.stringToIndexProps.getProperty(uri);
                Integer idx = new Integer(prop);
                this.stringToIndex.put(uri, idx);
                this.indexToString.put(idx, uri);
            }
            in.close();
        }
        this.lastModified = modTime;
    }

    private void save() throws IOException, FileSystemException {
        OutputStream out = this.file.getOutputStream();
        this.stringToIndexProps.store(out, "string index");
        out.close();
        this.lastModified = this.file.lastModified();
    }

    public int stringToIndex(String nsUri) {
        Integer idx = (Integer)this.stringToIndex.get(nsUri);
        if (idx == null) {
            try {
                this.load();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load lookup table: " + e);
            }
            idx = (Integer)this.stringToIndex.get(nsUri);
        }
        if (idx == null) {
            idx = new Integer(this.indexToString.size());
            this.stringToIndex.put(nsUri, idx);
            this.indexToString.put(idx, nsUri);
            this.stringToIndexProps.put(nsUri, idx.toString());
            try {
                this.save();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to store lookup table: " + e);
            }
        }
        return idx;
    }

    public String indexToString(int i) {
        Integer idx = new Integer(i);
        String s = (String)this.indexToString.get(idx);
        if (s == null) {
            try {
                this.load();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load lookup table: " + e);
            }
            s = (String)this.indexToString.get(idx);
        }
        return s;
    }
}

