/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.query.lucene.CachingMultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheckError;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsistencyCheck {
    private static final Logger log = LoggerFactory.getLogger((Class)ConsistencyCheck.class);
    private final ItemStateManager stateMgr;
    private final MultiIndex index;
    private Set documentUUIDs;
    private final List errors = new ArrayList();

    private ConsistencyCheck(MultiIndex index, ItemStateManager mgr) {
        this.index = index;
        this.stateMgr = mgr;
    }

    static ConsistencyCheck run(MultiIndex index, ItemStateManager mgr) throws IOException {
        ConsistencyCheck check = new ConsistencyCheck(index, mgr);
        check.run();
        return check;
    }

    void repair(boolean ignoreFailure) throws IOException {
        if (this.errors.size() == 0) {
            log.info("No errors found.");
            return;
        }
        int notRepairable = 0;
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            ConsistencyCheckError error = (ConsistencyCheckError)it.next();
            try {
                if (error.repairable()) {
                    error.repair();
                    continue;
                }
                log.warn("Not repairable: " + error);
                ++notRepairable;
            }
            catch (Exception e2) {
                IOException e2;
                if (ignoreFailure) {
                    log.warn("Exception while reparing: " + e2);
                    continue;
                }
                if (!(e2 instanceof IOException)) {
                    e2 = new IOException(e2.getMessage());
                }
                throw (IOException)e2;
            }
        }
        log.info("Repaired " + (this.errors.size() - notRepairable) + " errors.");
        if (notRepairable > 0) {
            log.warn("" + notRepairable + " error(s) not repairable.");
        }
    }

    List getErrors() {
        return new ArrayList(this.errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws IOException {
        UUID uuid;
        HashSet<UUID> multipleEntries = new HashSet<UUID>();
        this.documentUUIDs = new HashSet();
        CachingMultiIndexReader reader = this.index.getIndexReader();
        try {
            for (int i = 0; i < reader.maxDoc(); ++i) {
                if (i > 10 && i % (reader.maxDoc() / 5) == 0) {
                    long progress = Math.round(100.0 * (double)i / (double)((float)reader.maxDoc() * 2.0f));
                    log.info("progress: " + progress + "%");
                }
                if (reader.isDeleted(i)) continue;
                Document d = reader.document(i, FieldSelectors.UUID);
                uuid = UUID.fromString((String)d.get(FieldNames.UUID));
                if (this.stateMgr.hasItemState(new NodeId(uuid))) {
                    if (this.documentUUIDs.add(uuid)) continue;
                    multipleEntries.add(uuid);
                    continue;
                }
                this.errors.add(new NodeDeleted(uuid));
            }
        }
        finally {
            reader.close();
        }
        Iterator it = multipleEntries.iterator();
        while (it.hasNext()) {
            this.errors.add(new MultipleEntries((UUID)it.next()));
        }
        reader = this.index.getIndexReader();
        try {
            for (int i = 0; i < reader.maxDoc(); ++i) {
                if (i > 10 && i % (reader.maxDoc() / 5) == 0) {
                    long progress = Math.round(100.0 * (double)i / (double)((float)reader.maxDoc() * 2.0f));
                    log.info("progress: " + (progress + 50L) + "%");
                }
                if (reader.isDeleted(i)) continue;
                Document d = reader.document(i, FieldSelectors.UUID_AND_PARENT);
                uuid = UUID.fromString((String)d.get(FieldNames.UUID));
                String parentUUIDString = d.get(FieldNames.PARENT);
                UUID parentUUID = null;
                if (parentUUIDString.length() > 0) {
                    parentUUID = UUID.fromString((String)parentUUIDString);
                }
                if (parentUUID == null || this.documentUUIDs.contains(parentUUID)) continue;
                NodeId parentId = new NodeId(parentUUID);
                if (this.stateMgr.hasItemState(parentId)) {
                    this.errors.add(new MissingAncestor(uuid, parentUUID));
                    continue;
                }
                this.errors.add(new UnknownParent(uuid, parentUUID));
            }
        }
        finally {
            reader.close();
        }
    }

    private String getPath(NodeState node) {
        String uuid = node.getNodeId().toString();
        StringBuffer path = new StringBuffer();
        ArrayList<NodeState.ChildNodeEntry> elements = new ArrayList<NodeState.ChildNodeEntry>();
        try {
            while (node.getParentId() != null) {
                NodeId parentId = node.getParentId();
                NodeState parent = (NodeState)this.stateMgr.getItemState(parentId);
                NodeState.ChildNodeEntry entry = parent.getChildNodeEntry(node.getNodeId());
                elements.add(entry);
                node = parent;
            }
            for (int i = elements.size() - 1; i > -1; --i) {
                NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)elements.get(i);
                path.append('/').append(entry.getName().getLocalName());
                if (entry.getIndex() <= 1) continue;
                path.append('[').append(entry.getIndex()).append(']');
            }
            if (path.length() == 0) {
                path.append('/');
            }
            return path.toString();
        }
        catch (ItemStateException e) {
            return uuid;
        }
    }

    private class NodeDeleted
    extends ConsistencyCheckError {
        NodeDeleted(UUID uuid) {
            super("Node " + uuid + " does not longer exist.", uuid);
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            log.info("Removing deleted node from index: " + this.uuid);
            ConsistencyCheck.this.index.removeDocument(this.uuid);
        }
    }

    private class MultipleEntries
    extends ConsistencyCheckError {
        MultipleEntries(UUID uuid) {
            super("Multiple entries found for node " + uuid, uuid);
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            ConsistencyCheck.this.index.removeAllDocuments(this.uuid);
            try {
                NodeState node = (NodeState)ConsistencyCheck.this.stateMgr.getItemState(new NodeId(this.uuid));
                log.info("Re-indexing duplicate node occurrences in index: " + ConsistencyCheck.this.getPath(node));
                Document d = ConsistencyCheck.this.index.createDocument(node);
                ConsistencyCheck.this.index.addDocument(d);
                ConsistencyCheck.this.documentUUIDs.add(node.getNodeId().getUUID());
            }
            catch (ItemStateException e) {
                throw new IOException(e.toString());
            }
            catch (RepositoryException e) {
                throw new IOException(e.toString());
            }
        }
    }

    private class UnknownParent
    extends ConsistencyCheckError {
        private UnknownParent(UUID uuid, UUID parentUUID) {
            super("Node " + uuid + " has unknown parent: " + parentUUID, uuid);
        }

        public boolean repairable() {
            return false;
        }

        public void repair() throws IOException {
            log.warn("Unknown parent for " + this.uuid + " cannot be repaired");
        }
    }

    private class MissingAncestor
    extends ConsistencyCheckError {
        private final UUID parentUUID;

        private MissingAncestor(UUID uuid, UUID parentUUID) {
            super("Parent of " + uuid + " missing in index. Parent: " + parentUUID, uuid);
            this.parentUUID = parentUUID;
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            NodeId parentId = new NodeId(this.parentUUID);
            while (parentId != null && !ConsistencyCheck.this.documentUUIDs.contains(parentId.getUUID())) {
                try {
                    NodeState n = (NodeState)ConsistencyCheck.this.stateMgr.getItemState(parentId);
                    log.info("Reparing missing node " + ConsistencyCheck.this.getPath(n));
                    Document d = ConsistencyCheck.this.index.createDocument(n);
                    ConsistencyCheck.this.index.addDocument(d);
                    ConsistencyCheck.this.documentUUIDs.add(n.getNodeId().getUUID());
                    parentId = n.getParentId();
                }
                catch (ItemStateException e) {
                    throw new IOException(e.toString());
                }
                catch (RepositoryException e) {
                    throw new IOException(e.toString());
                }
            }
        }
    }
}

