/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BLOBInResource
extends BLOBFileValue {
    private static final Logger LOG = LoggerFactory.getLogger((Class)BLOBInResource.class);
    private static final String PREFIX = "fsResource:";
    private final FileSystemResource fsResource;
    private final long length;

    private BLOBInResource(FileSystemResource fsResource) throws IOException {
        try {
            if (!fsResource.exists()) {
                throw new IOException(fsResource.getPath() + ": the specified resource does not exist");
            }
            this.length = fsResource.length();
        }
        catch (FileSystemException fse) {
            throw new IOException(fsResource.getPath() + ": Error while creating value: " + fse.toString());
        }
        this.fsResource = fsResource;
    }

    static BLOBInResource getInstance(FileSystemResource fsResource) throws IOException {
        return new BLOBInResource(fsResource);
    }

    public void delete(boolean pruneEmptyParentDirs) {
        try {
            this.fsResource.delete(pruneEmptyParentDirs);
        }
        catch (FileSystemException fse) {
            LOG.warn("Error while deleting BLOBFileValue: " + fse.getMessage());
        }
    }

    public void discard() {
    }

    public boolean isImmutable() {
        return false;
    }

    public long getLength() {
        return this.length;
    }

    public InputStream getStream() throws RepositoryException {
        try {
            return this.fsResource.getInputStream();
        }
        catch (FileSystemException fse) {
            throw new RepositoryException(this.fsResource.getPath() + ": the specified resource does not exist", (Throwable)((Object)fse));
        }
    }

    public String toString() {
        return PREFIX + this.fsResource.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BLOBInResource) {
            BLOBInResource other = (BLOBInResource)obj;
            return this.length == other.length && this.fsResource.equals(other.fsResource);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

