/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.xml.DocViewImportHandler;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.SysViewImportHandler;
import org.apache.jackrabbit.core.xml.TargetImportHandler;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportHandler
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger((Class)ImportHandler.class);
    protected final Importer importer;
    protected final NamespaceRegistryImpl nsReg;
    protected final NamespaceResolver nsResolver;
    protected Locator locator;
    private TargetImportHandler targetHandler;
    private Map localNamespaceMappings;

    public ImportHandler(Importer importer, NamespaceResolver nsResolver, NamespaceRegistryImpl nsReg) {
        this.importer = importer;
        this.nsResolver = nsResolver;
        this.nsReg = nsReg;
    }

    public void warning(SAXParseException e) throws SAXException {
        log.warn("warning encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream", (Throwable)e);
    }

    public void error(SAXParseException e) throws SAXException {
        log.error("error encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream: " + e.toString());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        log.error("fatal error encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream: " + e.toString());
        throw e;
    }

    public void startDocument() throws SAXException {
        this.targetHandler = null;
        try {
            this.localNamespaceMappings = new HashMap();
            String[] uris = this.nsReg.getURIs();
            for (int i = 0; i < uris.length; ++i) {
                this.localNamespaceMappings.put(this.nsResolver.getPrefix(uris[i]), uris[i]);
            }
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    public void endDocument() throws SAXException {
        this.targetHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.localNamespaceMappings.put(prefix, uri);
        try {
            this.nsReg.safeRegisterNamespace(prefix, uri);
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.targetHandler == null) {
            this.targetHandler = "http://www.jcp.org/jcr/sv/1.0".equals(namespaceURI) ? new SysViewImportHandler(this.importer) : new DocViewImportHandler(this.importer);
            this.targetHandler.startDocument();
        }
        this.targetHandler.startNamespaceContext(this.localNamespaceMappings);
        this.localNamespaceMappings.clear();
        this.targetHandler.startElement(namespaceURI, localName, qName, atts);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.characters(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.targetHandler.endElement(namespaceURI, localName, qName);
        this.targetHandler.endNamespaceContext();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

