/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.util.List;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.platform.tag.TagServiceLocal;
import org.nuxeo.ecm.platform.tag.TagServiceRemote;
import org.nuxeo.runtime.api.Framework;

@Stateless
@Local(value={TagServiceLocal.class})
@Remote(value={TagServiceRemote.class})
public class TagServiceBean
implements TagService {
    private static final Log log = LogFactory.getLog(TagServiceBean.class);
    protected TagService tagService;

    protected TagService getLocalTagService() throws ClientException {
        if (this.tagService == null) {
            try {
                this.tagService = (TagService)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.tag.TagService");
            }
            catch (Exception e) {
                log.error((Object)"Cannot get TagService", (Throwable)e);
                throw new ClientException("TagService not available");
            }
        }
        return this.tagService;
    }

    public boolean isEnabled() throws ClientException {
        return this.getLocalTagService().isEnabled();
    }

    public void tag(CoreSession session, String docId, String tagLabel, String username) throws ClientException {
        this.getLocalTagService().tag(session, docId, tagLabel, username);
    }

    public void untag(CoreSession session, String docId, String tagLabel, String username) throws ClientException {
        this.getLocalTagService().untag(session, docId, tagLabel, username);
    }

    public List<Tag> getDocumentTags(CoreSession session, String docId, String username) throws ClientException {
        return this.getLocalTagService().getDocumentTags(session, docId, username);
    }

    public List<String> getTagDocumentIds(CoreSession session, String label, String username) throws ClientException {
        return this.getLocalTagService().getTagDocumentIds(session, label, username);
    }

    public List<Tag> getTagCloud(CoreSession session, String docId, String username, Boolean normalize) throws ClientException {
        return this.getLocalTagService().getTagCloud(session, docId, username, normalize);
    }

    public List<Tag> getSuggestions(CoreSession session, String label, String username) throws ClientException {
        return this.getLocalTagService().getSuggestions(session, label, username);
    }
}

