/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.TransientFolder;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.util.AbstractPageFetcher;
import org.apache.chemistry.opencmis.client.runtime.util.CollectionIterable;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoDocument;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoFileableObject;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObjectFactory;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoSession;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;

public class NuxeoFolder
extends NuxeoFileableObject
implements Folder {
    public NuxeoFolder(NuxeoSession session, NuxeoObjectData data, ObjectType type) {
        super(session, data, type);
    }

    public TransientFolder getTransientFolder() {
        return this.getAdapter(TransientFolder.class);
    }

    public Document createDocument(Map<String, ?> properties, ContentStream contentStream, VersioningState versioningState) {
        return this.createDocument(properties, contentStream, versioningState, null, null, null, this.session.getDefaultContext());
    }

    public Document createDocument(Map<String, ?> properties, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        String id = this.service.createDocument(this.getRepositoryId(), this.session.convertProperties(properties), this.getId(), contentStream, versioningState, this.session.objectFactory.convertPolicies(policies), this.session.objectFactory.convertAces(addAces), this.session.objectFactory.convertAces(removeAces), null);
        return (Document)this.session.getObject((ObjectId)new ObjectIdImpl(id), context);
    }

    public NuxeoDocument createDocumentFromSource(ObjectId source, Map<String, ?> properties, VersioningState versioningState) {
        return this.createDocumentFromSource(source, (Map)properties, versioningState, (List)null, (List)null, (List)null, this.session.getDefaultContext());
    }

    public NuxeoDocument createDocumentFromSource(ObjectId source, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addACEs, List<Ace> removeACEs, OperationContext context) {
        if (source == null || source.getId() == null) {
            throw new CmisInvalidArgumentException("Invalid source: " + source);
        }
        if (context == null) {
            context = this.session.getDefaultContext();
        }
        NuxeoObjectData newData = this.service.copy(source.getId(), this.getId(), properties, (TypeDefinition)this.type, versioningState, policies, addACEs, removeACEs, context);
        return (NuxeoDocument)this.session.getObjectFactory().convertObject(newData, context);
    }

    public Folder createFolder(Map<String, ?> properties) {
        return this.createFolder(properties, null, null, null, this.session.getDefaultContext());
    }

    public Folder createFolder(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public Policy createPolicy(Map<String, ?> properties) {
        return this.createPolicy(properties, null, null, null, this.session.getDefaultContext());
    }

    public Policy createPolicy(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        throw new CmisNotSupportedException();
    }

    public List<String> deleteTree(boolean allVersions, UnfileObject unfile, boolean continueOnFailure) {
        FailedToDeleteData failed = this.service.deleteTree(this.getRepositoryId(), this.getId(), allVersions, unfile, continueOnFailure, null);
        if (failed == null || failed.getIds() == null || failed.getIds().isEmpty()) {
            return null;
        }
        return failed.getIds();
    }

    public List<ObjectType> getAllowedChildObjectTypes() {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<Document> getCheckedOutDocs() {
        return this.getCheckedOutDocs(this.session.getDefaultContext());
    }

    public ItemIterable<Document> getCheckedOutDocs(OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public ItemIterable<CmisObject> getChildren() {
        return this.getChildren(this.session.getDefaultContext());
    }

    public ItemIterable<CmisObject> getChildren(OperationContext context) {
        NuxeoObjectFactory objectFactory = this.session.getObjectFactory();
        OperationContextImpl ctx = new OperationContextImpl(context);
        AbstractPageFetcher<CmisObject> pageFetcher = new AbstractPageFetcher<CmisObject>((long)ctx.getMaxItemsPerPage(), (OperationContext)ctx, (ObjectFactory)objectFactory){
            final /* synthetic */ OperationContext val$ctx;
            final /* synthetic */ ObjectFactory val$objectFactory;
            {
                this.val$ctx = operationContext;
                this.val$objectFactory = objectFactory;
                super(x0);
            }

            protected AbstractPageFetcher.Page<CmisObject> fetchPage(long skipCount) {
                DocumentModelList children;
                ArrayList<CmisObject> items = new ArrayList<CmisObject>();
                try {
                    children = NuxeoFolder.this.service.getCoreSession().getChildren(NuxeoFolder.this.data.doc.getRef());
                }
                catch (ClientException e) {
                    throw new CmisRuntimeException(e.toString(), (Throwable)e);
                }
                long totalItems = 0L;
                long skip = skipCount;
                for (DocumentModel child : children) {
                    if (NuxeoFolder.this.service.isFilteredOut(child)) continue;
                    ++totalItems;
                    if (skip > 0L) {
                        --skip;
                        continue;
                    }
                    if ((long)items.size() > this.maxNumItems) continue;
                    NuxeoObjectData data = new NuxeoObjectData(NuxeoFolder.this.service, child, this.val$ctx);
                    CmisObject ob = this.val$objectFactory.convertObject((ObjectData)data, this.val$ctx);
                    items.add(ob);
                }
                return new AbstractPageFetcher.Page(items, totalItems, totalItems > skipCount + (long)items.size());
            }
        };
        return new CollectionIterable((AbstractPageFetcher)pageFetcher);
    }

    public List<Tree<FileableCmisObject>> getDescendants(int depth) {
        throw new UnsupportedOperationException();
    }

    public List<Tree<FileableCmisObject>> getDescendants(int depth, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public Folder getFolderParent() {
        if (this.isRootFolder()) {
            return null;
        }
        List<Folder> parents = this.getParents();
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        return parents.get(0);
    }

    public List<Tree<FileableCmisObject>> getFolderTree(int depth) {
        throw new UnsupportedOperationException();
    }

    public List<Tree<FileableCmisObject>> getFolderTree(int depth, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public String getPath() {
        return this.data.doc.getPathAsString();
    }

    public boolean isRootFolder() {
        return this.data.doc.getPath().isRoot();
    }
}

