/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.Tree;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.apache.chemistry.opencmis.server.support.query.AbstractPredicateWalker;
import org.apache.chemistry.opencmis.server.support.query.CmisQueryWalker;
import org.apache.chemistry.opencmis.server.support.query.CmisSelector;
import org.apache.chemistry.opencmis.server.support.query.ColumnReference;
import org.apache.chemistry.opencmis.server.support.query.FunctionReference;
import org.apache.chemistry.opencmis.server.support.query.PredicateWalkerBase;
import org.apache.chemistry.opencmis.server.support.query.QueryObject;
import org.apache.chemistry.opencmis.server.support.query.QueryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoCmisService;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyDataBase;
import org.nuxeo.ecm.core.opencmis.impl.util.TypeManagerImpl;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableAlias;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class CMISQLQueryMaker
implements QueryMaker {
    private static final Log log = LogFactory.getLog(CMISQLQueryMaker.class);
    public static final String TYPE = "CMISQL";
    public static final String CMIS_PREFIX = "cmis:";
    public static final String DC_FRAGMENT_NAME = "dublincore";
    public static final String DC_TITLE_KEY = "title";
    public static final String DC_CREATOR_KEY = "creator";
    public static final String DC_CREATED_KEY = "created";
    public static final String DC_MODIFIED_KEY = "modified";
    public static final String DC_LAST_CONTRIBUTOR_KEY = "lastContributor";
    public static final String REL_FRAGMENT_NAME = "relation";
    public static final String REL_SOURCE_KEY = "source";
    public static final String REL_TARGET_KEY = "target";
    protected Database database;
    protected Dialect dialect;
    protected Model model;
    protected Table hierTable;
    protected QueryObject query;
    public Dialect.FulltextMatchInfo fulltextMatchInfo;
    protected Map<String, Map<String, Table>> allTables = new HashMap<String, Map<String, Table>>();
    protected List<SqlColumn> realColumns = new LinkedList<SqlColumn>();
    protected List<String> realColumnsParams = new LinkedList<String>();
    protected Map<String, ColumnReference> virtualColumns = new HashMap<String, ColumnReference>();
    Map<String, PropertyDefinition<?>> typeInfo;
    List<String> virtualColumnNames = new LinkedList<String>();
    protected static final String JOIN = "JOIN";
    protected static final String WHERE = "WHERE";
    protected static final String ORDER_BY = "ORDER BY";

    public String getName() {
        return TYPE;
    }

    public boolean accepts(String queryType) {
        return queryType.equals(TYPE);
    }

    public QueryMaker.Query buildQuery(SQLInfo sqlInfo, Model model, Session.PathResolver pathResolver, String statement, QueryFilter queryFilter, Object ... params) throws StorageException {
        this.database = sqlInfo.database;
        this.dialect = sqlInfo.dialect;
        this.model = model;
        NuxeoCmisService service = (NuxeoCmisService)((Object)params[0]);
        this.typeInfo = params.length > 1 ? (Map)params[1] : null;
        TypeManagerImpl typeManager = service.repository.getTypeManager();
        boolean addSystemColumns = true;
        this.hierTable = this.database.getTable("hierarchy");
        this.query = new QueryObject((TypeManager)typeManager);
        QueryUtil queryUtil = new QueryUtil();
        CmisQueryWalker walker = null;
        try {
            walker = queryUtil.getWalker(statement);
            walker.query(this.query, (PredicateWalkerBase)new AnalyzingWalker());
        }
        catch (RecognitionException e) {
            String msg = walker == null ? e.getMessage() : "Line " + e.line + ":" + e.charPositionInLine + " " + walker.getErrorMessage(e, walker.getTokenNames());
            throw new QueryParseException(msg, (Throwable)e);
        }
        catch (QueryParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryParseException(e.getMessage(), (Throwable)e);
        }
        for (CmisSelector sel : this.query.getSelectReferences()) {
            this.recordSelectSelector(sel);
        }
        for (CmisSelector sel : this.query.getJoinReferences()) {
            this.recordSelector(sel, JOIN);
        }
        for (CmisSelector sel : this.query.getWhereReferences()) {
            this.recordSelector(sel, WHERE);
        }
        for (QueryObject.SortSpec spec : this.query.getOrderBys()) {
            this.recordSelector(spec.getSelector(), ORDER_BY);
        }
        boolean distinct = false;
        boolean skipHidden = true;
        this.addSystemColumns(addSystemColumns, distinct, skipHidden);
        LinkedList<String> whereClauses = new LinkedList<String>();
        LinkedList<Object> whereParams = new LinkedList<Object>();
        List joins = this.query.getJoins();
        StringBuilder from = new StringBuilder();
        LinkedList<String> fromParams = new LinkedList<String>();
        for (int njoin = -1; njoin < joins.size(); ++njoin) {
            Object permissions;
            Object principals;
            boolean checkSecurity;
            TypeDefinitionContainer tc;
            Table table;
            String alias;
            QueryObject.JoinSpec join;
            boolean firstTable;
            boolean bl = firstTable = njoin == -1;
            if (firstTable) {
                join = null;
                alias = this.query.getMainTypeAlias();
            } else {
                join = (QueryObject.JoinSpec)joins.get(njoin);
                alias = join.alias;
            }
            String typeQueryName = this.query.getTypeQueryName(alias);
            String qual = alias;
            if (qual.equals(typeQueryName)) {
                qual = null;
            }
            Table qualHierTable = this.getTable(this.hierTable, qual);
            if (firstTable) {
                table = qualHierTable;
            } else {
                table = null;
                for (ColumnReference col : Arrays.asList(join.onLeft, join.onRight)) {
                    if (!alias.equals(col.getTypeQueryName())) continue;
                    table = ((Column)col.getInfo()).getTable();
                    break;
                }
                if (table == null) {
                    throw new QueryParseException("Bad query, qualifier not found: " + qual);
                }
                if (join.kind.equals("LEFT") || join.kind.equals("RIGHT")) {
                    from.append(" ");
                    from.append(join.kind);
                }
                from.append(" JOIN ");
            }
            boolean isRelation = table.getKey().equals(REL_FRAGMENT_NAME);
            String name = table.isAlias() ? table.getRealTable().getQuotedName() + " " + table.getQuotedName() : table.getQuotedName();
            from.append(name);
            if (!firstTable) {
                from.append(" ON ");
                from.append(((Column)join.onLeft.getInfo()).getFullQuotedName());
                from.append(" = ");
                from.append(((Column)join.onRight.getInfo()).getFullQuotedName());
            }
            String tableMainId = table.getColumn("id").getFullQuotedName();
            for (Table t : this.allTables.get(qual).values()) {
                if (t.getKey().equals(table.getKey())) continue;
                String n = t.isAlias() ? t.getRealTable().getQuotedName() + " " + t.getQuotedName() : t.getQuotedName();
                from.append(" LEFT JOIN ");
                from.append(n);
                from.append(" ON ");
                from.append(t.getColumn("id").getFullQuotedName());
                from.append(" = ");
                from.append(tableMainId);
            }
            List<Object> types = new ArrayList<String>();
            TypeDefinition td = this.query.getTypeDefinitionFromQueryName(typeQueryName);
            if (td.getParentTypeId() != null) {
                types.add(td.getId());
            }
            LinkedList<TypeDefinitionContainer> typesTodo = new LinkedList<TypeDefinitionContainer>();
            typesTodo.addAll(typeManager.getTypeDescendants(td.getId(), -1, Boolean.TRUE));
            while ((tc = (TypeDefinitionContainer)typesTodo.poll()) != null) {
                types.add(tc.getTypeDefinition().getId());
                typesTodo.addAll(tc.getChildren());
            }
            if (types.isEmpty()) {
                types = Collections.singletonList("__NOSUCHTYPE__");
            }
            StringBuilder qms = new StringBuilder();
            for (int i = 0; i < types.size(); ++i) {
                if (i != 0) {
                    qms.append(", ");
                }
                qms.append("?");
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = qualHierTable.getColumn("primarytype").getFullQuotedName();
            objectArray[1] = qms;
            whereClauses.add(String.format("%s IN (%s)", objectArray));
            whereParams.addAll(types);
            if (skipHidden) {
                Table misc = this.getTable(this.database.getTable("misc"), qual);
                Column lscol = misc.getColumn("lifecyclestate");
                whereClauses.add(String.format("%s <> ?", lscol.getFullQuotedName()));
                whereParams.add("deleted");
            }
            boolean bl2 = checkSecurity = !isRelation && queryFilter != null && queryFilter.getPrincipals() != null;
            if (!checkSecurity) continue;
            if (this.dialect.supportsArrays()) {
                principals = queryFilter.getPrincipals();
                permissions = queryFilter.getPermissions();
            } else {
                principals = StringUtils.join((Object[])queryFilter.getPrincipals(), (char)'|');
                permissions = StringUtils.join((Object[])queryFilter.getPermissions(), (char)'|');
            }
            if (this.dialect.supportsReadAcl()) {
                String readAclAclIdCol;
                String readAclIdCol;
                String readAclTable;
                if (joins.size() == 0) {
                    readAclTable = "hierarchy_read_acl";
                    readAclIdCol = "hierarchy_read_acl" + '.' + "id";
                    readAclAclIdCol = "hierarchy_read_acl" + '.' + "acl_id";
                } else {
                    String al = "nxr" + (njoin + 1);
                    readAclTable = "hierarchy_read_acl" + " " + al;
                    readAclIdCol = al + '.' + "id";
                    readAclAclIdCol = al + '.' + "acl_id";
                }
                whereClauses.add(this.dialect.getReadAclsCheckSql(readAclAclIdCol));
                whereParams.add(principals);
                from.append(String.format(" JOIN %s ON %s = %s", readAclTable, tableMainId, readAclIdCol));
                continue;
            }
            whereClauses.add(this.dialect.getSecurityCheckSql(tableMainId));
            whereParams.add(principals);
            whereParams.add(permissions);
        }
        Tree whereNode = walker.getWherePredicateTree();
        if (whereNode != null) {
            GeneratingWalker generator = new GeneratingWalker();
            generator.walkPredicate(whereNode);
            whereClauses.add(generator.whereBuf.toString());
            whereParams.addAll(generator.whereBufParams);
            Collections.sort(generator.ftJoins);
            for (Join join : generator.ftJoins) {
                from.append(join.toString());
                if (join.tableParam == null) continue;
                fromParams.add(join.tableParam);
            }
        }
        ArrayList<String> selectWhat = new ArrayList<String>();
        ArrayList<String> selectParams = new ArrayList<String>(1);
        for (SqlColumn rc : this.realColumns) {
            selectWhat.add(rc.sql);
        }
        selectParams.addAll(this.realColumnsParams);
        CMISQLMapMaker mapMaker = new CMISQLMapMaker(this.realColumns, this.virtualColumns, service);
        String what = StringUtils.join(selectWhat, (String)", ");
        if (distinct) {
            what = "DISTINCT " + what;
        }
        LinkedList<String> orderbys = new LinkedList<String>();
        for (QueryObject.SortSpec spec : this.query.getOrderBys()) {
            String orderby;
            CmisSelector sel = spec.getSelector();
            if (sel instanceof ColumnReference) {
                Column column = (Column)sel.getInfo();
                orderby = column.getFullQuotedName();
            } else {
                orderby = this.fulltextMatchInfo.scoreAlias;
            }
            if (!spec.ascending) {
                orderby = orderby + " DESC";
            }
            orderbys.add(orderby);
        }
        Select select = new Select(null);
        select.setWhat(what);
        select.setFrom(from.toString());
        select.setWhere(StringUtils.join(whereClauses, (String)" AND "));
        select.setOrderBy(StringUtils.join(orderbys, (String)", "));
        QueryMaker.Query q = new QueryMaker.Query();
        q.selectInfo = new SQLInfo.SQLInfoSelect(select.getStatement(), (SQLInfo.MapMaker)mapMaker);
        q.selectParams = selectParams;
        q.selectParams.addAll(fromParams);
        q.selectParams.addAll(whereParams);
        return q;
    }

    protected void addSystemColumns(boolean addSystemColumns, boolean distinct, boolean skipHidden) {
        ArrayList<ColumnReference> addedSystemColumns = new ArrayList<ColumnReference>(2);
        for (String string : this.allTables.keySet()) {
            TypeDefinition type = this.getTypeForQualifier(string);
            for (String propertyId : Arrays.asList("cmis:objectId", "cmis:objectTypeId")) {
                ColumnReference col = new ColumnReference(string, propertyId);
                col.setTypeDefinition(propertyId, type);
                String key = CMISQLQueryMaker.getColumnKey(col);
                boolean add = true;
                for (SqlColumn rc : this.realColumns) {
                    if (!rc.key.equals(key)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                addedSystemColumns.add(col);
            }
            if (!skipHidden) continue;
            Table table = this.getTable(this.database.getTable("misc"), string);
            Column column = table.getColumn("lifecyclestate");
            this.recordColumnFragment(string, column);
        }
        if (!distinct) {
            for (CmisSelector cmisSelector : addedSystemColumns) {
                this.recordSelectSelector(cmisSelector);
            }
        } else if (!addedSystemColumns.isEmpty()) {
            if (!this.virtualColumnNames.isEmpty()) {
                throw new QueryParseException("Cannot use DISTINCT with virtual columns: " + StringUtils.join(this.virtualColumnNames, (String)", "));
            }
            if (addSystemColumns) {
                throw new QueryParseException("Cannot use DISTINCT without explicit cmis:objectId");
            }
        }
        for (String string : this.allTables.keySet()) {
            Table table = this.getTable(this.hierTable, string);
            String fragment = table.getKey();
            Map<String, Table> tablesByFragment = this.allTables.get(string);
            if (tablesByFragment.containsKey(fragment)) continue;
            tablesByFragment.put(fragment, table);
        }
    }

    protected void recordSelectSelector(CmisSelector sel) {
        if (sel instanceof FunctionReference) {
            FunctionReference fr = (FunctionReference)sel;
            if (fr.getFunction() != FunctionReference.CmisQlFunction.SCORE) {
                throw new CmisRuntimeException("Unknown function: " + fr.getFunction());
            }
            String key = fr.getAliasName();
            if (key == null) {
                key = "SEARCH_SCORE";
            }
            SqlColumn c = new SqlColumn(this.fulltextMatchInfo.scoreExpr, this.fulltextMatchInfo.scoreCol, key);
            this.realColumns.add(c);
            if (this.fulltextMatchInfo.scoreExprParam != null) {
                this.realColumnsParams.add(this.fulltextMatchInfo.scoreExprParam);
            }
            if (this.typeInfo != null) {
                PropertyDecimalDefinitionImpl pd = new PropertyDecimalDefinitionImpl();
                pd.setId(key);
                pd.setQueryName(key);
                pd.setCardinality(Cardinality.SINGLE);
                pd.setDisplayName("Score");
                pd.setLocalName("score");
                this.typeInfo.put(key, (PropertyDefinition<?>)pd);
            }
        } else {
            ColumnReference col = (ColumnReference)sel;
            String qual = col.getTypeQueryName();
            if (col.getPropertyQueryName().equals("*")) {
                TypeDefinition type = this.getTypeForQualifier(qual);
                for (PropertyDefinition pd : type.getPropertyDefinitions().values()) {
                    if (pd.getCardinality() != Cardinality.SINGLE || !Boolean.TRUE.equals(pd.isQueryable())) continue;
                    String id = pd.getId();
                    ColumnReference c = new ColumnReference(qual, id);
                    c.setTypeDefinition(id, type);
                    this.recordSelectSelector((CmisSelector)c);
                }
                return;
            }
            String key = CMISQLQueryMaker.getColumnKey(col);
            PropertyDefinition pd = col.getPropertyDefinition();
            Column column = this.getColumn(col);
            if (column != null && pd.getCardinality() == Cardinality.SINGLE) {
                col.setInfo((Object)column);
                this.recordColumnFragment(qual, column);
                String sql = column.getFullQuotedName();
                SqlColumn c = new SqlColumn(sql, column, key);
                this.realColumns.add(c);
            } else {
                this.virtualColumns.put(key, col);
                this.virtualColumnNames.add(key);
            }
            if (this.typeInfo != null) {
                this.typeInfo.put(key, pd);
            }
        }
    }

    protected void recordSelector(CmisSelector sel, String clauseType) {
        if (sel instanceof FunctionReference) {
            FunctionReference fr = (FunctionReference)sel;
            if (clauseType != ORDER_BY) {
                throw new QueryParseException("Cannot use function in " + clauseType + " clause: " + fr.getFunction());
            }
            if (this.fulltextMatchInfo == null) {
                throw new QueryParseException("Cannot use ORDER BY SCORE without CONTAINS");
            }
            return;
        }
        ColumnReference col = (ColumnReference)sel;
        PropertyDefinition pd = col.getPropertyDefinition();
        boolean multi = pd.getCardinality() == Cardinality.MULTI;
        Column column = this.getColumn(col);
        if (column == null) {
            throw new QueryParseException("Cannot use column in " + clauseType + " clause: " + col.getPropertyQueryName());
        }
        col.setInfo((Object)column);
        String qual = col.getTypeQueryName();
        if (!multi) {
            this.recordColumnFragment(qual, column);
        }
    }

    protected void recordColumnFragment(String qual, Column column) {
        Table table = column.getTable();
        String fragment = table.getKey();
        Map<String, Table> tablesByFragment = this.allTables.get(qual);
        if (tablesByFragment == null) {
            tablesByFragment = new HashMap<String, Table>();
            this.allTables.put(qual, tablesByFragment);
        }
        tablesByFragment.put(fragment, table);
    }

    protected Column getColumn(ColumnReference col) {
        Column column;
        String qual = col.getTypeQueryName();
        String id = col.getPropertyId();
        if (id.startsWith(CMIS_PREFIX)) {
            column = this.getSystemColumn(qual, id);
        } else {
            ModelProperty propertyInfo = this.model.getPropertyInfo(id);
            boolean multi = propertyInfo.propertyType.isArray();
            Table table = this.database.getTable(propertyInfo.fragmentName);
            String key = multi ? "item" : propertyInfo.fragmentKey;
            column = this.getTable(table, qual).getColumn(key);
        }
        return column;
    }

    protected Column getSystemColumn(String qual, String id) {
        Column column = this.getSystemColumn(id);
        if (column != null && qual != null) {
            Table table = column.getTable();
            column = this.getTable(table, qual).getColumn(column.getKey());
        }
        return column;
    }

    protected Column getSystemColumn(String id) {
        if (id.equals("cmis:objectId")) {
            return this.hierTable.getColumn("id");
        }
        if (id.equals("cmis:parentId")) {
            return this.hierTable.getColumn("parentid");
        }
        if (id.equals("cmis:objectTypeId")) {
            return this.hierTable.getColumn("primarytype");
        }
        if (id.equals("cmis:versionLabel")) {
            return this.database.getTable("versions").getColumn("label");
        }
        if (id.equals("cmis:name")) {
            return this.database.getTable(DC_FRAGMENT_NAME).getColumn(DC_TITLE_KEY);
        }
        if (id.equals("cmis:createdBy")) {
            return this.database.getTable(DC_FRAGMENT_NAME).getColumn(DC_CREATOR_KEY);
        }
        if (id.equals("cmis:creationDate")) {
            return this.database.getTable(DC_FRAGMENT_NAME).getColumn(DC_CREATED_KEY);
        }
        if (id.equals("cmis:lastModificationDate")) {
            return this.database.getTable(DC_FRAGMENT_NAME).getColumn(DC_MODIFIED_KEY);
        }
        if (id.equals("cmis:lastModifiedBy")) {
            return this.database.getTable(DC_FRAGMENT_NAME).getColumn(DC_LAST_CONTRIBUTOR_KEY);
        }
        if (id.equals("cmis:sourceId")) {
            return this.database.getTable(REL_FRAGMENT_NAME).getColumn(REL_SOURCE_KEY);
        }
        if (id.equals("cmis:targetId")) {
            return this.database.getTable(REL_FRAGMENT_NAME).getColumn(REL_TARGET_KEY);
        }
        return null;
    }

    protected static String getColumnKey(ColumnReference col) {
        String alias = col.getAliasName();
        if (alias != null) {
            return alias;
        }
        return CMISQLQueryMaker.getPropertyKey(col.getTypeQueryName(), col.getPropertyQueryName());
    }

    protected static String getPropertyKey(String qual, String id) {
        if (qual == null) {
            return id;
        }
        return qual + '.' + id;
    }

    protected TypeDefinition getTypeForQualifier(String qual) {
        if (qual == null) {
            for (Map.Entry en : this.query.getTypes().entrySet()) {
                if (!((String)en.getKey()).equals(en.getValue())) continue;
                qual = (String)en.getValue();
                break;
            }
        }
        return this.query.getTypeDefinitionFromQueryName(this.query.getTypeQueryName(qual));
    }

    protected Table getTable(Table table, String qual) {
        if (qual == null) {
            return table;
        }
        return new TableAlias(table, this.getTableAlias(table, qual));
    }

    protected String getTableAlias(Table table, String qual) {
        return "_" + qual + "_" + table.getPhysicalName();
    }

    public class GeneratingWalker
    extends AbstractPredicateWalker {
        public StringBuilder whereBuf = new StringBuilder();
        public LinkedList<Serializable> whereBufParams = new LinkedList();
        public final List<Join> ftJoins = new LinkedList<Join>();

        public Boolean walkNot(Tree opNode, Tree node) {
            this.whereBuf.append("NOT ");
            this.walkPredicate(node);
            return null;
        }

        public Boolean walkAnd(Tree opNode, Tree leftNode, Tree rightNode) {
            this.whereBuf.append("(");
            this.walkPredicate(leftNode);
            this.whereBuf.append(" AND ");
            this.walkPredicate(rightNode);
            this.whereBuf.append(")");
            return null;
        }

        public Boolean walkOr(Tree opNode, Tree leftNode, Tree rightNode) {
            this.whereBuf.append("(");
            this.walkPredicate(leftNode);
            this.whereBuf.append(" OR ");
            this.walkPredicate(rightNode);
            this.whereBuf.append(")");
            return null;
        }

        public Boolean walkEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.whereBuf.append(" = ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkNotEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.whereBuf.append(" <> ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkGreaterThan(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.whereBuf.append(" > ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkGreaterOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.whereBuf.append(" >= ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkLessThan(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.whereBuf.append(" < ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkLessOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
            this.walkExpr(leftNode);
            this.whereBuf.append(" <= ");
            this.walkExpr(rightNode);
            return null;
        }

        public Boolean walkIn(Tree opNode, Tree colNode, Tree listNode) {
            this.walkExpr(colNode);
            this.whereBuf.append(" IN ");
            this.walkExpr(listNode);
            return null;
        }

        public Boolean walkNotIn(Tree opNode, Tree colNode, Tree listNode) {
            this.walkExpr(colNode);
            this.whereBuf.append(" NOT IN ");
            this.walkExpr(listNode);
            return null;
        }

        public Boolean walkInAny(Tree opNode, Tree colNode, Tree listNode) {
            this.walkAny(colNode, "IN", listNode);
            return null;
        }

        public Boolean walkNotInAny(Tree opNode, Tree colNode, Tree listNode) {
            this.walkAny(colNode, "NOT IN", listNode);
            return null;
        }

        public Boolean walkEqAny(Tree opNode, Tree literalNode, Tree colNode) {
            this.walkAny(colNode, "=", literalNode);
            return null;
        }

        protected void walkAny(Tree colNode, String op, Tree exprNode) {
            int token = colNode.getTokenStartIndex();
            ColumnReference col = (ColumnReference)CMISQLQueryMaker.this.query.getColumnReference(Integer.valueOf(token));
            PropertyDefinition pd = col.getPropertyDefinition();
            if (pd.getCardinality() != Cardinality.MULTI) {
                throw new QueryParseException("Cannot use " + op + " ANY with single-valued property: " + col.getPropertyQueryName());
            }
            Column column = (Column)col.getInfo();
            String qual = col.getTypeQueryName();
            Model cfr_ignored_0 = CMISQLQueryMaker.this.model;
            Column hierMainColumn = CMISQLQueryMaker.this.getTable(CMISQLQueryMaker.this.hierTable, qual).getColumn("id");
            Model cfr_ignored_1 = CMISQLQueryMaker.this.model;
            Column multiMainColumn = column.getTable().getColumn("id");
            this.whereBuf.append("EXISTS (SELECT 1 FROM ");
            this.whereBuf.append(column.getTable().getQuotedName());
            this.whereBuf.append(" WHERE ");
            this.whereBuf.append(hierMainColumn.getFullQuotedName());
            this.whereBuf.append(" = ");
            this.whereBuf.append(multiMainColumn.getFullQuotedName());
            this.whereBuf.append(" AND ");
            this.whereBuf.append(column.getFullQuotedName());
            this.whereBuf.append(" ");
            this.whereBuf.append(op);
            this.whereBuf.append(" ");
            this.walkExpr(exprNode);
            this.whereBuf.append(")");
        }

        public Boolean walkIsNull(Tree opNode, Tree colNode) {
            this.walkExpr(colNode);
            this.whereBuf.append(" IS NULL");
            return null;
        }

        public Boolean walkIsNotNull(Tree opNode, Tree colNode) {
            this.walkExpr(colNode);
            this.whereBuf.append(" IS NOT NULL");
            return null;
        }

        public Boolean walkLike(Tree opNode, Tree colNode, Tree stringNode) {
            this.walkExpr(colNode);
            this.whereBuf.append(" LIKE ");
            this.walkExpr(stringNode);
            return null;
        }

        public Boolean walkNotLike(Tree opNode, Tree colNode, Tree stringNode) {
            this.walkExpr(colNode);
            this.whereBuf.append(" NOT LIKE ");
            this.walkExpr(stringNode);
            return null;
        }

        public Boolean walkContains(Tree opNode, Tree qualNode, Tree queryNode) {
            if (CMISQLQueryMaker.this.fulltextMatchInfo.joins != null) {
                this.ftJoins.addAll(CMISQLQueryMaker.this.fulltextMatchInfo.joins);
            }
            this.whereBuf.append(CMISQLQueryMaker.this.fulltextMatchInfo.whereExpr);
            if (CMISQLQueryMaker.this.fulltextMatchInfo.whereExprParam != null) {
                this.whereBufParams.add((Serializable)((Object)CMISQLQueryMaker.this.fulltextMatchInfo.whereExprParam));
            }
            return null;
        }

        public Boolean walkInFolder(Tree opNode, Tree qualNode, Tree paramNode) {
            String qual = qualNode == null ? null : qualNode.getText();
            Column column = CMISQLQueryMaker.this.getSystemColumn(qual, "cmis:parentId");
            this.whereBuf.append(column.getFullQuotedName());
            this.whereBuf.append(" = ?");
            String id = (String)super.walkString(paramNode);
            this.whereBufParams.add((Serializable)((Object)id));
            return null;
        }

        public Boolean walkInTree(Tree opNode, Tree qualNode, Tree paramNode) {
            String qual = qualNode == null ? null : qualNode.getText();
            Column column = CMISQLQueryMaker.this.getSystemColumn(qual, "cmis:objectId");
            String sql = CMISQLQueryMaker.this.dialect.getInTreeSql(column.getFullQuotedName());
            String id = (String)super.walkString(paramNode);
            this.whereBuf.append(sql);
            this.whereBufParams.add((Serializable)((Object)id));
            return null;
        }

        public Object walkList(Tree node) {
            this.whereBuf.append("(");
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (i != 0) {
                    this.whereBuf.append(", ");
                }
                Tree child = node.getChild(i);
                this.walkExpr(child);
            }
            this.whereBuf.append(")");
            return null;
        }

        public Object walkBoolean(Tree node) {
            Serializable value = (Serializable)super.walkBoolean(node);
            this.whereBuf.append("?");
            this.whereBufParams.add(value);
            return null;
        }

        public Object walkNumber(Tree node) {
            Serializable value = (Serializable)super.walkNumber(node);
            this.whereBuf.append("?");
            this.whereBufParams.add(value);
            return null;
        }

        public Object walkString(Tree node) {
            Serializable value = (Serializable)super.walkString(node);
            this.whereBuf.append("?");
            this.whereBufParams.add(value);
            return null;
        }

        public Object walkTimestamp(Tree node) {
            Serializable value = (Serializable)super.walkTimestamp(node);
            this.whereBuf.append("?");
            this.whereBufParams.add(value);
            return null;
        }

        public Object walkCol(Tree node) {
            int token = node.getTokenStartIndex();
            CmisSelector sel = CMISQLQueryMaker.this.query.getColumnReference(Integer.valueOf(token));
            if (!(sel instanceof ColumnReference)) {
                throw new QueryParseException("Cannot use column in WHERE clause: " + sel.getName());
            }
            Column column = (Column)sel.getInfo();
            this.whereBuf.append(column.getFullQuotedName());
            return null;
        }
    }

    public class AnalyzingWalker
    extends AbstractPredicateWalker {
        public static final String NX_FULLTEXT_INDEX_PREFIX = "nx:";
        public boolean hasContains;

        public Boolean walkContains(Tree opNode, Tree qualNode, Tree queryNode) {
            if (this.hasContains) {
                throw new QueryParseException("At most one CONTAINS() is allowed");
            }
            this.hasContains = true;
            String qual = qualNode == null ? null : qualNode.getText();
            Column column = CMISQLQueryMaker.this.getSystemColumn(qual, "cmis:objectId");
            String statement = (String)super.walkString(queryNode);
            String indexName = "default";
            if (statement.startsWith(NX_FULLTEXT_INDEX_PREFIX)) {
                int firstColumnIdx = (statement = statement.substring(NX_FULLTEXT_INDEX_PREFIX.length())).indexOf(58);
                if (firstColumnIdx > 0 && firstColumnIdx < statement.length() - 1) {
                    String requestedIndexName = statement.substring(0, firstColumnIdx);
                    statement = statement.substring(firstColumnIdx + 1);
                    if (CMISQLQueryMaker.this.model.fulltextInfo.indexNames.contains(requestedIndexName)) {
                        indexName = requestedIndexName;
                    } else {
                        log.warn((Object)String.format("'%s' is not a registered fulltext index name: fallback to '%s'", requestedIndexName, indexName));
                    }
                } else {
                    log.warn((Object)String.format("fail to microparse custom fulltext index: fallback to '%s'", indexName));
                }
            }
            CMISQLQueryMaker.this.fulltextMatchInfo = CMISQLQueryMaker.this.dialect.getFulltextScoredMatchInfo(statement, indexName, 1, column, CMISQLQueryMaker.this.model, CMISQLQueryMaker.this.database);
            return null;
        }
    }

    public static class CMISQLMapMaker
    implements SQLInfo.MapMaker {
        protected List<SqlColumn> realColumns;
        protected Map<String, ColumnReference> virtualColumns;
        protected NuxeoCmisService service;

        public CMISQLMapMaker(List<SqlColumn> realColumns, Map<String, ColumnReference> virtualColumns, NuxeoCmisService service) {
            this.realColumns = realColumns;
            this.virtualColumns = virtualColumns;
            this.service = service;
        }

        public Map<String, Serializable> makeMap(ResultSet rs) throws SQLException {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            int i = 1;
            for (SqlColumn rc : this.realColumns) {
                Serializable value;
                if ((value = rc.column.getFromResultSet(rs, i++)) instanceof Long) {
                    value = BigInteger.valueOf((Long)value);
                } else if (value instanceof Integer) {
                    value = BigInteger.valueOf(((Integer)value).intValue());
                } else if (value instanceof Double) {
                    value = BigDecimal.valueOf((Double)value);
                }
                map.put(rc.key, value);
            }
            HashMap<String, NuxeoObjectData> datas = null;
            for (Map.Entry<String, ColumnReference> vc : this.virtualColumns.entrySet()) {
                NuxeoPropertyDataBase<?> pd;
                NuxeoObjectData data;
                String key = vc.getKey();
                ColumnReference col = vc.getValue();
                String qual = col.getTypeQueryName();
                if (datas == null) {
                    datas = new HashMap<String, NuxeoObjectData>(2);
                }
                if ((data = (NuxeoObjectData)datas.get(qual)) == null) {
                    String id = (String)map.get(CMISQLQueryMaker.getPropertyKey(qual, "cmis:objectId"));
                    try {
                        data = this.service.getObject(this.service.getNuxeoRepository().getId(), id, null, null, null, null, null, null, null);
                    }
                    catch (CmisRuntimeException e) {
                        log.error((Object)("Cannot get document: " + id), (Throwable)e);
                    }
                    datas.put(qual, data);
                }
                Serializable v = data == null ? null : ((pd = data.getProperty(key)) == null ? null : (pd.getPropertyDefinition().getCardinality() == Cardinality.SINGLE ? (Serializable)pd.getFirstValue() : (Serializable)((Object)pd.getValues())));
                map.put(key, v);
            }
            return map;
        }
    }

    public static class SqlColumn {
        public final String sql;
        public final Column column;
        public final String key;

        public SqlColumn(String sql, Column column, String key) {
            this.sql = sql;
            this.column = column;
            this.key = key;
        }
    }
}

