/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb.inflow;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.jboss.aop.Advisor;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.mdb.MDB;
import org.jboss.ejb3.mdb.inflow.MessageInflowLocalProxy;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanServerLocator;

public class JBossMessageEndpointFactory
implements MessageEndpointFactory {
    private static final Logger log = Logger.getLogger(JBossMessageEndpointFactory.class);
    protected boolean trace = log.isTraceEnabled();
    protected MDB container;
    protected HashMap properties = new HashMap();
    protected Class messagingTypeClass;
    protected String resourceAdapterName;
    protected ObjectName resourceAdapterObjectName;
    protected ActivationSpec activationSpec;
    protected Class[] interfaces;
    protected SynchronizedInt nextProxyId = new SynchronizedInt(0);
    protected MBeanServer server;
    protected String[] createActivationSpecSig = new String[]{Class.class.getName(), Collection.class.getName()};
    protected String[] activationSig = new String[]{MessageEndpointFactory.class.getName(), ActivationSpec.class.getName()};

    public MDB getContainer() {
        return this.container;
    }

    public MessageEndpoint createEndpoint(XAResource resource) throws UnavailableException {
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace((Object)("createEndpoint " + this + " xaResource=" + resource));
        }
        MessageEndpoint endpoint = this.createProxy(resource);
        if (this.trace) {
            log.trace((Object)("Created endpoint " + endpoint + " from " + this));
        }
        return endpoint;
    }

    protected MessageEndpoint createProxy(XAResource resource) {
        try {
            Class<?> proxyClass = Proxy.getProxyClass(this.container.getBeanClass().getClassLoader(), this.interfaces);
            Class[] constructorParams = new Class[]{InvocationHandler.class};
            Constructor<?> proxyConstructor = proxyClass.getConstructor(constructorParams);
            MessageInflowLocalProxy proxy = new MessageInflowLocalProxy(this.container);
            proxy.setXaResource(resource);
            proxy.setMessageEndpointFactory(this);
            Object[] args = new Object[]{proxy};
            MessageEndpoint endpoint = (MessageEndpoint)proxyConstructor.newInstance(args);
            return endpoint;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        TransactionManagementType mtype = TxUtil.getTransactionManagementType((Advisor)this.container);
        if (mtype == TransactionManagementType.BEAN) {
            return false;
        }
        TransactionAttribute attr = (TransactionAttribute)this.container.resolveAnnotation(method, TransactionAttribute.class);
        if (attr == null) {
            attr = (TransactionAttribute)this.container.resolveAnnotation(TransactionAttribute.class);
        }
        TransactionAttributeType type = TransactionAttributeType.REQUIRED;
        if (attr != null) {
            type = attr.value();
        }
        return type == TransactionAttributeType.REQUIRED;
    }

    public void start() throws Exception {
        this.resolveMessageListener();
        this.resolveResourceAdapterName();
        this.resolveResourceAdapter();
        this.createActivationSpec();
        this.interfaces = new Class[]{MessageEndpoint.class, this.messagingTypeClass};
        this.activate();
    }

    public void stop() throws Exception {
        this.deactivate();
    }

    public void setContainer(Container container) {
        this.container = (MDB)container;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(super.toString());
        buffer.append("{ resourceAdapter=").append(this.resourceAdapterName);
        buffer.append(", messagingType=").append(this.container.getMessagingType());
        buffer.append(", ejbName=").append(this.container.getEjbName());
        buffer.append(", activationConfig=").append(this.properties.values());
        buffer.append(", activationSpec=").append(this.activationSpec);
        buffer.append("}");
        return buffer.toString();
    }

    protected void resolveMessageListener() throws DeploymentException {
        this.messagingTypeClass = this.container.getMessagingType();
    }

    protected void resolveResourceAdapterName() throws DeploymentException {
        this.resourceAdapterName = this.container.getResourceAdaptorName();
    }

    protected void resolveResourceAdapter() {
        try {
            this.server = MBeanServerLocator.locateJBoss();
            this.resourceAdapterObjectName = new ObjectName("jboss.jca:service=RARDeployment,name='" + this.resourceAdapterName + "'");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    protected void augmentActivationConfigProperties() throws DeploymentException {
        String jndiName = this.container.getDestination();
        if (jndiName != null) {
            this.properties.put("destination", jndiName);
        }
    }

    protected void createActivationSpec() throws DeploymentException {
        this.properties = new HashMap(this.container.getActivationConfigProperties());
        this.augmentActivationConfigProperties();
        Object[] params = new Object[]{this.messagingTypeClass, this.properties.values()};
        try {
            this.activationSpec = (ActivationSpec)this.server.invoke(this.resourceAdapterObjectName, "createActivationSpec", params, this.createActivationSpecSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            DeploymentException.rethrowAsDeploymentException((String)("Unable to create activation spec ra=" + this.resourceAdapterObjectName + " messaging-type=" + this.messagingTypeClass.getName() + " properties=" + this.container.getActivationConfigProperties()), (Throwable)t);
        }
    }

    protected void activate() throws DeploymentException {
        Object[] params = new Object[]{this, this.activationSpec};
        try {
            this.server.invoke(this.resourceAdapterObjectName, "endpointActivation", params, this.activationSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            DeploymentException.rethrowAsDeploymentException((String)("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec), (Throwable)t);
        }
    }

    protected void deactivate() {
        Object[] params = new Object[]{this, this.activationSpec};
        try {
            this.server.invoke(this.resourceAdapterObjectName, "endpointDeactivation", params, this.activationSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            log.warn((Object)("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec), t);
        }
    }
}

