/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.api.CloseListener;
import org.h2.api.Trigger;
import org.h2.tools.SimpleResultSet;
import org.nuxeo.ecm.core.storage.sql.db.EmbeddedFunctions;

public class H2Functions
extends EmbeddedFunctions {
    private static final Log log = LogFactory.getLog(H2Functions.class);

    private static boolean isLogEnabled() {
        return false;
    }

    private static void logDebug(String message, Object ... args) {
        log.trace((Object)("SQL: " + String.format(message.replace("?", "%s"), args)));
    }

    public static boolean isInTreeString(Connection conn, String id, String baseId) throws SQLException {
        return H2Functions.isInTree(conn, (Serializable)((Object)id), (Serializable)((Object)baseId));
    }

    public static boolean isInTreeLong(Connection conn, Long id, Long baseId) throws SQLException {
        return H2Functions.isInTree(conn, id, baseId);
    }

    public static boolean isAccessAllowedString(Connection conn, String id, String principals, String permissions) throws SQLException {
        return H2Functions.isAccessAllowed(conn, (Serializable)((Object)id), H2Functions.split(principals), H2Functions.split(permissions));
    }

    public static boolean isAccessAllowedLong(Connection conn, Long id, String principals, String permissions) throws SQLException {
        return H2Functions.isAccessAllowed(conn, id, H2Functions.split(principals), H2Functions.split(permissions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clusterInvalidateString(Connection conn, String id, String fragments, int kind) throws SQLException {
        Statement ps = null;
        try {
            String sql = "SELECT \"NODEID\" FROM \"CLUSTER_NODES\" WHERE \"NODEID\" <> SESSION_ID()";
            if (H2Functions.isLogEnabled()) {
                H2Functions.logDebug(sql, new Object[0]);
            }
            ps = conn.prepareStatement(sql);
            LinkedList<Long> nodeIds = new LinkedList<Long>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                nodeIds.add(rs.getLong(1));
            }
            if (H2Functions.isLogEnabled()) {
                H2Functions.logDebug("  -> " + nodeIds, new Object[0]);
            }
            sql = "INSERT INTO \"CLUSTER_INVALS\" (\"NODEID\", \"ID\", \"FRAGMENTS\", \"KIND\") VALUES (?, ?, ?, ?)";
            for (Long nodeId : nodeIds) {
                if (H2Functions.isLogEnabled()) {
                    H2Functions.logDebug(sql, nodeId, id, fragments, kind);
                }
                ps = conn.prepareStatement(sql);
                ps.setLong(1, nodeId);
                ps.setObject(2, id);
                ps.setString(3, fragments);
                ps.setInt(4, kind);
                ps.execute();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet getClusterInvalidationsString(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        SimpleResultSet result = new SimpleResultSet();
        result.addColumn("ID", 12, 0, 0);
        result.addColumn("FRAGMENTS", 12, 0, 0);
        result.addColumn("KIND", 4, 0, 0);
        if (meta.getURL().startsWith("jdbc:columnlist:")) {
            return result;
        }
        Statement ps = null;
        Statement st = null;
        try {
            String sql = "SELECT \"ID\", \"FRAGMENTS\", \"KIND\" FROM \"CLUSTER_INVALS\" WHERE \"NODEID\" = SESSION_ID()";
            if (H2Functions.isLogEnabled()) {
                H2Functions.logDebug(sql, new Object[0]);
            }
            ps = conn.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            LinkedList<String> debugValues = null;
            if (H2Functions.isLogEnabled()) {
                debugValues = new LinkedList<String>();
            }
            while (rs.next()) {
                String id = rs.getString(1);
                String fragments = rs.getString(2);
                long kind = rs.getLong(3);
                result.addRow(new Object[]{id, fragments, kind});
                if (debugValues == null) continue;
                debugValues.add(id + ',' + fragments + ',' + kind);
            }
            if (debugValues != null) {
                H2Functions.logDebug("  -> " + debugValues, new Object[0]);
            }
            sql = "DELETE FROM \"CLUSTER_INVALS\" WHERE \"NODEID\" = SESSION_ID()";
            if (H2Functions.isLogEnabled()) {
                H2Functions.logDebug(sql, new Object[0]);
            }
            st = conn.createStatement();
            st.execute(sql);
            SimpleResultSet simpleResultSet = result;
            return simpleResultSet;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getLocalReadAcl(Connection conn, String id, String userSeparator) throws SQLException {
        String sql = "SELECT \"GRANT\", \"USER\" FROM ACLS WHERE   \"ID\" = '" + id + "'" + "   AND \"PERMISSION\" IN (SELECT permission FROM read_acl_permissions)" + " ORDER BY \"POS\"";
        if (H2Functions.isLogEnabled()) {
            H2Functions.logDebug(sql, new Object[0]);
        }
        PreparedStatement ps = conn.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        StringBuffer readAcl = new StringBuffer();
        try {
            while (rs.next()) {
                Boolean grant = rs.getBoolean(1);
                String op = grant != false ? rs.getString(2) : '-' + rs.getString(2);
                if (readAcl.length() == 0) {
                    readAcl.append(op);
                    continue;
                }
                readAcl.append(userSeparator + op);
            }
        }
        finally {
            ps.close();
        }
        return readAcl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReadAcl(Connection conn, String id, String userSeparator) throws SQLException {
        StringBuffer readAcl = new StringBuffer();
        PreparedStatement ps1 = null;
        Statement ps2 = null;
        try {
            String newId;
            ps1 = conn.prepareStatement("SELECT PARENTID FROM HIERARCHY WHERE ID = ?;");
            boolean first = true;
            do {
                String localReadAcl;
                if ((localReadAcl = H2Functions.getLocalReadAcl(conn, id, userSeparator)) != null && localReadAcl.length() > 0) {
                    if (readAcl.length() == 0) {
                        readAcl.append(localReadAcl);
                    } else {
                        readAcl.append(userSeparator + localReadAcl);
                    }
                }
                ps1.setObject(1, id);
                ResultSet rs = ps1.executeQuery();
                if (rs.next()) {
                    newId = (String)rs.getObject(1);
                    if (rs.wasNull()) {
                        newId = null;
                    }
                } else {
                    newId = null;
                }
                if (first && newId == null) {
                    ps2 = conn.prepareStatement("SELECT VERSIONABLEID FROM VERSIONS WHERE ID = ?;");
                    ps2.setObject(1, id);
                    rs = ps2.executeQuery();
                    if (rs.next()) {
                        newId = (String)rs.getObject(1);
                        if (rs.wasNull()) {
                            newId = null;
                        }
                    } else {
                        newId = null;
                    }
                }
                first = false;
            } while ((id = newId) != null);
        }
        finally {
            if (ps1 != null) {
                ps1.close();
            }
            if (ps2 != null) {
                ps2.close();
            }
        }
        return readAcl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet getReadAclsFor(Connection conn, String principals, String userSeparator) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        SimpleResultSet result = new SimpleResultSet();
        result.addColumn("ID", 12, 0, 0);
        if (meta.getURL().startsWith("jdbc:columnlist:")) {
            return result;
        }
        if (principals == null) {
            return result;
        }
        Set<String> principalsList = H2Functions.split(principals);
        HashSet<String> blackList = new HashSet<String>();
        for (String user : principalsList) {
            blackList.add('-' + user);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("SELECT \"ID\", \"ACL\" FROM READ_ACLS");
            rs = ps.executeQuery();
            block4: while (rs.next()) {
                String[] acl;
                String id = rs.getString(1);
                for (String ace : acl = rs.getString(2).split(userSeparator)) {
                    if (principalsList.contains(ace)) {
                        result.addRow(new Object[]{id});
                        continue;
                    }
                    if (blackList.contains(ace)) continue block4;
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet rebuildReadAcls(Connection conn, String userSeparator) throws SQLException {
        SimpleResultSet result = new SimpleResultSet();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("TRUNCATE TABLE hierarchy_read_acl;");
            ps.executeUpdate();
            ps = conn.prepareStatement(String.format("INSERT INTO hierarchy_read_acl  SELECT id, nx_get_read_acl(id, '%s')  FROM (SELECT id FROM hierarchy WHERE NOT isproperty) AS uids;", userSeparator));
            ps.executeUpdate();
            ps = conn.prepareStatement("TRUNCATE TABLE read_acls;");
            ps.executeUpdate();
            ps = conn.prepareStatement(String.format("INSERT INTO read_acls  SELECT acl, acl  FROM (SELECT DISTINCT(nx_get_read_acl(id, '%s')) AS acl        FROM  (SELECT DISTINCT(id) AS id               FROM acls) AS uids) AS read_acls_input;", userSeparator));
            ps.executeUpdate();
            ps = conn.prepareStatement("TRUNCATE TABLE hierarchy_modified_acl;");
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet updateReadAcls(Connection conn, String usersSeparator) throws SQLException {
        SimpleResultSet result = new SimpleResultSet();
        Statement ps = null;
        try {
            ps = conn.prepareStatement(String.format("INSERT INTO hierarchy_read_acl SELECT id, nx_get_read_acl(id , '%s') FROM (SELECT DISTINCT(id) AS id   FROM hierarchy_modified_acl   WHERE is_new AND     EXISTS (SELECT 1 FROM hierarchy WHERE hierarchy_modified_acl.id=hierarchy.id)) AS uids;", usersSeparator));
            int rowCount = ps.executeUpdate();
            ps = conn.prepareStatement("DELETE FROM hierarchy_modified_acl WHERE is_new;");
            ps.executeUpdate();
            ps = conn.prepareStatement("UPDATE hierarchy_read_acl SET acl_id = NULL WHERE id IN ( SELECT DISTINCT(id) AS id FROM hierarchy_modified_acl WHERE NOT is_new);");
            rowCount = ps.executeUpdate();
            ps = conn.prepareStatement("DELETE FROM hierarchy_modified_acl WHERE NOT is_new;");
            ps.executeUpdate();
            if (rowCount > 0) {
                ps = conn.prepareStatement("TRUNCATE TABLE read_acls;");
                ps.executeUpdate();
                ps = conn.prepareStatement(String.format("INSERT INTO read_acls SELECT acl, acl FROM (SELECT DISTINCT(nx_get_read_acl(id, '%s')) AS acl       FROM  (SELECT DISTINCT(id) AS id              FROM acls) AS uids) AS read_acls_input;", usersSeparator));
                ps.executeUpdate();
            }
            ps = conn.prepareStatement("UPDATE hierarchy_read_acl SET acl_id = NULL WHERE id IN ( SELECT h.id FROM hierarchy AS h JOIN hierarchy_read_acl AS r ON h.id = r.id WHERE r.acl_id IS NOT NULL AND h.parentid IN (SELECT id FROM hierarchy_read_acl WHERE acl_id IS NULL));");
            while ((rowCount = ps.executeUpdate()) > 0) {
            }
            ps = conn.prepareStatement(String.format("UPDATE hierarchy_read_acl SET acl_id = nx_get_read_acl(id, '%s') WHERE acl_id IS NULL;", usersSeparator));
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet upgradeVersions(Connection conn) throws SQLException {
        PreparedStatement ps1 = null;
        Statement ps2 = null;
        try {
            String sql = "SELECT v.id, v.versionableid, h.majorversion, h.minorversion  FROM versions v JOIN hierarchy h ON v.id = h.id  ORDER BY v.versionableid, v.created DESC";
            ps1 = conn.prepareStatement(sql);
            ResultSet rs = ps1.executeQuery();
            String series = null;
            boolean isLatest = false;
            boolean isLatestMajor = false;
            while (rs.next()) {
                String id = rs.getString("id");
                String vid = rs.getString("versionableid");
                long maj = rs.getLong("majorversion");
                long min = rs.getLong("minorversion");
                if (vid == null || !vid.equals(series)) {
                    isLatest = true;
                    isLatestMajor = true;
                    series = vid;
                }
                boolean isMajor = min == 0L;
                ps2 = conn.prepareStatement("UPDATE versions SET label = ?, islatest = ?, islatestmajor = ? WHERE id = ?");
                ps2.setString(1, maj + "." + min);
                ps2.setBoolean(2, isLatest);
                ps2.setBoolean(3, isMajor && isLatestMajor);
                ps2.setString(4, id);
                ps2.executeUpdate();
                isLatest = false;
                if (!isMajor) continue;
                isLatestMajor = false;
            }
        }
        finally {
            if (ps1 != null) {
                ps1.close();
            }
            if (ps2 != null) {
                ps2.close();
            }
        }
        return new SimpleResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet upgradeLastContributor(Connection conn) throws SQLException {
        PreparedStatement ps1 = null;
        Statement ps2 = null;
        try {
            String sql = "SELECT dc_c.id, dc_c.item  FROM dublincore dc    JOIN (SELECT id, max(pos) AS pos FROM dc_contributors GROUP BY id) AS tmp ON (dc.id = tmp.id)    JOIN dc_contributors dc_c ON (tmp.id = dc_c.id AND tmp.pos = dc_c.pos)  WHERE dc.lastContributor IS NULL;";
            ps1 = conn.prepareStatement(sql);
            ResultSet rs = ps1.executeQuery();
            Object series = null;
            while (rs.next()) {
                String id = rs.getString("id");
                String lastContributor = rs.getString("item");
                ps2 = conn.prepareStatement("UPDATE dublincore SET lastContributor = ? WHERE id = ?");
                ps2.setString(1, lastContributor);
                ps2.setString(2, id);
                ps2.executeUpdate();
            }
        }
        finally {
            if (ps1 != null) {
                ps1.close();
            }
            if (ps2 != null) {
                ps2.close();
            }
        }
        return new SimpleResultSet();
    }

    public static class LogHierarchyModified
    implements Trigger,
    CloseListener {
        private final String idName = "ID";
        private int idIndex;
        private int idType;
        private final String parentIdName = "PARENTID";
        private int parentIdIndex;
        private final String isPropertyName = "ISPROPERTY";
        private int isPropertyIndex;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(Connection conn, String schema, String triggerName, String table, boolean before, int opType) throws SQLException {
            ResultSet rs = null;
            try {
                DatabaseMetaData meta = conn.getMetaData();
                rs = meta.getColumns(null, schema, table, "ID");
                if (!rs.next()) {
                    throw new SQLException("No id key for: " + schema + '.' + table);
                }
                this.idType = rs.getInt("DATA_TYPE");
                this.idIndex = rs.getInt("ORDINAL_POSITION") - 1;
                rs.close();
                rs = meta.getColumns(null, schema, table, "PARENTID");
                if (!rs.next()) {
                    throw new SQLException("No parentid in " + schema + '.' + table);
                }
                this.parentIdIndex = rs.getInt("ORDINAL_POSITION") - 1;
                rs.close();
                rs = meta.getColumns(null, schema, table, "ISPROPERTY");
                if (!rs.next()) {
                    throw new SQLException("No isproperty in " + schema + '.' + table);
                }
                this.isPropertyIndex = rs.getInt("ORDINAL_POSITION") - 1;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            if (newRow != null && !((Boolean)newRow[this.isPropertyIndex]).booleanValue()) {
                PreparedStatement ps = null;
                try {
                    ps = conn.prepareStatement("INSERT INTO hierarchy_modified_acl VALUES(?, ?);");
                    ps.setString(1, newRow[this.idIndex].toString());
                    if (oldRow == null) {
                        ps.setString(2, "t");
                        ps.executeUpdate();
                    } else if (oldRow[this.parentIdIndex] != newRow[this.parentIdIndex]) {
                        ps.setString(2, "f");
                        ps.executeUpdate();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        }

        public void close() throws SQLException {
        }

        public void remove() {
        }
    }

    public static class LogAclsModified
    implements Trigger,
    CloseListener {
        private final String idName = "ID";
        private int idIndex;
        private int idType;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(Connection conn, String schema, String triggerName, String table, boolean before, int opType) throws SQLException {
            ResultSet rs = null;
            try {
                DatabaseMetaData meta = conn.getMetaData();
                rs = meta.getColumns(null, schema, table, "ID");
                if (!rs.next()) {
                    throw new SQLException("No id key for: " + schema + '.' + table);
                }
                this.idType = rs.getInt("DATA_TYPE");
                this.idIndex = rs.getInt("ORDINAL_POSITION") - 1;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            String id = null;
            if (oldRow != null) {
                id = oldRow[this.idIndex].toString();
            } else if (newRow != null) {
                id = newRow[this.idIndex].toString();
            } else {
                return;
            }
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement("INSERT INTO hierarchy_modified_acl VALUES(?, ?);");
                ps.setString(1, id);
                ps.setString(2, "f");
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }

        public void close() throws SQLException {
        }

        public void remove() {
        }
    }
}

