/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.RelationMetaData;
import org.jboss.metadata.RelationshipRoleMetaData;
import org.w3c.dom.Element;

public final class JDBCRelationMetaData {
    private static final int TABLE = 1;
    private static final int FOREIGN_KEY = 2;
    private final String relationName;
    private final JDBCRelationshipRoleMetaData left;
    private final JDBCRelationshipRoleMetaData right;
    private final int mappingStyle;
    private final String dataSourceName;
    private final String datasourceMappingName;
    private transient DataSource dataSource;
    private final JDBCTypeMappingMetaData datasourceMapping;
    private final String tableName;
    private boolean tableCreated;
    private boolean tableDropped;
    private final boolean createTable;
    private final boolean removeTable;
    private final boolean alterTable;
    private final ArrayList tablePostCreateCmd;
    private final boolean rowLocking;
    private final boolean primaryKeyConstraint;
    private final boolean readOnly;
    private final int readTimeOut;

    public JDBCRelationMetaData(JDBCApplicationMetaData jdbcApplication, RelationMetaData relationMetaData) throws DeploymentException {
        this.relationName = relationMetaData.getRelationName();
        RelationshipRoleMetaData leftRole = relationMetaData.getLeftRelationshipRole();
        RelationshipRoleMetaData rightRole = relationMetaData.getRightRelationshipRole();
        this.mappingStyle = leftRole.isMultiplicityMany() && rightRole.isMultiplicityMany() ? 1 : 2;
        this.dataSourceName = null;
        this.datasourceMappingName = null;
        this.datasourceMapping = null;
        this.createTable = false;
        this.removeTable = false;
        this.alterTable = false;
        this.rowLocking = false;
        this.primaryKeyConstraint = false;
        this.readOnly = false;
        this.readTimeOut = -1;
        this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, leftRole);
        this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, rightRole);
        this.left.init(this.right);
        this.right.init(this.left);
        if (this.mappingStyle == 1) {
            this.tableName = this.createDefaultTableName();
            this.tablePostCreateCmd = this.getDefaultTablePostCreateCmd();
        } else {
            this.tableName = null;
            this.tablePostCreateCmd = null;
        }
    }

    public JDBCRelationMetaData(JDBCApplicationMetaData jdbcApplication, Element element, JDBCRelationMetaData defaultValues) throws DeploymentException {
        String alterString;
        String tableNameString;
        this.relationName = defaultValues.getRelationName();
        this.mappingStyle = this.loadMappingStyle(element, defaultValues);
        String readOnlyString = MetaData.getOptionalChildContent(element, "read-only");
        this.readOnly = readOnlyString != null ? Boolean.valueOf(readOnlyString).booleanValue() : defaultValues.isReadOnly();
        String readTimeOutString = MetaData.getOptionalChildContent(element, "read-time-out");
        if (readTimeOutString != null) {
            try {
                this.readTimeOut = Integer.parseInt(readTimeOutString);
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid number format in read-time-out '" + readTimeOutString + "': " + e);
            }
        } else {
            this.readTimeOut = defaultValues.getReadTimeOut();
        }
        Element mappingElement = JDBCRelationMetaData.getMappingElement(element);
        String dataSourceNameString = MetaData.getOptionalChildContent(mappingElement, "datasource");
        this.dataSourceName = dataSourceNameString != null ? dataSourceNameString : defaultValues.getDataSourceName();
        String datasourceMappingString = MetaData.getOptionalChildContent(mappingElement, "datasource-mapping");
        if (datasourceMappingString != null) {
            this.datasourceMappingName = datasourceMappingString;
            this.datasourceMapping = jdbcApplication.getTypeMappingByName(datasourceMappingString);
            if (this.datasourceMapping == null) {
                throw new DeploymentException("Error in jbosscmp-jdbc.xml : datasource-mapping " + datasourceMappingString + " not found");
            }
        } else if (defaultValues.datasourceMappingName != null && defaultValues.getTypeMapping() != null) {
            this.datasourceMappingName = null;
            this.datasourceMapping = defaultValues.getTypeMapping();
        } else {
            this.datasourceMappingName = null;
            this.datasourceMapping = JDBCEntityMetaData.obtainTypeMappingFromLibrary(this.dataSourceName);
        }
        if ((tableNameString = MetaData.getOptionalChildContent(mappingElement, "table-name")) == null && (tableNameString = defaultValues.getDefaultTableName()) == null) {
            tableNameString = defaultValues.createDefaultTableName();
        }
        this.tableName = tableNameString;
        String createString = MetaData.getOptionalChildContent(mappingElement, "create-table");
        this.createTable = createString != null ? Boolean.valueOf(createString).booleanValue() : defaultValues.getCreateTable();
        String removeString = MetaData.getOptionalChildContent(mappingElement, "remove-table");
        this.removeTable = removeString != null ? Boolean.valueOf(removeString).booleanValue() : defaultValues.getRemoveTable();
        Element posttc = MetaData.getOptionalChild(mappingElement, "post-table-create");
        if (posttc != null) {
            Iterator it = MetaData.getChildrenByTagName(posttc, "sql-statement");
            this.tablePostCreateCmd = new ArrayList();
            while (it.hasNext()) {
                Element etmp = (Element)it.next();
                this.tablePostCreateCmd.add(MetaData.getElementContent(etmp));
            }
        } else {
            this.tablePostCreateCmd = defaultValues.getDefaultTablePostCreateCmd();
        }
        this.alterTable = (alterString = MetaData.getOptionalChildContent(mappingElement, "alter-table")) != null ? Boolean.valueOf(alterString).booleanValue() : defaultValues.getAlterTable();
        String sForUpString = MetaData.getOptionalChildContent(mappingElement, "row-locking");
        this.rowLocking = sForUpString != null ? !this.isReadOnly() && Boolean.valueOf(sForUpString) != false : defaultValues.hasRowLocking();
        String pkString = MetaData.getOptionalChildContent(mappingElement, "pk-constraint");
        this.primaryKeyConstraint = pkString != null ? Boolean.valueOf(pkString).booleanValue() : defaultValues.hasPrimaryKeyConstraint();
        JDBCRelationshipRoleMetaData defaultLeft = defaultValues.getLeftRelationshipRole();
        JDBCRelationshipRoleMetaData defaultRight = defaultValues.getRightRelationshipRole();
        if (!MetaData.getChildrenByTagName(element, "ejb-relationship-role").hasNext()) {
            this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, element, defaultLeft);
            this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, element, defaultRight);
            this.left.init(this.right);
            this.right.init(this.left);
        } else {
            Element leftElement = JDBCRelationMetaData.getEJBRelationshipRoleElement(element, defaultLeft);
            this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, leftElement, defaultLeft);
            Element rightElement = JDBCRelationMetaData.getEJBRelationshipRoleElement(element, defaultRight);
            this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, rightElement, defaultRight);
            this.left.init(this.right, leftElement);
            this.right.init(this.left, rightElement);
        }
        if (this.isForeignKeyMappingStyle() && this.left.getKeyFields().isEmpty() && this.right.getKeyFields().isEmpty()) {
            throw new DeploymentException("Atleast one role of a foreign-key mapped relationship must have key fields (or <primkey-field> is missing from ejb-jar.xml): ejb-relation-name=" + this.relationName);
        }
        if (this.isTableMappingStyle() && (this.left.getKeyFields().isEmpty() || this.right.getKeyFields().isEmpty())) {
            throw new DeploymentException("Both roles of a relation-table mapped relationship must have key fields: ejb-relation-name=" + this.relationName);
        }
    }

    private int loadMappingStyle(Element element, JDBCRelationMetaData defaultValues) throws DeploymentException {
        if ("defaults".equals(element.getTagName())) {
            String perferredRelationMapping = MetaData.getOptionalChildContent(element, "preferred-relation-mapping");
            if ("relation-table".equals(perferredRelationMapping) || defaultValues.isManyToMany()) {
                return 1;
            }
            return 2;
        }
        if (MetaData.getOptionalChild(element, "relation-table-mapping") != null) {
            return 1;
        }
        if (MetaData.getOptionalChild(element, "foreign-key-mapping") != null) {
            if (defaultValues.isManyToMany()) {
                throw new DeploymentException("Foreign key mapping-style is not allowed for many-to-many relationsips.");
            }
            return 2;
        }
        return defaultValues.mappingStyle;
    }

    private static Element getMappingElement(Element element) throws DeploymentException {
        if ("defaults".equals(element.getTagName())) {
            return element;
        }
        Element tableMappingElement = MetaData.getOptionalChild(element, "relation-table-mapping");
        if (tableMappingElement != null) {
            return tableMappingElement;
        }
        Element foreignKeyMappingElement = MetaData.getOptionalChild(element, "foreign-key-mapping");
        if (foreignKeyMappingElement != null) {
            return foreignKeyMappingElement;
        }
        return null;
    }

    private static Element getEJBRelationshipRoleElement(Element element, JDBCRelationshipRoleMetaData defaultRole) throws DeploymentException {
        String roleName = defaultRole.getRelationshipRoleName();
        if (roleName == null) {
            throw new DeploymentException("No ejb-relationship-role-name element found");
        }
        Iterator iter = MetaData.getChildrenByTagName(element, "ejb-relationship-role");
        if (!iter.hasNext()) {
            throw new DeploymentException("No ejb-relationship-role elements found");
        }
        Element roleElement = null;
        int i = 0;
        while (iter.hasNext()) {
            if (i > 1) {
                throw new DeploymentException("Expected only 2 ejb-relationship-role but found more then 2");
            }
            Element tempElement = (Element)iter.next();
            if (roleName.equals(MetaData.getUniqueChildContent(tempElement, "ejb-relationship-role-name"))) {
                roleElement = tempElement;
            }
            ++i;
        }
        if (roleElement == null) {
            throw new DeploymentException("An ejb-relationship-role element was not found for role '" + roleName + "'");
        }
        return roleElement;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public JDBCRelationshipRoleMetaData getLeftRelationshipRole() {
        return this.left;
    }

    public JDBCRelationshipRoleMetaData getRightRelationshipRole() {
        return this.right;
    }

    public JDBCRelationshipRoleMetaData getOtherRelationshipRole(JDBCRelationshipRoleMetaData role) {
        if (this.left == role) {
            return this.right;
        }
        if (this.right == role) {
            return this.left;
        }
        throw new IllegalArgumentException("Specified role is not the left or right role. role=" + role);
    }

    public boolean isTableMappingStyle() {
        return this.mappingStyle == 1;
    }

    public boolean isForeignKeyMappingStyle() {
        return this.mappingStyle == 2;
    }

    private String getDataSourceName() {
        return this.dataSourceName;
    }

    public JDBCTypeMappingMetaData getTypeMapping() throws DeploymentException {
        if (this.datasourceMapping == null) {
            throw new DeploymentException("type-mapping is not initialized: " + this.dataSourceName + " was not deployed or type-mapping was not configured.");
        }
        return this.datasourceMapping;
    }

    public String getDefaultTableName() {
        return this.tableName;
    }

    public ArrayList getDefaultTablePostCreateCmd() {
        return this.tablePostCreateCmd;
    }

    public boolean isTableCreated() {
        return this.tableCreated;
    }

    public void setTableCreated() {
        this.tableCreated = true;
    }

    public void setTableDropped() {
        this.tableDropped = true;
    }

    public boolean isTableDropped() {
        return this.tableDropped;
    }

    public boolean getCreateTable() {
        return this.createTable;
    }

    public boolean getRemoveTable() {
        return this.removeTable;
    }

    public boolean getAlterTable() {
        return this.alterTable;
    }

    public boolean hasPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public boolean hasRowLocking() {
        return this.rowLocking;
    }

    private String createDefaultTableName() {
        String defaultTableName = this.left.getEntity().getName();
        if (this.left.getCMRFieldName() != null) {
            defaultTableName = defaultTableName + "_" + this.left.getCMRFieldName();
        }
        defaultTableName = defaultTableName + "_" + this.right.getEntity().getName();
        if (this.right.getCMRFieldName() != null) {
            defaultTableName = defaultTableName + "_" + this.right.getCMRFieldName();
        }
        return defaultTableName;
    }

    private boolean isManyToMany() {
        return this.left.isMultiplicityMany() && this.right.isMultiplicityMany();
    }

    public synchronized DataSource getDataSource() {
        if (this.dataSource == null) {
            try {
                InitialContext context = new InitialContext();
                this.dataSource = (DataSource)context.lookup(this.dataSourceName);
            }
            catch (NamingException e) {
                throw new EJBException("Data source for relationship named " + this.relationName + " not found " + this.dataSourceName);
            }
        }
        return this.dataSource;
    }
}

