/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import java.io.File;
import javax.ws.rs.core.Application;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleManager;

public abstract class WebApplication
extends Application {
    protected ModuleConfiguration cfg = new ModuleConfiguration();

    protected WebApplication(String name) {
        this(name, null);
    }

    protected WebApplication(String name, String baseModule) {
        this.cfg.base = baseModule;
        this.cfg.name = name;
        this.cfg.types = this.getWebTypes();
    }

    public void setModuleDirectory(File moduleDir) {
        this.cfg.file = new File(moduleDir, "module.xml");
        this.cfg.directory = moduleDir;
    }

    public ModuleConfiguration resolve() throws Exception {
        if (this.cfg.file.isFile()) {
            ModuleConfiguration mc = ModuleManager.readConfiguration(this.cfg.engine, this.cfg.file);
            mc.base = this.cfg.base;
            mc.name = this.cfg.name;
            mc.types = this.cfg.types;
            mc.file = this.cfg.file;
            mc.directory = this.cfg.directory;
            this.cfg = mc;
        }
        return this.cfg;
    }

    public ModuleConfiguration getConfiguration() {
        return this.cfg;
    }

    public Module getModule() {
        return this.cfg.get();
    }

    public abstract Class<?>[] getWebTypes();
}

