/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.WebEngineModuleFactory;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationFactory;
import org.nuxeo.ecm.webengine.loader.WebLoader;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleManager;
import org.osgi.framework.Bundle;

public class WebEngineModule
extends Application
implements ApplicationFactory {
    private static Log log = LogFactory.getLog(WebEngineModule.class);
    protected Bundle bundle;
    protected ModuleConfiguration cfg;

    void init(WebEngine engine, Bundle bundle, File moduleDir, Map<String, String> attrs) throws Exception {
        this.bundle = bundle;
        this.loadModuleConfigurationFile(engine, new File(moduleDir, "module.xml"));
        if (attrs != null) {
            String v = attrs.get("name");
            if (v != null) {
                this.cfg.name = v;
            }
            if ((v = attrs.get("extends")) != null) {
                this.cfg.base = v;
            }
            if ((v = attrs.get("headless")) != null) {
                this.cfg.isHeadless = Boolean.parseBoolean(v);
            }
        }
        if (this.cfg.name == null) {
            throw new IllegalStateException("No name given for web module in bundle " + bundle.getSymbolicName());
        }
        this.cfg.directory = moduleDir;
        this.initTypes(engine);
        this.initRoots(engine);
    }

    private void initTypes(WebEngine engine) throws Exception {
        this.cfg.types = this.getWebTypes();
        if (this.cfg.types == null) {
            this.loadMetaTypeFile(engine);
            if (this.cfg.types == null && this.cfg.types == null) {
                throw new IllegalStateException("No web types defined in web module " + this.cfg.name + " from bundle " + this.bundle.getSymbolicName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetaTypeFile(WebEngine engine) throws Exception {
        URL url = this.bundle.getEntry("META-INF/web-types");
        if (url != null) {
            InputStream in = url.openStream();
            try {
                this.cfg.types = WebEngineModule.readWebTypes(engine.getWebLoader(), in);
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?>[] readWebTypes(WebLoader loader, InputStream in) throws Exception {
        HashSet types = new HashSet();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                int p = line.indexOf(124);
                if (p > -1) {
                    line = line.substring(0, p);
                }
                Class<?> cl = loader.loadClass(line);
                types.add(cl);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return types.toArray(new Class[types.size()]);
    }

    private void initRoots(WebEngine engine) throws Exception {
        ArrayList roots = new ArrayList();
        for (Class<?> cl : this.cfg.types) {
            WebObject wo;
            if (cl.isAnnotationPresent(Path.class)) {
                roots.add(cl);
                continue;
            }
            if (this.cfg.rootType == null || (wo = cl.getAnnotation(WebObject.class)) == null || !wo.type().equals(this.cfg.rootType)) continue;
            log.warn((Object)("Invalid web module " + this.cfg.name + " from bundle " + this.bundle.getSymbolicName() + ". The root-type " + cl + " in module.xml is deprecated. Consider using @Path annotation on you root web objects."));
        }
        if (roots.isEmpty()) {
            log.error((Object)("No root web objects found in web module " + this.cfg.name + " from bundle " + this.bundle.getSymbolicName()));
        }
        this.cfg.roots = roots.toArray(new Class[roots.size()]);
    }

    private ModuleConfiguration loadModuleConfigurationFile(WebEngine engine, File file) throws Exception {
        this.cfg = file != null && file.isFile() ? ModuleManager.readConfiguration(engine, file) : new ModuleConfiguration();
        this.cfg.engine = engine;
        this.cfg.file = file;
        return this.cfg;
    }

    public ModuleConfiguration getConfiguration() {
        return this.cfg;
    }

    public Module getModule() {
        return this.cfg.get();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Set<Class<?>> getClasses() {
        if (this.cfg.roots == null) {
            return new HashSet();
        }
        HashSet set = new HashSet();
        for (Class<?> root : this.cfg.roots) {
            set.add(root);
        }
        return set;
    }

    public String getId() {
        return this.bundle.getSymbolicName();
    }

    public Class<?>[] getWebTypes() {
        return null;
    }

    public Application getApplication(Bundle bundle, Map<String, String> args) throws Exception {
        return WebEngineModuleFactory.getApplication(this, bundle, args);
    }
}

