/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.WebEngineModule;
import org.nuxeo.runtime.api.Framework;
import org.osgi.framework.Bundle;

public class WebEngineModuleFactory {
    public static Log log = LogFactory.getLog(WebEngineModuleFactory.class);

    public static WebEngineModule getApplication(WebEngineModule app, Bundle bundle, Map<String, String> attrs) throws Exception {
        WebEngine engine = (WebEngine)Framework.getLocalService(WebEngine.class);
        boolean explode = true;
        if (attrs != null && "false".equals(attrs.get("explode"))) {
            explode = false;
        }
        File moduleDir = null;
        File bundleFile = Framework.getRuntime().getBundleFile(bundle);
        if (explode) {
            moduleDir = WebEngineModuleFactory.explodeBundle(engine, bundle, bundleFile);
        } else if (bundleFile.isDirectory()) {
            moduleDir = bundleFile;
        }
        if (engine.isDevMode() && moduleDir != null) {
            engine.getWebLoader().addClassPathElement(moduleDir);
            app = (WebEngineModule)((Object)engine.loadClass(((Object)((Object)app)).getClass().getName()).newInstance());
        }
        app.init(engine, bundle, moduleDir, attrs);
        engine.addApplication(app);
        log.info((Object)("Deployed web module found in bundle: " + bundle.getSymbolicName()));
        return app;
    }

    private static File explodeBundle(WebEngine engine, Bundle bundle, File bundleFile) throws IOException {
        if (bundleFile.isDirectory()) {
            return bundleFile;
        }
        File moduleRoot = new File(engine.getRootDirectory(), "modules/" + bundle.getSymbolicName());
        if (moduleRoot.exists()) {
            if (bundleFile.lastModified() < moduleRoot.lastModified()) {
                return moduleRoot;
            }
            FileUtils.deleteTree((File)moduleRoot);
        }
        moduleRoot.mkdirs();
        ZipUtils.unzip((File)bundleFile, (File)moduleRoot);
        return moduleRoot;
    }
}

