/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.js.AbstractExpression;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Pair;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectConstructor
extends AbstractExpression {
    @ParseTreeNode.ReflectiveCtor
    public ObjectConstructor(FilePosition pos, Void value, List<? extends Expression> children) {
        super(pos, Expression.class);
        this.createMutation().appendChildren(children).execute();
    }

    public ObjectConstructor(FilePosition pos, List<Pair<Literal, Expression>> properties) {
        super(pos, Expression.class);
        MutableParseTreeNode.Mutation m = this.createMutation();
        for (Pair<Literal, Expression> p : properties) {
            m.appendChild((ParseTreeNode)p.a);
            m.appendChild((ParseTreeNode)p.b);
        }
        m.execute();
    }

    public ObjectConstructor(FilePosition pos) {
        super(pos, Expression.class);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        List<? extends Expression> children = this.children();
        if (0 != (children.size() & 1)) {
            throw new IllegalArgumentException("Odd number of children");
        }
        for (int i = 0; i < children.size(); ++i) {
            Expression e = children.get(i);
            if ((i & 1) != 0 || e instanceof StringLiteral) continue;
            throw new ClassCastException("object field must be a string literal, not " + e);
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    public List<? extends Expression> children() {
        return this.childrenAs(Expression.class);
    }

    public Expression getValue(String key) {
        List<? extends Expression> children = this.children();
        int n = children.size();
        for (int i = 0; i < n; i += 2) {
            StringLiteral sl = (StringLiteral)children.get(i);
            if (!key.equals(sl.getUnquotedValue())) continue;
            return children.get(i + 1);
        }
        return null;
    }

    @Override
    public Boolean conditionResult() {
        return true;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        out.consume("{");
        boolean seen = false;
        Iterator<? extends Expression> els = this.children().iterator();
        while (els.hasNext()) {
            String uqVal;
            Expression key = els.next();
            Expression value = els.next();
            if (seen) {
                out.consume(",");
                out.consume("\n");
            } else {
                seen = true;
            }
            if (rc.rawObjKeys() && key instanceof StringLiteral && ParserBase.isJavascriptIdentifier(uqVal = ((StringLiteral)key).getUnquotedValue()) && !"get".equals(uqVal) && !"set".equals(uqVal)) {
                out.consume(uqVal);
            } else {
                key.render(rc);
            }
            out.consume(":");
            if (!Operation.is((ParseTreeNode)value, Operator.COMMA)) {
                value.render(rc);
                continue;
            }
            out.mark(value.getFilePosition());
            out.consume("(");
            value.render(rc);
            out.consume(")");
        }
        out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
        out.consume("}");
    }

    @Override
    public String typeOf() {
        return "object";
    }
}

