/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql.repository;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;

public class Column
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final int sqlType;
    private final String key;
    private boolean identity;
    private boolean primary;
    private int length = 255;
    private int precision = 19;
    private int scale = 2;
    private boolean nullable = true;
    private String defaultValue;

    public Column(String name, int sqlType, String key) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.sqlType = sqlType;
        this.key = key;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName(Dialect dialect) {
        return dialect.openQuote() + this.name + dialect.closeQuote();
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getKey() {
        return this.key;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int scale) {
        this.precision = scale;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getSqlTypeString(Dialect dialect) {
        if (dialect.getClass().getName().contains("SQLServer") && 12 == this.sqlType && !this.primary) {
            return "nvarchar(" + this.length + ")";
        }
        return dialect.getTypeName(this.sqlType, this.length, this.precision, this.scale);
    }

    public Serializable getFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
        Object result;
        switch (this.sqlType) {
            case -5: {
                result = rs.getLong(columnIndex);
                break;
            }
            case 4: {
                result = rs.getInt(columnIndex);
                break;
            }
            case 12: 
            case 2005: {
                result = rs.getString(columnIndex);
                break;
            }
            case -9: {
                result = rs.getNString(columnIndex);
                break;
            }
            case 93: {
                result = rs.getTimestamp(columnIndex);
                break;
            }
            default: {
                throw new SQLException("Unhandled SQL type " + this.sqlType);
            }
        }
        if (rs.wasNull()) {
            result = null;
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.name + ')';
    }
}

