/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.descriptors;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.descriptors.FieldDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutDescriptors;
import org.nuxeo.ecm.platform.forms.layout.descriptors.PropertiesDescriptor;
import org.w3c.dom.DocumentFragment;

@XObject(value="configuration")
public class WidgetTypeConfigurationDescriptor
implements WidgetTypeConfiguration {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(WidgetTypeConfigurationDescriptor.class);
    @XNode(value="sinceVersion")
    String sinceVersion;
    @XNode(value="title")
    String title;
    String description;
    @XNodeList(value="supportedModes/mode", type=ArrayList.class, componentType=String.class)
    List<String> supportedModes;
    @XNode(value="acceptingSubWidgets")
    boolean acceptingSubWidgets = false;
    @XNode(value="fields/list")
    boolean list = false;
    @XNode(value="fields/complex")
    boolean complex = false;
    @XNodeList(value="fields/supportedTypes/type", type=ArrayList.class, componentType=String.class)
    List<String> supportedFieldTypes;
    @XNodeList(value="fields/defaultTypes/type", type=ArrayList.class, componentType=String.class)
    List<String> defaultFieldTypes;
    @XNodeList(value="fields/defaultConfiguration/field", type=ArrayList.class, componentType=FieldDescriptor.class)
    List<FieldDefinition> defaultFieldDefinitions;
    @XNodeList(value="categories/category", type=ArrayList.class, componentType=String.class)
    List<String> categories;
    @XNodeMap(value="properties/layouts", key="@mode", type=HashMap.class, componentType=LayoutDescriptors.class)
    Map<String, LayoutDescriptors> propertyLayouts;
    Map<String, Serializable> properties;

    public List<String> getCategories() {
        return this.categories;
    }

    public String getDescription() {
        return this.description;
    }

    @XContent(value="description")
    public void setDescription(DocumentFragment descriptionDOM) {
        try {
            OutputFormat of = new OutputFormat();
            of.setOmitXMLDeclaration(true);
            this.description = DOMSerializer.toString((DocumentFragment)descriptionDOM, (OutputFormat)of).trim();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isAcceptingSubWidgets() {
        return this.acceptingSubWidgets;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public boolean isList() {
        return this.list;
    }

    public List<String> getDefaultFieldTypes() {
        return this.defaultFieldTypes;
    }

    public List<String> getSupportedFieldTypes() {
        return this.supportedFieldTypes;
    }

    public List<FieldDefinition> getDefaultFieldDefinitions() {
        return this.defaultFieldDefinitions;
    }

    public Map<String, Serializable> getConfProperties() {
        return this.properties;
    }

    public Serializable getConfProperty(String propName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propName);
    }

    @XNode(value="confProperties")
    public void setConfProperties(PropertiesDescriptor propsDesc) {
        this.properties = propsDesc.getProperties();
    }

    public List<LayoutDefinition> getPropertyLayouts(String mode, String additionalMode) {
        if (this.propertyLayouts != null) {
            List<LayoutDefinition> modeLayoutsList;
            LayoutDescriptors modeLayouts;
            List<LayoutDefinition> defaultLayoutsList;
            LayoutDescriptors defaultLayouts;
            ArrayList<LayoutDefinition> res = new ArrayList<LayoutDefinition>();
            if (additionalMode != null && (defaultLayouts = this.propertyLayouts.get(additionalMode)) != null && (defaultLayoutsList = defaultLayouts.getLayouts()) != null) {
                res.addAll(defaultLayoutsList);
            }
            if ((modeLayouts = this.propertyLayouts.get(mode)) != null && (modeLayoutsList = modeLayouts.getLayouts()) != null) {
                res.addAll(modeLayoutsList);
            }
            return res;
        }
        return null;
    }

    public Map<String, List<LayoutDefinition>> getPropertyLayouts() {
        if (this.propertyLayouts != null) {
            HashMap<String, List<LayoutDefinition>> res = new HashMap<String, List<LayoutDefinition>>();
            for (Map.Entry<String, LayoutDescriptors> entry : this.propertyLayouts.entrySet()) {
                res.put(entry.getKey(), entry.getValue().getLayouts());
            }
            return res;
        }
        return null;
    }

    public String getSinceVersion() {
        return this.sinceVersion;
    }

    public List<String> getSupportedModes() {
        return this.supportedModes;
    }
}

