/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import java.util.ArrayList;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;

public class ValueExpressionHelper {
    private ValueExpressionHelper() {
    }

    public static boolean isFormattedAsELExpression(String expression) {
        return expression.contains(".") || expression.contains("[");
    }

    public static String createExpressionString(String valueName, FieldDefinition field) {
        String dmResolverValue;
        if (field == null || "".equals(field.getPropertyName())) {
            return String.format("#{%s}", valueName);
        }
        ArrayList<String> expressionElements = new ArrayList<String>();
        expressionElements.add(valueName);
        String fieldName = field.getFieldName();
        if (ValueExpressionHelper.isFormattedAsELExpression(fieldName)) {
            expressionElements.add(fieldName);
            dmResolverValue = String.format("#{%s}", StringUtils.join(expressionElements, (String)"."));
        } else {
            String[] splittedFieldName;
            String propertyName;
            String[] s;
            String schemaName = field.getSchemaName();
            if (schemaName == null && (s = (propertyName = field.getFieldName()).split(":")).length == 2) {
                schemaName = s[0];
                fieldName = s[1];
            }
            if (schemaName != null) {
                expressionElements.add(String.format("['%s']", schemaName));
            }
            for (String item : splittedFieldName = fieldName.split("/")) {
                try {
                    expressionElements.add(String.format("[%s]", Integer.parseInt(item)));
                }
                catch (NumberFormatException e) {
                    expressionElements.add(String.format("['%s']", item));
                }
            }
            dmResolverValue = String.format("#{%s}", StringUtils.join(expressionElements, (String)""));
        }
        return dmResolverValue;
    }
}

