/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client.core;

import org.nuxeo.gwt.habyt.upload.client.FileWidgetProvider;
import org.nuxeo.gwt.habyt.upload.client.FilesView;
import org.nuxeo.gwt.habyt.upload.client.Uploader;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public abstract class AbstractUploadWidget extends Composite {

    protected Uploader uploader;

    protected FilesView files;

    public AbstractUploadWidget(String baseUrl) {
        this(baseUrl, null);
    }

    public AbstractUploadWidget(String baseUrl, FileWidgetProvider provider) {
        uploader = createUploader(baseUrl, provider);
        uploader.setMultiUpload(isMultiUpload());
        files = createFilesView();
        initWidget(createWidget());
    }

    public Uploader getUploader() {
        return uploader;
    }

    public FilesView getFilesView() {
        return files;
    }

    public boolean isMultiUpload() {
        return true;
    }

    protected Uploader createUploader(String baseUrl,
            FileWidgetProvider provider) {
        return new DefaultUploader(baseUrl, provider);
    }

    protected FilesView createFilesView() {
        return new DefaultFilesView(uploader);
    }

    protected Widget createWidget() {
        FlowPanel panel = new FlowPanel();
        panel.add(files);
        panel.add(uploader.getWidget());
        return panel;
    }

    @Override
    public Widget getWidget() {
        return super.getWidget();
    }

}
