/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ws.session;

import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSession;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSessionManager;
import org.nuxeo.ecm.platform.api.ws.session.impl.WSRemotingSessionImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class WSRemotingSessionManagerImpl
extends DefaultComponent
implements WSRemotingSessionManager {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.ws.session.WSRemotingSessionManagerImpl");
    private static final Log log = LogFactory.getLog(WSRemotingSessionManagerImpl.class);
    private static final Map<String, WSRemotingSession> sessions = new Hashtable<String, WSRemotingSession>();

    @Override
    public void addSession(String sid, WSRemotingSession session) {
        log.debug((Object)("Adding a new Web Service remoting session for username=" + session.getUsername()));
        sessions.put(sid, session);
    }

    @Override
    public WSRemotingSession createSession(String username, String password, String repository, UserManager um, CoreSession session) {
        return new WSRemotingSessionImpl(session, um, repository, username, password);
    }

    @Override
    public WSRemotingSession getSession(String sid) throws ClientException {
        if (sid == null) {
            throw new ClientException("Invalid value for sid... null value");
        }
        WSRemotingSession session = sessions.get(sid);
        if (session == null) {
            throw new ClientException("Cannot find session for sid=" + sid);
        }
        log.debug((Object)("Found session for username=" + session.getUsername()));
        log.debug((Object)"Forwarding the session now...");
        return session;
    }

    @Override
    public void delSession(String sid) throws ClientException {
        WSRemotingSession session = this.getSession(sid);
        sessions.remove(sid);
        log.debug((Object)("Removing session for username=" + session.getUsername()));
    }
}

