/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import org.javasimon.AbstractSimon;
import org.javasimon.Counter;
import org.javasimon.CounterSample;
import org.javasimon.Manager;
import org.javasimon.utils.SimonUtils;

final class CounterImpl
extends AbstractSimon
implements Counter {
    private long counter;
    private long incrementSum;
    private long decrementSum;
    private long max = Long.MIN_VALUE;
    private long maxTimestamp;
    private long min = Long.MAX_VALUE;
    private long minTimestamp;

    CounterImpl(String name, Manager manager) {
        super(name, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Counter set(long val) {
        try {
            Counter counter = this.privateSet(val);
            return counter;
        }
        finally {
            this.manager.callback().counterSet(this, val);
        }
    }

    private Counter privateSet(long val) {
        this.updateUsages();
        this.counter = val;
        if (this.counter >= this.max) {
            this.max = this.counter;
            this.maxTimestamp = this.getLastUsage();
        }
        if (this.counter <= this.min) {
            this.min = this.counter;
            this.minTimestamp = this.getLastUsage();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Counter increase() {
        try {
            this.updateUsages();
            ++this.counter;
            ++this.incrementSum;
            if (this.counter >= this.max) {
                this.max = this.counter;
                this.maxTimestamp = this.getLastUsage();
            }
            CounterImpl counterImpl = this;
            return counterImpl;
        }
        finally {
            this.manager.callback().counterIncrease(this, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Counter decrease() {
        try {
            this.updateUsages();
            --this.counter;
            ++this.decrementSum;
            if (this.counter <= this.min) {
                this.min = this.counter;
                this.minTimestamp = this.getLastUsage();
            }
            CounterImpl counterImpl = this;
            return counterImpl;
        }
        finally {
            this.manager.callback().counterDecrease(this, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Counter increase(long inc) {
        try {
            this.incrementSum += inc;
            Counter counter = this.set(this.counter + inc);
            return counter;
        }
        finally {
            this.manager.callback().counterIncrease(this, inc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Counter decrease(long dec) {
        try {
            this.decrementSum -= dec;
            Counter counter = this.set(this.counter - dec);
            return counter;
        }
        finally {
            this.manager.callback().counterDecrease(this, dec);
        }
    }

    public synchronized Counter reset() {
        this.counter = 0L;
        this.max = Long.MIN_VALUE;
        this.maxTimestamp = 0L;
        this.min = Long.MAX_VALUE;
        this.minTimestamp = 0L;
        this.incrementSum = 0L;
        this.decrementSum = 0L;
        this.saveResetTimestamp();
        this.manager.callback().reset(this);
        return this;
    }

    public synchronized CounterSample sampleAndReset() {
        CounterSample sample = this.sample();
        this.reset();
        return sample;
    }

    public synchronized CounterSample sample() {
        CounterSample sample = new CounterSample();
        sample.setCounter(this.counter);
        sample.setMin(this.min);
        sample.setMax(this.max);
        sample.setMinTimestamp(this.minTimestamp);
        sample.setMaxTimestamp(this.maxTimestamp);
        sample.setIncrementSum(this.incrementSum);
        sample.setDecrementSum(this.decrementSum);
        sample.setNote(this.getNote());
        return sample;
    }

    public synchronized long getCounter() {
        return this.counter;
    }

    public synchronized long getMin() {
        return this.min;
    }

    public synchronized long getMinTimestamp() {
        return this.minTimestamp;
    }

    public synchronized long getMax() {
        return this.max;
    }

    public synchronized long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public long getIncrementSum() {
        return this.incrementSum;
    }

    public long getDecrementSum() {
        return this.decrementSum;
    }

    public String toString() {
        return "Simon Counter: " + super.toString() + " counter=" + this.counter + ", max=" + SimonUtils.presentMinMaxCount(this.max) + ", min=" + SimonUtils.presentMinMaxCount(this.min) + (this.getNote() != null && this.getNote().length() != 0 ? ", note '" + this.getNote() + "'" : "");
    }
}

