/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.search.ejb;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResources;
import org.nuxeo.ecm.core.search.api.client.IndexingException;
import org.nuxeo.ecm.core.search.api.client.SearchException;
import org.nuxeo.ecm.core.search.api.client.SearchService;
import org.nuxeo.ecm.core.search.api.client.indexing.blobs.BlobExtractor;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.IndexableResources;
import org.nuxeo.ecm.core.search.api.client.indexing.session.SearchServiceSession;
import org.nuxeo.ecm.core.search.api.client.query.ComposedNXQuery;
import org.nuxeo.ecm.core.search.api.client.query.NativeQuery;
import org.nuxeo.ecm.core.search.api.client.query.NativeQueryString;
import org.nuxeo.ecm.core.search.api.client.query.QueryException;
import org.nuxeo.ecm.core.search.api.client.query.SearchPrincipal;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultSet;
import org.nuxeo.ecm.core.search.api.ejb.remote.SearchServiceRemote;
import org.nuxeo.ecm.core.search.api.events.IndexingEventConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.ResourceTypeDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.FulltextFieldDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.IndexableDocType;
import org.nuxeo.ecm.platform.search.ejb.local.SearchServiceLocal;
import org.nuxeo.runtime.api.Framework;

@Stateless
@Remote(value={SearchServiceRemote.class})
@Local(value={SearchServiceLocal.class})
public class SearchServiceBean
implements SearchService {
    private static final long serialVersionUID = -589486174154627675L;
    private static final Log log = LogFactory.getLog(SearchServiceBean.class);
    private transient SearchService service;
    @Resource
    transient EJBContext context;

    private SearchService getSearchService() {
        if (this.service == null) {
            this.service = (SearchService)Framework.getLocalService(SearchService.class);
        }
        return this.service;
    }

    public void deleteAggregatedResources(String key) throws IndexingException {
        if (this.getSearchService() != null) {
            this.getSearchService().deleteAggregatedResources(key);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    public void deleteAtomicResource(String key) throws IndexingException {
        if (this.getSearchService() != null) {
            this.getSearchService().deleteAtomicResource(key);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    public void index(IndexableResources sources, boolean fulltext) throws IndexingException {
        if (this.getSearchService() != null) {
            this.getSearchService().index(sources, fulltext);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    public void unindex(DocumentModel dm) throws IndexingException {
        if (this.getSearchService() != null) {
            this.getSearchService().unindex(dm);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    public ResultSet searchQuery(NativeQuery nativeQuery, int offset, int range) throws SearchException, QueryException {
        ResultSet resultSet = null;
        if (this.getSearchService() != null) {
            nativeQuery.setSearchPrincipal(this.getSearchPrincipal());
            resultSet = this.getSearchService().searchQuery(nativeQuery, offset, range);
        } else {
            log.error((Object)"Cannot find core search service, returning an empty result set....");
        }
        return resultSet;
    }

    public ResultSet searchQuery(ComposedNXQuery nxqlQuery, int offset, int range) throws SearchException, QueryException {
        ResultSet resultSet = null;
        if (this.getSearchService() != null) {
            nxqlQuery.setSearchPrincipal(this.getSearchPrincipal());
            resultSet = this.getSearchService().searchQuery(nxqlQuery, offset, range);
        } else {
            log.error((Object)"Cannot find core search service, returning an empty result set....");
        }
        return resultSet;
    }

    public ResultSet searchQuery(NativeQueryString queryString, String backendName, int offset, int range) throws SearchException, QueryException {
        ResultSet resultSet = null;
        if (this.getSearchService() != null) {
            queryString.setSearchPrincipal(this.getSearchPrincipal());
            resultSet = this.getSearchService().searchQuery(queryString, backendName, offset, range);
        } else {
            log.error((Object)"Cannot find core search service, returning an empty result set....");
        }
        return resultSet;
    }

    public List<String> getSupportedAnalyzersFor(String backendName) {
        List capabilities = Collections.emptyList();
        if (this.getSearchService() != null) {
            capabilities = this.getSearchService().getSupportedAnalyzersFor(backendName);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
        return capabilities;
    }

    public List<String> getSupportedFieldTypes(String backendName) {
        List capabilities = Collections.emptyList();
        if (this.getSearchService() != null) {
            capabilities = this.getSearchService().getSupportedFieldTypes(backendName);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
        return capabilities;
    }

    public IndexableResourceConf getIndexableResourceConfByName(String name, boolean full) {
        IndexableResourceConf conf = null;
        if (this.getSearchService() != null) {
            conf = this.getSearchService().getIndexableResourceConfByName(name, full);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
        return conf;
    }

    public IndexableDocType getIndexableDocTypeFor(String docType) {
        IndexableDocType iDocType = null;
        if (this.getSearchService() != null) {
            iDocType = this.getSearchService().getIndexableDocTypeFor(docType);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
        return iDocType;
    }

    public Map<String, IndexableResourceConf> getIndexableResourceConfs() {
        HashMap confs;
        if (this.getSearchService() != null) {
            confs = this.getSearchService().getIndexableResourceConfs();
        } else {
            log.error((Object)"Cannot find core search service....");
            confs = new HashMap();
        }
        return confs;
    }

    public String[] getAvailableBackendNames() {
        String[] names;
        if (this.getSearchService() != null) {
            names = this.getSearchService().getAvailableBackendNames();
        } else {
            log.error((Object)"Cannot find core search service....");
            names = new String[]{};
        }
        return names;
    }

    protected SearchPrincipal getSearchPrincipal() {
        Principal principal = this.context.getCallerPrincipal();
        return this.getSearchPrincipal(principal);
    }

    public SearchPrincipal getSearchPrincipal(Principal principal) {
        SearchPrincipal sprincipal = null;
        if (this.getSearchService() != null) {
            sprincipal = this.getSearchService().getSearchPrincipal(principal);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
        return sprincipal;
    }

    public IndexableResourceConf getIndexableResourceConfByPrefix(String prefix, boolean full) {
        if (this.getSearchService() != null) {
            return this.getSearchService().getIndexableResourceConfByPrefix(prefix, full);
        }
        log.error((Object)"Cannot find core search service....");
        return null;
    }

    public boolean isEnabled() {
        if (this.getSearchService() != null) {
            return this.getSearchService().isEnabled();
        }
        log.error((Object)"Cannot find core search service....");
        return false;
    }

    public void setStatus(boolean active) {
        if (this.getSearchService() != null) {
            this.getSearchService().setStatus(active);
        }
        log.error((Object)"Cannot find core search service....");
    }

    public FulltextFieldDescriptor getFullTextDescriptorByName(String prefixedName) {
        if (this.getSearchService() != null) {
            return this.getSearchService().getFullTextDescriptorByName(prefixedName);
        }
        log.error((Object)"Cannot find core search service....");
        return null;
    }

    public IndexingEventConf getIndexingEventConfByName(String name) {
        if (this.getSearchService() != null) {
            return this.getSearchService().getIndexingEventConfByName(name);
        }
        log.error((Object)"Cannot find core search service....");
        return null;
    }

    public void invalidateComputedIndexableResourceConfs() {
        if (this.getSearchService() != null) {
            this.getSearchService().invalidateComputedIndexableResourceConfs();
        }
        log.error((Object)"Cannot find core search service....");
    }

    public void clear() throws IndexingException {
        if (this.getSearchService() != null) {
            this.getSearchService().clear();
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    public BlobExtractor getBlobExtractorByName(String name) {
        if (this.getSearchService() != null) {
            return this.getSearchService().getBlobExtractorByName(name);
        }
        log.error((Object)"Cannot find core search service....");
        return null;
    }

    public ResourceTypeDescriptor getResourceTypeDescriptorByName(String name) {
        if (this.getSearchService() != null) {
            return this.getSearchService().getResourceTypeDescriptorByName(name);
        }
        log.error((Object)"Cannot find core search service....");
        return null;
    }

    public void index(ResolvedResources sources) throws IndexingException {
        if (this.getSearchService() != null) {
            this.getSearchService().index(sources);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    public long getIndexingWaitingQueueSize() {
        if (this.getSearchService() != null) {
            return this.getSearchService().getIndexingWaitingQueueSize();
        }
        log.error((Object)"Cannot find core search service....");
        return 0L;
    }

    public int getNumberOfIndexingThreads() {
        if (this.getSearchService() != null) {
            return this.getSearchService().getNumberOfIndexingThreads();
        }
        log.error((Object)"Cannot find core search service....");
        return 0;
    }

    public void closeSession(String sid) {
        if (this.getSearchService() != null) {
            this.getSearchService().closeSession(sid);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    public SearchServiceSession openSession() {
        if (this.getSearchService() != null) {
            return this.getSearchService().openSession();
        }
        log.error((Object)"Cannot find core search service....");
        return null;
    }

    public int getIndexingDocBatchSize() {
        if (this.getSearchService() != null) {
            return this.getSearchService().getIndexingDocBatchSize();
        }
        log.error((Object)"Cannot find core search service....");
        return 1;
    }

    public void setIndexingDocBatchSize(int docBatchSize) {
        if (this.getSearchService() != null) {
            this.getSearchService().setIndexingDocBatchSize(docBatchSize);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    public void setNumberOfIndexingThreads(int numberOfIndexingThreads) {
        if (this.getSearchService() != null) {
            this.getSearchService().setNumberOfIndexingThreads(numberOfIndexingThreads);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    public void saveAllSessions() throws IndexingException {
        if (this.getSearchService() != null) {
            this.getSearchService().saveAllSessions();
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    @Deprecated
    public void reindexAll(String repoName, String path, boolean fulltext) throws IndexingException {
        if (this.getSearchService() != null) {
            this.getSearchService().reindexAll(repoName, path, fulltext);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }

    public int getActiveIndexingTasks() {
        if (this.getSearchService() != null) {
            return this.getSearchService().getActiveIndexingTasks();
        }
        log.error((Object)"Cannot find core search service....");
        return 0;
    }

    public long getTotalCompletedIndexingTasks() {
        if (this.getSearchService() != null) {
            return this.getSearchService().getTotalCompletedIndexingTasks();
        }
        log.error((Object)"Cannot find core search service....");
        return 0L;
    }

    public boolean isReindexingAll() {
        if (this.getSearchService() != null) {
            return this.getSearchService().isReindexingAll();
        }
        log.error((Object)"Cannot find core search service....");
        return false;
    }

    public void setReindexingAll(boolean flag) {
        if (this.getSearchService() != null) {
            this.getSearchService().setReindexingAll(flag);
        } else {
            log.error((Object)"Cannot find core search service....");
        }
    }
}

