/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.model.AntiSamyPattern;
import org.owasp.validator.html.model.Attribute;
import org.owasp.validator.html.model.Property;
import org.owasp.validator.html.model.Tag;
import org.owasp.validator.html.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Policy {
    private static Policy _instance = null;
    private static final String DEFAULT_POLICY_URI = "resources/antisamy.xml";
    private static final String DEFAULT_ONINVALID = "removeAttribute";
    public static final int DEFAULT_MAX_INPUT_SIZE = 100000;
    public static final int DEFAULT_MAX_STYLESHEET_IMPORTS = 1;
    public static final String OMIT_XML_DECLARATION = "omitXmlDeclaration";
    public static final String OMIT_DOCTYPE_DECLARATION = "omitDoctypeDeclaration";
    public static final String MAX_INPUT_SIZE = "maxInputSize";
    public static final String USE_XHTML = "useXHTML";
    public static final String FORMAT_OUTPUT = "formatOutput";
    public static final String EMBED_STYLESHEETS = "embedStyleSheets";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String ENCODE_TAGS = "onUnknownTag";
    private static char REGEXP_BEGIN = (char)94;
    private static char REGEXP_END = (char)36;
    private HashMap commonRegularExpressions;
    private HashMap commonAttributes;
    private HashMap tagRules;
    private HashMap cssRules;
    private HashMap directives;
    private HashMap globalAttributes;
    private ArrayList encodeTags;
    private ArrayList tagNames;

    public boolean isTagInListToEncode(String s) {
        for (int i = 0; i < this.encodeTags.size(); ++i) {
            if (!s.equals((String)this.encodeTags.get(i))) continue;
            return true;
        }
        return false;
    }

    public Tag getTagByName(String tagName) {
        return (Tag)this.tagRules.get(tagName.toLowerCase());
    }

    public Property getPropertyByName(String propertyName) {
        return (Property)this.cssRules.get(propertyName.toLowerCase());
    }

    public static Policy getInstance() throws PolicyException {
        try {
            _instance = new Policy(new FileInputStream(DEFAULT_POLICY_URI));
        }
        catch (IOException e) {
            throw new PolicyException(e);
        }
        return _instance;
    }

    public static Policy getInstance(String filename) throws PolicyException {
        try {
            _instance = new Policy(new FileInputStream(filename));
        }
        catch (IOException e) {
            throw new PolicyException(e);
        }
        return _instance;
    }

    public static Policy getInstance(File file) throws PolicyException {
        try {
            _instance = new Policy(new FileInputStream(file.getAbsoluteFile()));
        }
        catch (IOException e) {
            throw new PolicyException(e);
        }
        return _instance;
    }

    private Policy(File file) throws PolicyException, IOException {
        this(new FileInputStream(file));
    }

    public static Policy getInstance(InputStream inputStream) throws PolicyException {
        _instance = new Policy(inputStream);
        return _instance;
    }

    private Policy(InputStream is) throws PolicyException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = null;
            dom = db.parse(is);
            Element topLevelElement = dom.getDocumentElement();
            Element commonRegularExpressionListNode = (Element)topLevelElement.getElementsByTagName("common-regexps").item(0);
            this.commonRegularExpressions = this.parseCommonRegExps(commonRegularExpressionListNode);
            Element directiveListNode = (Element)topLevelElement.getElementsByTagName("directives").item(0);
            this.directives = this.parseDirectives(directiveListNode);
            Element commonAttributeListNode = (Element)topLevelElement.getElementsByTagName("common-attributes").item(0);
            this.commonAttributes = this.parseCommonAttributes(commonAttributeListNode);
            Element globalAttributeListNode = (Element)topLevelElement.getElementsByTagName("global-tag-attributes").item(0);
            this.globalAttributes = this.parseGlobalAttributes(globalAttributeListNode);
            NodeList tagsToEncodeList = topLevelElement.getElementsByTagName("tags-to-encode");
            this.encodeTags = tagsToEncodeList != null && tagsToEncodeList.getLength() != 0 ? this.parseTagsToEncode((Element)tagsToEncodeList.item(0)) : new ArrayList();
            Element tagListNode = (Element)topLevelElement.getElementsByTagName("tag-rules").item(0);
            this.tagRules = this.parseTagRules(tagListNode);
            Element cssListNode = (Element)topLevelElement.getElementsByTagName("css-rules").item(0);
            this.cssRules = this.parseCSSRules(cssListNode);
        }
        catch (SAXException e) {
            throw new PolicyException(e);
        }
        catch (ParserConfigurationException e) {
            throw new PolicyException(e);
        }
        catch (IOException e) {
            throw new PolicyException(e);
        }
    }

    private HashMap parseDirectives(Element root) {
        HashMap<String, String> directives = new HashMap<String, String>();
        NodeList directiveNodes = root.getElementsByTagName("directive");
        for (int i = 0; i < directiveNodes.getLength(); ++i) {
            Element ele = (Element)directiveNodes.item(i);
            String name = XMLUtil.getAttributeValue(ele, "name");
            String value = XMLUtil.getAttributeValue(ele, "value");
            directives.put(name, value);
        }
        return directives;
    }

    private ArrayList parseTagsToEncode(Element root) throws PolicyException {
        ArrayList<String> tagsToEncode = new ArrayList<String>();
        NodeList tagsToEncodeNodes = root.getElementsByTagName("tag");
        if (tagsToEncodeNodes != null) {
            for (int i = 0; i < tagsToEncodeNodes.getLength(); ++i) {
                Element ele = (Element)tagsToEncodeNodes.item(i);
                if (ele.getFirstChild() == null || ele.getFirstChild().getNodeType() != 3) continue;
                tagsToEncode.add(ele.getFirstChild().getNodeValue());
            }
        }
        return tagsToEncode;
    }

    private HashMap parseGlobalAttributes(Element root) throws PolicyException {
        HashMap<String, Attribute> globalAttributes = new HashMap<String, Attribute>();
        NodeList globalAttributeNodes = root.getElementsByTagName("attribute");
        for (int i = 0; i < globalAttributeNodes.getLength(); ++i) {
            Element ele = (Element)globalAttributeNodes.item(i);
            String name = XMLUtil.getAttributeValue(ele, "name");
            Attribute toAdd = this.getCommonAttributeByName(name);
            if (toAdd == null) {
                throw new PolicyException("Global attribute '" + name + "' was not defined in <common-attributes>");
            }
            globalAttributes.put(name.toLowerCase(), toAdd);
        }
        return globalAttributes;
    }

    private HashMap parseCommonRegExps(Element root) {
        HashMap<String, AntiSamyPattern> commonRegularExpressions = new HashMap<String, AntiSamyPattern>();
        NodeList commonRegExpPatternNodes = root.getElementsByTagName("regexp");
        for (int i = 0; i < commonRegExpPatternNodes.getLength(); ++i) {
            Element ele = (Element)commonRegExpPatternNodes.item(i);
            String name = XMLUtil.getAttributeValue(ele, "name");
            Pattern pattern = Pattern.compile(XMLUtil.getAttributeValue(ele, "value"));
            commonRegularExpressions.put(name, new AntiSamyPattern(name, pattern));
        }
        return commonRegularExpressions;
    }

    private HashMap parseCommonAttributes(Element root) {
        HashMap<String, Attribute> commonAttributes = new HashMap<String, Attribute>();
        NodeList commonAttributesNodes = root.getElementsByTagName("attribute");
        for (int i = 0; i < commonAttributesNodes.getLength(); ++i) {
            Element literalListNode;
            String value;
            Element ele = (Element)commonAttributesNodes.item(i);
            String onInvalid = XMLUtil.getAttributeValue(ele, "onInvalid");
            String name = XMLUtil.getAttributeValue(ele, "name");
            Attribute attribute = new Attribute(XMLUtil.getAttributeValue(ele, "name"));
            attribute.setDescription(XMLUtil.getAttributeValue(ele, "description"));
            if (onInvalid != null && onInvalid.length() > 0) {
                attribute.setOnInvalid(onInvalid);
            } else {
                attribute.setOnInvalid(DEFAULT_ONINVALID);
            }
            Element regExpListNode = (Element)ele.getElementsByTagName("regexp-list").item(0);
            if (regExpListNode != null) {
                NodeList regExpList = regExpListNode.getElementsByTagName("regexp");
                for (int j = 0; j < regExpList.getLength(); ++j) {
                    Element regExpNode = (Element)regExpList.item(j);
                    String regExpName = XMLUtil.getAttributeValue(regExpNode, "name");
                    value = XMLUtil.getAttributeValue(regExpNode, "value");
                    if (regExpName != null && regExpName.length() > 0) {
                        attribute.addAllowedRegExp(this.getRegularExpression(regExpName).getPattern());
                        continue;
                    }
                    attribute.addAllowedRegExp(Pattern.compile(REGEXP_BEGIN + value + REGEXP_END));
                }
            }
            if ((literalListNode = (Element)ele.getElementsByTagName("literal-list").item(0)) != null) {
                NodeList literalList = literalListNode.getElementsByTagName("literal");
                for (int j = 0; j < literalList.getLength(); ++j) {
                    Element literalNode = (Element)literalList.item(j);
                    value = XMLUtil.getAttributeValue(literalNode, "value");
                    if (value != null && value.length() > 0) {
                        attribute.addAllowedValue(value);
                        continue;
                    }
                    if (literalNode.getNodeValue() == null) continue;
                    attribute.addAllowedValue(literalNode.getNodeValue());
                }
            }
            commonAttributes.put(name.toLowerCase(), attribute);
        }
        return commonAttributes;
    }

    private HashMap parseTagRules(Element root) throws PolicyException {
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        NodeList tagList = root.getElementsByTagName("tag");
        for (int i = 0; i < tagList.getLength(); ++i) {
            Element tagNode = (Element)tagList.item(i);
            String name = XMLUtil.getAttributeValue(tagNode, "name");
            String action = XMLUtil.getAttributeValue(tagNode, "action");
            Tag tag = new Tag(name);
            if (this.tagNames == null) {
                this.tagNames = new ArrayList();
            }
            this.tagNames.add(name);
            tag.setAction(action);
            NodeList attributeList = tagNode.getElementsByTagName("attribute");
            for (int j = 0; j < attributeList.getLength(); ++j) {
                Element literalListNode;
                String value;
                Attribute attribute;
                Element attributeNode = (Element)attributeList.item(j);
                if (!attributeNode.hasChildNodes()) {
                    attribute = this.getCommonAttributeByName(XMLUtil.getAttributeValue(attributeNode, "name"));
                    if (attribute != null) {
                        String onInvalid = XMLUtil.getAttributeValue(attributeNode, "onInvalid");
                        String description = XMLUtil.getAttributeValue(attributeNode, "description");
                        if (onInvalid != null && onInvalid.length() != 0) {
                            attribute.setOnInvalid(onInvalid);
                        }
                        if (description != null && description.length() != 0) {
                            attribute.setDescription(description);
                        }
                        tag.addAttribute((Attribute)attribute.clone());
                        continue;
                    }
                    throw new PolicyException("Attribute '" + XMLUtil.getAttributeValue(attributeNode, "name") + "' was referenced as a common attribute in definition of '" + tag.getName() + "', but does not exist in <common-attributes>");
                }
                attribute = new Attribute(XMLUtil.getAttributeValue(attributeNode, "name"));
                attribute.setOnInvalid(XMLUtil.getAttributeValue(attributeNode, "onInvalid"));
                attribute.setDescription(XMLUtil.getAttributeValue(attributeNode, "description"));
                Element regExpListNode = (Element)attributeNode.getElementsByTagName("regexp-list").item(0);
                if (regExpListNode != null) {
                    NodeList regExpList = regExpListNode.getElementsByTagName("regexp");
                    for (int k = 0; k < regExpList.getLength(); ++k) {
                        Element regExpNode = (Element)regExpList.item(k);
                        String regExpName = XMLUtil.getAttributeValue(regExpNode, "name");
                        value = XMLUtil.getAttributeValue(regExpNode, "value");
                        if (regExpName != null && regExpName.length() > 0) {
                            AntiSamyPattern pattern = this.getRegularExpression(regExpName);
                            if (pattern != null) {
                                attribute.addAllowedRegExp(pattern.getPattern());
                                continue;
                            }
                            throw new PolicyException("Regular expression '" + regExpName + "' was referenced as a common regexp in definition of '" + tag.getName() + "', but does not exist in <common-regexp>");
                        }
                        if (value == null || value.length() <= 0) continue;
                        attribute.addAllowedRegExp(Pattern.compile(REGEXP_BEGIN + value + REGEXP_END));
                    }
                }
                if ((literalListNode = (Element)attributeNode.getElementsByTagName("literal-list").item(0)) != null) {
                    NodeList literalList = literalListNode.getElementsByTagName("literal");
                    for (int k = 0; k < literalList.getLength(); ++k) {
                        Element literalNode = (Element)literalList.item(k);
                        value = XMLUtil.getAttributeValue(literalNode, "value");
                        if (value != null && value.length() > 0) {
                            attribute.addAllowedValue(value);
                            continue;
                        }
                        if (literalNode.getNodeValue() == null) continue;
                        attribute.addAllowedValue(literalNode.getNodeValue());
                    }
                }
                tag.addAttribute(attribute);
            }
            tags.put(name.toLowerCase(), tag);
        }
        return tags;
    }

    private HashMap parseCSSRules(Element root) throws PolicyException {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        NodeList propertyNodes = root.getElementsByTagName("property");
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            Element shorthandListNode;
            Element literalListNode;
            Element ele = (Element)propertyNodes.item(i);
            String name = XMLUtil.getAttributeValue(ele, "name");
            String description = XMLUtil.getAttributeValue(ele, "description");
            Property property = new Property(name);
            property.setDescription(description);
            String onInvalid = XMLUtil.getAttributeValue(ele, "onInvalid");
            if (onInvalid != null && onInvalid.length() > 0) {
                property.setOnInvalid(onInvalid);
            } else {
                property.setOnInvalid(DEFAULT_ONINVALID);
            }
            Element regExpListNode = (Element)ele.getElementsByTagName("regexp-list").item(0);
            if (regExpListNode != null) {
                NodeList regExpList = regExpListNode.getElementsByTagName("regexp");
                for (int j = 0; j < regExpList.getLength(); ++j) {
                    Element regExpNode = (Element)regExpList.item(j);
                    String regExpName = XMLUtil.getAttributeValue(regExpNode, "name");
                    String value = XMLUtil.getAttributeValue(regExpNode, "value");
                    AntiSamyPattern pattern = this.getRegularExpression(regExpName);
                    if (pattern != null) {
                        property.addAllowedRegExp(pattern.getPattern());
                        continue;
                    }
                    if (value != null) {
                        property.addAllowedRegExp(Pattern.compile(REGEXP_BEGIN + value + REGEXP_END));
                        continue;
                    }
                    throw new PolicyException("Regular expression '" + regExpName + "' was referenced as a common regexp in definition of '" + property.getName() + "', but does not exist in <common-regexp>");
                }
            }
            if ((literalListNode = (Element)ele.getElementsByTagName("literal-list").item(0)) != null) {
                NodeList literalList = literalListNode.getElementsByTagName("literal");
                for (int j = 0; j < literalList.getLength(); ++j) {
                    Element literalNode = (Element)literalList.item(j);
                    property.addAllowedValue(XMLUtil.getAttributeValue(literalNode, "value"));
                }
            }
            if ((shorthandListNode = (Element)ele.getElementsByTagName("shorthand-list").item(0)) != null) {
                NodeList shorthandList = shorthandListNode.getElementsByTagName("shorthand");
                for (int j = 0; j < shorthandList.getLength(); ++j) {
                    Element shorthandNode = (Element)shorthandList.item(j);
                    property.addShorthandRef(XMLUtil.getAttributeValue(shorthandNode, "name"));
                }
            }
            properties.put(name.toLowerCase(), property);
        }
        return properties;
    }

    public AntiSamyPattern getRegularExpression(String name) {
        return (AntiSamyPattern)this.commonRegularExpressions.get(name);
    }

    public Attribute getGlobalAttributeByName(String name) {
        return (Attribute)this.globalAttributes.get(name.toLowerCase());
    }

    private Attribute getCommonAttributeByName(String attributeName) {
        return (Attribute)this.commonAttributes.get(attributeName.toLowerCase());
    }

    public String[] getTags() {
        return this.tagNames.toArray(new String[1]);
    }

    public String getDirective(String name) {
        return (String)this.directives.get(name);
    }

    public void setDirective(String name, String value) {
        this.directives.put(name, value);
    }

    public int getMaxInputSize() {
        int maxInputSize = 100000;
        try {
            maxInputSize = Integer.parseInt(this.getDirective(MAX_INPUT_SIZE));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maxInputSize;
    }

    public static void main(String[] args) throws Exception {
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = parser.parse(new File(DEFAULT_POLICY_URI));
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaFile = new StreamSource(new File("resources/antisamy.xsd"));
        Schema schema = factory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        try {
            validator.validate(new DOMSource(document));
            System.out.println("made it through!");
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

