/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.ActionFilterRegistry;
import org.nuxeo.ecm.platform.actions.ActionRegistry;
import org.nuxeo.ecm.platform.actions.DefaultActionFilter;
import org.nuxeo.ecm.platform.actions.FilterFactory;
import org.nuxeo.ecm.platform.actions.FilterRule;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.ReloadableComponent;

public class ActionService
extends ReloadableComponent
implements ActionManager {
    public static final ComponentName ID = new ComponentName("org.nuxeo.ecm.platform.actions.ActionService");
    private static final long serialVersionUID = -5256555810901945824L;
    private static final Log log = LogFactory.getLog(ActionService.class);
    private ActionRegistry actionReg;
    private ActionFilterRegistry filterReg;

    public void activate(ComponentContext context) {
        this.actionReg = new ActionRegistry();
        this.filterReg = new ActionFilterRegistry();
    }

    public void deactivate(ComponentContext context) {
        this.actionReg = null;
        this.filterReg = null;
    }

    public ActionRegistry getActionRegistry() {
        return this.actionReg;
    }

    public ActionFilterRegistry getFilterRegistry() {
        return this.filterReg;
    }

    private void applyFilters(ActionContext context, List<Action> actions) {
        Iterator<Action> it = actions.iterator();
        block0: while (it.hasNext()) {
            Action action = it.next();
            for (String filterId : action.getFilterIds()) {
                ActionFilter filter = this.filterReg.getFilter(filterId);
                if (filter == null || filter.accept(action, context)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    @Override
    public List<Action> getActions(String category, ActionContext context) {
        return this.getActions(category, context, true);
    }

    @Override
    public List<Action> getAllActions(String category) {
        return this.actionReg.getActions(category);
    }

    @Override
    public List<Action> getActions(String category, ActionContext context, boolean hideUnavailableActions) {
        List<Action> actions = this.actionReg.getActions(category);
        if (hideUnavailableActions) {
            this.applyFilters(context, actions);
            Collections.sort(actions);
            return actions;
        }
        ArrayList<Action> allActions = new ArrayList<Action>();
        allActions.addAll(actions);
        this.applyFilters(context, actions);
        for (Action a : allActions) {
            a.setAvailable(actions.contains(a));
        }
        Collections.sort(allActions);
        return allActions;
    }

    @Override
    public Action getAction(String actionId) {
        return this.actionReg.getAction(actionId);
    }

    @Override
    public boolean isRegistered(String actionId) {
        return this.actionReg.getAction(actionId) != null;
    }

    @Override
    public boolean isEnabled(String actionId, ActionContext context) {
        Action action = this.actionReg.getAction(actionId);
        if (action != null) {
            return this.isEnabled(action, context);
        }
        return false;
    }

    public boolean isEnabled(Action action, ActionContext context) {
        for (String filterId : action.getFilterIds()) {
            ActionFilter filter = this.filterReg.getFilter(filterId);
            if (filter == null || filter.accept(action, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ActionFilter[] getFilters(String actionId) {
        Action action = this.actionReg.getAction(actionId);
        if (action == null) {
            return null;
        }
        List<String> filterIds = action.getFilterIds();
        if (filterIds != null && !filterIds.isEmpty()) {
            ActionFilter[] filters = new ActionFilter[filterIds.size()];
            for (int i = 0; i < filters.length; ++i) {
                String filterId = filterIds.get(i);
                filters[i] = this.filterReg.getFilter(filterId);
            }
            return filters;
        }
        return null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if ("actions".equals(extensionPoint)) {
            this.registerActionExtension(contribution);
        } else if ("filters".equals(extensionPoint)) {
            this.registerFilterExtension(contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if ("actions".equals(extensionPoint)) {
            this.unregisterActionExtension(((Action)contribution).getId());
        } else if ("filters".equals(extensionPoint)) {
            this.unregisterFilterExtension(contribution);
        }
    }

    public void registerFilterExtension(Object contrib) {
        if (contrib.getClass() == FilterFactory.class) {
            FilterFactory ff = (FilterFactory)contrib;
            this.filterReg.removeFilter(ff.id);
            try {
                ActionFilter filter = (ActionFilter)Thread.currentThread().getContextClassLoader().loadClass(ff.className).newInstance();
                filter.setId(ff.id);
                this.filterReg.addFilter(filter);
            }
            catch (Exception e) {
                log.error((Object)"Failed to create action filter", (Throwable)e);
            }
        } else {
            ActionFilter filter = (ActionFilter)contrib;
            if (this.filterReg.getFilter(filter.getId()) != null) {
                DefaultActionFilter newFilter = (DefaultActionFilter)filter;
                DefaultActionFilter oldFilter = (DefaultActionFilter)this.filterReg.getFilter(filter.getId());
                if (newFilter.getAppend()) {
                    ArrayList<FilterRule> mergedRules = new ArrayList<FilterRule>();
                    mergedRules.addAll(Arrays.asList(oldFilter.getRules()));
                    mergedRules.addAll(Arrays.asList(newFilter.getRules()));
                    oldFilter.setRules(mergedRules.toArray(new FilterRule[mergedRules.size()]));
                } else {
                    this.filterReg.removeFilter(filter.getId());
                    this.filterReg.addFilter(filter);
                }
            } else {
                this.filterReg.addFilter(filter);
            }
        }
    }

    public void unregisterFilterExtension(Object contrib) {
        if (contrib.getClass() == FilterFactory.class) {
            this.filterReg.removeFilter(((FilterFactory)contrib).id);
        } else {
            this.filterReg.removeFilter(((ActionFilter)contrib).getId());
        }
    }

    protected List<Action> getContributedActionsById(String id) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Extension xt : this.extensions) {
            for (Object o : xt.getContributions()) {
                Action a;
                if (!(o instanceof Action) || !id.equals((a = (Action)o).getId())) continue;
                actions.add(a);
            }
        }
        return actions;
    }

    protected void unregisterActionExtension(String id) {
        if (null != this.actionReg.removeAction(id)) {
            List<Action> actions = this.getContributedActionsById(id);
            for (Action action : actions) {
                this.registerActionExtension(action);
            }
        }
    }

    public void registerActionExtension(Object contrib) {
        List<String> actionFilterIds;
        Action action = (Action)contrib;
        ActionFilter[] filters = action.getFilters();
        String actionId = action.getId();
        Action existingAction = this.actionReg.getAction(actionId);
        if (existingAction != null) {
            log.debug((Object)("Upgrading web action with id " + actionId));
            action = ActionService.mergeActions(existingAction, action);
            this.actionReg.removeAction(actionId);
        }
        ArrayList<String> filterIds = new ArrayList<String>();
        if (filters != null) {
            for (ActionFilter filter : filters) {
                this.filterReg.removeFilter(filter.getId());
                this.filterReg.addFilter(filter);
                filterIds.add(filter.getId());
            }
        }
        if ((actionFilterIds = action.getFilterIds()) == null) {
            action.setFilterIds(filterIds);
        } else {
            actionFilterIds.addAll(filterIds);
            action.setFilterIds(actionFilterIds);
        }
        if (action.getLabel() == null) {
            action.setLabel(actionId);
        }
        this.actionReg.addAction(action);
    }

    protected static Action mergeActions(Action existingOne, Action newOne) {
        try {
            Action clone = existingOne.clone();
            clone.mergeWith(newOne);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    @Override
    public void remove() {
    }
}

