/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.BeanMap;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;

public class TestRepository {
    private static final String CONF_RESOURCE = "test-repository.xml";
    private static final String HOME_PROPERTY = "org.apache.jackrabbit.test.repository.home";
    private static final String HOME_DEFAULT = "jackrabbit-test-repository";
    private static Repository instance = null;

    public static synchronized Repository getInstance() throws RepositoryException {
        try {
            if (instance == null) {
                try {
                    instance = TestRepository.getIntegratedInstance();
                }
                catch (RepositoryException e) {
                    throw e;
                }
                catch (Exception e) {
                    InputStream xml = TestRepository.class.getResourceAsStream(CONF_RESOURCE);
                    String home = System.getProperty(HOME_PROPERTY, HOME_DEFAULT);
                    RepositoryConfig config = RepositoryConfig.create(xml, home);
                    instance = new TransientRepository(config);
                }
            }
            return instance;
        }
        catch (ConfigurationException e) {
            throw new RepositoryException("Error in test repository configuration", (Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new RepositoryException("Error in test repository initialization", (Throwable)e);
        }
    }

    private static Repository getIntegratedInstance() throws Exception {
        Class<?> test = Class.forName("org.apache.jackrabbit.test.AbstractJCRTest");
        BeanMap helper = new BeanMap(test.getField("helper").get(null));
        final Repository repository = (Repository)helper.get("repository");
        final Credentials superuser = (Credentials)helper.get("superuserCredentials");
        return new Repository(){

            public String[] getDescriptorKeys() {
                return repository.getDescriptorKeys();
            }

            public String getDescriptor(String key) {
                return repository.getDescriptor(key);
            }

            public Session login(Credentials credentials, String workspace) throws RepositoryException {
                return repository.login(credentials, workspace);
            }

            public Session login(Credentials credentials) throws RepositoryException {
                return repository.login(credentials);
            }

            public Session login(String workspace) throws RepositoryException {
                return repository.login(superuser, workspace);
            }

            public Session login() throws RepositoryException {
                return repository.login(superuser);
            }
        };
    }

    public static synchronized void setInstance(Repository repository) {
        instance = repository;
    }

    private TestRepository() {
    }
}

