/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.runtime.AbstractPersistentFilableCmisObject;
import org.apache.chemistry.opencmis.client.runtime.PersistentSessionImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentDocumentImpl
extends AbstractPersistentFilableCmisObject
implements Document {
    public PersistentDocumentImpl(PersistentSessionImpl session, ObjectType objectType, ObjectData objectData, OperationContext context) {
        this.initialize(session, objectType, objectData, context);
    }

    public String getCheckinComment() {
        return (String)this.getPropertyValue("cmis:checkinComment");
    }

    public String getVersionLabel() {
        return (String)this.getPropertyValue("cmis:versionLabel");
    }

    public String getVersionSeriesId() {
        return (String)this.getPropertyValue("cmis:versionSeriesId");
    }

    public String getVersionSeriesCheckedOutId() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutId");
    }

    public String getVersionSeriesCheckedOutBy() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutBy");
    }

    public Boolean isImmutable() {
        return (Boolean)this.getPropertyValue("cmis:isImmutable");
    }

    public Boolean isLatestMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestMajorVersion");
    }

    public Boolean isLatestVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestVersion");
    }

    public Boolean isMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isMajorVersion");
    }

    public Boolean isVersionSeriesCheckedOut() {
        return (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
    }

    public long getContentStreamLength() {
        BigInteger bigInt = (BigInteger)this.getPropertyValue("cmis:contentStreamLength");
        return bigInt == null ? -1L : bigInt.longValue();
    }

    public String getContentStreamMimeType() {
        return (String)this.getPropertyValue("cmis:contentStreamMimeType");
    }

    public String getContentStreamFileName() {
        return (String)this.getPropertyValue("cmis:contentStreamFileName");
    }

    public String getContentStreamId() {
        return (String)this.getPropertyValue("cmis:contentStreamId");
    }

    public Document copy(ObjectId targetFolderId, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addACEs, List<Ace> removeACEs, OperationContext context) {
        if (targetFolderId == null || targetFolderId.getId() == null) {
            throw new CmisInvalidArgumentException("Target must be set");
        }
        ObjectFactory factory = this.getObjectFactory();
        HashSet<Updatability> updatability = new HashSet<Updatability>();
        updatability.add(Updatability.READWRITE);
        String newId = this.getBinding().getObjectService().createDocumentFromSource(this.getRepositoryId(), this.getId(), factory.convertProperties(properties, this.getType(), updatability), targetFolderId.getId(), versioningState, factory.convertPolicies(policies), factory.convertAces(addACEs), factory.convertAces(removeACEs), null);
        if (context == null || newId == null) {
            return null;
        }
        CmisObject object = this.getSession().getObject(this.getSession().createObjectId(newId), context);
        if (!(object instanceof Document)) {
            throw new CmisRuntimeException("Newly created object is not a document! New id: " + newId);
        }
        return (Document)object;
    }

    public Document copy(ObjectId targetFolderId) {
        return this.copy(targetFolderId, null, null, null, null, null, this.getSession().getDefaultContext());
    }

    public void deleteAllVersions() {
        this.delete(true);
    }

    public ObjectId checkOut() {
        String objectId = this.getObjectId();
        Holder objectIdHolder = new Holder((Object)objectId);
        this.getBinding().getVersioningService().checkOut(this.getRepositoryId(), objectIdHolder, null, null);
        if (objectIdHolder.getValue() == null) {
            return null;
        }
        return this.getSession().createObjectId((String)objectIdHolder.getValue());
    }

    public void cancelCheckOut() {
        String objectId = this.getObjectId();
        this.getBinding().getVersioningService().cancelCheckOut(this.getRepositoryId(), objectId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        ObjectType type;
        String objectId;
        this.readLock();
        try {
            objectId = this.getObjectId();
            type = this.getType();
        }
        finally {
            this.readUnlock();
        }
        Holder objectIdHolder = new Holder((Object)objectId);
        ObjectFactory of = this.getObjectFactory();
        HashSet<Updatability> updatebility = new HashSet<Updatability>();
        updatebility.add(Updatability.READWRITE);
        updatebility.add(Updatability.WHENCHECKEDOUT);
        this.getBinding().getVersioningService().checkIn(this.getRepositoryId(), objectIdHolder, Boolean.valueOf(major), of.convertProperties(properties, type, updatebility), of.convertContentStream(contentStream), checkinComment, of.convertPolicies(policies), of.convertAces(addAces), of.convertAces(removeAces), null);
        if (objectIdHolder.getValue() == null) {
            return null;
        }
        return this.getSession().createObjectId((String)objectIdHolder.getValue());
    }

    public List<Document> getAllVersions() {
        return this.getAllVersions(this.getSession().getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> getAllVersions(OperationContext context) {
        String versionSeriesId;
        String objectId;
        this.readLock();
        try {
            objectId = this.getObjectId();
            versionSeriesId = this.getVersionSeriesId();
        }
        finally {
            this.readUnlock();
        }
        List versions = this.getBinding().getVersioningService().getAllVersions(this.getRepositoryId(), objectId, versionSeriesId, context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), null);
        ObjectFactory objectFactory = this.getSession().getObjectFactory();
        ArrayList<Document> result = new ArrayList<Document>();
        if (versions != null) {
            for (ObjectData objectData : versions) {
                CmisObject doc = objectFactory.convertObject(objectData, context);
                if (!(doc instanceof Document)) continue;
                result.add((Document)doc);
            }
        }
        return result;
    }

    public Document getObjectOfLatestVersion(boolean major) {
        return this.getObjectOfLatestVersion(major, this.getSession().getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getObjectOfLatestVersion(boolean major, OperationContext context) {
        String versionSeriesId;
        String objectId;
        this.readLock();
        try {
            objectId = this.getObjectId();
            versionSeriesId = this.getVersionSeriesId();
        }
        finally {
            this.readUnlock();
        }
        if (versionSeriesId == null) {
            throw new CmisRuntimeException("Version series id is unknown!");
        }
        ObjectData objectData = this.getBinding().getVersioningService().getObjectOfLatestVersion(this.getRepositoryId(), objectId, versionSeriesId, Boolean.valueOf(major), context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), null);
        ObjectFactory objectFactory = this.getSession().getObjectFactory();
        CmisObject result = objectFactory.convertObject(objectData, context);
        if (!(result instanceof Document)) {
            throw new CmisRuntimeException("Latest version is not a document!");
        }
        return (Document)result;
    }

    public ContentStream getContentStream() {
        return this.getContentStream(null);
    }

    public ContentStream getContentStream(String streamId) {
        ContentStream contentStream;
        String objectId = this.getObjectId();
        try {
            contentStream = this.getBinding().getObjectService().getContentStream(this.getRepositoryId(), objectId, streamId, null, null, null);
        }
        catch (CmisConstraintException e) {
            return null;
        }
        String filename = contentStream.getFileName();
        if (filename == null) {
            filename = this.getContentStreamFileName();
        }
        long length = contentStream.getBigLength() == null ? -1L : contentStream.getBigLength().longValue();
        return this.getSession().getObjectFactory().createContentStream(filename, length, contentStream.getMimeType(), contentStream.getStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId setContentStream(ContentStream contentStream, boolean overwrite) {
        String changeToken;
        String objectId;
        this.readLock();
        try {
            objectId = this.getObjectId();
            changeToken = (String)this.getPropertyValue("cmis:changeToken");
        }
        finally {
            this.readUnlock();
        }
        Holder objectIdHolder = new Holder((Object)objectId);
        Holder changeTokenHolder = new Holder((Object)changeToken);
        this.getBinding().getObjectService().setContentStream(this.getRepositoryId(), objectIdHolder, Boolean.valueOf(overwrite), changeTokenHolder, this.getObjectFactory().convertContentStream(contentStream), null);
        if (objectIdHolder.getValue() == null) {
            return null;
        }
        return this.getSession().createObjectId((String)objectIdHolder.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId deleteContentStream() {
        String changeToken;
        String objectId;
        this.readLock();
        try {
            objectId = this.getObjectId();
            changeToken = (String)this.getPropertyValue("cmis:changeToken");
        }
        finally {
            this.readUnlock();
        }
        Holder objectIdHolder = new Holder((Object)objectId);
        Holder changeTokenHolder = new Holder((Object)changeToken);
        this.getBinding().getObjectService().deleteContentStream(this.getRepositoryId(), objectIdHolder, changeTokenHolder, null);
        if (objectIdHolder.getValue() == null) {
            return null;
        }
        return this.getSession().createObjectId((String)objectIdHolder.getValue());
    }

    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment) {
        return this.checkIn(major, properties, contentStream, checkinComment, null, null, null);
    }
}

