/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.CmisBindingHelper;
import org.apache.chemistry.opencmis.client.runtime.PersistentSessionImpl;
import org.apache.chemistry.opencmis.client.runtime.repository.RepositoryImpl;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.SessionType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionFactoryImpl
implements SessionFactory {
    protected SessionFactoryImpl() {
    }

    public static SessionFactory newInstance() {
        return new SessionFactoryImpl();
    }

    public <T extends Session> T createSession(Map<String, String> parameters) {
        PersistentSessionImpl s = null;
        SessionType t = null;
        t = parameters.containsKey("org.apache.chemistry.opencmis.session.type") ? SessionType.fromValue((String)parameters.get("org.apache.chemistry.opencmis.session.type")) : SessionType.PERSISTENT;
        switch (t) {
            case PERSISTENT: {
                PersistentSessionImpl ps = new PersistentSessionImpl(parameters);
                ps.connect();
                s = ps;
                break;
            }
            case TRANSIENT: {
                throw new CmisNotSupportedException("SessionType " + t + "not implemented!");
            }
            default: {
                throw new CmisRuntimeException("SessionType " + t + "not known!");
            }
        }
        return (T)s;
    }

    public List<Repository> getRepositories(Map<String, String> parameters) {
        CmisBinding binding = CmisBindingHelper.createProvider(parameters);
        List repositoryInfos = binding.getRepositoryService().getRepositoryInfos(null);
        ArrayList<Repository> result = new ArrayList<Repository>();
        for (RepositoryInfo data : repositoryInfos) {
            result.add(new RepositoryImpl(data, parameters, this));
        }
        return result;
    }
}

