/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.objecttype;

import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.RelationshipType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.objecttype.ObjectTypeHelper;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipTypeImpl
extends RelationshipTypeDefinitionImpl
implements RelationshipType {
    private static final long serialVersionUID = 1L;
    private ObjectTypeHelper helper;
    private List<ObjectType> allowedSourceTypes;
    private List<ObjectType> allowedTargetTypes;

    public RelationshipTypeImpl(Session session, RelationshipTypeDefinition typeDefinition) {
        this.initialize((TypeDefinition)typeDefinition);
        this.setAllowedSourceTypes(typeDefinition.getAllowedSourceTypeIds());
        this.setAllowedTargetTypes(typeDefinition.getAllowedTargetTypeIds());
        this.helper = new ObjectTypeHelper(session, (ObjectType)this);
    }

    public ObjectType getBaseType() {
        return this.helper.getBaseType();
    }

    public ItemIterable<ObjectType> getChildren() {
        return this.helper.getChildren();
    }

    public List<Tree<ObjectType>> getDescendants(int depth) {
        return this.helper.getDescendants(depth);
    }

    public ObjectType getParentType() {
        return this.helper.getParentType();
    }

    public boolean isBaseType() {
        return this.helper.isBaseType();
    }

    public List<ObjectType> getAllowedSourceTypes() {
        if (this.allowedSourceTypes == null) {
            List ids = this.getAllowedSourceTypeIds();
            ArrayList<ObjectType> types = new ArrayList<ObjectType>(ids == null ? 0 : ids.size());
            if (ids != null) {
                for (String id : ids) {
                    types.add(this.helper.getSession().getTypeDefinition(id));
                }
            }
            this.allowedSourceTypes = types;
        }
        return this.allowedSourceTypes;
    }

    public List<ObjectType> getAllowedTargetTypes() {
        if (this.allowedTargetTypes == null) {
            List ids = this.getAllowedTargetTypeIds();
            ArrayList<ObjectType> types = new ArrayList<ObjectType>(ids == null ? 0 : ids.size());
            if (ids != null) {
                for (String id : ids) {
                    types.add(this.helper.getSession().getTypeDefinition(id));
                }
            }
            this.allowedTargetTypes = types;
        }
        return this.allowedTargetTypes;
    }
}

