/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.repository;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.runtime.ChangeEventImpl;
import org.apache.chemistry.opencmis.client.runtime.ChangeEventsImpl;
import org.apache.chemistry.opencmis.client.runtime.PersistentDocumentImpl;
import org.apache.chemistry.opencmis.client.runtime.PersistentFolderImpl;
import org.apache.chemistry.opencmis.client.runtime.PersistentPolicyImpl;
import org.apache.chemistry.opencmis.client.runtime.PersistentPropertyImpl;
import org.apache.chemistry.opencmis.client.runtime.PersistentRelationshipImpl;
import org.apache.chemistry.opencmis.client.runtime.PersistentSessionImpl;
import org.apache.chemistry.opencmis.client.runtime.QueryResultImpl;
import org.apache.chemistry.opencmis.client.runtime.RenditionImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.DocumentTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.FolderTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.PolicyTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.RelationshipTypeImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentObjectFactoryImpl
implements ObjectFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private PersistentSessionImpl session = null;

    protected PersistentObjectFactoryImpl(PersistentSessionImpl session) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        this.session = session;
    }

    public static ObjectFactory newInstance(PersistentSessionImpl session) {
        return new PersistentObjectFactoryImpl(session);
    }

    protected BindingsObjectFactory getBindingsObjectFactory() {
        return this.session.getBinding().getObjectFactory();
    }

    public Acl convertAces(List<Ace> aces) {
        if (aces == null) {
            return null;
        }
        BindingsObjectFactory bof = this.getBindingsObjectFactory();
        ArrayList<Ace> providerAces = new ArrayList<Ace>();
        for (Ace ace : aces) {
            providerAces.add(bof.createAccessControlEntry(ace.getPrincipalId(), ace.getPermissions()));
        }
        return bof.createAccessControlList(providerAces);
    }

    public Ace createAce(String principal, List<String> permissions) {
        BindingsObjectFactory bof = this.getBindingsObjectFactory();
        Ace ace = bof.createAccessControlEntry(principal, permissions);
        return ace;
    }

    public Acl createAcl(List<Ace> aces) {
        BindingsObjectFactory bof = this.getBindingsObjectFactory();
        Acl acl = bof.createAccessControlList(aces);
        return acl;
    }

    public List<String> convertPolicies(List<Policy> policies) {
        if (policies == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Policy policy : policies) {
            if (policy == null || policy.getId() == null) continue;
            result.add(policy.getId());
        }
        return result;
    }

    public Rendition convertRendition(String objectId, RenditionData rendition) {
        if (rendition == null) {
            throw new IllegalArgumentException("Rendition must be set!");
        }
        long length = rendition.getBigLength() == null ? -1L : rendition.getBigLength().longValue();
        int height = rendition.getBigHeight() == null ? -1 : rendition.getBigHeight().intValue();
        int width = rendition.getBigWidth() == null ? -1 : rendition.getBigWidth().intValue();
        return new RenditionImpl(this.session, objectId, rendition.getStreamId(), rendition.getRenditionDocumentId(), rendition.getKind(), length, rendition.getMimeType(), rendition.getTitle(), height, width);
    }

    public ContentStream createContentStream(String filename, long length, String mimetype, InputStream stream) {
        return new ContentStreamImpl(filename, BigInteger.valueOf(length), mimetype, stream);
    }

    public ContentStream convertContentStream(ContentStream contentStream) {
        if (contentStream == null) {
            return null;
        }
        BigInteger length = contentStream.getLength() < 0L ? null : BigInteger.valueOf(contentStream.getLength());
        return this.getBindingsObjectFactory().createContentStream(contentStream.getFileName(), length, contentStream.getMimeType(), contentStream.getStream());
    }

    public ObjectType convertTypeDefinition(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof DocumentTypeDefinition) {
            return new DocumentTypeImpl(this.session, (DocumentTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof FolderTypeDefinition) {
            return new FolderTypeImpl(this.session, (FolderTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof RelationshipTypeDefinition) {
            return new RelationshipTypeImpl(this.session, (RelationshipTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof PolicyTypeDefinition) {
            return new PolicyTypeImpl(this.session, (PolicyTypeDefinition)typeDefinition);
        }
        throw new CmisRuntimeException("Unknown base type!");
    }

    public ObjectType getTypeFromObjectData(ObjectData objectData) {
        if (objectData == null || objectData.getProperties() == null || objectData.getProperties().getProperties() == null) {
            return null;
        }
        PropertyData typeProperty = (PropertyData)objectData.getProperties().getProperties().get("cmis:objectTypeId");
        if (!(typeProperty instanceof PropertyId)) {
            return null;
        }
        return this.session.getTypeDefinition((String)typeProperty.getFirstValue());
    }

    public <T> Property<T> createProperty(PropertyDefinition<T> type, List<T> values) {
        return new PersistentPropertyImpl<T>(type, values);
    }

    protected <T> Property<T> convertProperty(ObjectType objectType, PropertyData<T> pd) {
        PropertyDefinition definition = (PropertyDefinition)objectType.getPropertyDefinitions().get(pd.getId());
        if (definition == null) {
            throw new CmisRuntimeException("Property '" + pd.getId() + "' doesn't exist!");
        }
        return this.createProperty(definition, pd.getValues());
    }

    public Map<String, Property<?>> convertProperties(ObjectType objectType, Properties properties) {
        if (objectType == null) {
            throw new IllegalArgumentException("Object type must set!");
        }
        if (objectType.getPropertyDefinitions() == null) {
            throw new IllegalArgumentException("Object type has no property defintions!");
        }
        if (properties == null || properties.getProperties() == null) {
            throw new IllegalArgumentException("Properties must be set!");
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : properties.getProperties().entrySet()) {
            Property apiProperty = this.convertProperty(objectType, (PropertyData)entry.getValue());
            result.put((String)entry.getKey(), apiProperty);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties convertProperties(Map<String, ?> properties, ObjectType type, Set<Updatability> updatabilityFilter) {
        if (properties == null) {
            return null;
        }
        if (type == null) {
            Object typeId = properties.get("cmis:objectTypeId");
            if (!(typeId instanceof String)) {
                throw new IllegalArgumentException("Type or type property must be set!");
            }
            type = this.session.getTypeDefinition(typeId.toString());
        }
        BindingsObjectFactory bof = this.getBindingsObjectFactory();
        ArrayList<PropertyString> propertyList = new ArrayList<PropertyString>();
        for (Map.Entry<String, ?> property : properties.entrySet()) {
            Object firstValue;
            List<void> values;
            void var9_9;
            PropertyDefinition definition;
            if (property == null || property.getKey() == null) continue;
            String id = property.getKey();
            Object obj = property.getValue();
            if (obj instanceof Property) {
                Object object;
                Property p = (Property)obj;
                if (!id.equals(p.getId())) {
                    throw new IllegalArgumentException("Property id mismatch: '" + id + "' != '" + p.getId() + "'!");
                }
                Object object2 = object = p.getDefinition().getCardinality() == Cardinality.SINGLE ? p.getFirstValue() : p.getValues();
            }
            if ((definition = (PropertyDefinition)type.getPropertyDefinitions().get(id)) == null) {
                throw new IllegalArgumentException("Property +'" + id + "' is not valid for this type!");
            }
            if (updatabilityFilter != null && !updatabilityFilter.contains(definition.getUpdatability())) continue;
            if (var9_9 == null) {
                values = null;
            } else if (var9_9 instanceof List) {
                if (definition.getCardinality() != Cardinality.MULTI) {
                    throw new IllegalArgumentException("Property '" + id + "' is not a multi value property!");
                }
                values = (List)var9_9;
                Class<?> valueClazz = null;
                for (void o : values) {
                    if (o == null) {
                        throw new IllegalArgumentException("Property '" + id + "' contains null values!");
                    }
                    if (valueClazz == null) {
                        valueClazz = o.getClass();
                        continue;
                    }
                    if (valueClazz.isInstance(o)) continue;
                    throw new IllegalArgumentException("Property '" + id + "' is inhomogeneous!");
                }
            } else {
                if (definition.getCardinality() != Cardinality.SINGLE) {
                    throw new IllegalArgumentException("Property '" + id + "' is not a single value property!");
                }
                values = Collections.singletonList(var9_9);
            }
            PropertyString propertyData = null;
            Object object = firstValue = values == null || values.isEmpty() ? null : values.get(0);
            if (definition instanceof PropertyStringDefinition) {
                if (firstValue == null) {
                    propertyData = bof.createPropertyStringData(id, (List)null);
                } else {
                    if (!(firstValue instanceof String)) throw new IllegalArgumentException("Property '" + id + "' is a String property!");
                    propertyData = bof.createPropertyStringData(id, values);
                }
            } else if (definition instanceof PropertyIdDefinition) {
                if (firstValue == null) {
                    propertyData = bof.createPropertyIdData(id, (List)null);
                } else {
                    if (!(firstValue instanceof String)) throw new IllegalArgumentException("Property '" + id + "' is an Id property!");
                    propertyData = bof.createPropertyIdData(id, values);
                }
            } else if (definition instanceof PropertyHtmlDefinition) {
                if (firstValue == null) {
                    propertyData = bof.createPropertyHtmlData(id, values);
                } else {
                    if (!(firstValue instanceof String)) throw new IllegalArgumentException("Property '" + id + "' is a HTML property!");
                    propertyData = bof.createPropertyHtmlData(id, values);
                }
            } else if (definition instanceof PropertyUriDefinition) {
                if (firstValue == null) {
                    propertyData = bof.createPropertyUriData(id, (List)null);
                } else {
                    if (!(firstValue instanceof String)) throw new IllegalArgumentException("Property '" + id + "' is an URI property!");
                    propertyData = bof.createPropertyUriData(id, values);
                }
            } else if (definition instanceof PropertyIntegerDefinition) {
                if (firstValue == null) {
                    propertyData = bof.createPropertyIntegerData(id, (List)null);
                } else if (firstValue instanceof BigInteger) {
                    propertyData = bof.createPropertyIntegerData(id, values);
                } else {
                    if (!(firstValue instanceof Byte) && !(firstValue instanceof Short) && !(firstValue instanceof Integer) && !(firstValue instanceof Long)) throw new IllegalArgumentException("Property '" + id + "' is an Integer property!");
                    ArrayList<BigInteger> list = new ArrayList<BigInteger>(values.size());
                    for (void v : values) {
                        list.add(BigInteger.valueOf(((Number)v).longValue()));
                    }
                    propertyData = bof.createPropertyIntegerData(id, list);
                }
            } else if (definition instanceof PropertyBooleanDefinition) {
                if (firstValue == null) {
                    propertyData = bof.createPropertyBooleanData(id, (List)null);
                } else {
                    if (!(firstValue instanceof Boolean)) throw new IllegalArgumentException("Property '" + id + "' is a Boolean property!");
                    propertyData = bof.createPropertyBooleanData(id, values);
                }
            } else if (definition instanceof PropertyDecimalDefinition) {
                if (firstValue == null) {
                    propertyData = bof.createPropertyDecimalData(id, (List)null);
                } else {
                    if (!(firstValue instanceof BigDecimal)) throw new IllegalArgumentException("Property '" + id + "' is a Decimal property!");
                    propertyData = bof.createPropertyDecimalData(id, values);
                }
            } else if (definition instanceof PropertyDateTimeDefinition) {
                if (firstValue == null) {
                    propertyData = bof.createPropertyDateTimeData(id, (List)null);
                } else {
                    if (!(firstValue instanceof GregorianCalendar)) throw new IllegalArgumentException("Property '" + id + "' is a Decimal property!");
                    propertyData = bof.createPropertyDateTimeData(id, values);
                }
            }
            if (propertyData == null) {
                throw new IllegalArgumentException("Property '" + id + "' doesn't match the property defintion!");
            }
            propertyList.add(propertyData);
        }
        return bof.createPropertiesData(propertyList);
    }

    public List<PropertyData<?>> convertQueryProperties(Properties properties) {
        if (properties == null || properties.getProperties() == null) {
            throw new IllegalArgumentException("Properties must be set!");
        }
        return new ArrayList(properties.getPropertyList());
    }

    public CmisObject convertObject(ObjectData objectData, OperationContext context) {
        if (objectData == null) {
            throw new IllegalArgumentException("Object data is null!");
        }
        ObjectType type = this.getTypeFromObjectData(objectData);
        switch (objectData.getBaseTypeId()) {
            case CMIS_DOCUMENT: {
                return new PersistentDocumentImpl(this.session, type, objectData, context);
            }
            case CMIS_FOLDER: {
                return new PersistentFolderImpl(this.session, type, objectData, context);
            }
            case CMIS_POLICY: {
                return new PersistentPolicyImpl(this.session, type, objectData, context);
            }
            case CMIS_RELATIONSHIP: {
                return new PersistentRelationshipImpl(this.session, type, objectData, context);
            }
        }
        throw new CmisRuntimeException("unsupported type: " + objectData.getBaseTypeId());
    }

    public QueryResult convertQueryResult(ObjectData objectData) {
        if (objectData == null) {
            throw new IllegalArgumentException("Object data is null!");
        }
        return new QueryResultImpl(this.session, objectData);
    }

    public ChangeEvent convertChangeEvent(ObjectData objectData) {
        ChangeType changeType = null;
        GregorianCalendar changeTime = null;
        String objectId = null;
        HashMap properties = null;
        List policyIds = null;
        Acl acl = null;
        if (objectData.getChangeEventInfo() != null) {
            changeType = objectData.getChangeEventInfo().getChangeType();
            changeTime = objectData.getChangeEventInfo().getChangeTime();
        }
        if (objectData.getProperties() != null && objectData.getProperties().getPropertyList() != null) {
            List objectIdList;
            properties = new HashMap();
            for (PropertyData property : objectData.getProperties().getPropertyList()) {
                properties.put(property.getId(), property.getValues());
            }
            if (properties.containsKey("cmis:objectId") && (objectIdList = (List)properties.get("cmis:objectId")) != null && !objectIdList.isEmpty()) {
                objectId = objectIdList.get(0).toString();
            }
            if (objectData.getPolicyIds() != null && objectData.getPolicyIds().getPolicyIds() != null) {
                policyIds = objectData.getPolicyIds().getPolicyIds();
            }
            if (objectData.getAcl() != null) {
                acl = objectData.getAcl();
            }
        }
        return new ChangeEventImpl(changeType, changeTime, objectId, properties, policyIds, acl);
    }

    public ChangeEvents convertChangeEvents(String changeLogToken, ObjectList objectList) {
        if (objectList == null) {
            return null;
        }
        ArrayList<ChangeEvent> events = new ArrayList<ChangeEvent>();
        if (objectList.getObjects() != null) {
            for (ObjectData objectData : objectList.getObjects()) {
                if (objectData == null) continue;
                events.add(this.convertChangeEvent(objectData));
            }
        }
        boolean hasMoreItems = objectList.hasMoreItems() == null ? false : objectList.hasMoreItems();
        long totalNumItems = objectList.getNumItems() == null ? -1L : objectList.getNumItems().longValue();
        return new ChangeEventsImpl(changeLogToken, events, hasMoreItems, totalNumItems);
    }
}

