/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.operation;

import java.io.Serializable;

public class Status
implements Serializable {
    private static final long serialVersionUID = 8300750665351096031L;
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int CANCEL = 3;
    public static final Status STATUS_OK = new Status(0, "Ok");
    protected final int severity;
    private final Serializable details;

    public Status(int severity) {
        this.severity = severity;
        this.details = null;
    }

    public Status(int severity, String message) {
        this.severity = severity;
        this.details = message;
    }

    public Status(int severity, Throwable exception) {
        this.severity = severity;
        this.details = exception;
    }

    public int getSeverity() {
        return this.severity;
    }

    public Serializable getDetails() {
        return this.details;
    }

    public boolean isOk() {
        return this.severity == 0;
    }

    public boolean isError() {
        return this.severity == 2;
    }

    public boolean isCancel() {
        return this.severity == 3;
    }

    public boolean isWarning() {
        return this.severity == 1;
    }

    public String getMessage() {
        if (this.details == null) {
            return null;
        }
        return this.details.getClass() == String.class ? (String)((Object)this.details) : ((Throwable)this.details).getMessage();
    }

    public Throwable getException() {
        if (this.details instanceof Throwable) {
            return (Throwable)this.details;
        }
        return null;
    }

    public boolean isMultiStatus() {
        return false;
    }
}

