/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository.cache;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.DirtyUpdateInvokeBridge;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryExceptionHandler;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.api.repository.RepositoryInstanceHandler;
import org.nuxeo.ecm.core.api.repository.cache.CachingDocumentList;
import org.nuxeo.ecm.core.api.repository.cache.DirtyUpdateChecker;
import org.nuxeo.ecm.core.api.repository.cache.DocumentModelCache;
import org.nuxeo.ecm.core.api.repository.cache.DocumentModelCacheListener;
import org.nuxeo.ecm.core.api.repository.cache.SimpleDocumentModelIterator;

public class CachingRepositoryInstanceHandler
extends RepositoryInstanceHandler
implements DocumentModelCache {
    public static final Log log = LogFactory.getLog(CachingRepositoryInstanceHandler.class);
    protected Principal principal;
    protected String sessionId;
    protected final Map<String, DocumentModel> cache = new ReferenceMap(0, 1);
    protected final Map<String, String> path2Ids = new DualHashBidiMap();
    protected final Map<String, List<DocumentRef>> childrenCache = new HashMap<String, List<DocumentRef>>();
    protected final List<DocumentModelCacheListener> listeners = new CopyOnWriteArrayList<DocumentModelCacheListener>();
    protected Object dirtyUpdateTag;

    public CachingRepositoryInstanceHandler(Repository repository) {
        super(repository);
    }

    public CachingRepositoryInstanceHandler(Repository repository, RepositoryExceptionHandler exceptionHandler) {
        super(repository, exceptionHandler);
    }

    @Override
    public Class<?>[] getProxyInterfaces() {
        return new Class[]{RepositoryInstance.class, DocumentModelCache.class};
    }

    public Principal getPrincipal() throws Exception {
        if (this.principal == null) {
            this.principal = this.getSession().getPrincipal();
        }
        return this.principal;
    }

    public String getSessionId() throws Exception {
        if (this.sessionId == null) {
            this.sessionId = this.getSession().getSessionId();
        }
        return this.sessionId;
    }

    public String getRepositoryName() {
        return this.repository.getName();
    }

    @Override
    public synchronized DocumentModel cacheDocument(DocumentModel doc) {
        String id = doc.getId();
        if (id == null) {
            return doc;
        }
        if (this.cache.containsKey(id)) {
            return this.cache.get(id);
        }
        this.cache.put(id, doc);
        this.path2Ids.put(doc.getPathAsString(), id);
        this.childrenCache.remove(id);
        return doc;
    }

    @Override
    public synchronized DocumentModel uncacheDocument(DocumentRef ref) {
        if (ref.type() == 1) {
            String id = ((IdRef)ref).value;
            DocumentModel doc = this.cache.remove(id);
            if (doc != null) {
                this.path2Ids.remove(doc.getPathAsString());
            }
            return doc;
        }
        String path = ((PathRef)ref).value;
        String id = this.path2Ids.remove(path);
        if (id != null) {
            return this.cache.remove(id);
        }
        return null;
    }

    @Override
    public synchronized DocumentModel getCachedDocument(DocumentRef ref) {
        if (ref.type() == 1) {
            return this.cache.get(((IdRef)ref).value);
        }
        String id = this.path2Ids.get(((PathRef)ref).value);
        if (id == null) {
            return null;
        }
        if (!this.cache.containsKey(id)) {
            this.rehydrateCache(id);
        }
        return this.cache.get(id);
    }

    @Override
    public synchronized void flushDocumentCache() {
        while (this.path2Ids.isEmpty() && this.cache.isEmpty()) {
            this.path2Ids.clear();
            this.cache.clear();
        }
    }

    @Override
    public DocumentModel fetchDocument(DocumentRef ref) throws ClientException {
        DocumentModel doc = this.getCachedDocument(ref);
        if (doc != null) {
            doc.refresh(293, null);
            return doc;
        }
        return this.cacheDocument(this.session.getDocument(ref));
    }

    public synchronized DocumentModel getChild(DocumentRef parent, String name) throws ClientException {
        DocumentModel doc = this.getCachedDocument(parent);
        if (doc != null) {
            String path = doc.getPathAsString();
            String id = this.path2Ids.get(path = new StringBuffer(path.length() + 256).append(path).append("/").append(name).toString());
            if (id != null && (doc = this.cache.get(id)) != null) {
                return doc;
            }
        }
        return this.cacheDocument(this.session.getChild(parent, name));
    }

    public synchronized DocumentModel getRootDocument() throws ClientException {
        DocumentModel doc;
        String id = this.path2Ids.get("/");
        if (id != null && (doc = this.cache.get(id)) != null) {
            return doc;
        }
        return this.cacheDocument(this.session.getRootDocument());
    }

    public DocumentModel getDocument(DocumentRef ref) throws ClientException {
        DocumentModel doc = this.getCachedDocument(ref);
        return doc != null ? doc : this.cacheDocument(this.session.getDocument(ref));
    }

    public DocumentModel getParentDocument(DocumentRef ref) throws ClientException {
        DocumentModel doc = this.getCachedDocument(ref);
        if (doc != null) {
            return this.getDocument(doc.getParentRef());
        }
        return this.cacheDocument(this.session.getParentDocument(ref));
    }

    public DocumentModelList getChildren(DocumentRef parent) throws ClientException {
        String id = this.getDocumentId(parent);
        if (id != null) {
            DocumentModelList result = this.getCachedChildren(parent);
            return result != null ? result : this.fetchAndCacheChildren(parent);
        }
        return new DocumentModelListImpl();
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent) throws ClientException {
        return new SimpleDocumentModelIterator(this.getChildren(parent));
    }

    public DocumentModelList query(String query) throws ClientException {
        return new CachingDocumentList(this, this.session.query(query));
    }

    public DocumentModelList getFiles(DocumentRef parent) throws ClientException {
        DocumentModelList docs = this.getCachedChildrenWithoutFacet(parent, "Folderish");
        if (docs == null) {
            docs = this.filterWithoutFacet(this.fetchAndCacheChildren(parent), "Folderish");
        }
        return docs;
    }

    public DocumentModelList getFolders(DocumentRef parent) throws ClientException {
        DocumentModelList docs = this.getCachedChildrenWithFacet(parent, "Folderish");
        if (docs == null) {
            docs = this.filterByFacet(this.fetchAndCacheChildren(parent), "Folderish");
        }
        return docs;
    }

    public DocumentModelList getChildren(DocumentRef parent, String type) throws ClientException {
        DocumentModelList docs = this.getCachedChildrenWithType(parent, type);
        if (docs == null) {
            docs = this.filterByType(this.fetchAndCacheChildren(parent), type);
        }
        return docs;
    }

    public DocumentModel createDocument(DocumentModel doc) throws ClientException {
        return this.cacheDocument(this.session.createDocument(doc));
    }

    public DocumentModel[] createDocument(DocumentModel[] docs) throws ClientException {
        docs = this.session.createDocument(docs);
        for (int i = docs.length - 1; i >= 0; --i) {
            docs[i] = this.cacheDocument(docs[i]);
        }
        return docs;
    }

    public DocumentModel createDocumentModel(String type) throws ClientException {
        return this.cacheDocument(this.session.createDocumentModel(type));
    }

    public DocumentModel createDocumentModel(String type, Map<String, Object> options) throws ClientException {
        return this.cacheDocument(this.session.createDocumentModel(type, options));
    }

    public DocumentModel createDocumentModel(String parentPath, String id, String type) throws ClientException {
        return this.cacheDocument(this.session.createDocumentModel(parentPath, id, type));
    }

    public DocumentModel createProxy(DocumentRef parentRef, DocumentRef docRef, VersionModel version, boolean overwriteExistingProxy) throws ClientException {
        return this.cacheDocument(this.session.createProxy(parentRef, docRef, version, overwriteExistingProxy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocumentId(DocumentRef docRef) {
        String id = null;
        switch (docRef.type()) {
            case 1: {
                id = (String)docRef.reference();
                break;
            }
            case 2: {
                String path = (String)docRef.reference();
                CachingRepositoryInstanceHandler cachingRepositoryInstanceHandler = this;
                synchronized (cachingRepositoryInstanceHandler) {
                    id = this.path2Ids.get(path);
                    break;
                }
            }
        }
        if (id != null && !this.cache.containsKey(id)) {
            this.rehydrateCache(id);
        }
        return id;
    }

    protected void rehydrateCache(String id) {
        try {
            this.cacheDocument(this.session.getDocument(new IdRef(id)));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException("Cannot rehydrate cache for  " + id, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheChildren(DocumentRef parent, DocumentModelList children) {
        String id = this.getDocumentId(parent);
        if (id != null) {
            ArrayList<DocumentRef> cache = new ArrayList<DocumentRef>();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                DocumentModel child = (DocumentModel)children.get(i);
                child = this.cacheDocument(child);
                children.set(i, child);
                cache.add(child.getRef());
            }
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                this.childrenCache.put(id, cache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncacheChildren(DocumentRef parent) {
        String id = this.getDocumentId(parent);
        if (id != null) {
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                this.childrenCache.remove(id);
            }
        }
    }

    @Override
    public DocumentModelList fetchChildren(DocumentRef parent) throws Exception {
        return this.getSession().getChildren(parent);
    }

    public DocumentModelList filterByFacet(DocumentModelList docs, String facet) {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            if (!doc.hasFacet(facet)) continue;
            result.add(doc);
        }
        return result;
    }

    public DocumentModelList filterWithoutFacet(DocumentModelList docs, String facet) {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            if (doc.hasFacet(facet)) continue;
            result.add(doc);
        }
        return result;
    }

    public DocumentModelList filterByType(DocumentModelList docs, String type) {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            if (!type.equals(doc.getType())) continue;
            result.add(doc);
        }
        return result;
    }

    @Override
    public DocumentModelList fetchAndCacheChildren(DocumentRef parent) throws ClientException {
        try {
            DocumentModelList children = this.getSession().getChildren(parent);
            this.cacheChildren(parent, children);
            return children;
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Failed to get proxy session", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentModelList getCachedChildren(DocumentRef parent) throws ClientException {
        String id = this.getDocumentId(parent);
        if (id != null) {
            List<DocumentRef> children = null;
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                children = this.childrenCache.get(id);
            }
            if (children != null) {
                DocumentRef[] refs = children.toArray(new DocumentRef[children.size()]);
                DocumentModelListImpl result = new DocumentModelListImpl();
                for (DocumentRef ref : refs) {
                    result.add(this.getDocument(ref));
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList getCachedChildrenWithType(DocumentRef parent, String type) throws ClientException {
        String id = this.getDocumentId(parent);
        if (id != null) {
            List<DocumentRef> children = null;
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                children = this.childrenCache.get(id);
            }
            if (children != null) {
                DocumentRef[] refs = children.toArray(new DocumentRef[children.size()]);
                DocumentModelListImpl result = new DocumentModelListImpl();
                for (DocumentRef ref : refs) {
                    DocumentModel doc = this.getDocument(ref);
                    if (!type.equals(doc.getType())) continue;
                    result.add(doc);
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList getCachedChildrenWithFacet(DocumentRef parent, String facet) throws ClientException {
        String id = this.getDocumentId(parent);
        if (id != null) {
            List<DocumentRef> children = null;
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                children = this.childrenCache.get(id);
            }
            if (children != null) {
                DocumentRef[] refs = children.toArray(new DocumentRef[children.size()]);
                DocumentModelListImpl result = new DocumentModelListImpl();
                for (DocumentRef ref : refs) {
                    DocumentModel doc = this.getDocument(ref);
                    if (!doc.hasFacet(facet)) continue;
                    result.add(doc);
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList getCachedChildrenWithoutFacet(DocumentRef parent, String facet) throws ClientException {
        String id = this.getDocumentId(parent);
        if (id != null) {
            List<DocumentRef> children = null;
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                children = this.childrenCache.get(id);
            }
            if (children != null) {
                DocumentRef[] refs = children.toArray(new DocumentRef[children.size()]);
                DocumentModelListImpl result = new DocumentModelListImpl();
                for (DocumentRef ref : refs) {
                    DocumentModel doc = this.getDocument(ref);
                    if (doc.hasFacet(facet)) continue;
                    result.add(doc);
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheChild(DocumentRef parent, DocumentRef child) {
        String id = this.getDocumentId(parent);
        if (id != null) {
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                List<DocumentRef> list = this.childrenCache.get(id);
                if (list == null) {
                    list = new ArrayList<DocumentRef>();
                    this.childrenCache.put(id, list);
                }
                list.add(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncacheChild(DocumentRef parent, DocumentRef child) {
        String id = this.getDocumentId(parent);
        if (id != null) {
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                List<DocumentRef> list = this.childrenCache.get(id);
                if (list != null) {
                    list.remove(child);
                }
            }
        }
    }

    public void save() {
        log.warn((Object)"filtered save, session is remote and is auto committed");
    }

    @Override
    public void handleDirtyUpdateTag(Object tag) {
        this.dirtyUpdateTag = DirtyUpdateChecker.earliestTag(this.dirtyUpdateTag, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            DirtyUpdateInvokeBridge.putTagInThreadContext((Object)this.dirtyUpdateTag);
            Object object = super.invoke(proxy, method, args);
            return object;
        }
        finally {
            DirtyUpdateInvokeBridge.clearThreadContext();
        }
    }

    @Override
    public void addListener(DocumentModelCacheListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(DocumentModelCacheListener listener) {
        this.listeners.remove(listener);
    }
}

