/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.NoSuchElementException;

public class HTMLPanel
extends ComplexPanel {
    private static Element hiddenDiv;

    public static String createUniqueId() {
        return DOM.createUniqueId();
    }

    public HTMLPanel(String html) {
        this.setElement(DOM.createDiv());
        DOM.setInnerHTML(this.getElement(), html);
    }

    public void add(Widget widget, String id) {
        Element elem = this.getElementById(id);
        if (elem == null) {
            throw new NoSuchElementException(id);
        }
        super.add(widget, elem);
    }

    public void addAndReplaceElement(Widget widget, String id) {
        Element toReplace = this.getElementById(id);
        if (toReplace == null) {
            throw new NoSuchElementException(id);
        }
        widget.removeFromParent();
        this.getChildren().add(widget);
        toReplace.getParentNode().replaceChild(widget.getElement(), toReplace);
        this.adopt(widget);
    }

    public Element getElementById(String id) {
        return this.isAttached() ? DOM.getElementById(id) : this.attachToDomAndGetElement(id);
    }

    private Element attachToDomAndGetElement(String id) {
        if (hiddenDiv == null) {
            hiddenDiv = DOM.createDiv();
            UIObject.setVisible(hiddenDiv, false);
            DOM.appendChild(RootPanel.getBodyElement(), hiddenDiv);
        }
        Element origParent = DOM.getParent(this.getElement());
        Element origSibling = DOM.getNextSibling(this.getElement());
        DOM.appendChild(hiddenDiv, this.getElement());
        Element child = DOM.getElementById(id);
        if (origParent != null) {
            DOM.insertBefore(origParent, this.getElement(), origSibling);
        }
        return child;
    }
}

