/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.AbstractAnnotation;
import com.google.caja.ancillary.jsdoc.Annotation;
import com.google.caja.ancillary.jsdoc.AnnotationHandler;
import com.google.caja.ancillary.jsdoc.BlockAnnotation;
import com.google.caja.ancillary.jsdoc.InlineAnnotation;
import com.google.caja.ancillary.jsdoc.JsdocMessageType;
import com.google.caja.ancillary.jsdoc.JsdocRewriter;
import com.google.caja.ancillary.jsdoc.TextAnnotation;
import com.google.caja.ancillary.jsdoc.Updoc;
import com.google.caja.ancillary.jsdoc.UpdocParser;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.BooleanLiteral;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.NullLiteral;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Join;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationHandlers {
    private final Map<String, AnnotationHandler> handlers = new HashMap<String, AnnotationHandler>();
    private final MessageContext mc;
    private static final Expression OK = new NullLiteral(FilePosition.UNKNOWN);
    private static final Pattern QUALIFIED_NAME_PATTERN = Pattern.compile("(?<![\\p{Digit}])[_\\p{L}$][\\p{Alnum}$_]*(?:\\s*\\.\\s*[_\\p{L}$][\\p{Alnum}$_]*)*");
    private static final Set<String> SCHEMES = Sets.newHashSet("http", "https");
    private static final Pattern IDENTIFIER = Pattern.compile("^[\\p{L}_$]\\w*$");
    private static final Pattern COMMENT_TOKEN = Pattern.compile("^\\s*([/\\w\\.\\-#@?&:]+(?=\\s|$)|\\{[^}]*\\})\\s*");
    private static final Set<String> BUILTIN_TYPE_IDENT = new HashSet<String>(Arrays.asList("boolean", "number", "object", "string", "undefined"));
    private static final String NAME = "[^\\s<>()@][^<>()@]*[^\\s<>()@]+";
    private static final String EMAIL = "[\\w.-]+@(?:\\w+(?:\\.\\w+)*)";
    private static final Pattern EMAIL_OR_NAME = Pattern.compile("^\\s*(?:(?:([^\\s<>()@][^<>()@]*[^\\s<>()@]+)\\s*)?(?:[<(]\\s*([\\w.-]+@(?:\\w+(?:\\.\\w+)*))\\s*[)>])?|([\\w.-]+@(?:\\w+(?:\\.\\w+)*))(?:\\s*\\(\\s*([^\\s<>()@][^<>()@]*[^\\s<>()@]+)\\s*\\))?)\\s*$");

    public AnnotationHandlers(MessageContext mc) {
        this.register("author", this.procedure(this.requireBlock(), this.oneOf(this.htmlLink("mailto", "http", "https"), this.person())));
        this.register("code", this.procedure(AnnotationHandlers.requireInline(), this.htmlElement(this.concat(), "code", "class=\"prettyprint\"", "${0}")));
        this.register("constructor", this.booleanHandler());
        this.register("deprecated", this.booleanHandler());
        this.register("define", this.unimplemented());
        this.register("desc", this.unimplemented());
        this.register("enum", this.procedure(this.requireBlock(), this.split(Pair.pair("type", this.type()))));
        this.register("extends", this.procedure(this.requireBlock(), this.globalName()));
        this.register("fileoverview", this.procedure(this.requireBlock(), this.concat()));
        this.register("final", this.booleanHandler());
        this.register("hidden", this.unimplemented());
        this.register("inheritDoc", this.unimplemented());
        this.register("link", this.procedure(AnnotationHandlers.requireInline(), this.htmlElement(this.oneOf(this.tee(this.docLink(), this.concat()), this.list(this.docLink(), this.concat())), "a", "href=\"${0}\"", "${1}")));
        this.register("namespace", this.booleanHandler());
        this.register("notypecheck", this.booleanHandler());
        this.register("override", this.booleanHandler());
        this.register("overrides", this.series(this.docLink()));
        this.register("param", this.procedure(this.requireBlock(), this.oneOf(this.split(Pair.pair("type", this.type()), Pair.pair("name", this.requireParamName(this.identifier())), Pair.pair("summary", this.concat())), this.split(Pair.pair("name", this.requireParamName(this.identifier())), Pair.pair("summary", this.concat())))));
        this.register("provides", this.series(this.docLink()));
        this.register("requires", this.series(this.docLink()));
        this.register("return", this.procedure(this.requireBlock(), this.oneOf(this.split(Pair.pair("type", this.type()), Pair.pair("summary", this.concat())), this.split(Pair.pair("summary", this.concat())))));
        this.register("private", this.booleanHandler());
        this.register("protected", this.booleanHandler());
        this.register("public", this.booleanHandler());
        this.register("see", this.procedure(this.requireBlock(), this.oneOf(this.split(Pair.pair("url", this.docLink())), this.htmlLink("http", "https", "mailto"))));
        this.register("this", this.procedure(this.requireBlock(), this.type()));
        this.register("throws", this.procedure(this.requireBlock(), this.oneOf(this.split(Pair.pair("type", this.type()), Pair.pair("summary", this.concat())), this.split(Pair.pair("summary", this.concat())))));
        this.register("type", this.procedure(this.requireBlock(), this.type()));
        this.register("updoc", this.procedure(AnnotationHandlers.requireInline(), this.updoc()));
        this.register("::description", this.procedure(this.requireBlock(), this.concat()));
        this.mc = mc;
    }

    public AnnotationHandlers register(String name, AnnotationHandler handler) {
        if (handler == null || name == null || this.handlers.containsKey(name)) {
            throw new IllegalArgumentException(name);
        }
        this.handlers.put(name, handler);
        return this;
    }

    public AnnotationHandler handlerFor(Annotation a) {
        return this.delayCalls(this.rawHandlerFor(a));
    }

    private AnnotationHandler rawHandlerFor(Annotation a) {
        if (a instanceof TextAnnotation) {
            return new TextAnnotationHandler();
        }
        AnnotationHandler h = this.handlers.get(a.getValue());
        return h != null ? h : new UnrecognizedAnnotationHandler();
    }

    private static String closestMatch(String target, Set<String> candidates) {
        int longestPrefix = 0;
        String best = null;
        for (String candidate : candidates) {
            int i;
            if (candidate.length() <= longestPrefix) continue;
            int n = Math.min(target.length(), candidate.length());
            for (i = 0; i < n && target.charAt(i) == candidate.charAt(i); ++i) {
            }
            if (i <= longestPrefix) continue;
            longestPrefix = i;
            best = candidate;
        }
        return best;
    }

    private AnnotationHandler booleanHandler() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                if (a instanceof InlineAnnotation) {
                    mq.addMessage((MessageTypeInt)JsdocMessageType.ANNOTATION_OUT_OF_PLACE, a.getFilePosition(), AnnotationHandlers.toMessagePart(a));
                    return null;
                }
                for (Annotation annotation : a.children()) {
                    if (annotation instanceof TextAnnotation && "".equals(annotation.getValue().trim())) continue;
                    mq.addMessage((MessageTypeInt)JsdocMessageType.UNEXPECTED_CONTENT, a.getFilePosition(), AnnotationHandlers.toMessagePart(a));
                    return null;
                }
                return new BooleanLiteral(a.getFilePosition(), true);
            }
        };
    }

    private AnnotationHandler concat() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                List exprs = AnnotationHandlers.this.applyChildren(a, mq);
                if (exprs == null) {
                    return null;
                }
                if (exprs.isEmpty()) {
                    mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_DOCUMENTATION_TEXT, a.getFilePosition(), AnnotationHandlers.toMessagePart(a));
                    return null;
                }
                Expression e = null;
                for (Expression e2 : exprs) {
                    e = AnnotationHandlers.concatenate(e, e2);
                }
                return e;
            }
        };
    }

    private AnnotationHandler delayCalls(final AnnotationHandler handler) {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                Expression e = handler.handle(a, mq);
                if (e == null) {
                    return null;
                }
                if (this.hasCall(e)) {
                    return (Expression)QuasiBuilder.substV("(function (docRoot, apiElementName) {  var apiElement = this;  return @e;})", "e", e);
                }
                return e;
            }

            private boolean hasCall(Expression e) {
                if (e instanceof FunctionConstructor) {
                    return false;
                }
                if (Operation.is((ParseTreeNode)e, Operator.FUNCTION_CALL)) {
                    return true;
                }
                for (ParseTreeNode parseTreeNode : e.children()) {
                    if (parseTreeNode instanceof Expression && this.hasCall((Expression)parseTreeNode)) {
                        return true;
                    }
                    if (!(parseTreeNode instanceof ObjProperty) || !this.hasCall(((ObjProperty)parseTreeNode).children().get(1))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private AnnotationHandler docLink() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                URI uri;
                Expression target;
                String value = AnnotationHandlers.this.contentAsString(a, mq);
                if (value == null) {
                    return null;
                }
                value = value.trim();
                if (QUALIFIED_NAME_PATTERN.matcher(value).matches() && (target = AnnotationHandlers.this.toIdentifierChain(value, a.getFilePosition(), mq)) != null) {
                    return (Expression)QuasiBuilder.substV("jsdoc___.linkTo(    apiElement, apiElementName, @target, @name, @pos?)", "target", target, "name", AnnotationHandlers.stringFrom(a, value), "pos", AnnotationHandlers.stringFrom(a, AnnotationHandlers.this.format(a.getFilePosition())));
                }
                if ((value.indexOf(47) >= 0 || value.indexOf(58) > 0 || value.indexOf(35) >= 0 || value.endsWith(".js")) && (uri = AnnotationHandlers.this.parseDocUri(value, SCHEMES, a.getFilePosition(), mq)) != null) {
                    return AnnotationHandlers.stringFrom(a, uri.toString());
                }
                mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_URL_OR_REFERENCE, a.getFilePosition(), AnnotationHandlers.toMessagePart(a));
                return null;
            }
        };
    }

    private AnnotationHandler globalName() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                Expression e;
                String value = AnnotationHandlers.this.contentAsString(a, mq);
                if (value == null) {
                    return null;
                }
                if ((value = value.trim()).startsWith("{") && value.endsWith("}")) {
                    value = value.substring(1, value.length() - 1).trim();
                }
                if ((e = AnnotationHandlers.this.toIdentifierChain(value, a.getFilePosition(), mq)) == null) {
                    return null;
                }
                return (Expression)QuasiBuilder.substV("jsdoc___.nameOf(@e)", "e", e);
            }
        };
    }

    private AnnotationHandler htmlElement(final AnnotationHandler bodyHandler, String tagName, String ... attribAndBody) {
        List<String> attribs = Arrays.asList(attribAndBody);
        attribs = attribs.subList(0, attribs.size() - 1);
        String body = attribAndBody[attribs.size()];
        final String tmpl = "<" + tagName + (attribs.size() == 0 ? "" : " " + Join.join((CharSequence)" ", attribs)) + ">" + body + "</" + tagName + ">";
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                int st;
                Expression e = bodyHandler.handle(a, mq);
                if (e == null) {
                    return null;
                }
                List<Expression> parts = e instanceof ArrayConstructor ? ((ArrayConstructor)e).children() : Collections.singletonList(e);
                Expression element = null;
                int done = 0;
                while ((st = tmpl.indexOf("${", done)) > 0) {
                    int et = tmpl.indexOf(125, st);
                    int index = Integer.parseInt(tmpl.substring(st + 2, et));
                    element = AnnotationHandlers.concatenate(element, AnnotationHandlers.stringFrom(a, tmpl.substring(done, st)));
                    Expression html = (Expression)QuasiBuilder.substV("jsdoc___.html(@e)", "e", parts.get(index));
                    element = AnnotationHandlers.concatenate(element, html);
                    done = et + 1;
                }
                return AnnotationHandlers.concatenate(element, AnnotationHandlers.stringFrom(a, tmpl.substring(done)));
            }
        };
    }

    private AnnotationHandler htmlLink(String ... schemes) {
        final HashSet<String> schemeSet = new HashSet<String>(Arrays.asList(schemes));
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                String content = AnnotationHandlers.this.contentAsString(a, mq);
                if (content == null) {
                    return null;
                }
                if (content.startsWith("<")) {
                    URI uri;
                    Attr href;
                    Element link;
                    FilePosition p = a.getFilePosition();
                    try {
                        CharProducer cp = CharProducer.Factory.create(new StringReader(content), p);
                        HtmlLexer lexer = new HtmlLexer(cp);
                        DomParser parser = new DomParser(lexer, false, p.source(), mq);
                        DocumentFragment f = parser.parseFragment();
                        parser.getTokenQueue().expectEmpty();
                        Node fFirst = f.getFirstChild();
                        link = fFirst == null || !(fFirst instanceof Element) || !"a".equals(fFirst.getNodeName()) ? null : (Element)fFirst;
                    }
                    catch (ParseException ex) {
                        ex.toMessageQueue(mq);
                        return null;
                    }
                    if (link != null && (href = link.getAttributeNodeNS("http://www.w3.org/1999/xhtml", "href")) != null && (uri = AnnotationHandlers.this.parseDocUri(href.getValue(), schemeSet, Nodes.getFilePositionForValue(href), mq)) != null) {
                        StringBuilder name = new StringBuilder();
                        Concatenator tc = new Concatenator(name, null);
                        RenderContext rc = new RenderContext(tc);
                        for (Node node : Nodes.childrenOf(link)) {
                            Nodes.render(node, rc);
                        }
                        tc.noMoreTokens();
                        return (Expression)QuasiBuilder.substV("({ 'name': @name, 'url': @url })", "name", AnnotationHandlers.stringFrom(a, name.toString()), "url", AnnotationHandlers.stringFrom(a, uri.toString()));
                    }
                }
                mq.addMessage((MessageTypeInt)JsdocMessageType.BAD_LINK, a.getFilePosition(), MessagePart.Factory.valueOf(content));
                return null;
            }
        };
    }

    private AnnotationHandler identifier() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                String value = AnnotationHandlers.this.contentAsString(a, mq);
                if (value == null) {
                    return null;
                }
                if (!IDENTIFIER.matcher(value).matches()) {
                    mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_IDENTIFIER, a.getFilePosition(), AnnotationHandlers.toMessagePart(a));
                    return null;
                }
                return AnnotationHandlers.stringFrom(a, value);
            }
        };
    }

    private AnnotationHandler list(final AnnotationHandler ... itemHandlers) {
        assert (itemHandlers.length > 0);
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                Expression item;
                AbstractAnnotation tail;
                if (!(a.children().get(0) instanceof TextAnnotation)) {
                    mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_DOCUMENTATION_TEXT, a.getFilePosition(), AnnotationHandlers.toMessagePart(a));
                    return null;
                }
                TextAnnotation first = (TextAnnotation)a.children().get(0);
                String value = first.getValue();
                int last = itemHandlers.length - 1;
                List<Expression> items = Lists.newArrayList();
                int consumed = 0;
                for (int i = 0; i < last; ++i) {
                    Matcher m = COMMENT_TOKEN.matcher(value.substring(consumed));
                    if (!m.find()) {
                        tail = first.slice(consumed, value.length());
                        mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_DOCUMENTATION_TEXT, tail.getFilePosition(), MessagePart.Factory.valueOf('\"' + tail.getValue() + '\"'));
                        return null;
                    }
                    TextAnnotation tok = first.slice(consumed + m.start(1), consumed + m.end(1));
                    item = itemHandlers[i].handle(tok, mq);
                    if (item == null) {
                        return null;
                    }
                    items.add(item);
                    consumed += m.end();
                }
                List<? extends Annotation> children = a.children();
                TextAnnotation unusedText = first.slice(consumed, value.length());
                if (a instanceof BlockAnnotation) {
                    List<? extends Annotation> newChildren = Lists.newArrayList();
                    newChildren.add(unusedText);
                    newChildren.addAll(children.subList(1, children.size()));
                    tail = new BlockAnnotation(a.getValue(), newChildren, FilePosition.span(unusedText.getFilePosition(), a.getFilePosition()));
                } else {
                    tail = new InlineAnnotation(a.getValue(), unusedText, unusedText.getFilePosition());
                }
                item = itemHandlers[last].handle(tail, mq);
                if (item == null) {
                    return null;
                }
                items.add(item);
                return new ArrayConstructor(a.getFilePosition(), items);
            }
        };
    }

    private AnnotationHandler oneOf(final AnnotationHandler ... options) {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                int mqCount = mq.getMessages().size();
                for (AnnotationHandler option : options) {
                    mq.getMessages().subList(mqCount, mq.getMessages().size()).clear();
                    Expression e = option.handle(a, mq);
                    if (e == null) continue;
                    return e;
                }
                return null;
            }
        };
    }

    private AnnotationHandler procedure(final AnnotationHandler ... handlers) {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                Expression e = null;
                for (AnnotationHandler handler : handlers) {
                    e = handler.handle(a, mq);
                    if (e != null) continue;
                    return null;
                }
                return e;
            }
        };
    }

    private AnnotationHandler requireBlock() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                if (a instanceof BlockAnnotation) {
                    return OK;
                }
                mq.addMessage((MessageTypeInt)JsdocMessageType.ANNOTATION_OUT_OF_PLACE, a.getFilePosition(), AnnotationHandlers.toMessagePart(a));
                return null;
            }
        };
    }

    private static AnnotationHandler requireInline() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                if (a instanceof InlineAnnotation) {
                    return OK;
                }
                mq.addMessage((MessageTypeInt)JsdocMessageType.ANNOTATION_OUT_OF_PLACE, a.getFilePosition(), AnnotationHandlers.toMessagePart(a));
                return null;
            }
        };
    }

    private AnnotationHandler requireParamName(final AnnotationHandler name) {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                Expression e = name.handle(a, mq);
                if (e == null) {
                    return null;
                }
                return (Expression)QuasiBuilder.substV("jsdoc___.requireParam(    apiElement, apiElementName,     jsdoc___.resolvePromise(        @name, docRoot, apiElementName, apiElement))", "name", e);
            }
        };
    }

    private AnnotationHandler series(final AnnotationHandler ah) {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                String value = AnnotationHandlers.this.contentAsString(a, mq);
                if (value == null) {
                    return null;
                }
                List<Expression> elements = Lists.newArrayList();
                boolean nullPart = false;
                for (String part : value.split("[\\s,]+")) {
                    Expression e = ah.handle(new TextAnnotation(part, a.getFilePosition()), mq);
                    if (e != null) {
                        elements.add(e);
                        continue;
                    }
                    nullPart = true;
                }
                if (nullPart) {
                    return null;
                }
                return (Expression)QuasiBuilder.substV("@arr.join(' ')", "arr", new ArrayConstructor(a.getFilePosition(), elements));
            }
        };
    }

    private AnnotationHandler updoc() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                String value = AnnotationHandlers.this.contentAsString(a, mq);
                if (value == null) {
                    return null;
                }
                try {
                    Updoc updoc = new UpdocParser(mq).parseComplete(CharProducer.Factory.create(new StringReader(value), a.getFilePosition()));
                    List<ObjectConstructor> runs = Lists.newArrayList();
                    for (Updoc.Run run : updoc.getRuns()) {
                        runs.add((ObjectConstructor)QuasiBuilder.substV("({ doc:    @runSource,   input:  function () { return @input; },   result: function () { return @result; },   pos:    @runPos })", "runSource", AnnotationHandlers.stringFrom(a, AnnotationHandlers.this.render(run, false)), "input", run.getInput(), "result", run.getResult(), "runPos", AnnotationHandlers.stringFrom(a, AnnotationHandlers.this.format(run.getFilePosition()))));
                    }
                    return (Expression)QuasiBuilder.substV("jsdoc___.updoc([@runs*])", "runs", new ParseTreeNodeContainer(runs));
                }
                catch (ParseException ex) {
                    ex.toMessageQueue(mq);
                    return null;
                }
            }
        };
    }

    private AnnotationHandler split(Pair<String, AnnotationHandler> a) {
        return this.split(Collections.singletonList(a));
    }

    private AnnotationHandler split(Pair<String, AnnotationHandler> a, Pair<String, AnnotationHandler> b) {
        List<Pair<String, AnnotationHandler>> pairs = Lists.newArrayList();
        pairs.add(a);
        pairs.add(b);
        return this.split(pairs);
    }

    private AnnotationHandler split(Pair<String, AnnotationHandler> a, Pair<String, AnnotationHandler> b, Pair<String, AnnotationHandler> c) {
        List<Pair<String, AnnotationHandler>> pairs = Lists.newArrayList();
        pairs.add(a);
        pairs.add(b);
        pairs.add(c);
        return this.split(pairs);
    }

    private AnnotationHandler split(List<Pair<String, AnnotationHandler>> entries) {
        final List<Pair<String, AnnotationHandler>> tokenEntries = entries.subList(0, entries.size() - 1);
        final Pair<String, AnnotationHandler> remainder = entries.get(entries.size() - 1);
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                List parts = AnnotationHandlers.this.applyChildren(a, mq);
                if (parts == null) {
                    return null;
                }
                if (parts.isEmpty() || !(parts.get(0) instanceof StringLiteral)) {
                    mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_DOCUMENTATION_TEXT, a.getFilePosition(), AnnotationHandlers.toMessagePart(a));
                    return null;
                }
                List<ValueProperty> mapEntries = Lists.newArrayList();
                StringLiteral sl = (StringLiteral)parts.get(0);
                FilePosition slpos = sl.getFilePosition();
                String s = sl.getUnquotedValue();
                int consumed = 0;
                for (Pair entry : tokenEntries) {
                    Matcher m = COMMENT_TOKEN.matcher(s.substring(consumed));
                    if (!m.find()) {
                        return null;
                    }
                    Expression value = ((AnnotationHandler)entry.b).handle(TextAnnotation.slice(s, slpos, consumed + m.start(1), consumed + m.end(1)), mq);
                    if (value == null) {
                        return null;
                    }
                    mapEntries.add(new ValueProperty(AnnotationHandlers.stringFrom(a, (CharSequence)entry.a), value));
                    consumed += m.end();
                }
                List<? extends Annotation> tailMembers = Lists.newArrayList(a.children());
                tailMembers.set(0, TextAnnotation.slice(s, slpos, consumed, s.length()));
                BlockAnnotation block = new BlockAnnotation(a.getValue(), tailMembers, FilePosition.span(tailMembers.get(0).getFilePosition(), a.getFilePosition()));
                Expression value = ((AnnotationHandler)remainder.b).handle(block, mq);
                if (value == null) {
                    return null;
                }
                mapEntries.add(new ValueProperty(AnnotationHandlers.stringFrom(a, (CharSequence)remainder.a), value));
                return new ObjectConstructor(a.getFilePosition(), mapEntries);
            }
        };
    }

    private AnnotationHandler tee(final AnnotationHandler ... handlers) {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                List<Expression> results = Lists.newArrayList();
                for (AnnotationHandler h : handlers) {
                    Expression e = h.handle(a, mq);
                    if (e == null) {
                        return null;
                    }
                    results.add(e);
                }
                return new ArrayConstructor(a.getFilePosition(), results);
            }
        };
    }

    private AnnotationHandler type() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                String s = AnnotationHandlers.this.contentAsString(a, mq);
                if (s != null && (s = s.trim()).startsWith("{") && s.endsWith("}")) {
                    String typeString = s.substring(1, s.length() - 1).trim();
                    List<Expression> symbolNames = Lists.newArrayList();
                    Matcher m = QUALIFIED_NAME_PATTERN.matcher(typeString);
                    while (m.find()) {
                        String ident = m.group(0);
                        if ("".equals(ident) || BUILTIN_TYPE_IDENT.contains(ident) || Keyword.isKeyword(ident)) continue;
                        Expression ref = AnnotationHandlers.this.toIdentifierChain(ident, a.getFilePosition(), mq);
                        if (ref == null) {
                            return null;
                        }
                        symbolNames.add((Expression)QuasiBuilder.substV("function () { return @ref; }", "ref", ref));
                        symbolNames.add(AnnotationHandlers.stringFrom(a, ident));
                    }
                    StringLiteral type = AnnotationHandlers.stringFrom(a, typeString);
                    if (symbolNames.isEmpty()) {
                        return type;
                    }
                    return (Expression)QuasiBuilder.substV("jsdoc___.requireTypeAtoms(@pos, [@symbols*]), @type", "pos", AnnotationHandlers.stringFrom(a, AnnotationHandlers.this.format(a.getFilePosition())), "symbols", new ParseTreeNodeContainer(symbolNames), "type", type);
                }
                mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_TYPE, a.getFilePosition(), MessagePart.Factory.valueOf(s != null ? s : "<null>"));
                return null;
            }
        };
    }

    private AnnotationHandler person() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                String value = AnnotationHandlers.this.contentAsString(a, mq);
                if (value == null) {
                    return null;
                }
                Matcher m = EMAIL_OR_NAME.matcher(value);
                if (m.matches()) {
                    String name = m.group(1);
                    String email = m.group(2);
                    if (email == null) {
                        email = m.group(3);
                    }
                    if (name == null) {
                        name = m.group(4);
                    }
                    URI uri = null;
                    if (email != null) {
                        uri = AnnotationHandlers.this.parseDocUri(email, Collections.singleton("mailto"), a.getFilePosition(), mq);
                        if (uri == null) {
                            return null;
                        }
                        if (!uri.isAbsolute()) {
                            mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_EMAIL_OR_NAME, a.getFilePosition(), MessagePart.Factory.valueOf(value));
                            return null;
                        }
                    }
                    if (name != null || uri != null) {
                        List<ValueProperty> entries = Lists.newArrayList();
                        if (name != null) {
                            entries.add(new ValueProperty(AnnotationHandlers.stringFrom(a, "name"), AnnotationHandlers.stringFrom(a, name)));
                        }
                        if (uri != null) {
                            entries.add(new ValueProperty(AnnotationHandlers.stringFrom(a, "url"), AnnotationHandlers.stringFrom(a, "" + uri)));
                        }
                        return new ObjectConstructor(a.getFilePosition(), entries);
                    }
                }
                mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_EMAIL_OR_NAME, a.getFilePosition(), MessagePart.Factory.valueOf(value));
                return null;
            }
        };
    }

    private AnnotationHandler unimplemented() {
        return new AnnotationHandler(){

            public Expression handle(Annotation a, MessageQueue mq) {
                return AnnotationHandlers.stringFrom(a, "");
            }
        };
    }

    private String contentAsString(Annotation a, MessageQueue mq) {
        if (a instanceof TextAnnotation) {
            return a.getValue();
        }
        StringBuilder sb = new StringBuilder();
        for (Annotation annotation : a.children()) {
            if (!(annotation instanceof TextAnnotation)) {
                mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_DOCUMENTATION_TEXT, annotation.getFilePosition(), AnnotationHandlers.toMessagePart(a));
                return null;
            }
            sb.append(annotation.getValue());
        }
        return sb.toString().trim();
    }

    private List<Expression> applyChildren(Annotation a, MessageQueue mq) {
        List<? extends Annotation> children = a.children();
        List<Expression> exprs = Lists.newArrayList();
        Expression last = null;
        for (Annotation annotation : children) {
            Expression e = this.rawHandlerFor(annotation).handle(annotation, mq);
            if (e == null) {
                return null;
            }
            if (e instanceof StringLiteral && last instanceof StringLiteral) {
                exprs.remove(exprs.size() - 1);
                last = AnnotationHandlers.stringFrom(a, ((StringLiteral)last).getUnquotedValue() + ((StringLiteral)e).getUnquotedValue());
            } else {
                last = e;
            }
            exprs.add(last);
        }
        return exprs;
    }

    private Expression toIdentifierChain(String s, FilePosition pos, MessageQueue mq) {
        String[] parts = s.split("\\s*\\.\\s*");
        Reference e = null;
        for (String part : parts) {
            if (!IDENTIFIER.matcher(part).matches() || Keyword.isKeyword(part) && !Keyword.THIS.toString().equals(part)) {
                mq.addMessage((MessageTypeInt)JsdocMessageType.EXPECTED_IDENTIFIER, pos, MessagePart.Factory.valueOf("'" + s + "'"));
                return null;
            }
            Reference r = new Reference(new Identifier(pos, part));
            e = e == null ? r : Operation.createInfix(Operator.MEMBER_ACCESS, e, r);
        }
        return e;
    }

    private static Expression concatenate(Expression a, Expression b) {
        if (a == null) {
            return b;
        }
        return Operation.createInfix(Operator.ADDITION, a, b);
    }

    private URI parseDocUri(String s, Set<String> schemes, FilePosition p, MessageQueue mq) {
        if (!"".equals(s)) {
            if (s.indexOf(64) >= 0 && s.indexOf(58) < 0 && s.indexOf(47) < 0 && s.indexOf(35) < 0 && schemes.contains("mailto")) {
                s = "mailto:" + s;
            }
            try {
                URI uri = new URI(s);
                if (!uri.isAbsolute()) {
                    return uri;
                }
                String scheme = uri.getScheme().toLowerCase(Locale.ENGLISH);
                if (schemes.contains(scheme)) {
                    return uri;
                }
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
        mq.addMessage((MessageTypeInt)JsdocMessageType.BAD_LINK, p, MessagePart.Factory.valueOf(s));
        return null;
    }

    private String format(FilePosition pos) {
        return JsdocRewriter.format(pos, this.mc);
    }

    private String render(ParseTreeNode n, boolean minimal) {
        StringBuilder sb = new StringBuilder();
        TokenConsumer tc = minimal ? new JsMinimalPrinter(new Concatenator(sb)) : n.makeRenderer(sb, null);
        RenderContext rc = new RenderContext(tc);
        n.render(rc);
        tc.noMoreTokens();
        return sb.toString();
    }

    private static MessagePart toMessagePart(Annotation a) {
        if (a instanceof TextAnnotation) {
            String value = a.getValue();
            if (value.length() > 40) {
                value = value.substring(0, 37) + "...";
            }
            return MessagePart.Factory.valueOf("'" + value + "'");
        }
        return MessagePart.Factory.valueOf("@" + a.getValue());
    }

    private static StringLiteral stringFrom(Annotation a, CharSequence s) {
        return StringLiteral.valueOf(a.getFilePosition(), s);
    }

    private class UnrecognizedAnnotationHandler
    implements AnnotationHandler {
        private UnrecognizedAnnotationHandler() {
        }

        public Expression handle(Annotation a, MessageQueue mq) {
            mq.addMessage((MessageTypeInt)JsdocMessageType.UNRECOGNIZED_ANNOTATION, a.getFilePosition(), MessagePart.Factory.valueOf(a.getValue()));
            String match = AnnotationHandlers.closestMatch(a.getValue(), AnnotationHandlers.this.handlers.keySet());
            if (match != null) {
                mq.addMessage((MessageTypeInt)JsdocMessageType.DID_YOU_MEAN, a.getFilePosition(), MessagePart.Factory.valueOf(match), MessagePart.Factory.valueOf(a.getValue()));
            }
            return null;
        }
    }

    private static class TextAnnotationHandler
    implements AnnotationHandler {
        private TextAnnotationHandler() {
        }

        public Expression handle(Annotation a, MessageQueue mq) {
            return AnnotationHandlers.stringFrom(a, a.getValue());
        }
    }
}

