/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.BooleanLiteral;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.CaseStmt;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Conditional;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.DefaultCaseStmt;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FinallyStmt;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.LabeledStmtWrapper;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.OperatorCategory;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.SwitchCase;
import com.google.caja.parser.js.SwitchStmt;
import com.google.caja.parser.js.ThrowStmt;
import com.google.caja.parser.js.TryStmt;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.SafeIdentifierMaker;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementSimplifier {
    private final MessageQueue mq;
    private final Map<String, StmtLabel> labels = Maps.newHashMap();
    private String blankLabel = "";
    private final SafeIdentifierMaker labelGenerator = new SafeIdentifierMaker();

    public static ParseTreeNode optimize(ParseTreeNode n, MessageQueue mq) {
        return new StatementSimplifier(mq).optimize(n, false);
    }

    private StatementSimplifier(MessageQueue mq) {
        this.mq = mq;
    }

    private ParseTreeNode optimize(ParseTreeNode n, boolean needsBlock) {
        String lbl;
        if (n instanceof LabeledStatement) {
            LabeledStatement ls = (LabeledStatement)n;
            String label = ls.getLabel();
            if (label != null && !"".equals(label)) {
                StmtLabel oldSl = this.labels.get(label);
                String oldBlankLabel = this.blankLabel;
                StmtLabel sl = new StmtLabel(this.labelGenerator.next());
                this.labels.put(label, sl);
                this.blankLabel = label;
                boolean wrap = ls instanceof LabeledStmtWrapper;
                LabeledStatement unlabeled = wrap ? ((LabeledStmtWrapper)ls).getBody() : ls;
                Statement opt = (Statement)this.optimizeUnlabeled(unlabeled, needsBlock);
                if (oldSl == null) {
                    this.labels.remove(label);
                } else {
                    this.labels.put(label, oldSl);
                }
                this.blankLabel = oldBlankLabel;
                if (sl.nUses == 0) {
                    if (!wrap && opt instanceof LabeledStatement && !"".equals(((LabeledStatement)opt).getLabel())) {
                        return ParseTreeNodes.newNodeInstance(opt.getClass(), opt.getFilePosition(), "", opt.children());
                    }
                } else {
                    if (!wrap && opt instanceof LabeledStatement) {
                        return ParseTreeNodes.newNodeInstance(opt.getClass(), opt.getFilePosition(), sl.newName, opt.children());
                    }
                    if (opt instanceof LabeledStatement) {
                        opt = new Block(opt.getFilePosition(), Arrays.asList(opt));
                    }
                    return new LabeledStmtWrapper(n.getFilePosition(), sl.newName, opt);
                }
                return opt;
            }
            String oldBlankLabel = this.blankLabel;
            this.blankLabel = "";
            Statement opt = (Statement)this.optimizeUnlabeled(n, needsBlock);
            this.blankLabel = oldBlankLabel;
            return opt;
        }
        if ((n instanceof BreakStmt || n instanceof ContinueStmt) && (lbl = (String)n.getValue()) != null && !"".equals(lbl)) {
            String newName;
            if (this.blankLabel.equals(lbl)) {
                newName = "";
            } else {
                StmtLabel renamed = this.labels.get(lbl);
                if (renamed != null) {
                    newName = renamed.newName;
                    ++renamed.nUses;
                } else {
                    newName = "";
                    this.mq.addMessage((MessageTypeInt)MessageType.UNDEFINED_SYMBOL, MessageLevel.ERROR, n.getFilePosition(), MessagePart.Factory.valueOf(lbl));
                }
            }
            return ParseTreeNodes.newNodeInstance(n.getClass(), n.getFilePosition(), newName, n.children());
        }
        return this.optimizeUnlabeled(n, needsBlock);
    }

    private ParseTreeNode optimizeUnlabeled(ParseTreeNode n, boolean needsBlock) {
        List<? extends ParseTreeNode> outChildren;
        if (n instanceof Block) {
            List<Statement> newChildren;
            List<? extends Statement> children = ((Block)n).children();
            int nChildren = children.size();
            List<Statement> flattened = this.flattenBlocksAndIgnoreNoops(children);
            List<Statement> joined = this.joinAdjacentExprs(flattened == null ? Lists.newArrayList(children) : flattened);
            List<Statement> list = newChildren = joined != null ? joined : flattened;
            if (newChildren != null) {
                nChildren = newChildren.size();
            }
            if (!needsBlock) {
                switch (nChildren) {
                    case 0: {
                        return new Noop(n.getFilePosition());
                    }
                    case 1: {
                        return (newChildren == null ? children : newChildren).get(0);
                    }
                }
            }
            return newChildren != null ? new Block(n.getFilePosition(), newChildren) : n;
        }
        if (n instanceof SwitchStmt) {
            return this.optimizeSwitch((SwitchStmt)n);
        }
        if (n instanceof ReturnStmt) {
            Expression optReturnValue;
            ReturnStmt rs = (ReturnStmt)n;
            Expression returnValue = rs.getReturnValue();
            Expression expression = optReturnValue = returnValue != null ? (Expression)this.optimize(returnValue, false) : null;
            if (optReturnValue != null && returnValue != null && "undefined".equals(returnValue.typeOf()) && optReturnValue.simplifyForSideEffect() == null) {
                return new ReturnStmt(rs.getFilePosition(), null);
            }
            if (optReturnValue != returnValue) {
                return new ReturnStmt(rs.getFilePosition(), optReturnValue);
            }
            return rs;
        }
        List<? extends ParseTreeNode> children = n.children();
        int nChildren = children.size();
        List<ParseTreeNode> newChildren = null;
        boolean childNeedsBlock = n instanceof FunctionConstructor || n instanceof TryStmt || n instanceof CatchStmt || n instanceof FinallyStmt || n instanceof SwitchCase;
        for (int i = 0; i < nChildren; ++i) {
            ParseTreeNode newChild;
            ParseTreeNode child = children.get(i);
            if (child == (newChild = this.optimize(child, childNeedsBlock))) continue;
            if (newChildren == null) {
                newChildren = Lists.newArrayList(nChildren);
            }
            newChildren.addAll(children.subList(newChildren.size(), i));
            newChildren.add(newChild);
        }
        if (newChildren != null) {
            newChildren.addAll(children.subList(newChildren.size(), nChildren));
        }
        List<? extends ParseTreeNode> list = outChildren = newChildren == null ? children : newChildren;
        if (n instanceof ExpressionStmt) {
            Expression e = (Expression)outChildren.get(0);
            Expression simple = e.simplifyForSideEffect();
            if (simple == null) {
                return new Noop(n.getFilePosition());
            }
            if (simple != e) {
                newChildren = Collections.singletonList(simple);
            }
        } else if (n instanceof Conditional) {
            List<ParseTreeNode> condParts = newChildren != null ? newChildren : Lists.newArrayList(children);
            Statement optCond = StatementSimplifier.optimizeConditional(n.getFilePosition(), condParts);
            if (optCond != null) {
                return optCond;
            }
            int nCondParts = condParts.size();
            if ((nCondParts & 1) == 1 && condParts.get(nCondParts - 1) instanceof Noop) {
                if (newChildren == null) {
                    newChildren = Lists.newArrayList(condParts);
                    condParts = newChildren;
                }
                condParts.remove(--nCondParts);
            }
            if ((nCondParts & 1) == 1) {
                boolean allExit = true;
                for (int i = 1; i < nCondParts; i += 2) {
                    if (StatementSimplifier.exits(condParts.get(i))) continue;
                    allExit = false;
                    break;
                }
                if (allExit) {
                    return StatementSimplifier.combine(n.getFilePosition(), new Conditional(FilePosition.span(n.getFilePosition(), condParts.get(nCondParts - 1).getFilePosition()), null, condParts.subList(0, nCondParts - 1)), (Statement)condParts.get(nCondParts - 1));
                }
            }
        }
        if (newChildren != null) {
            n = ParseTreeNodes.newNodeInstance(n.getClass(), n.getFilePosition(), n.getValue(), newChildren);
        }
        return n instanceof Expression ? ((Expression)n).fold(false) : n;
    }

    private List<Statement> flattenBlocksAndIgnoreNoops(List<? extends Statement> stmts) {
        int nStmts = stmts.size();
        List<Statement> newStmts = null;
        int pos = 0;
        for (int i = 0; i < nStmts; ++i) {
            ParseTreeNode optS;
            ParseTreeNode s = stmts.get(i);
            if (s == (optS = this.optimize(s, false)) && !(optS instanceof Noop) && !(optS instanceof Block)) continue;
            if (newStmts == null) {
                newStmts = Lists.newArrayList(nStmts);
            }
            newStmts.addAll(stmts.subList(pos, i));
            if (optS instanceof Block) {
                newStmts.addAll(((Block)optS).children());
            } else if (!(optS instanceof Noop)) {
                newStmts.add((Statement)optS);
            }
            pos = i + 1;
        }
        if (newStmts != null) {
            newStmts.addAll(stmts.subList(pos, nStmts));
        }
        List<Statement> blockStmts = newStmts != null ? newStmts : stmts;
        int last = blockStmts.size() - 1;
        for (int i = 0; i < last; ++i) {
            int j;
            if (!StatementSimplifier.exits(blockStmts.get(i))) continue;
            boolean hasNonDecls = false;
            for (j = i + 1; j <= last; ++j) {
                if (blockStmts.get(j) instanceof Declaration || blockStmts.get(j) instanceof MultiDeclaration) continue;
                hasNonDecls = true;
                break;
            }
            if (!hasNonDecls) break;
            newStmts = Lists.newArrayList(stmts.subList(0, i + 1));
            for (j = i + 1; j <= last; ++j) {
                StatementSimplifier.hoistDecls(blockStmts.get(j), newStmts);
            }
            break;
        }
        return newStmts;
    }

    private static void hoistDecls(Statement s, List<Statement> out) {
        if (s instanceof Declaration) {
            Declaration d = (Declaration)s;
            if (d instanceof FunctionDeclaration || d.getInitializer() == null) {
                out.add(d);
            } else {
                out.add(new Declaration(d.getFilePosition(), d.getIdentifier(), null));
            }
        } else if (s instanceof CatchStmt) {
            StatementSimplifier.hoistDecls(((CatchStmt)s).getBody(), out);
        } else {
            for (ParseTreeNode parseTreeNode : s.children()) {
                if (!(parseTreeNode instanceof Statement)) continue;
                StatementSimplifier.hoistDecls((Statement)parseTreeNode, out);
            }
        }
    }

    private List<Statement> joinAdjacentExprs(List<Statement> stmts) {
        boolean progress;
        if (stmts.isEmpty()) {
            return null;
        }
        boolean changed = false;
        do {
            progress = false;
            Statement last = stmts.get(0);
            int n = stmts.size();
            for (int i = 1; i < n; ++i) {
                ParseTreeNode optCond;
                Conditional combined;
                Statement next = stmts.get(i);
                if (StatementSimplifier.isExpressionListTerminator(next) && last instanceof Conditional && (combined = StatementSimplifier.condAndImplicitElse((Conditional)last, next)) != null && StatementSimplifier.isExpressionListTerminator(optCond = this.optimize(combined, false))) {
                    stmts.subList(i - 1, i + 1).clear();
                    last = (Statement)optCond;
                    stmts.add(i - 1, last);
                    --n;
                    --i;
                    progress = true;
                    continue;
                }
                last = next;
            }
            int firstExprStmt = -1;
            int i = 0;
            int n2 = stmts.size();
            while (true) {
                Statement s;
                Statement statement = s = i != n2 ? stmts.get(i) : null;
                if (!(firstExprStmt == -1 || i != n2 && s instanceof ExpressionStmt)) {
                    int start = firstExprStmt;
                    int end = i;
                    firstExprStmt = -1;
                    if (StatementSimplifier.isExpressionListTerminator(s)) {
                        ++end;
                    }
                    if (end - start >= 2) {
                        progress = true;
                        ParseTreeNode joined = null;
                        for (Statement toJoin : stmts.subList(start, end)) {
                            List<? extends ParseTreeNode> tjChildren = toJoin.children();
                            Expression e = tjChildren.isEmpty() ? StatementSimplifier.undef(FilePosition.endOf(toJoin.getFilePosition())) : (Expression)tjChildren.get(0);
                            joined = joined == null ? e : StatementSimplifier.commaOp((Expression)joined, e);
                        }
                        assert (joined != null);
                        FilePosition exprPos = joined.getFilePosition();
                        AbstractStatement newChild = s instanceof ReturnStmt ? new ReturnStmt(exprPos, (Expression)joined) : (s instanceof ThrowStmt ? new ThrowStmt(exprPos, (Expression)joined) : new ExpressionStmt(exprPos, (Expression)joined));
                        stmts.subList(start, end).clear();
                        stmts.add(start, newChild);
                        n2 -= end - start;
                        i = start;
                    }
                } else if (s instanceof ExpressionStmt && firstExprStmt == -1) {
                    firstExprStmt = i;
                }
                if (i == n2) break;
                ++i;
            }
            if (!progress) continue;
            changed = true;
        } while (progress);
        return changed ? stmts : null;
    }

    private static Statement optimizeConditional(FilePosition parentPos, List<ParseTreeNode> condParts) {
        boolean hasElse;
        int n = condParts.size();
        Class<?> clauseClass = condParts.get(1).getClass();
        boolean bl = hasElse = (n & 1) == 1;
        if (clauseClass != ExpressionStmt.class && (!hasElse || clauseClass != ReturnStmt.class && clauseClass != ThrowStmt.class)) {
            return null;
        }
        for (int i = 3; i < n; i += 2) {
            if (condParts.get(i).getClass() == clauseClass) continue;
            return null;
        }
        if (hasElse && condParts.get(n - 1).getClass() != clauseClass) {
            return null;
        }
        int pos = n;
        Expression e = StatementSimplifier.expressionChildOf(condParts.get(--pos));
        if (!hasElse) {
            Expression lastCond;
            e = Operation.is((ParseTreeNode)(lastCond = (Expression)condParts.get(--pos)), Operator.NOT) ? Operation.createInfix(Operator.LOGICAL_OR, (Expression)lastCond.children().get(0), e) : Operation.createInfix(Operator.LOGICAL_AND, lastCond, e);
        }
        while (pos > 0) {
            Expression clause = StatementSimplifier.expressionChildOf(condParts.get(--pos));
            Expression cond = (Expression)condParts.get(--pos);
            FilePosition fpos = FilePosition.span(cond.getFilePosition(), e.getFilePosition());
            if (clause instanceof BooleanLiteral && e instanceof BooleanLiteral) {
                BooleanLiteral a = (BooleanLiteral)clause;
                BooleanLiteral b = (BooleanLiteral)e;
                if (a.value == b.value) {
                    e = StatementSimplifier.commaOp(cond, a).fold(false);
                } else {
                    int nNotsNeeded;
                    int n2 = nNotsNeeded = a.value ? 2 : 1;
                    if (nNotsNeeded == 2 && "boolean".equals(cond.typeOf())) {
                        nNotsNeeded = 0;
                    }
                    e = cond;
                    while (--nNotsNeeded >= 0) {
                        e = Operation.create(e.getFilePosition(), Operator.NOT, e).fold(false);
                    }
                }
            } else if (Operation.is((ParseTreeNode)cond, Operator.NOT)) {
                Expression notCond = ((Operation)cond).children().get(0);
                e = Operation.create(fpos, Operator.TERNARY, notCond, e, clause);
            } else {
                e = Operation.create(fpos, Operator.TERNARY, cond, clause, e);
            }
            e = StatementSimplifier.optimizeExpressionFlow(e);
        }
        return (Statement)ParseTreeNodes.newNodeInstance(clauseClass, parentPos, null, Collections.singletonList(e));
    }

    private static Expression expressionChildOf(ParseTreeNode returnThrowOrExprStmt) {
        List<? extends ParseTreeNode> children = returnThrowOrExprStmt.children();
        assert (children.size() < 2);
        if (children.isEmpty()) {
            FilePosition pos = FilePosition.endOf(returnThrowOrExprStmt.getFilePosition());
            return Operation.create(pos, Operator.VOID, new IntegerLiteral(pos, 0L));
        }
        return (Expression)children.get(0);
    }

    static Expression optimizeExpressionFlow(Expression e) {
        CommaCommonalities opt;
        if (!(e instanceof Operation)) {
            return e;
        }
        Operation op = (Operation)e;
        List<? extends Expression> operands = op.children();
        Expression[] newOperands = null;
        int n = operands.size();
        for (int i = 0; i < n; ++i) {
            Expression newOperand;
            Expression operand = operands.get(i);
            if (operand == (newOperand = StatementSimplifier.optimizeExpressionFlow(operand))) continue;
            if (newOperands == null) {
                newOperands = operands.toArray(new Expression[n]);
            }
            newOperands[i] = newOperand;
        }
        Operator oper = op.getOperator();
        FilePosition pos = e.getFilePosition();
        if (oper != Operator.TERNARY) {
            return newOperands == null ? e : Operation.create(pos, oper, newOperands);
        }
        Expression[] ternaryOperands = newOperands != null ? newOperands : operands.toArray(new Expression[3]);
        Expression c = ternaryOperands[0];
        Expression x = ternaryOperands[1];
        Expression y = ternaryOperands[2];
        while (Operation.is((ParseTreeNode)c, Operator.NOT)) {
            c = ((Operation)c).children().get(0);
            Expression t = x;
            x = y;
            y = t;
        }
        if (ParseTreeNodes.deepEquals(x, y)) {
            if (c.simplifyForSideEffect() == null) {
                return x;
            }
            return StatementSimplifier.commaOp(pos, c, x);
        }
        if (StatementSimplifier.isSimple(c)) {
            if (ParseTreeNodes.deepEquals(c, x)) {
                return Operation.create(pos, Operator.LOGICAL_OR, c, y);
            }
            if (ParseTreeNodes.deepEquals(c, y)) {
                return Operation.create(pos, Operator.LOGICAL_AND, c, x);
            }
        }
        if ((opt = StatementSimplifier.commaCommonalities(x, y)) != null) {
            if (opt.aReduced == null) {
                return StatementSimplifier.commaOp(pos, Operation.createInfix(Operator.LOGICAL_OR, c, opt.bReduced), opt.commonTail);
            }
            if (opt.bReduced == null) {
                return StatementSimplifier.commaOp(pos, Operation.createInfix(Operator.LOGICAL_AND, c, opt.aReduced), opt.commonTail);
            }
            return StatementSimplifier.commaOp(pos, StatementSimplifier.optimizeExpressionFlow(Operation.createTernary(c, opt.aReduced, opt.bReduced)), opt.commonTail);
        }
        ternaryOperands[0] = c;
        ternaryOperands[1] = x;
        ternaryOperands[2] = y;
        if (x instanceof Operation && y instanceof Operation) {
            Operation xop = (Operation)x;
            Operation yop = (Operation)y;
            Operator xoper = xop.getOperator();
            if (xoper == yop.getOperator()) {
                List<? extends Expression> xoperands = xop.children();
                List<? extends Expression> yoperands = yop.children();
                int nOperands = xoperands.size();
                if (nOperands == yoperands.size()) {
                    Expression xoperand0 = xoperands.get(0);
                    if (nOperands == 2 && ParseTreeNodes.deepEquals(xoperands.get(1), yoperands.get(1)) && xoper.getCategory() != OperatorCategory.ASSIGNMENT && (xoper != Operator.FUNCTION_CALL || !Operation.is((ParseTreeNode)xoperand0, Operator.MEMBER_ACCESS) && !Operation.is((ParseTreeNode)xoperand0, Operator.SQUARE_BRACKET))) {
                        return Operation.create(pos, xoper, StatementSimplifier.optimizeExpressionFlow(Operation.createTernary(c, xoperands.get(0), yoperands.get(0))), xoperands.get(1));
                    }
                    if (StatementSimplifier.isSimple(xoperands.get(0)) && StatementSimplifier.isSimple(c) && ParseTreeNodes.deepEquals(xoperands.get(0), yoperands.get(0))) {
                        return Operation.create(pos, xoper, xoperands.get(0), StatementSimplifier.optimizeExpressionFlow(Operation.createTernary(c, xoperands.get(1), yoperands.get(1))));
                    }
                }
            }
        }
        if (((Object)operands).equals(Arrays.asList(ternaryOperands))) {
            return e;
        }
        return Operation.create(pos, Operator.TERNARY, ternaryOperands);
    }

    private static CommaCommonalities commaCommonalities(Expression a, Expression b) {
        Expression bel;
        Expression ael;
        List<Expression> aChain = StatementSimplifier.unrollComma(a);
        List<Expression> bChain = StatementSimplifier.unrollComma(b);
        int aSize = aChain.size();
        int bSize = bChain.size();
        int minSize = Math.min(aSize, bSize);
        int nCommon = 0;
        for (int i = 0; i < minSize && ParseTreeNodes.deepEquals(ael = aChain.get(aSize - 1 - i), bel = bChain.get(bSize - 1 - i)); ++i) {
            ++nCommon;
        }
        if (nCommon == 0) {
            return null;
        }
        CommaCommonalities c = new CommaCommonalities();
        if (aSize != nCommon) {
            c.aReduced = a;
            int i = nCommon;
            while (--i >= 0) {
                assert (Operation.is((ParseTreeNode)c.aReduced, Operator.COMMA));
                c.aReduced = ((Operation)c.aReduced).children().get(0);
            }
        }
        if (bSize != nCommon) {
            c.bReduced = b;
            int i = nCommon;
            while (--i >= 0) {
                assert (Operation.is((ParseTreeNode)c.bReduced, Operator.COMMA));
                c.bReduced = ((Operation)c.bReduced).children().get(0);
            }
        }
        c.commonTail = aChain.get(aSize - nCommon);
        for (int i = aSize - nCommon + 1; i < aSize; ++i) {
            c.commonTail = StatementSimplifier.commaOp(c.commonTail, aChain.get(i));
        }
        return c;
    }

    private static List<Expression> unrollComma(Expression e) {
        List<Expression> chain = Lists.newArrayList();
        while (Operation.is((ParseTreeNode)e, Operator.COMMA)) {
            List<? extends Expression> operands = ((Operation)e).children();
            e = operands.get(0);
            chain.add(operands.get(1));
        }
        chain.add(e);
        int j = chain.size();
        for (int i = 0; i < --j; ++i) {
            Expression t = chain.get(i);
            chain.set(i, chain.get(j));
            chain.set(j, t);
        }
        return chain;
    }

    private static Expression commaOp(FilePosition pos, Expression a, Expression b) {
        while (Operation.is((ParseTreeNode)b, Operator.COMMA)) {
            List<? extends Expression> operands = ((Operation)b).children();
            Expression op0 = operands.get(0);
            a = StatementSimplifier.commaOp(a, op0);
            b = operands.get(1);
        }
        return Operation.create(pos, Operator.COMMA, a, b);
    }

    private static Expression commaOp(Expression a, Expression b) {
        return StatementSimplifier.commaOp(FilePosition.span(a.getFilePosition(), b.getFilePosition()), a, b);
    }

    private static boolean isSimple(Expression e) {
        return e.simplifyForSideEffect() == null || e instanceof Reference;
    }

    private static boolean isExpressionListTerminator(ParseTreeNode s) {
        return s instanceof ReturnStmt || s instanceof ThrowStmt;
    }

    private static Expression undef(FilePosition pos) {
        return Operation.create(pos, Operator.VOID, new IntegerLiteral(pos, 0L));
    }

    private static Conditional condAndImplicitElse(Conditional cond, Statement follower) {
        List<? extends ParseTreeNode> children = cond.children();
        if ((children.size() & 1) != 0) {
            return null;
        }
        Class<?> commonType = children.get(1).getClass();
        if (commonType != ReturnStmt.class && commonType != ThrowStmt.class) {
            return null;
        }
        for (int i = children.size() - 1; i >= 3; i -= 2) {
            if (children.get(i).getClass() == commonType) continue;
            return null;
        }
        List<? extends ParseTreeNode> allChildren = Lists.newArrayList(children);
        allChildren.add(follower);
        return new Conditional(FilePosition.span(cond.getFilePosition(), follower.getFilePosition()), null, allChildren);
    }

    static boolean exits(ParseTreeNode node) {
        if (node instanceof Block) {
            List<? extends ParseTreeNode> children = node.children();
            return !children.isEmpty() && StatementSimplifier.exits(children.get(children.size() - 1));
        }
        if (node instanceof Conditional) {
            List<? extends ParseTreeNode> children = node.children();
            int n = children.size();
            if ((n & 1) == 0) {
                return false;
            }
            for (int i = 1; i < n; i += 2) {
                if (StatementSimplifier.exits(children.get(i))) continue;
                return false;
            }
            return StatementSimplifier.exits(children.get(n - 1));
        }
        return node instanceof BreakStmt || node instanceof ContinueStmt || node instanceof ReturnStmt || node instanceof ThrowStmt;
    }

    private Statement optimizeSwitch(SwitchStmt ss) {
        SwitchCase prev;
        Block body;
        SwitchCase cs;
        List<? extends ParseTreeNode> newChildren = Lists.newArrayList(ss.children());
        boolean changed = false;
        int n = newChildren.size();
        for (int i = 0; i < n; ++i) {
            ParseTreeNode child = newChildren.get(i);
            ParseTreeNode newChild = this.optimize(child, false);
            if (newChild == child) continue;
            changed = true;
            newChildren.set(i, newChild);
        }
        boolean hasDefault = false;
        int i = newChildren.size();
        while (--i >= 1) {
            cs = (SwitchCase)newChildren.get(i);
            if (!(cs instanceof DefaultCaseStmt)) continue;
            body = cs.getBody();
            if (body.children().isEmpty()) {
                changed = true;
                newChildren.remove(i);
                continue;
            }
            if (StatementSimplifier.isBlankBreak(body)) {
                if (i != 1 || !StatementSimplifier.exits(((SwitchCase)newChildren.get(i - 1)).getBody())) {
                    prev = (SwitchCase)newChildren.get(i - 1);
                    newChildren.set(i - 1, StatementSimplifier.withBody(prev, StatementSimplifier.combine(prev.getBody(), body)));
                    changed = true;
                }
                newChildren.remove(i);
                changed = true;
                continue;
            }
            hasDefault = true;
        }
        if (!hasDefault) {
            i = newChildren.size();
            while (--i >= 1) {
                cs = (CaseStmt)newChildren.get(i);
                body = ((CaseStmt)cs).getBody();
                if (!StatementSimplifier.isBlankBreak(body) || ((CaseStmt)cs).getCaseValue().simplifyForSideEffect() != null) continue;
                if (i != 1 && !StatementSimplifier.exits((prev = (SwitchCase)newChildren.get(i - 1)).getBody())) {
                    newChildren.set(i - 1, StatementSimplifier.withBody(prev, StatementSimplifier.combine(prev.getBody(), body)));
                }
                newChildren.remove(i);
                changed = true;
            }
        }
        SwitchCase last = null;
        for (int i2 = 1; i2 < newChildren.size(); ++i2) {
            SwitchCase cs2 = (SwitchCase)newChildren.get(i2);
            if (last != null && !last.getBody().children().isEmpty() && ParseTreeNodes.deepEquals(last.getBody(), cs2.getBody())) {
                newChildren.set(i2 - 1, StatementSimplifier.withoutBody(last));
                changed = true;
            }
            last = cs2;
        }
        while (newChildren.size() > 1) {
            CaseStmt cs3;
            int lastIndex = newChildren.size() - 1;
            last = (SwitchCase)newChildren.get(lastIndex);
            Block lastBody = last.getBody();
            boolean changedOne = false;
            if (!lastBody.children().isEmpty()) {
                List<? extends Statement> stmts = lastBody.children();
                int n2 = stmts.size();
                if (n2 > 0 && StatementSimplifier.isBlankBreak(stmts.get(n2 - 1))) {
                    stmts = stmts.subList(0, n2 - 1);
                    Block newBody = new Block(lastBody.getFilePosition(), stmts);
                    newChildren.set(newChildren.size() - 1, StatementSimplifier.withBody(last, newBody));
                    changedOne = true;
                }
            } else if (StatementSimplifier.isBlankBreak(lastBody)) {
                newChildren.set(lastIndex, StatementSimplifier.withoutBody(last));
                changedOne = true;
            } else if (!hasDefault && null == (cs3 = (CaseStmt)last).getCaseValue().simplifyForSideEffect()) {
                newChildren.remove(lastIndex);
                changedOne = true;
            }
            if (!changedOne) break;
            changed = true;
        }
        return changed ? new SwitchStmt(ss.getFilePosition(), ss.getLabel(), newChildren) : ss;
    }

    private static SwitchCase withoutBody(SwitchCase sc) {
        return StatementSimplifier.withBody(sc, new Block(sc.getBody().getFilePosition()));
    }

    private static SwitchCase withBody(SwitchCase sc, Block body) {
        if (sc instanceof DefaultCaseStmt) {
            return new DefaultCaseStmt(sc.getFilePosition(), body);
        }
        CaseStmt cs = (CaseStmt)sc;
        return new CaseStmt(sc.getFilePosition(), cs.getCaseValue(), body);
    }

    private static boolean isBlankBreak(Statement s) {
        while (s instanceof Block) {
            Block block = (Block)s;
            if (block.children().size() != 1) {
                return false;
            }
            s = block.children().get(0);
        }
        return s instanceof BreakStmt && "".equals(((BreakStmt)s).getLabel());
    }

    private static Block combine(Block a, Block b) {
        if (b.children().isEmpty()) {
            return a;
        }
        if (a.children().isEmpty()) {
            return b;
        }
        FilePosition pos = FilePosition.span(a.getFilePosition(), b.getFilePosition());
        Statement s = StatementSimplifier.combine(pos, a, b);
        if (s instanceof Block) {
            return (Block)s;
        }
        if (s instanceof Noop) {
            return new Block(pos);
        }
        return new Block(pos, Collections.singletonList(s));
    }

    private static Statement combine(FilePosition pos, Statement a, Statement b) {
        if (b instanceof Noop) {
            return a;
        }
        if (a instanceof Noop) {
            return b;
        }
        List<Statement> stmts = Lists.newArrayList();
        if (a instanceof Block) {
            stmts.addAll(((Block)a).children());
        } else {
            stmts.add(a);
        }
        if (b instanceof Block) {
            stmts.addAll(((Block)b).children());
        } else {
            stmts.add(b);
        }
        return new Block(pos, stmts);
    }

    private static final class StmtLabel {
        final String newName;
        int nUses;

        StmtLabel(String newName) {
            this.newName = newName;
        }
    }

    private static class CommaCommonalities {
        Expression aReduced;
        Expression bReduced;
        Expression commonTail;

        private CommaCommonalities() {
        }
    }
}

