/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.css;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.parser.css.CssTree;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Criterion;
import com.google.caja.util.Lists;
import com.google.caja.util.Name;
import com.google.caja.util.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssParser {
    private final TokenQueue<CssTokenType> tq;
    private final MessageQueue mq;
    private final MessageLevel tolerance;
    private final boolean isTolerant;
    private static final Name PROG_ID_KEYWORD = Name.css("progid");
    private static final RecoveryStrategy DO_NOTHING = new RecoveryStrategy(){

        void recover(CssParser p, TokenQueue.Mark start) {
        }
    };
    private static final RecoveryStrategy SKIP_COMMA_LIST_ITEM = new RecoveryStrategy(){

        void recover(CssParser p, TokenQueue.Mark start) throws ParseException {
            if (start == null) {
                start = p.tq.mark();
            }
            while (!p.tq.isEmpty()) {
                Token t = p.tq.peek();
                if (t.type == CssTokenType.PUNCTUATION ? t.text.length() == 1 && ",{};".contains(t.text) : t.type == CssTokenType.SYMBOL) break;
                p.tq.advance();
            }
            p.reportSkipping(p.pos(start));
        }
    };
    private static final RecoveryStrategy SKIP_TO_CHUNK_END_FROM_WITHIN_BLOCK = new RecoveryStrategy(){

        void recover(CssParser p, TokenQueue.Mark start) throws ParseException {
            if (start == null) {
                start = p.tq.mark();
            }
            int depth = 1;
            while (!p.tq.isEmpty()) {
                Token t = p.tq.peek();
                if (t.type == CssTokenType.PUNCTUATION) {
                    if (";".equals(t.text) && depth <= 1) break;
                    if ("}".equals(t.text)) {
                        if (--depth <= 0) {
                            break;
                        }
                    } else if ("{".equals(t.text)) {
                        ++depth;
                    }
                } else if (t.type == CssTokenType.SYMBOL) break;
                p.tq.advance();
            }
            p.reportSkipping(p.pos(start));
        }
    };
    private static final RecoveryStrategy SKIP_TO_CHUNK_END_FROM_OUTSIDE_BLOCK = new RecoveryStrategy(){

        void recover(CssParser p, TokenQueue.Mark start) throws ParseException {
            if (start == null) {
                start = p.tq.mark();
            }
            int depth = 0;
            while (!p.tq.isEmpty()) {
                Token t = p.tq.peek();
                if (t.type == CssTokenType.PUNCTUATION) {
                    if (";".equals(t.text) && depth <= 0) {
                        p.tq.advance();
                        break;
                    }
                    if ("}".equals(t.text)) {
                        if (--depth <= 0) {
                            p.tq.advance();
                            break;
                        }
                    } else if ("{".equals(t.text)) {
                        ++depth;
                    }
                } else if (t.type == CssTokenType.SYMBOL) break;
                p.tq.advance();
            }
            p.reportSkipping(p.pos(start));
        }
    };

    public static TokenQueue<CssTokenType> makeTokenQueue(CharProducer cp, MessageQueue mq, boolean allowSubstitutions) {
        return new TokenQueue<CssTokenType>(new CssLexer(cp, mq, allowSubstitutions), cp.getCurrentPosition().source(), new Criterion<Token<CssTokenType>>(){

            @Override
            public boolean accept(Token<CssTokenType> t) {
                return CssTokenType.SPACE != t.type && CssTokenType.COMMENT != t.type;
            }
        });
    }

    public CssParser(TokenQueue<CssTokenType> tq, MessageQueue mq, MessageLevel tolerance) {
        assert (tq != null && tolerance != null);
        this.tq = tq;
        this.mq = mq;
        this.tolerance = tolerance;
        this.isTolerant = this.isTolerant();
    }

    public TokenQueue<CssTokenType> getTokenQueue() {
        return this.tq;
    }

    public CssTree.StyleSheet parseStyleSheet() throws ParseException {
        try {
            TokenQueue.Mark m = this.tq.mark();
            List stmts = Lists.newArrayList();
            while (true) {
                this.skipTopLevelIgnorables();
                if (!this.lookaheadSymbol("@import")) break;
                CssParser.addIfNotNull(stmts, this.parseImport());
            }
            while (true) {
                this.skipTopLevelIgnorables();
                if (this.tq.isEmpty()) break;
                CssParser.addIfNotNull(stmts, this.parseStatement());
            }
            return new CssTree.StyleSheet(this.pos(m), stmts);
        }
        catch (RuntimeException e) {
            throw new ParseException(new Message((MessageTypeInt)MessageType.PARSE_ERROR, this.tq.currentPosition()), (Throwable)e);
        }
    }

    public CssTree.DeclarationGroup parseDeclarationGroup() throws ParseException {
        try {
            TokenQueue.Mark m = this.tq.mark();
            List decls = Lists.newArrayList();
            while (!this.tq.isEmpty()) {
                while (this.tq.lookaheadToken(";")) {
                    this.tq.advance();
                }
                if (this.tq.isEmpty()) break;
                CssParser.addIfNotNull(decls, this.parseDeclaration());
                if (this.tq.checkToken(";")) continue;
            }
            return new CssTree.DeclarationGroup(this.pos(m), decls);
        }
        catch (RuntimeException e) {
            throw new ParseException(new Message((MessageTypeInt)MessageType.PARSE_ERROR, this.tq.currentPosition()), (Throwable)e);
        }
    }

    public boolean isTolerant() {
        return MessageLevel.FATAL_ERROR.compareTo(this.tolerance) > 0;
    }

    private CssTree.Import parseImport() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        this.expectSymbol("@import");
        CssTree.UriLiteral uri = this.parseUri();
        if (uri == null) {
            SKIP_TO_CHUNK_END_FROM_OUTSIDE_BLOCK.recover(this, m);
            return null;
        }
        List<Object> media = Collections.emptyList();
        if (!this.tq.checkToken(";")) {
            media = Lists.newArrayList();
            do {
                CssTree.Medium medium;
                if ((medium = this.parseMedium()) == null) {
                    SKIP_TO_CHUNK_END_FROM_OUTSIDE_BLOCK.recover(this, m);
                    return null;
                }
                media.add(medium);
            } while (this.tq.checkToken(","));
            if (this.expect(";", SKIP_TO_CHUNK_END_FROM_OUTSIDE_BLOCK, m)) {
                return null;
            }
        }
        return new CssTree.Import(this.pos(m), uri, media);
    }

    private CssTree.Medium parseMedium() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        String ident = this.expectIdent();
        if (ident == null) {
            return null;
        }
        return new CssTree.Medium(this.pos(m), Name.css(ident));
    }

    private CssTree.CssStatement parseStatement() throws ParseException {
        Token<CssTokenType> t = this.tq.peek();
        if (t.type == CssTokenType.SYMBOL) {
            if (this.lookaheadSymbol("@media")) {
                return this.parseMedia();
            }
            if (this.lookaheadSymbol("@page")) {
                return this.parsePage();
            }
            if (this.lookaheadSymbol("@font-face")) {
                return this.parseFontFace();
            }
            if (this.isTolerant) {
                TokenQueue.Mark m = this.tq.mark();
                this.tq.advance();
                SKIP_TO_CHUNK_END_FROM_OUTSIDE_BLOCK.recover(this, m);
                return null;
            }
        } else if (this.isTolerant && ";".equals(t.text)) {
            this.tq.advance();
            this.reportSkipping(this.tq.lastPosition());
            return null;
        }
        return this.parseRuleSet();
    }

    private CssTree.Media parseMedia() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        this.expectSymbol("@media");
        List<CssTree> children = Lists.newArrayList();
        do {
            CssTree.Medium medium;
            if ((medium = this.parseMedium()) == null) {
                SKIP_TO_CHUNK_END_FROM_OUTSIDE_BLOCK.recover(this, m);
                return null;
            }
            children.add(medium);
        } while (this.tq.checkToken(","));
        if (this.expect("{", SKIP_TO_CHUNK_END_FROM_OUTSIDE_BLOCK, m)) {
            return null;
        }
        while (!this.tq.checkToken("}")) {
            CssTree.RuleSet rs = this.parseRuleSet();
            if (rs == null) {
                SKIP_TO_CHUNK_END_FROM_WITHIN_BLOCK.recover(this, m);
                return null;
            }
            children.add(rs);
        }
        return new CssTree.Media(this.pos(m), children);
    }

    private CssTree.Page parsePage() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        this.expectSymbol("@page");
        Token<CssTokenType> t = this.tq.peek();
        String ident = null;
        if (CssTokenType.IDENT == t.type) {
            ident = CssParser.unescape(t);
            this.tq.advance();
        }
        List<CssTree.PseudoPage> elements = Lists.newArrayList();
        if (this.tq.lookaheadToken(":")) {
            TokenQueue.Mark m2 = this.tq.mark();
            this.tq.expectToken(":");
            String pseudoPage = this.expectIdent();
            if (pseudoPage == null) {
                SKIP_TO_CHUNK_END_FROM_OUTSIDE_BLOCK.recover(this, m);
                return null;
            }
            elements.add(new CssTree.PseudoPage(this.pos(m2), Name.css(pseudoPage)));
        }
        if (this.parseDeclarationBlock(elements, m)) {
            return null;
        }
        return new CssTree.Page(this.pos(m), ident == null ? null : Name.css(ident), elements);
    }

    private CssTree.FontFace parseFontFace() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        this.expectSymbol("@font-face");
        List elements = Lists.newArrayList();
        if (this.parseDeclarationBlock(elements, m)) {
            return null;
        }
        return new CssTree.FontFace(this.pos(m), elements);
    }

    private boolean parseDeclarationBlock(List<? super CssTree.Declaration> decls, TokenQueue.Mark start) throws ParseException {
        if (this.expect("{", SKIP_TO_CHUNK_END_FROM_OUTSIDE_BLOCK, start)) {
            return true;
        }
        do {
            CssParser.addIfNotNull(decls, this.parseDeclaration());
        } while (this.tq.checkToken(";"));
        return this.expect("}", SKIP_TO_CHUNK_END_FROM_WITHIN_BLOCK, start);
    }

    private CssTree.Operation parseOperation() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        CssTree.Operator op = CssTree.Operator.NONE;
        if (!this.tq.isEmpty()) {
            Token<CssTokenType> t = this.tq.peek();
            if (CssTokenType.PUNCTUATION == t.type) {
                if ("/".equals(t.text)) {
                    op = CssTree.Operator.DIV;
                    this.tq.advance();
                } else if (",".equals(t.text)) {
                    op = CssTree.Operator.COMMA;
                    this.tq.advance();
                } else if ("=".equals(t.text)) {
                    op = CssTree.Operator.EQUAL;
                    this.tq.advance();
                }
            }
        }
        return new CssTree.Operation(this.pos(m), op);
    }

    private CssTree.Combination parseCombinator() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        CssTree.Combinator comb = CssTree.Combinator.DESCENDANT;
        if (!this.tq.isEmpty()) {
            Token<CssTokenType> t = this.tq.peek();
            if (CssTokenType.PUNCTUATION == t.type) {
                if ("+".equals(t.text)) {
                    comb = CssTree.Combinator.SIBLING;
                    this.tq.advance();
                } else if (">".equals(t.text)) {
                    comb = CssTree.Combinator.CHILD;
                    this.tq.advance();
                }
            }
        }
        return new CssTree.Combination(this.pos(m), comb);
    }

    private CssTree.Property parseProperty() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        String ident = this.expectIdent();
        if (ident == null && this.isTolerant) {
            return null;
        }
        assert (ident != null);
        return new CssTree.Property(this.pos(m), Name.css(ident));
    }

    private CssTree.RuleSet parseRuleSet() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        List elements = Lists.newArrayList();
        do {
            CssTree.Selector sel = this.parseSelector();
            CssParser.addIfNotNull(elements, sel);
        } while (this.tq.checkToken(","));
        if (elements.isEmpty()) {
            SKIP_TO_CHUNK_END_FROM_OUTSIDE_BLOCK.recover(this, m);
            return null;
        }
        if (this.parseDeclarationBlock(elements, m)) {
            return null;
        }
        return new CssTree.RuleSet(this.pos(m), elements);
    }

    private CssTree.Selector parseSelector() throws ParseException {
        Token<CssTokenType> t;
        TokenQueue.Mark m = this.tq.mark();
        List<CssTree> elements = Lists.newArrayList();
        do {
            CssTree.SimpleSelector sel;
            if (!elements.isEmpty()) {
                elements.add(this.parseCombinator());
            }
            if ((sel = this.parseSimpleSelector()) == null) {
                SKIP_COMMA_LIST_ITEM.recover(this, m);
                return null;
            }
            elements.add(sel);
            if (this.tq.isEmpty()) break;
            t = this.tq.peek();
        } while (CssTokenType.PUNCTUATION != t.type || ":*.[+>".contains(t.text));
        if (elements.isEmpty()) {
            SKIP_COMMA_LIST_ITEM.recover(this, m);
            return null;
        }
        return new CssTree.Selector(this.pos(m), elements);
    }

    private CssTree.SimpleSelector parseSimpleSelector() throws ParseException {
        Token<CssTokenType> t;
        TokenQueue.Mark m = this.tq.mark();
        List<CssTree> elements = Lists.newArrayList();
        if (!this.tq.isEmpty()) {
            t = this.tq.peek();
            if (CssTokenType.IDENT == t.type) {
                String elementName = CssParser.unescape(t);
                this.tq.advance();
                elements.add(new CssTree.IdentLiteral(this.pos(m), elementName));
            } else if ("*".equals(t.text)) {
                this.tq.advance();
                elements.add(new CssTree.WildcardElement(this.pos(m)));
            }
        }
        while (!this.tq.isEmpty() && (elements.isEmpty() || this.adjacent())) {
            CssTree selectorPart;
            t = this.tq.peek();
            if (CssTokenType.HASH == t.type) {
                String identifier = CssParser.unescape(t);
                if (!CssLexer.isNmStart(identifier.charAt(1))) {
                    selectorPart = null;
                } else {
                    selectorPart = new CssTree.IdLiteral(t.pos, identifier);
                    this.tq.advance();
                }
            } else if (".".equals(t.text)) {
                selectorPart = this.parseClass();
            } else if ("[".equals(t.text)) {
                selectorPart = this.parseAttrib();
            } else {
                if (!":".equals(t.text)) break;
                selectorPart = this.parsePseudo();
            }
            if (selectorPart == null) {
                return null;
            }
            elements.add(selectorPart);
        }
        if (elements.isEmpty()) {
            this.throwOrReportExpectedToken("<Selector>");
            return null;
        }
        return new CssTree.SimpleSelector(this.pos(m), elements);
    }

    private CssTree.ClassLiteral parseClass() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        this.tq.expectToken(".");
        String ident = this.expectIdent();
        if (ident == null) {
            return null;
        }
        return new CssTree.ClassLiteral(this.pos(m), "." + ident);
    }

    private CssTree.Attrib parseAttrib() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        this.tq.expectToken("[");
        String ident = this.expectIdent();
        if (ident == null) {
            return null;
        }
        CssTree.AttribOperation op = null;
        if (this.isTolerant && this.tq.isEmpty()) {
            return null;
        }
        Token<CssTokenType> t = this.tq.peek();
        if (CssTokenType.PUNCTUATION == t.type) {
            if ("=".equals(t.text)) {
                op = new CssTree.AttribOperation(t.pos, CssTree.AttribOperator.EQUAL);
                this.tq.advance();
            } else if ("~=".equals(t.text)) {
                op = new CssTree.AttribOperation(t.pos, CssTree.AttribOperator.INCLUDES);
                this.tq.advance();
            } else if ("|=".equals(t.text)) {
                op = new CssTree.AttribOperation(t.pos, CssTree.AttribOperator.DASHMATCH);
                this.tq.advance();
            }
        }
        CssTree.CssLiteral value = null;
        if (null != op) {
            if (this.isTolerant && this.tq.isEmpty()) {
                return null;
            }
            t = this.tq.peek();
            if (CssTokenType.STRING == t.type) {
                String s = CssParser.unescape(t);
                s = s.substring(1, s.length() - 1);
                value = new CssTree.StringLiteral(t.pos, s);
                this.tq.advance();
            } else {
                String valuePattern = this.expectIdent();
                if (valuePattern == null) {
                    return null;
                }
                value = new CssTree.IdentLiteral(t.pos, valuePattern);
            }
        }
        if (this.expect("]", DO_NOTHING, m)) {
            return null;
        }
        return new CssTree.Attrib(this.pos(m), ident, op, value);
    }

    private CssTree.Pseudo parsePseudo() throws ParseException {
        CssTree.CssExprAtom atom;
        TokenQueue.Mark m = this.tq.mark();
        this.tq.expectToken(":");
        TokenQueue.Mark m2 = this.tq.mark();
        if (this.isTolerant && this.tq.isEmpty()) {
            return null;
        }
        Token<CssTokenType> t = this.tq.peek();
        if (CssTokenType.FUNCTION == t.type) {
            String fnName = CssParser.unescape(t);
            fnName = fnName.substring(0, fnName.length() - 1);
            this.tq.advance();
            TokenQueue.Mark m3 = this.tq.mark();
            String argIdent = this.expectIdent();
            if (argIdent == null) {
                return null;
            }
            FilePosition pos3 = this.pos(m3);
            CssTree.IdentLiteral lit = new CssTree.IdentLiteral(pos3, argIdent);
            CssTree.Term term = new CssTree.Term(pos3, null, lit);
            CssTree.Expr arg = new CssTree.Expr(pos3, Collections.singletonList(term));
            if (this.expect(")", DO_NOTHING, m)) {
                return null;
            }
            atom = new CssTree.FunctionCall(this.pos(m2), Name.css(fnName), arg);
        } else {
            String ident = this.expectIdent();
            if (ident == null) {
                return null;
            }
            atom = new CssTree.IdentLiteral(this.pos(m2), ident);
        }
        return new CssTree.Pseudo(this.pos(m), atom);
    }

    private CssTree.Declaration parseDeclaration() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        if (this.tq.lookaheadToken("}") || this.tq.lookaheadToken(";")) {
            return new CssTree.EmptyDeclaration(this.pos(m));
        }
        boolean hasStarHack = this.tq.checkToken("*");
        TokenQueue.Mark declStart = this.tq.mark();
        CssTree.Property property = this.parseProperty();
        if (property == null) {
            SKIP_TO_CHUNK_END_FROM_WITHIN_BLOCK.recover(this, m);
            return null;
        }
        List<CssTree> children = Lists.newArrayList(3);
        children.add(property);
        if (this.expect(":", SKIP_TO_CHUNK_END_FROM_WITHIN_BLOCK, m)) {
            return null;
        }
        CssTree.Expr expr = this.parseExpr();
        if (expr == null) {
            SKIP_TO_CHUNK_END_FROM_WITHIN_BLOCK.recover(this, m);
            return null;
        }
        children.add(expr);
        if (!(this.tq.isEmpty() || this.tq.lookaheadToken("}") || this.tq.lookaheadToken(";"))) {
            CssTree.Prio prio = this.parsePrio();
            if (prio == null) {
                SKIP_TO_CHUNK_END_FROM_WITHIN_BLOCK.recover(this, m);
                return null;
            }
            children.add(prio);
        }
        CssTree.PropertyDeclaration d = new CssTree.PropertyDeclaration(this.pos(declStart), children);
        if (hasStarHack) {
            return new CssTree.UserAgentHack(this.pos(m), CssTree.UserAgent.ie7OrOlder(), Collections.singletonList(d));
        }
        return d;
    }

    private CssTree.Prio parsePrio() throws ParseException {
        String s;
        Token<CssTokenType> t = this.tq.peek();
        if (CssTokenType.DIRECTIVE == t.type && "!important".equals(s = Strings.toLowerCase(CssParser.unescape(t)))) {
            this.tq.advance();
            return new CssTree.Prio(t.pos, s);
        }
        return (CssTree.Prio)this.throwOrReport(MessageType.EXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf(";"), MessagePart.Factory.valueOf(t.text));
    }

    private CssTree.Expr parseExpr() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        List<CssTree> children = Lists.newArrayList();
        CssTree.Term term = this.parseTerm();
        if (term == null) {
            return null;
        }
        children.add(term);
        while (!this.tq.isEmpty()) {
            Token<CssTokenType> t = this.tq.peek();
            if (CssTokenType.PUNCTUATION == t.type ? !"=".equals(t.text) && !"/".equals(t.text) && !",".equals(t.text) && !"-".equals(t.text) : CssTokenType.DIRECTIVE == t.type) break;
            children.add(this.parseOperation());
            CssTree.Term term2 = this.parseTerm();
            if (term2 == null) {
                return null;
            }
            children.add(term2);
        }
        return new CssTree.Expr(this.pos(m), children);
    }

    private CssTree.Term parseTerm() throws ParseException {
        CssTree.CssExprAtom expr;
        TokenQueue.Mark m = this.tq.mark();
        CssTree.UnaryOperator op = this.parseUnaryOperator();
        if (this.isTolerant && this.tq.isEmpty()) {
            return null;
        }
        TokenQueue.Mark m2 = this.tq.mark();
        Token<CssTokenType> t = this.tq.peek();
        switch ((CssTokenType)t.type) {
            case IDENT: {
                String ident = CssParser.unescape(t);
                this.tq.advance();
                if (PROG_ID_KEYWORD.equals(Name.css(ident)) && this.tq.checkToken(":")) {
                    expr = this.parseProgId(m2);
                    break;
                }
                expr = new CssTree.IdentLiteral(this.pos(m2), ident);
                break;
            }
            case FUNCTION: {
                this.tq.advance();
                String fn = CssParser.unescape(t);
                fn = fn.substring(0, fn.length() - 1);
                CssTree.Expr arg = this.parseExpr();
                if (arg == null) {
                    return null;
                }
                if (this.expect(")", DO_NOTHING, m)) {
                    return null;
                }
                expr = new CssTree.FunctionCall(this.pos(m2), Name.css(fn), arg);
                break;
            }
            default: {
                expr = this.parseLiteral();
            }
        }
        if (expr == null) {
            return null;
        }
        return new CssTree.Term(this.pos(m), op, expr);
    }

    private CssTree.UnaryOperator parseUnaryOperator() throws ParseException {
        CssTree.UnaryOperator op = null;
        if (!this.tq.isEmpty()) {
            Token<CssTokenType> t = this.tq.peek();
            if (CssTokenType.PUNCTUATION == t.type) {
                if ("+".equals(t.text)) {
                    op = CssTree.UnaryOperator.IDENTITY;
                    this.tq.advance();
                } else if ("-".equals(t.text)) {
                    op = CssTree.UnaryOperator.NEGATION;
                    this.tq.advance();
                }
            }
        }
        return op;
    }

    private CssTree.CssLiteral parseLiteral() throws ParseException {
        TokenQueue.Mark m = this.tq.mark();
        Token<CssTokenType> t = this.tq.pop();
        switch ((CssTokenType)t.type) {
            case QUANTITY: {
                return new CssTree.QuantityLiteral(this.pos(m), CssParser.unescape(t));
            }
            case STRING: {
                String value = CssParser.unescape(t);
                value = value.substring(1, value.length() - 1);
                return new CssTree.StringLiteral(this.pos(m), value);
            }
            case HASH: {
                String color = CssParser.unescape(t);
                if (color.length() != 4 && color.length() != 7) {
                    return (CssTree.CssLiteral)this.throwOrReport(MessageType.UNEXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf(t.text));
                }
                try {
                    return new CssTree.HashLiteral(this.pos(m), color);
                }
                catch (IllegalArgumentException e) {
                    return (CssTree.CssLiteral)this.throwOrReport(MessageType.UNEXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf(t.text));
                }
            }
            case UNICODE_RANGE: {
                return new CssTree.UnicodeRangeLiteral(this.pos(m), CssParser.unescape(t));
            }
            case URI: {
                this.tq.rewind(m);
                return this.parseUri();
            }
            case SUBSTITUTION: {
                return new CssTree.Substitution(t.pos, t.text);
            }
            case IDENT: {
                return new CssTree.IdentLiteral(t.pos, CssParser.unescape(t));
            }
        }
        this.tq.rewind(m);
        return (CssTree.CssLiteral)this.throwOrReport(MessageType.UNEXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf(t.text));
    }

    private CssTree.UriLiteral parseUri() throws ParseException {
        Token<CssTokenType> t = this.tq.peek();
        TokenQueue.Mark m = this.tq.mark();
        try {
            String uriStr;
            switch ((CssTokenType)t.type) {
                case URI: {
                    char ch0;
                    String s = t.text;
                    s = s.substring(s.indexOf(40) + 1, s.lastIndexOf(41)).trim();
                    s = CssParser.unescape(s, false);
                    this.tq.advance();
                    if (s.length() >= 2 && ('\'' == (ch0 = s.charAt(0)) || '\"' == ch0) && ch0 == s.charAt(s.length() - 1)) {
                        s = s.substring(1, s.length() - 1);
                    }
                    uriStr = s;
                    break;
                }
                case STRING: {
                    String s = CssParser.unescape(t);
                    this.tq.advance();
                    uriStr = s.substring(1, s.length() - 1);
                    break;
                }
                default: {
                    return (CssTree.UriLiteral)this.throwOrReport(MessageType.EXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf("<URI>"), MessagePart.Factory.valueOf(t.text));
                }
            }
            return new CssTree.UriLiteral(this.pos(m), new URI(uriStr));
        }
        catch (URISyntaxException ex) {
            return (CssTree.UriLiteral)this.throwOrReport(MessageType.MALFORMED_URI, t.pos, MessagePart.Factory.valueOf(t.text));
        }
    }

    private CssTree.ProgId parseProgId(TokenQueue.Mark start) throws ParseException {
        StringBuilder sb = new StringBuilder();
        block4: while (true) {
            if (this.tq.isEmpty()) {
                return null;
            }
            Token<CssTokenType> t = this.tq.pop();
            switch ((CssTokenType)t.type) {
                case FUNCTION: {
                    sb.append(CssParser.unescape(t.text.substring(0, t.text.length() - 1), true));
                    break block4;
                }
                case IDENT: {
                    sb.append(CssParser.unescape(t));
                    break;
                }
                default: {
                    return null;
                }
            }
            if (!this.tq.checkToken(".")) {
                return null;
            }
            sb.append('.');
        }
        List<CssTree.ProgIdAttribute> attrs = Lists.newArrayList();
        if (!this.tq.checkToken(")")) {
            do {
                CssTree.ProgIdAttribute attr;
                if ((attr = this.parseProgIdAttribute()) == null) {
                    return null;
                }
                attrs.add(attr);
            } while (this.tq.checkToken(","));
            if (!this.tq.checkToken(")")) {
                return null;
            }
        }
        return new CssTree.ProgId(this.pos(start), Name.css(sb.toString()), attrs);
    }

    private CssTree.ProgIdAttribute parseProgIdAttribute() throws ParseException {
        TokenQueue.Mark attrStart = this.tq.mark();
        String name = this.expectIdent();
        if (name == null) {
            return null;
        }
        if (!this.tq.checkToken("=")) {
            return null;
        }
        TokenQueue.Mark valueStart = this.tq.mark();
        CssTree.UnaryOperator op = this.parseUnaryOperator();
        if (this.tq.isEmpty()) {
            return null;
        }
        Token<CssTokenType> t = this.tq.peek();
        CssTree.CssLiteral lit = null;
        if (t.type == CssTokenType.HASH) {
            String color = CssParser.unescape(t);
            if (9 == color.length()) {
                this.tq.advance();
                try {
                    lit = new CssTree.HashLiteral(t.pos, color);
                }
                catch (IllegalArgumentException e) {
                    return (CssTree.ProgIdAttribute)this.throwOrReport(MessageType.UNEXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf(t.text));
                }
            } else {
                lit = this.parseLiteral();
            }
        } else {
            lit = this.parseLiteral();
        }
        if (lit == null) {
            return null;
        }
        return new CssTree.ProgIdAttribute(this.pos(attrStart), Name.css(name), Collections.singletonList(new CssTree.Term(this.pos(valueStart), op, lit)));
    }

    private FilePosition pos(TokenQueue.Mark m) throws ParseException {
        FilePosition start = m.getFilePosition();
        FilePosition end = this.tq.lastPosition();
        return (this.tq.isEmpty() || this.tq.currentPosition() != start) && start.source().equals(end.source()) && start.endCharInFile() <= end.endCharInFile() ? FilePosition.span(start, this.tq.lastPosition()) : FilePosition.startOf(start);
    }

    static String unescape(Token<CssTokenType> t) {
        return CssParser.unescape(t.text, t.type != CssTokenType.STRING);
    }

    static String unescape(String s, boolean removeSpaces) {
        int pos = 0;
        StringBuilder sb = null;
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if ('\\' == ch && i + 1 < n) {
                if (null == sb) {
                    sb = new StringBuilder();
                }
                sb.append(s, pos, i);
                char ch1 = s.charAt(++i);
                if (CssLexer.isHexChar(ch1)) {
                    char nextChar;
                    int end;
                    for (end = i; end < n && end - i < 6 && CssLexer.isHexChar(s.charAt(end)); ++end) {
                    }
                    int chi = Integer.parseInt(s.substring(i, end), 16);
                    i = end - 1;
                    if (i + 1 < n && CssLexer.isSpaceChar(nextChar = s.charAt(i + 1)) && '\r' == nextChar && ++i + 1 < n && '\n' == s.charAt(i + 1)) {
                        ++i;
                    }
                    sb.appendCodePoint(chi);
                } else if ('\r' == ch1) {
                    if (i + 1 < n && s.charAt(i + 1) == '\n') {
                        ++i;
                    }
                } else if ('\n' != ch1) {
                    sb.append(ch1);
                }
                pos = i + 1;
                continue;
            }
            if (!CssLexer.isSpaceChar(ch) || !removeSpaces) continue;
            if (null == sb) {
                sb = new StringBuilder();
            }
            if (i > pos) {
                sb.append(s, pos, i);
            }
            pos = i + 1;
        }
        if (null == sb) {
            return s;
        }
        sb.append(s, pos, s.length());
        return sb.toString();
    }

    private boolean lookaheadSymbol(String symbol) throws ParseException {
        if (this.tq.isEmpty()) {
            return false;
        }
        Token<CssTokenType> t = this.tq.peek();
        return t.type == CssTokenType.SYMBOL && Strings.equalsIgnoreCase(symbol, CssParser.unescape(t));
    }

    private void expectSymbol(String symbol) throws ParseException {
        Token<CssTokenType> t = this.tq.pop();
        if (t.type == CssTokenType.SYMBOL && Strings.equalsIgnoreCase(symbol, CssParser.unescape(t))) {
            return;
        }
        throw new ParseException(new Message((MessageTypeInt)MessageType.EXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf(symbol), MessagePart.Factory.valueOf(t.text)));
    }

    private String expectIdent() throws ParseException {
        Token<CssTokenType> t = null;
        if (!this.tq.isEmpty()) {
            t = this.tq.peek();
            if (CssTokenType.IDENT == t.type) {
                this.tq.advance();
                return CssParser.unescape(t);
            }
        }
        this.throwOrReportExpectedToken("<Identifier>");
        return null;
    }

    private void skipTopLevelIgnorables() throws ParseException {
        while (!this.tq.isEmpty()) {
            Token<CssTokenType> t = this.tq.peek();
            if (CssTokenType.PUNCTUATION != t.type || !"<!--".equals(t.text) && !"-->".equals(t.text)) break;
            this.tq.advance();
        }
    }

    private boolean adjacent() throws ParseException {
        FilePosition last = this.tq.lastPosition();
        FilePosition current = this.tq.currentPosition();
        return null != last && null != current && last.endCharInFile() == current.startCharInFile();
    }

    private static <T> void addIfNotNull(Collection<? super T> coll, T item) {
        if (item != null) {
            coll.add(item);
        }
    }

    private boolean expect(String token, RecoveryStrategy rs, TokenQueue.Mark start) throws ParseException {
        if (this.tq.checkToken(token)) {
            return false;
        }
        this.throwOrReportExpectedToken(token);
        rs.recover(this, start);
        return true;
    }

    private void throwOrReportExpectedToken(String token) throws ParseException {
        FilePosition pos;
        String actual;
        if (this.tq.isEmpty()) {
            actual = "<EOF>";
            pos = FilePosition.endOf(this.tq.lastPosition());
        } else {
            actual = this.tq.peek().text;
            pos = this.tq.currentPosition();
        }
        this.throwOrReport(MessageType.EXPECTED_TOKEN, pos, MessagePart.Factory.valueOf(token), MessagePart.Factory.valueOf(actual));
    }

    private void reportSkipping(FilePosition skipped) {
        if (skipped.length() != 0) {
            this.mq.addMessage((MessageTypeInt)MessageType.SKIPPING, this.tolerance, skipped);
        }
    }

    private <T> T throwOrReport(MessageTypeInt t, MessagePart ... parts) throws ParseException {
        Message msg = new Message(t, this.tolerance, parts);
        if (this.isTolerant) {
            this.mq.getMessages().add(msg);
            return null;
        }
        throw new ParseException(msg);
    }

    private static abstract class RecoveryStrategy {
        private RecoveryStrategy() {
        }

        abstract void recover(CssParser var1, TokenQueue.Mark var2) throws ParseException;
    }
}

