/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.css;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.render.Concatenator;
import com.google.caja.render.CssPrettyPrinter;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import com.google.caja.util.Name;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CssTree
extends AbstractParseTreeNode {
    private static final Pattern IDLITERAL = Pattern.compile("^#.+$");
    private static final Pattern CLASSLITERAL = Pattern.compile("^\\..+$");
    private static final Pattern IDENTLITERAL = Pattern.compile("^.+$");
    private static final Pattern HASHLITERAL = Pattern.compile("^#[a-fA-F0-9]{3}(?:[a-fA-F0-9]{3}(?:[a-fA-F0-9]{2})?)?$");
    private static final Pattern QUANTITYLITERAL = Pattern.compile("^(?:\\.\\d+|\\d+(?:\\.\\d+)?)([a-zA-Z]+|%)?$");
    private static final Pattern UNICODERANGELITERAL = Pattern.compile("^U\\+(?:[0-9a-fA-F]{1,6}-[0-9a-fA-F]{1,6}|[0-9a-fA-F?]{1,6})$", 2);
    private static final Pattern SUBSTITUTION = Pattern.compile("^\\$\\{.*\\}(?:%|[a-z]+)?$", 32);

    private CssTree(FilePosition pos, List<? extends CssTree> children) {
        super(pos, CssTree.class);
        this.createMutation().appendChildren(children).execute();
    }

    private <T extends CssTree> CssTree(FilePosition pos, Class<T> subType, List<? extends T> children) {
        super(pos, subType);
        this.createMutation().appendChildren(children).execute();
    }

    @Override
    public Object getValue() {
        return null;
    }

    public List<? extends CssTree> children() {
        return this.childrenAs(CssTree.class);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.formatSelf(new MessageContext(), 0, sb);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders shouldn't throw IOExceptions");
        }
        return sb.toString();
    }

    @Override
    public final TokenConsumer makeRenderer(Appendable out, Callback<IOException> exHandler) {
        return new CssPrettyPrinter(new Concatenator(out, exHandler));
    }

    private static void renderStatements(List<? extends CssTree> children, @Nullable FilePosition pos, RenderContext r) {
        TokenConsumer out = r.getOut();
        out.mark(pos);
        out.consume("{");
        CssTree last = null;
        for (CssTree cssTree : children) {
            if (last != null) {
                out.consume(";");
            }
            cssTree.render(r);
            last = cssTree;
        }
        out.mark(FilePosition.endOfOrNull(pos));
        out.consume("}");
    }

    private static void renderCommaGroup(List<? extends CssTree> children, RenderContext r) {
        boolean first = true;
        for (CssTree cssTree : children) {
            if (!first) {
                r.getOut().consume(",");
            } else {
                first = false;
            }
            cssTree.render(r);
        }
    }

    private static void renderSpaceGroup(List<? extends CssTree> children, RenderContext r) {
        boolean needSpace = false;
        for (CssTree cssTree : children) {
            if (needSpace) {
                r.getOut().consume(" ");
            } else {
                needSpace = true;
            }
            cssTree.render(r);
        }
    }

    private static void renderCssIdent(String ident, RenderContext r) {
        StringBuilder sb = new StringBuilder();
        Escaping.escapeCssIdent((CharSequence)ident, sb);
        r.getOut().consume(sb.toString());
    }

    private static void renderCssString(String s, RenderContext r) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        Escaping.escapeCssString((CharSequence)s, sb);
        sb.append('\'');
        r.getOut().consume(sb.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UserAgent {
        IE6,
        IE7,
        IE8;


        public static EnumSet<UserAgent> ie7OrOlder() {
            return EnumSet.of(IE6, IE7);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UserAgentHack
    extends Declaration {
        private final EnumSet<UserAgent> enabledOn;

        @ParseTreeNode.ReflectiveCtor
        public UserAgentHack(FilePosition pos, Set<UserAgent> enabledOn, List<? extends PropertyDeclaration> decl) {
            super(pos, PropertyDeclaration.class, decl);
            this.enabledOn = EnumSet.copyOf(enabledOn);
        }

        @Override
        public EnumSet<UserAgent> getValue() {
            return EnumSet.copyOf(this.enabledOn);
        }

        @Override
        protected void childrenChanged() {
            super.childrenChanged();
            List<? extends CssTree> children = this.children();
            if (children.size() != 1) {
                throw new IllegalStateException();
            }
            if (!(children.get(0) instanceof PropertyDeclaration)) {
                throw new ClassCastException(children.get(0).getClass().getName());
            }
        }

        public PropertyDeclaration getDeclaration() {
            return (PropertyDeclaration)this.children().get(0);
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.mark(this.getFilePosition());
            out.consume("*");
            this.getDeclaration().render(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Combinator {
        SIBLING("+"),
        CHILD(">"),
        DESCENDANT(null);

        private final String symbol;

        private Combinator(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnaryOperator {
        NEGATION("-"),
        IDENTITY("+");

        private final String symbol;

        private UnaryOperator(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        DIV("/"),
        COMMA(","),
        EQUAL("="),
        NONE(null);

        private final String symbol;

        private Operator(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Operation
    extends CssTree {
        final Operator op;

        @ParseTreeNode.ReflectiveCtor
        public Operation(FilePosition pos, Operator op, List<? extends CssTree> none) {
            this(pos, op);
        }

        public Operation(FilePosition pos, Operator op) {
            super(pos, Collections.emptyList());
            this.op = op;
        }

        public Operator getValue() {
            return this.op;
        }

        public Operator getOperator() {
            return this.op;
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            if (null != this.op.symbol) {
                r.getOut().consume(this.op.symbol);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Combination
    extends CssTree {
        final Combinator comb;

        @ParseTreeNode.ReflectiveCtor
        public Combination(FilePosition pos, Combinator comb, List<? extends CssTree> none) {
            this(pos, comb);
        }

        public Combination(FilePosition pos, Combinator comb) {
            super(pos, Collections.emptyList());
            this.comb = comb;
        }

        public Combinator getValue() {
            return this.comb;
        }

        public Combinator getCombinator() {
            return this.comb;
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            if (null != this.comb.symbol) {
                r.getOut().consume(this.comb.symbol);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Substitution
    extends CssLiteral {
        public Substitution(FilePosition pos, String value, List<? extends CssTree> none) {
            this(pos, value);
        }

        public Substitution(FilePosition pos, String value) {
            super(pos, value);
        }

        public String getBody() {
            String value = this.getValue();
            StringBuilder sb = new StringBuilder("  ");
            int end = value.lastIndexOf(125);
            sb.append(value, 2, end);
            while (sb.length() < value.length()) {
                sb.append(' ');
            }
            return sb.toString();
        }

        public String getSuffix() {
            String value = this.getValue();
            return value.substring(value.lastIndexOf(125) + 1);
        }

        @Override
        public boolean checkValue(String value) {
            return SUBSTITUTION.matcher(value).matches();
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume(this.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ProgIdAttribute
    extends CssTree {
        private final Name name;

        @ParseTreeNode.ReflectiveCtor
        public ProgIdAttribute(FilePosition pos, Name name, List<? extends Term> value) {
            super(pos, Term.class, value);
            this.name = name;
        }

        @Override
        public Name getValue() {
            return this.name;
        }

        public Name getName() {
            return this.name;
        }

        public List<? extends Term> children() {
            return this.childrenAs(Term.class);
        }

        public Term getPropertyValue() {
            return this.children().get(0);
        }

        @Override
        protected void childrenChanged() {
            super.childrenChanged();
            List<? extends Term> terms = this.children();
            if (terms.size() != 1) {
                throw new IllegalStateException();
            }
            CssExprAtom atom = terms.get(0).getExprAtom();
            if (!(atom instanceof CssLiteral)) {
                throw new ClassCastException(atom.getClass().getName());
            }
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer tc = r.getOut();
            tc.mark(this.getFilePosition());
            CssTree.renderCssIdent(this.name.getCanonicalForm(), r);
            tc.consume("=");
            this.getPropertyValue().render(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ProgId
    extends CssExprAtom {
        private final Name name;

        @ParseTreeNode.ReflectiveCtor
        public ProgId(FilePosition pos, Name name, List<? extends ProgIdAttribute> attrs) {
            super(pos, ProgIdAttribute.class, attrs);
            this.name = name;
        }

        @Override
        public Name getValue() {
            return this.name;
        }

        public Name getName() {
            return this.name;
        }

        public List<? extends ProgIdAttribute> children() {
            return this.childrenAs(ProgIdAttribute.class);
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer tc = r.getOut();
            tc.mark(this.getFilePosition());
            tc.consume("progid");
            tc.consume(":");
            boolean dot = false;
            for (String part : this.name.getCanonicalForm().split("\\.")) {
                if (dot) {
                    tc.consume(".");
                }
                dot = true;
                CssTree.renderCssIdent(part, r);
            }
            tc.consume("(");
            CssTree.renderCommaGroup(this.children(), r);
            tc.consume(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FunctionCall
    extends CssExprAtom {
        private final Name name;

        @ParseTreeNode.ReflectiveCtor
        public FunctionCall(FilePosition pos, Name name, List<? extends Expr> expr) {
            this(pos, name, expr.get(0));
        }

        public FunctionCall(FilePosition pos, Name name, Expr expr) {
            super(pos, Collections.singletonList(expr));
            this.name = name;
        }

        @Override
        public Name getValue() {
            return this.name;
        }

        public Name getName() {
            return this.name;
        }

        public Expr getArguments() {
            return (Expr)this.children().get(0);
        }

        @Override
        protected void childrenChanged() {
            super.childrenChanged();
            assert (1 == this.children().size() && this.children().get(0) instanceof Expr);
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.mark(this.getFilePosition());
            CssTree.renderCssIdent(this.name.getCanonicalForm(), r);
            out.consume("(");
            this.children().get(0).render(r);
            out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
            out.consume(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IdentLiteral
    extends CssLiteral {
        @ParseTreeNode.ReflectiveCtor
        public IdentLiteral(FilePosition pos, String value, List<? extends CssTree> none) {
            this(pos, value);
        }

        public IdentLiteral(FilePosition pos, String value) {
            super(pos, value);
        }

        @Override
        protected boolean checkValue(String value) {
            return IDENTLITERAL.matcher(value).matches();
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            CssTree.renderCssIdent(this.getValue(), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UriLiteral
    extends CssLiteral {
        @ParseTreeNode.ReflectiveCtor
        public UriLiteral(FilePosition pos, String value, List<? extends CssTree> none) {
            this(pos, URI.create(value));
        }

        public UriLiteral(FilePosition pos, URI value) {
            super(pos, value.toString());
        }

        @Override
        protected boolean checkValue(String value) {
            try {
                URI.create(value);
                return true;
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }

        @Override
        public void render(RenderContext r) {
            String url;
            TokenConsumer out = r.getOut();
            out.mark(this.getFilePosition());
            out.consume("url");
            out.consume("(");
            try {
                url = UriUtil.normalizeUri(this.getValue());
            }
            catch (URISyntaxException ex) {
                url = "data:,";
            }
            CssTree.renderCssString(url, r);
            out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
            out.consume(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UnicodeRangeLiteral
    extends CssLiteral {
        @ParseTreeNode.ReflectiveCtor
        public UnicodeRangeLiteral(FilePosition pos, String inputValue, List<? extends CssTree> none) {
            this(pos, inputValue);
        }

        public UnicodeRangeLiteral(FilePosition pos, String value) {
            super(pos, value);
        }

        @Override
        protected boolean checkValue(String value) {
            return UNICODERANGELITERAL.matcher(value).matches();
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume(this.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class QuantityLiteral
    extends CssLiteral {
        @ParseTreeNode.ReflectiveCtor
        public QuantityLiteral(FilePosition pos, String inputValue, List<? extends CssTree> none) {
            this(pos, inputValue);
        }

        public QuantityLiteral(FilePosition pos, String value) {
            super(pos, value);
        }

        @Override
        protected boolean checkValue(String value) {
            return QUANTITYLITERAL.matcher(value).matches();
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume(this.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HashLiteral
    extends CssLiteral {
        @ParseTreeNode.ReflectiveCtor
        public HashLiteral(FilePosition pos, String inputValue, List<? extends CssTree> none) {
            this(pos, inputValue);
        }

        public HashLiteral(FilePosition pos, String value) {
            super(pos, value);
        }

        public static HashLiteral hex(FilePosition pos, int n, int digits) {
            StringBuilder sb = new StringBuilder(digits + 1);
            sb.append('#');
            while (--digits >= 0) {
                sb.append("0123456789abcdef".charAt(n >>> digits * 4 & 0xF));
            }
            return new HashLiteral(pos, sb.toString());
        }

        @Override
        protected boolean checkValue(String value) {
            return HASHLITERAL.matcher(value).matches();
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume(this.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StringLiteral
    extends CssLiteral {
        @ParseTreeNode.ReflectiveCtor
        public StringLiteral(FilePosition pos, String inputValue, List<? extends CssTree> none) {
            this(pos, inputValue);
        }

        public StringLiteral(FilePosition pos, String value) {
            super(pos, value);
        }

        @Override
        protected boolean checkValue(String value) {
            return value != null;
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            CssTree.renderCssString(this.getValue(), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClassLiteral
    extends CssLiteral {
        @ParseTreeNode.ReflectiveCtor
        public ClassLiteral(FilePosition pos, String inputValue, List<? extends CssTree> none) {
            this(pos, inputValue);
        }

        public ClassLiteral(FilePosition pos, String value) {
            super(pos, value);
        }

        @Override
        protected boolean checkValue(String value) {
            return CLASSLITERAL.matcher(value).matches();
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume(".");
            CssTree.renderCssIdent(this.getValue().substring(1), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IdLiteral
    extends CssLiteral {
        @ParseTreeNode.ReflectiveCtor
        public IdLiteral(FilePosition pos, String inputValue, List<? extends CssTree> none) {
            this(pos, inputValue);
        }

        public IdLiteral(FilePosition pos, String value) {
            super(pos, value);
        }

        @Override
        protected boolean checkValue(String value) {
            return IDLITERAL.matcher(value).matches();
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume("#");
            CssTree.renderCssIdent(this.getValue().substring(1), r);
        }
    }

    public static abstract class CssLiteral
    extends CssExprAtom {
        private String value;

        CssLiteral(FilePosition pos, String inputValue) {
            super(pos, Collections.emptyList());
            this.setValue(inputValue);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String newValue) {
            if (!this.checkValue(newValue)) {
                throw new IllegalArgumentException(newValue);
            }
            this.value = newValue;
        }

        protected abstract boolean checkValue(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CssExprAtom
    extends CssTree {
        CssExprAtom(FilePosition pos, List<? extends CssTree> children) {
            super(pos, children);
        }

        <T extends CssTree> CssExprAtom(FilePosition pos, Class<T> childType, List<? extends T> children) {
            super(pos, childType, children);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Term
    extends CssTree {
        private final UnaryOperator op;

        @ParseTreeNode.ReflectiveCtor
        public Term(FilePosition pos, UnaryOperator op, List<? extends CssExprAtom> oneatom) {
            this(pos, op, oneatom.get(0));
        }

        public Term(FilePosition pos, UnaryOperator op, CssExprAtom expr) {
            super(pos, Collections.singletonList(expr));
            this.op = op;
        }

        public UnaryOperator getValue() {
            return this.op;
        }

        public UnaryOperator getOperator() {
            return this.op;
        }

        public CssExprAtom getExprAtom() {
            return (CssExprAtom)this.children().get(0);
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            if (null != this.op) {
                r.getOut().consume(this.op.symbol);
            }
            this.getExprAtom().render(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Expr
    extends CssTree {
        @ParseTreeNode.ReflectiveCtor
        public Expr(FilePosition pos, Void novalue, List<? extends CssTree> children) {
            this(pos, children);
        }

        public Expr(FilePosition pos, List<? extends CssTree> children) {
            super(pos, children);
        }

        @Override
        protected void childrenChanged() {
            super.childrenChanged();
            assert (1 == this.children().size() % 2);
        }

        public int getNTerms() {
            return this.children().size() + 1 >> 1;
        }

        public Term getNthTerm(int n) {
            return (Term)this.children().get(n * 2);
        }

        public Operation getNthOperation(int n) {
            return (Operation)this.children().get(1 + n * 2);
        }

        public Operator getNthOperator(int n) {
            return ((Operation)this.children().get(1 + n * 2)).getOperator();
        }

        @Override
        public void render(RenderContext r) {
            CssTree.renderSpaceGroup(this.children(), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Prio
    extends CssTree {
        final String value;

        @ParseTreeNode.ReflectiveCtor
        public Prio(FilePosition pos, String value, List<? extends CssTree> none) {
            this(pos, value);
        }

        public Prio(FilePosition pos, String value) {
            super(pos, Collections.emptyList());
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume("!");
            CssTree.renderCssIdent(this.getValue().substring(1).toLowerCase(Locale.ENGLISH), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyDeclaration
    extends Declaration {
        private Property prop;
        private Expr expr;
        private Prio prio;

        @ParseTreeNode.ReflectiveCtor
        public PropertyDeclaration(FilePosition pos, Void novalue, List<? extends CssTree> children) {
            this(pos, children);
        }

        public PropertyDeclaration(FilePosition pos, List<? extends CssTree> children) {
            super(pos, children);
        }

        @Override
        protected void childrenChanged() {
            super.childrenChanged();
            List<? extends CssTree> children = this.children();
            this.prop = (Property)children.get(0);
            this.expr = (Expr)children.get(1);
            Prio prio = this.prio = children.size() > 2 ? (Prio)children.get(2) : null;
            assert (children.size() <= 3 && null != this.prop && null != this.expr);
        }

        public Property getProperty() {
            return this.prop;
        }

        public Expr getExpr() {
            return this.expr;
        }

        public Prio getPrio() {
            return this.prio;
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            this.prop.render(r);
            r.getOut().consume(":");
            r.getOut().consume(" ");
            this.expr.render(r);
            if (null != this.prio) {
                r.getOut().consume(" ");
                this.prio.render(r);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EmptyDeclaration
    extends Declaration {
        @ParseTreeNode.ReflectiveCtor
        public EmptyDeclaration(FilePosition pos, Void novalue, List<? extends CssTree> none) {
            this(pos);
            assert (none.isEmpty());
        }

        public EmptyDeclaration(FilePosition pos) {
            super(pos, Collections.emptyList());
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Declaration
    extends PageElement {
        Declaration(FilePosition pos, List<? extends CssTree> children) {
            super(pos, children);
        }

        <T extends CssTree> Declaration(FilePosition pos, Class<T> childType, List<? extends T> children) {
            super(pos, childType, children);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Pseudo
    extends CssTree {
        @ParseTreeNode.ReflectiveCtor
        public Pseudo(FilePosition pos, Void novalue, List<? extends CssExprAtom> oneAtom) {
            this(pos, oneAtom.get(0));
        }

        public Pseudo(FilePosition pos, CssExprAtom child) {
            super(pos, Collections.singletonList(child));
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume(":");
            this.children().get(0).render(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AttribOperation
    extends CssTree {
        final AttribOperator op;

        @ParseTreeNode.ReflectiveCtor
        public AttribOperation(FilePosition pos, AttribOperator op, List<? extends CssTree> none) {
            this(pos, op);
        }

        public AttribOperation(FilePosition pos, AttribOperator op) {
            super(pos, Collections.emptyList());
            this.op = op;
        }

        public AttribOperator getValue() {
            return this.op;
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume(this.op.getToken());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttribOperator {
        EQUAL("="),
        INCLUDES("~="),
        DASHMATCH("|=");

        private final String op;

        private AttribOperator(String op) {
            this.op = op;
        }

        public String getToken() {
            return this.op;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Attrib
    extends CssTree {
        final String ident;

        @ParseTreeNode.ReflectiveCtor
        public Attrib(FilePosition pos, String ident, List<? extends CssTree> operatorAndValue) {
            super(pos, operatorAndValue);
            this.ident = ident;
        }

        public Attrib(FilePosition pos, String ident, AttribOperation operator, CssLiteral value) {
            super(pos, null == operator ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(operator, value)));
            this.ident = ident;
        }

        @Override
        public String getValue() {
            return this.ident;
        }

        public String getIdent() {
            return this.ident;
        }

        public AttribOperation getOperation() {
            return this.children().isEmpty() ? null : (AttribOperation)this.children().get(0);
        }

        public CssLiteral getRhsValue() {
            return this.children().isEmpty() ? null : (CssLiteral)this.children().get(1);
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.mark(this.getFilePosition());
            out.consume("[");
            CssTree.renderCssIdent(this.ident, r);
            List<? extends CssTree> children = this.children();
            if (!children.isEmpty()) {
                out.consume(" ");
                CssTree.renderSpaceGroup(children, r);
            }
            out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
            out.consume("]");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WildcardElement
    extends CssTree {
        @ParseTreeNode.ReflectiveCtor
        public WildcardElement(FilePosition pos, Void novalue, List<? extends CssTree> none) {
            this(pos);
        }

        public WildcardElement(FilePosition pos) {
            super(pos, Collections.emptyList());
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.mark(this.getFilePosition());
            out.consume(" ");
            out.consume("*");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SimpleSelector
    extends CssTree {
        @ParseTreeNode.ReflectiveCtor
        public SimpleSelector(FilePosition pos, Void novalue, List<? extends CssTree> children) {
            this(pos, children);
        }

        public SimpleSelector(FilePosition pos, List<? extends CssTree> children) {
            super(pos, children);
        }

        public String getElementName() {
            CssTree first = this.children().get(0);
            if (first instanceof IdentLiteral) {
                return ((IdentLiteral)first).getValue();
            }
            return null;
        }

        @Override
        public void render(RenderContext r) {
            for (CssTree cssTree : this.children()) {
                cssTree.render(r);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Selector
    extends CssTree {
        @ParseTreeNode.ReflectiveCtor
        public Selector(FilePosition pos, Void novalue, List<? extends CssTree> children) {
            this(pos, children);
        }

        public Selector(FilePosition pos, List<? extends CssTree> children) {
            super(pos, children);
        }

        @Override
        public void render(RenderContext r) {
            CssTree.renderSpaceGroup(this.children(), r);
        }

        @Override
        protected void childrenChanged() {
            super.childrenChanged();
            List<? extends CssTree> children = this.children();
            int n = children.size();
            boolean needSelector = true;
            for (CssTree cssTree : children) {
                if (cssTree instanceof SimpleSelector) {
                    needSelector = false;
                    continue;
                }
                if (!needSelector && cssTree instanceof Combination) {
                    needSelector = true;
                    continue;
                }
                throw new ClassCastException(cssTree.getClass().getName());
            }
            if (needSelector && n != 0) {
                throw new IllegalArgumentException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RuleSet
    extends CssStatement {
        @ParseTreeNode.ReflectiveCtor
        public RuleSet(FilePosition pos, Void novalue, List<? extends CssTree> selectorsAndDecls) {
            this(pos, selectorsAndDecls);
        }

        public RuleSet(FilePosition pos, List<? extends CssTree> selectorsAndDecls) {
            super(pos, selectorsAndDecls);
        }

        @Override
        public void render(RenderContext r) {
            int i;
            List<? extends CssTree> children = this.children();
            for (i = 0; i < children.size() && !(children.get(i) instanceof Declaration); ++i) {
            }
            CssTree.renderCommaGroup(children.subList(0, i), r);
            FilePosition selectorEnd = children.get(i - 1).getFilePosition();
            FilePosition pos = selectorEnd != null && this.getFilePosition() != null ? FilePosition.span(FilePosition.endOf(selectorEnd), FilePosition.endOf(this.getFilePosition())) : null;
            CssTree.renderStatements(children.subList(i, children.size()), pos, r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Property
    extends CssTree {
        private final Name ident;

        @ParseTreeNode.ReflectiveCtor
        public Property(FilePosition pos, Name ident, List<? extends CssTree> none) {
            this(pos, ident);
        }

        public Property(FilePosition pos, Name ident) {
            super(pos, Collections.emptyList());
            this.ident = ident;
        }

        @Override
        public Name getValue() {
            return this.ident;
        }

        public Name getPropertyName() {
            return this.ident;
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            CssTree.renderCssIdent(this.ident.getCanonicalForm(), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FontFace
    extends CssStatement {
        @ParseTreeNode.ReflectiveCtor
        public FontFace(FilePosition pos, Void novalue, List<? extends Declaration> decls) {
            this(pos, decls);
        }

        public FontFace(FilePosition pos, List<? extends Declaration> decls) {
            super(pos, decls);
        }

        @Override
        protected void childrenChanged() {
            super.childrenChanged();
            for (CssTree cssTree : this.children()) {
                if (cssTree instanceof Declaration) continue;
                throw new ClassCastException(cssTree.getClass().getName());
            }
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume("@");
            r.getOut().consume("font-face");
            r.getOut().consume(" ");
            CssTree.renderStatements(this.children(), this.getFilePosition(), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PseudoPage
    extends PageElement {
        final Name ident;

        @ParseTreeNode.ReflectiveCtor
        public PseudoPage(FilePosition pos, Name ident, List<? extends CssTree> none) {
            this(pos, ident);
        }

        public PseudoPage(FilePosition pos, Name ident) {
            super(pos, Collections.emptyList());
            this.ident = ident;
        }

        @Override
        public Name getValue() {
            return this.ident;
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            r.getOut().consume(":");
            CssTree.renderCssIdent(this.ident.getCanonicalForm(), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PageElement
    extends CssTree {
        PageElement(FilePosition pos, List<? extends CssTree> children) {
            super(pos, children);
        }

        <T extends CssTree> PageElement(FilePosition pos, Class<T> childType, List<? extends T> children) {
            super(pos, childType, children);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Page
    extends CssStatement {
        final Name ident;

        @ParseTreeNode.ReflectiveCtor
        public Page(FilePosition pos, Name ident, List<? extends PageElement> decls) {
            super(pos, decls);
            this.ident = ident;
        }

        @Override
        public Name getValue() {
            return this.ident;
        }

        @Override
        public void render(RenderContext r) {
            List<? extends CssTree> children;
            TokenConsumer out = r.getOut();
            out.mark(this.getFilePosition());
            out.consume("@");
            out.consume("page");
            if (null != this.ident) {
                out.consume(" ");
                CssTree.renderCssIdent(this.ident.getCanonicalForm(), r);
            }
            if ((children = this.children()).get(0) instanceof PseudoPage) {
                children.get(0).render(r);
                children = children.subList(1, children.size());
            }
            CssTree.renderStatements(children, this.getFilePosition(), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Medium
    extends CssTree {
        final Name ident;

        @ParseTreeNode.ReflectiveCtor
        public Medium(FilePosition pos, Name ident, List<? extends CssTree> none) {
            this(pos, ident);
        }

        public Medium(FilePosition pos, Name ident) {
            super(pos, Collections.emptyList());
            this.ident = ident;
        }

        @Override
        public Name getValue() {
            return this.ident;
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            CssTree.renderCssIdent(this.ident.getCanonicalForm(), r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Media
    extends CssStatement {
        @ParseTreeNode.ReflectiveCtor
        public Media(FilePosition pos, Void novalue, List<? extends CssTree> mediaAndRuleset) {
            this(pos, mediaAndRuleset);
        }

        public Media(FilePosition pos, List<? extends CssTree> mediaAndRuleset) {
            super(pos, mediaAndRuleset);
        }

        public List<Medium> getMedia() {
            ArrayList<Medium> media = new ArrayList<Medium>();
            for (CssTree cssTree : this.children()) {
                if (!(cssTree instanceof Medium)) break;
                media.add((Medium)cssTree);
            }
            return media;
        }

        @Override
        public void render(RenderContext r) {
            int i;
            TokenConsumer out = r.getOut();
            out.mark(this.getFilePosition());
            out.consume("@");
            out.consume("media");
            out.consume(" ");
            List<? extends CssTree> children = this.children();
            for (i = 0; i < children.size() && children.get(i) instanceof Medium; ++i) {
            }
            CssTree.renderCommaGroup(children.subList(0, i), r);
            out.consume("{");
            for (CssTree cssTree : children.subList(i, children.size())) {
                cssTree.render(r);
            }
            out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
            out.consume("}");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Import
    extends CssStatement {
        private static <T> List<T> join(List<? extends T> a, List<? extends T> b) {
            ArrayList<T> l = new ArrayList<T>(a.size() + b.size());
            l.addAll(a);
            l.addAll(b);
            return l;
        }

        @ParseTreeNode.ReflectiveCtor
        public Import(FilePosition pos, Void novalue, List<? extends Medium> media) {
            super(pos, media);
        }

        public Import(FilePosition pos, UriLiteral uri, List<? extends Medium> media) {
            super(pos, Import.join(Collections.singletonList(uri), media));
        }

        public UriLiteral getUri() {
            return (UriLiteral)this.children().get(0);
        }

        public List<Medium> getMedia() {
            ArrayList<Medium> media = new ArrayList<Medium>(this.children().size() - 1);
            for (CssTree cssTree : this.children().subList(1, this.children().size())) {
                media.add((Medium)cssTree);
            }
            return media;
        }

        @Override
        public void render(RenderContext r) {
            TokenConsumer out = r.getOut();
            out.mark(this.getFilePosition());
            out.consume("@");
            out.consume("import");
            out.consume(" ");
            this.getUri().render(r);
            List<Medium> media = this.getMedia();
            if (!media.isEmpty()) {
                out.consume(" ");
                CssTree.renderCommaGroup(media, r);
            }
            out.consume(";");
            out.consume("\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CssStatement
    extends CssTree {
        CssStatement(FilePosition pos, List<? extends CssTree> children) {
            super(pos, children);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeclarationGroup
    extends CssTree {
        @ParseTreeNode.ReflectiveCtor
        public DeclarationGroup(FilePosition pos, Void novalue, List<? extends Declaration> decls) {
            this(pos, decls);
        }

        public DeclarationGroup(FilePosition pos, List<? extends Declaration> decls) {
            super(pos, Declaration.class, decls);
        }

        public List<? extends Declaration> children() {
            return this.childrenAs(Declaration.class);
        }

        @Override
        protected void childrenChanged() {
            super.childrenChanged();
            for (Declaration declaration : this.children()) {
                if (declaration instanceof Declaration) continue;
                throw new ClassCastException(declaration.getClass().getName());
            }
        }

        @Override
        public void render(RenderContext r) {
            r.getOut().mark(this.getFilePosition());
            boolean first = true;
            for (Declaration declaration : this.children()) {
                if (!first) {
                    r.getOut().consume(";");
                } else {
                    first = false;
                }
                declaration.render(r);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StyleSheet
    extends CssTree {
        @ParseTreeNode.ReflectiveCtor
        public StyleSheet(FilePosition pos, Void novalue, List<? extends CssStatement> rulesets) {
            this(pos, rulesets);
        }

        public StyleSheet(FilePosition pos, List<? extends CssStatement> rulesets) {
            super(pos, rulesets);
        }

        @Override
        public void render(RenderContext r) {
            for (CssTree cssTree : this.children()) {
                cssTree.render(r);
            }
        }
    }
}

