/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CatchStmt
extends AbstractStatement {
    private Declaration exception;
    private Block body;

    @ParseTreeNode.ReflectiveCtor
    public CatchStmt(FilePosition pos, Void value, List<? extends ParseTreeNode> children) {
        this(pos, (Declaration)children.get(0), (Block)children.get(1));
    }

    public CatchStmt(FilePosition pos, Declaration exception, Block body) {
        super(pos, Statement.class);
        this.createMutation().appendChild(exception).appendChild(body).execute();
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        List<? extends ParseTreeNode> children = this.children();
        this.exception = (Declaration)children.get(0);
        this.body = (Block)children.get(1);
    }

    public Declaration getException() {
        return this.exception;
    }

    public Block getBody() {
        return this.body;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        out.consume("catch");
        out.consume("(");
        out.mark(this.exception.getFilePosition());
        this.exception.getIdentifier().render(rc);
        out.consume(")");
        this.body.renderBlock(rc, false);
    }

    @Override
    public boolean hasHangingConditional() {
        return false;
    }

    @Override
    public JsonML toJsonML() {
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.CatchClause, this.getFilePosition()).addChild(this.exception.getIdentifier()).addChild(this.body).build();
    }
}

