/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.SourceBreaks;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.JsonMLConverter;
import com.google.caja.parser.js.Statement;
import com.google.caja.util.CajaTestCase;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMLCompatibleTest
extends CajaTestCase {
    public final void testToJsonML() throws Exception {
        this.testExpression("this", "[ 'ThisExpr', {} ]");
        this.testExpression("x", "[ 'IdExpr', { name : 'x' } ]");
        this.testExpression("10", "[ 'LiteralExpr', { type: 'number',  value: 10 } ]");
        this.testExpression("'foo'", "[ 'LiteralExpr', { type: 'string',  value: 'foo' } ]");
        this.testExpression("'foo'", "[ 'LiteralExpr', { type: 'string',  value: 'foo' } ]");
        this.testExpression("true", "[ 'LiteralExpr', { type: 'boolean', value: true } ]");
        this.testExpression("false", "[ 'LiteralExpr', { type: 'boolean', value: false } ]");
        this.testExpression("null", "[ 'LiteralExpr', { type: 'null',    value: null } ]");
        this.testExpression("/foo(.*)/g", "[ 'RegExpExpr', { body: \"foo(.*)\", flags: 'g' } ]");
        this.testExpression("[]", "[ 'ArrayExpr', {} ]");
        this.testExpression("[   ]", "[ 'ArrayExpr', {} ]");
        this.testExpression("[1]", "[ 'ArrayExpr', {}, [ 'LiteralExpr', { type: 'number',  value: 1 } ] ]");
        this.testExpression("[1,2]", "[ 'ArrayExpr', {}, [ 'LiteralExpr', { type: 'number',  value: 1 } ],[ 'LiteralExpr', { type: 'number',  value: 2 } ] ]");
        this.testExpression("[1,2,,]", "[ 'ArrayExpr', {}, [ 'LiteralExpr', { type: 'number',  value: 1 } ],[ 'LiteralExpr', { type: 'number',  value: 2 } ], ['Empty', {}] ]");
        this.testExpression("[1,2,3]", "[ 'ArrayExpr', {}, [ 'LiteralExpr', { type: 'number',  value: 1 } ],[ 'LiteralExpr', { type: 'number',  value: 2 } ],[ 'LiteralExpr', { type: 'number',  value: 3 } ] ]");
        this.testExpression("[1,2,3,,,]", "[ 'ArrayExpr', {}, [ 'LiteralExpr', { type: 'number',  value: 1 } ],[ 'LiteralExpr', { type: 'number',  value: 2 } ],[ 'LiteralExpr', { type: 'number',  value: 3 } ],['Empty', {}],['Empty', {}] ]");
        this.testExpression("{}", "[ 'ObjectExpr', {} ]");
        this.testExpression("{x:5}", "[ 'ObjectExpr', {}, ['DataProp', { name: 'x' },[ 'LiteralExpr', { type: 'number',  value: 5 } ] ] ]");
        this.testExpression("{x:5,y:6}", "[ 'ObjectExpr', {}, ['DataProp', { name: 'x' }, [ 'LiteralExpr', { type: 'number',  value: 5 } ] ], ['DataProp', { name: 'y' }, [ 'LiteralExpr', { type: 'number',  value: 6 } ] ] ]");
        this.testExpression("{x:5,}", "[ 'ObjectExpr', {}, ['DataProp', { name: 'x' }, [ 'LiteralExpr', { type: 'number',  value: 5 } ] ] ]");
        this.testExpression("{if:5}", "[ 'ObjectExpr', {}, ['DataProp', { name: 'if' }, [ 'LiteralExpr', { type: 'number',  value: 5 } ] ] ]");
        this.testExpression("{ get x() {this;} }", "['ObjectExpr', {}, [ 'GetterProp', {name:'x'}, ['FunctionExpr', {}, ['Empty', {}], ['ParamDecl',{}], ['ThisExpr', {}] ] ] ]");
        this.testExpression("{ set y(a) {this;} }", "['ObjectExpr', {}, [ 'SetterProp', {name:'y'}, ['FunctionExpr', {}, ['Empty', {}], ['ParamDecl',{},['IdPatt', {name:'a'}]], ['ThisExpr', {}] ] ] ]");
        this.testExpression("o.m", "[ 'MemberExpr', { 'op': '.' }, [ 'IdExpr', {name:'o'} ], [ 'LiteralExpr',{type: 'string', value: 'm'} ] ]");
        this.testExpression("o['m']", "[ 'MemberExpr', { 'op': \"[]\" }, [ 'IdExpr', {name:'o'} ], [ 'LiteralExpr',{type: 'string', value: 'm'} ] ]");
        this.testExpression("o['n']['m']", "[ 'MemberExpr', { 'op': \"[]\" }, [ 'MemberExpr', { 'op': \"[]\" }, [ 'IdExpr', {name:'o'} ], [ 'LiteralExpr',{type:'string',value: 'n'}]], [ 'LiteralExpr',{type: 'string', value: 'm'} ] ]");
        this.testExpression("o.n.m", "[ 'MemberExpr', { 'op': '.' }, [ 'MemberExpr', { 'op': '.' }, [ 'IdExpr', {name:'o'} ], [ 'LiteralExpr',{type:'string',value: 'n'}]], [ 'LiteralExpr',{type:'string', value: 'm'} ] ]");
        this.testExpression("o.if", "[ 'MemberExpr', { 'op': '.' }, [ 'IdExpr', {name:'o'} ], [ 'LiteralExpr',{type: 'string', value: 'if'} ] ]");
        this.testExpression("f()", "[ 'CallExpr',{},['IdExpr',{name:'f'}] ]");
        this.testExpression("f(x)", "[ 'CallExpr',{},['IdExpr',{name:'f'}], ['IdExpr',{name:'x'}] ]");
        this.testExpression("f(x,y)", "[ 'CallExpr',{},['IdExpr',{name:'f'}], ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("o.m()", "[ 'InvokeExpr',{ 'op': '.' },['IdExpr',{name:'o'}], ['LiteralExpr',{ type: 'string', value:'m' }] ]");
        this.testExpression("o['m']()", "[ 'InvokeExpr',{ 'op': \"[]\" },['IdExpr',{name:'o'}], ['LiteralExpr',{ type: 'string', value:'m' }] ]");
        this.testExpression("o.m(x)", "[ 'InvokeExpr',{ 'op': '.' },['IdExpr',{name:'o'}], ['LiteralExpr',{ type: 'string', value:'m' }], ['IdExpr',{name:'x'}] ]");
        this.testExpression("o['m'](x)", "[ 'InvokeExpr',{ 'op': \"[]\" },['IdExpr',{name:'o'}], ['LiteralExpr',{ type: 'string', value:'m' }], ['IdExpr',{name:'x'}] ]");
        this.testExpression("o.m(x,y)", "[ 'InvokeExpr',{ 'op': '.' },['IdExpr',{name:'o'}], ['LiteralExpr',{ type: 'string', value:'m' }], ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("o['m'](x,y)", "[ 'InvokeExpr',{ 'op': \"[]\" },['IdExpr',{name:'o'}], ['LiteralExpr',{ type: 'string', value:'m' }], ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("f(x)(y)", "[ 'CallExpr', {}, [ 'CallExpr',{}, ['IdExpr',{name:'f'}], ['IdExpr',{name:'x'}] ], ['IdExpr',{name:'y'}] ]");
        this.testExpression("f().x", "[ 'MemberExpr', { 'op': '.' }, [ 'CallExpr',{},['IdExpr',{name:'f'}] ], ['LiteralExpr', {type:'string',value:'x'}]]");
        this.testExpression("eval('x')", "['EvalExpr', {}, ['LiteralExpr',{ type: 'string', value:'x' }] ]");
        this.testExpression("(eval)('x')", "['EvalExpr', {}, ['LiteralExpr',{ type: 'string', value:'x' }] ]");
        this.testExpression("(1,eval)('x')", "['CallExpr', {}, ['BinaryExpr', {op:','}, [ 'LiteralExpr', { type: 'number',  value: 1 } ], ['IdExpr',{name:'eval'}] ], ['LiteralExpr',{ type: 'string', value:'x' }] ]");
        this.testExpression("eval(x,y)", "['EvalExpr', {}, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("new f()", "[ 'NewExpr', {}, ['IdExpr', { name: 'f' } ] ]");
        this.testExpression("new o", "[ 'NewExpr', {}, ['IdExpr',{name:'o'}] ]");
        this.testExpression("new o.m", "['NewExpr', {}, ['MemberExpr', { 'op': '.' }, ['IdExpr',{name:'o'}], ['LiteralExpr',{ type: 'string', value:'m' }] ] ]");
        this.testExpression("new o.m(x)", "['NewExpr', {}, ['MemberExpr', { 'op': '.' }, ['IdExpr',{name:'o'}], ['LiteralExpr',{ type: 'string', value:'m' }] ], ['IdExpr',{name:'x'}] ]");
        this.testExpression("new o.m(x,y)", "['NewExpr', {}, ['MemberExpr', { 'op': '.' }, ['IdExpr',{name:'o'}], ['LiteralExpr',{ type: 'string', value:'m' }] ], ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("++x", "['CountExpr', {isPrefix: true,  op: \"++\"}, ['IdExpr',{name:'x'}] ]");
        this.testExpression("x++", "['CountExpr', {isPrefix: false, op: \"++\"}, ['IdExpr',{name:'x'}] ]");
        this.testExpression("--x", "['CountExpr', {isPrefix: true,  op: \"--\"}, ['IdExpr',{name:'x'}] ]");
        this.testExpression("x--", "['CountExpr', {isPrefix: false, op: \"--\"}, ['IdExpr',{name:'x'}] ]");
        this.testExpression("x  ++", "['CountExpr', {isPrefix: false, op: \"++\"}, ['IdExpr',{name:'x'}] ]");
        this.testExpression("delete x", "[ 'DeleteExpr', {}, ['IdExpr',{name:'x'}] ]");
        this.testExpression("void x", "[ 'UnaryExpr', {op:'void'}, ['IdExpr',{name:'x'}] ]");
        this.testExpression("+ x", "[ 'UnaryExpr', {op:'+'   }, ['IdExpr',{name:'x'}] ]");
        this.testExpression("-x", "[ 'UnaryExpr', {op:'-'   }, ['IdExpr',{name:'x'}] ]");
        this.testExpression("~x", "[ 'UnaryExpr', {op:'~'   }, ['IdExpr',{name:'x'}] ]");
        this.testExpression("!x", "[ 'UnaryExpr', {op:'!'   }, ['IdExpr',{name:'x'}] ]");
        this.testExpression("+x++", "[ 'UnaryExpr', {op:'+'}, ['CountExpr', {isPrefix:false,op:\"++\"}, ['IdExpr',{name:'x'}] ] ]");
        this.testExpression("typeof x", "[ 'TypeofExpr', {}, ['IdExpr',{name:'x'}] ]");
        this.testExpression("1 * 2", "[ 'BinaryExpr', {op: '*'}, [ 'LiteralExpr', { type: 'number',  value: 1 } ], [ 'LiteralExpr', { type: 'number',  value: 2 } ] ]");
        this.testExpression("1 / 2", "[ 'BinaryExpr', {op: '/'}, [ 'LiteralExpr', { type: 'number',  value: 1 } ], [ 'LiteralExpr', { type: 'number',  value: 2 } ] ]");
        this.testExpression("1 % 2", "[ 'BinaryExpr', {op: '%'}, [ 'LiteralExpr', { type: 'number',  value: 1 } ], [ 'LiteralExpr', { type: 'number',  value: 2 } ] ]");
        this.testExpression("1 + 2", "[ 'BinaryExpr', {op: '+'}, [ 'LiteralExpr', { type: 'number',  value: 1 } ], [ 'LiteralExpr', { type: 'number',  value: 2 } ] ]");
        this.testExpression("1 - 2", "[ 'BinaryExpr', {op: '-'}, [ 'LiteralExpr', { type: 'number',  value: 1 } ], [ 'LiteralExpr', { type: 'number',  value: 2 } ] ]");
        this.testExpression("1 << 2", "[ 'BinaryExpr', {op: \"<<\"}, [ 'LiteralExpr', { type: 'number',  value: 1 } ], [ 'LiteralExpr', { type: 'number',  value: 2 } ] ]");
        this.testExpression("1 >>> 2", "[ 'BinaryExpr', {op: \">>>\"}, [ 'LiteralExpr', { type: 'number',  value: 1 } ], [ 'LiteralExpr', { type: 'number',  value: 2 } ] ]");
        this.testExpression("1 >> 2", "[ 'BinaryExpr', {op: \">>\"}, [ 'LiteralExpr', { type: 'number',  value: 1 } ], [ 'LiteralExpr', { type: 'number',  value: 2 } ] ]");
        this.testExpression("1 * 2 + 3", "['BinaryExpr', {op:'+'}, ['BinaryExpr', {op:'*'}, ['LiteralExpr', {type: 'number', value: 1}], ['LiteralExpr', {type: 'number', value: 2}]], ['LiteralExpr', {type: 'number', value: 3}]]");
        this.testExpression("(1 + 2) * 3", "[ 'BinaryExpr', {op:'*'}, ['BinaryExpr', {op:'+'}, ['LiteralExpr', {type:'number', value:1}], ['LiteralExpr', {type:'number', value:2}] ], [ 'LiteralExpr', { type: 'number',  value: 3 } ] ]");
        this.testExpression("1 * (2 + 3)", "['BinaryExpr', {op:'*'}, ['LiteralExpr', { type: 'number',  value: 1 } ], ['BinaryExpr', {op:'+'}, ['LiteralExpr', {type:'number', value:2}], ['LiteralExpr', {type:'number', value:3}] ] ]");
        this.testExpression("x < y", "[ 'BinaryExpr', {op: '<'  }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x > y", "[ 'BinaryExpr', {op: '>'  }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x <= y", "[ 'BinaryExpr', {op: \"<=\" }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x >= y", "[ 'BinaryExpr', {op: \">=\" }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x instanceof y", "[ 'BinaryExpr', {op: 'instanceof' }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x in y", "[ 'BinaryExpr', {op: 'in' }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x & y", "[ 'BinaryExpr', {op: '&' }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x ^ y", "[ 'BinaryExpr', {op: '^' }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x | y", "[ 'BinaryExpr', {op: '|' }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x & y | z", "[ 'BinaryExpr', {op: '|' }, ['BinaryExpr', {op:'&'}, ['IdExpr', {name:'x'}],['IdExpr', {name:'y'}] ], ['IdExpr',{name:'z'}] ]");
        this.testExpression("x && y", "['LogicalAndExpr', {}, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}]]");
        this.testExpression("x || y", "['LogicalOrExpr', {}, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}]]");
        this.testExpression("x && y || z", "['LogicalOrExpr', {}, ['LogicalAndExpr', {}, ['IdExpr', {name:'x'}], ['IdExpr', {name:'y'}] ], ['IdExpr',{name:'z'}] ]");
        this.testExpression("x || y && z", "['LogicalOrExpr', {}, ['IdExpr',{name:'x'}], ['LogicalAndExpr', {}, ['IdExpr', {name:'y'}], ['IdExpr', {name:'z'}] ] ]");
        this.testExpression("x < y ? z : w", "['ConditionalExpr', {}, ['BinaryExpr', {op:'<'}, ['IdExpr', {name:'x'}], ['IdExpr', {name:'y'}] ], ['IdExpr', {name:'z'}], ['IdExpr', {name:'w'}] ]");
        this.testExpression("x >>>= y", "['AssignExpr', {op: \">>>=\"}, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x <<= y", "['AssignExpr', {op: \"<<=\" }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x = y", "[ 'AssignExpr', {op: '='   }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x += y", "[ 'AssignExpr', {op: \"+=\"  }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x /= y", "[ 'AssignExpr', {op: \"/=\"  }, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testExpression("x , y", "[ 'BinaryExpr', {op: ','}, ['IdExpr',{name:'x'}], ['IdExpr',{name:'y'}] ]");
        this.testStatement("{}", "['BlockStmt', {}]");
        this.testStatement("{x;}", "['BlockStmt', {}, ['IdExpr', {name:'x'}] ]");
        this.testStatement("{x;y;}", "['BlockStmt', {}, ['IdExpr', {name:'x'}], ['IdExpr', {name:'y'}] ]");
        this.testStatement("var x;", "[ 'VarDecl', {}, ['IdPatt', {name: 'x'}] ]");
        this.testStatement("var x,y;", "[ 'VarDecl', {}, ['IdPatt', {name: 'x'}], ['IdPatt', {name:'y'}] ]");
        this.testStatement("var x=1,y=2;", "[ 'VarDecl', {}, ['InitPatt', {}, ['IdPatt', {name: 'x'}], ['LiteralExpr', { type: 'number',  value: 1 } ] ], ['InitPatt', {}, ['IdPatt', {name: 'y'}], ['LiteralExpr', { type: 'number',  value: 2 } ] ] ]");
        this.testStatement("var x,y=2;", "['VarDecl', {}, ['IdPatt', {name: 'x'} ], ['InitPatt', {}, ['IdPatt', {name: 'y'}], [ 'LiteralExpr', { type: 'number',  value: 2 } ] ] ]");
        this.testStatement(";", "['EmptyStmt', {}]");
        this.testStatement("\n;", "['EmptyStmt', {}]");
        this.testStatement("x;", "[ 'IdExpr', {name:'x'} ]");
        this.testStatement("5;", "[ 'LiteralExpr', {type:'number', value: 5}]");
        this.testStatement("1 + 2;", "[ 'BinaryExpr', {op:'+'}, [ 'LiteralExpr', { type: 'number',  value: 1 } ], [ 'LiteralExpr', { type: 'number',  value: 2 } ]]");
        this.testStatement("if (c) x; else y;", "[ 'IfStmt',{}, ['IdExpr',{name:'c'}], ['IdExpr', {name:'x'}], ['IdExpr', {name:'y'}] ]");
        this.testStatement("if (c) x;", "[ 'IfStmt',{}, ['IdExpr',{name:'c'}], ['IdExpr', {name:'x'}], ['EmptyStmt', {}] ]");
        this.testStatement("if (c) {} else {}", "[ 'IfStmt',{}, ['IdExpr',{name:'c'}], ['BlockStmt', {}], ['BlockStmt', {}] ]");
        this.testStatement("if (c1) if (c2) s1; else s2;", "[ 'IfStmt',{}, ['IdExpr',{name:'c1'}], [ 'IfStmt', {}, ['IdExpr',{name:'c2'}], ['IdExpr', {name:'s1'}], ['IdExpr', {name:'s2'}] ], [ 'EmptyStmt', {}] ]");
        this.testStatement("do s; while (e);", "[ 'DoWhileStmt', {}, ['IdExpr', {name:'s'}], ['IdExpr',{name:'e'}] ]");
        this.testStatement("while (e) s;", "[ 'WhileStmt',{}, ['IdExpr',{name:'e'}], ['IdExpr', {name:'s'}] ]");
        this.testStatement("for (;;) ;", "['ForStmt', {}, ['EmptyStmt', {}], ['LiteralExpr', {type: 'boolean', 'value': true}], ['EmptyStmt', {}], ['EmptyStmt',{}] ]");
        this.testStatement("for (;c;x++) x;", "[ 'ForStmt', {}, ['EmptyStmt', {}], ['IdExpr',{name:'c'}], ['CountExpr', {isPrefix:false,op:\"++\"}, ['IdExpr',{name:'x'}] ], ['IdExpr', {name:'x'}] ]");
        this.testStatement("for (i;i<10;i++) {}", "['ForStmt', {}, ['IdExpr',{name:'i'}], ['BinaryExpr', {op:'<'}, ['IdExpr', {name:'i'}], ['LiteralExpr', {type:'number',value:10}]], ['CountExpr', {isPrefix:false,op:\"++\"}, ['IdExpr',{name:'i'}] ], ['BlockStmt', {}] ]");
        this.testStatement("for (var i=0;i<len;i++) {}", "[ 'ForStmt', {}, [ 'VarDecl',{}, ['InitPatt', {}, ['IdPatt',{name:'i'}], [ 'LiteralExpr', { type: 'number',  value: 0 } ]] ], ['BinaryExpr', {op:'<'}, ['IdExpr', {name:'i'}],['IdExpr', {name:'len'}] ], ['CountExpr', {isPrefix:false,op:\"++\"}, ['IdExpr',{name:'i'}] ], ['BlockStmt', {}] ]");
        this.testStatement("for (var i=0,j=0;;) {}", "[ 'ForStmt', {}, [ 'VarDecl',{}, ['InitPatt', {}, ['IdPatt',{name:'i'}], [ 'LiteralExpr', { type: 'number',  value: 0 } ]], ['InitPatt', {}, ['IdPatt',{name:'j'}], [ 'LiteralExpr', { type: 'number',  value: 0 } ]] ], ['LiteralExpr', {type:'boolean', value:true}] , ['EmptyStmt', {}], ['BlockStmt', {}] ]");
        this.testStatement("for ((x in b); c; u) {}", "['ForStmt', {}, ['BinaryExpr', {op:'in'}, ['IdExpr', {name:'x'}],['IdExpr', {name:'b'}]], ['IdExpr',{name:'c'}], ['IdExpr', {name:'u'}], ['BlockStmt', {}]]");
        this.testStatement("for (x in a) ;", "['ForInStmt', {}, ['IdExpr', {name:'x'}], ['IdExpr', {name:'a'}], ['EmptyStmt', {}]]");
        this.testStatement("for (var x in a) {}", "['ForInStmt', {}, ['VarDecl', {}, ['IdPatt', {name:'x'}]], ['IdExpr', {name:'a'}], ['BlockStmt', {}] ]");
        this.testStatement("continue;", "['ContinueStmt', {}]");
        this.testStatement("continue label;", "['ContinueStmt',{label:'label'}]");
        this.testStatement("break;", "['BreakStmt',{}]");
        this.testStatement("break label;", "['BreakStmt',{label:'label'}]");
        this.testStatement("continue\n", "['ContinueStmt', {}]");
        this.testStatement("return;", "['ReturnStmt', {}]");
        this.testStatement("return 0;", "['ReturnStmt',{}, [ 'LiteralExpr', { type: 'number',  value: 0 } ]]");
        this.testStatement("return 0 + \n 1;", "['ReturnStmt',{}, ['BinaryExpr', {op:'+'}, ['LiteralExpr', {type:'number', value:0}],['LiteralExpr', {type:'number', value:1}] ]]");
        this.testStatement("with (e) s;", "['WithStmt', {}, ['IdExpr',{name:'e'}], ['IdExpr', {name:'s'}] ]");
        this.testStatement("switch (e) { case x: s; }", "['SwitchStmt',{}, ['IdExpr',{name:'e'}], ['Case', {}, ['IdExpr',{name:'x'}], ['IdExpr', {name:'s'}] ] ]");
        this.testStatement("switch (e) { case x: s1;s2; default: s3; case y: s4; }", "['SwitchStmt',{}, ['IdExpr',{name:'e'}], ['Case', {}, ['IdExpr',{name:'x'}], ['IdExpr', {name:'s1'}], ['IdExpr', {name:'s2'}] ], ['DefaultCase', {}, ['IdExpr', {name:'s3'}] ], ['Case', {}, ['IdExpr',{name:'y'}], ['IdExpr', {name:'s4'}] ] ]");
        this.testStatement("switch (e) { default: s1; case x: s2; case y: s3; }", "['SwitchStmt',{}, ['IdExpr',{name:'e'}], ['DefaultCase', {}, ['IdExpr', {name:'s1'}] ], ['Case', {}, ['IdExpr',{name:'x'}], ['IdExpr', {name:'s2'}] ], ['Case', {}, ['IdExpr',{name:'y'}], ['IdExpr', {name:'s3'}] ] ]");
        this.testStatement("switch (e) { default: s; }", "['SwitchStmt',{}, ['IdExpr',{name:'e'}], ['DefaultCase', {}, ['IdExpr', {name:'s'}] ] ]");
        this.testStatement("switch (e) { case x: s1; case y: s2; }", "['SwitchStmt',{}, ['IdExpr',{name:'e'}], ['Case', {}, ['IdExpr',{name:'x'}], ['IdExpr', {name:'s1'}] ], ['Case', {}, ['IdExpr',{name:'y'}], ['IdExpr', {name:'s2'}] ] ]");
        this.testStatement("foo : x;", "['LabelledStmt',{label:'foo'}, ['IdExpr', {name:'x'}]]");
        this.testStatement("throw x;", "['ThrowStmt',{}, ['IdExpr',{name:'x'}]]");
        this.testStatement("throw x\n", "['ThrowStmt',{}, ['IdExpr',{name:'x'}]]");
        this.testStatement("try { s1; } catch (e) { s2; }", "['TryStmt',{}, ['BlockStmt',{},['IdExpr', {name:'s1'}]], [ 'CatchClause', {}, ['IdPatt',{name:'e'}], ['BlockStmt',{},['IdExpr', {name:'s2'}]] ] ]");
        this.testStatement("try { s1; } finally { s2; }", "['TryStmt',{}, ['BlockStmt',{},['IdExpr', {name:'s1'}]], ['Empty', {}], ['BlockStmt',{},['IdExpr', {name:'s2'}]] ]");
        this.testStatement("try { s1; } catch (e) { s2; } finally { s3; }", "['TryStmt',{}, ['BlockStmt',{},['IdExpr', {name:'s1'}]], [ 'CatchClause', {}, ['IdPatt',{name:'e'}], ['BlockStmt',{},['IdExpr', {name:'s2'}]] ], ['BlockStmt',{},['IdExpr', {name:'s3'}]] ]");
        this.testStatement("debugger;", "['DebuggerStmt',{}]");
        this.testStatement("function f(x) { e; return x; }", "[ 'FunctionDecl', {}, ['IdPatt',{name:'f'}], ['ParamDecl',{},['IdPatt',{name:'x'}]], ['IdExpr', {name:'e'}], ['ReturnStmt', {}, ['IdExpr', { name: 'x' }]] ]");
        this.testStatement("function f() { x; y; }", "[ 'FunctionDecl', {}, ['IdPatt',{name:'f'}], ['ParamDecl',{}], ['IdExpr', {name:'x'}], ['IdExpr', {name:'y'}] ]");
        this.testStatement("function f(x,y) { var z; return x; }", "[ 'FunctionDecl', {}, ['IdPatt',{name:'f'}], ['ParamDecl',{},['IdPatt',{name:'x'}], ['IdPatt',{name:'y'}]], ['VarDecl', {}, ['IdPatt', { name: 'z' }] ], ['ReturnStmt', {}, ['IdExpr', { name: 'x' }]] ]");
        this.testExpression("function f(x) { return x; }", "[ 'FunctionExpr', {}, ['IdPatt',{name:'f'}], ['ParamDecl',{},['IdPatt',{name:'x'}]], ['ReturnStmt', {}, ['IdExpr', { name: 'x' }]] ]");
        this.testStatement("(function empty() {})", "[ 'FunctionExpr', {}, ['IdPatt',{name:'empty'}], ['ParamDecl',{}] ]");
        this.testStatement("(function f(x,y) { var z; return x; })", "[ 'FunctionExpr', {}, ['IdPatt',{name:'f'}], ['ParamDecl',{},['IdPatt',{name:'x'}], ['IdPatt',{name:'y'}]], ['VarDecl', {}, ['IdPatt', { name: 'z' }] ], ['ReturnStmt', {}, ['IdExpr', { name: 'x' }]] ]");
        this.testStatement("(function (x) { })", "[ 'FunctionExpr', { }, ['Empty', {}], ['ParamDecl',{},['IdPatt',{name:'x'}]] ]");
        this.testProgram("", "['Program',{}]");
        this.testProgram("x", "['Program', {}, ['IdExpr', {name:'x'}]]");
        this.testProgram("var x; function f(){} null", "['Program',{}, ['VarDecl', {}, ['IdPatt', {name:'x'}]], ['FunctionDecl', {}, ['IdPatt', {name:'f'}], ['ParamDecl',{}]], ['LiteralExpr', {type: 'null', value:null}] ]");
        this.testProgram(";;", "['Program',{}, ['EmptyStmt',{}], ['EmptyStmt', {}]]");
        this.testProgram("{ x; y; z; }", "['Program', {}, ['BlockStmt',{}, ['IdExpr', {name:'x'}], ['IdExpr', {name:'y'}], ['IdExpr', {name:'z'}] ] ]");
        this.testProgram("function f() { function g() { }}", "['Program', {}, ['FunctionDecl', {}, ['IdPatt', {name:'f'}], ['ParamDecl',{}], ['FunctionDecl', {}, ['IdPatt', {name:'g'}], ['ParamDecl',{}]] ]]");
        this.testProgram("continue \n foo;", "['Program',{}, ['ContinueStmt',{}], ['IdExpr', {name:'foo'}] ]");
        this.testProgram("break \n foo;", "['Program',{}, ['BreakStmt',{}], ['IdExpr', {name:'foo'}] ]");
        this.testProgram("return\nfoo;", "['Program',{}, ['ReturnStmt',{}], ['IdExpr', {name:'foo'}] ]");
        this.testProgram("\"use strict\"; 'bla'\n foo", "['Program', {}, ['PrologueDecl', {'directive': \"use strict\", 'value': \"use strict\"}], ['PrologueDecl', { 'directive':'bla', 'value': 'bla' } ], ['IdExpr', { 'name':'foo' } ] ]");
        this.testProgram("\"use\\x20strict\";", "['Program', {}, ['PrologueDecl', {'directive': \"use\\\\x20strict\", 'value': \"use strict\"}] ]");
        this.testExpression("function() { \"use strict\"; 'bla'\n foo }", "['FunctionExpr', {}, ['Empty', {}], ['ParamDecl',{}], ['PrologueDecl', { 'directive':\"use strict\", 'value':\"use strict\" } ], ['PrologueDecl', { 'directive':'bla', 'value':'bla' } ], ['IdExpr', { 'name':'foo' } ] ]");
        this.testProgram("\"use\\ strict\";", "['Program', {}, ['PrologueDecl', { directive:\"use\\\\ strict\", value: \"use strict\" }]]");
        this.testProgram("foo; \"use strict\";", "['Program', {}, ['IdExpr', {'name':'foo'} ], ['LiteralExpr', {type:'string', value:\"use strict\"} ] ]");
        this.testProgram("{ 1 \n 2 } 3", "[ 'Program', {}, ['BlockStmt', {}, ['LiteralExpr', {type: 'number', value:1}], ['LiteralExpr', {type:'number', value:2}] ], ['LiteralExpr', {type:'number', value: 3}] ]");
        this.testProgram("return\na + b", "[ 'Program', {}, ['ReturnStmt',{}], ['BinaryExpr',{op:'+'},['IdExpr',{name:'a'}],['IdExpr',{name:'b'}] ] ]");
        this.testProgram("a = b \n ++c", "[ 'Program', {}, ['AssignExpr',{op:'='}, ['IdExpr',{name:'a'}], ['IdExpr',{name:'b'}] ], ['CountExpr', {isPrefix:true,op:\"++\"}, ['IdExpr',{name:'c'}] ] ]");
    }

    private void testExpression(String js, String jsonMLGolden) throws ParseException {
        Expression e = this.jsExpr(this.fromString(js));
        JsonML actual = e.toJsonML();
        this.checkJsonML(e, actual, jsonMLGolden, Expression.class);
    }

    private void testStatement(String js, String jsonMLGolden) throws ParseException {
        Block bl = this.js(this.fromString(js));
        JsonMLCompatibleTest.assertEquals((int)1, (int)bl.children().size());
        Statement s = bl.children().get(0);
        JsonML actual = s.toJsonML();
        this.checkJsonML(s, actual, jsonMLGolden, Statement.class);
    }

    private void testProgram(String js, String jsonMLGolden) throws ParseException {
        Block program = "".equals(js) ? new Block() : this.js(this.fromString(js));
        JsonML actual = program.toJsonMLAsProgram();
        this.checkJsonML(program, actual, jsonMLGolden, Block.class);
    }

    private <T extends ParseTreeNode> void checkJsonML(T n, JsonML actual, String jsonMLGolden, Class<T> type) throws ParseException {
        JsonMLCompatibleTest.stripPositionInfo(actual);
        JsonMLCompatibleTest.assertEquals((String)JsonMLCompatibleTest.render(this.jsExpr(this.fromString(jsonMLGolden))), (String)JsonMLCompatibleTest.render(this.jsExpr(this.fromString(actual.toString()))));
        T reconverted = new JsonMLConverter(Collections.<String, SourceBreaks>emptyMap()).toNode(actual, type);
        JsonMLCompatibleTest.assertEquals((String)JsonMLCompatibleTest.normRender(n), (String)JsonMLCompatibleTest.normRender(reconverted));
    }

    private static String normRender(ParseTreeNode n) {
        return JsonMLCompatibleTest.render(n).replaceAll("\\.0\\b", "").replaceAll("\\b(new [\\w.]+)\\(\\)", "$1");
    }

    private static void stripPositionInfo(JsonML jsonml) {
        jsonml.getAttributes().remove(TagAttr.SOURCE);
        jsonml.getAttributes().remove(TagAttr.OPAQUE_POSITION);
        for (JsonML child : jsonml.getChildren()) {
            JsonMLCompatibleTest.stripPositionInfo(child);
        }
    }
}

